/*
 * Decompiled with CFR 0.152.
 */
package SEdit.Graphics;

import SEdit.Graphics.GObject;
import SEdit.SArrow;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Shape;

public class GArrow
extends GObject {
    public static final int DIRECT_LINE = 1;
    public static final int BROKEN_LINE = 2;
    Shape startingShape = null;
    Shape endingShape = null;
    Shape midShape = null;
    public int ra = 2;
    public int ras = 5;
    protected Point q;
    protected Point p;
    int lineStyle = 2;
    int startingForm = 0;
    int endingForm = 1;
    protected static final int defaultRp = 10;
    protected static final int defaultRb = 5;
    protected static final int bigRp = 14;
    protected static final int bigRb = 7;
    protected static final int rSquare = 5;
    protected static final int rRound = 5;
    protected static final int rDiamond = 10;
    public static final int NOTHING = 0;
    public static final int SHARPEND = 1;
    public static final int SQUAREEND = 2;
    public static final int ROUNDEND = 3;
    public static final int DIAMONDEND = 4;
    public static final int WHITESHARPEND = 5;

    public int getLineStyle() {
        return this.lineStyle;
    }

    public void setLineStyle(int n) {
        this.lineStyle = n;
    }

    public int getEndingForm() {
        return this.endingForm;
    }

    public int getStartingForm() {
        return this.startingForm;
    }

    public void setEndingForm(int n) {
        this.endingForm = n;
    }

    public void setStartingForm(int n) {
        this.startingForm = n;
    }

    public GArrow() {
        this.setEndingForm(1);
    }

    public GArrow(int n, int n2) {
        this();
        this.setLocation(n, n2);
    }

    public Point getCenter() {
        return new Point(this.x, this.y);
    }

    public void setCenter(int n, int n2) {
        this.setLocation(n, n2);
    }

    private Polygon defineSharpEdge(Point point, Point point2, int n, int n2) {
        Polygon polygon = new Polygon();
        polygon.addPoint(point2.x, point2.y);
        double d = Math.atan((float)(point.y - point2.y) / (float)(point2.x - point.x));
        double d2 = Math.atan((float)n2 / (float)n);
        double d3 = Math.sqrt(n * n + n2 * n2);
        if (point2.x - (this.x + this.height / 2) < 0) {
            d3 = -d3;
        }
        polygon.addPoint((int)Math.round((double)point2.x - d3 * Math.cos(d + d2)), (int)Math.round((double)point2.y + d3 * Math.sin(d + d2)));
        polygon.addPoint((int)Math.round((double)point2.x - d3 * Math.cos(d - d2)), (int)Math.round((double)point2.y + d3 * Math.sin(d - d2)));
        polygon.addPoint(point2.x, point2.y);
        return polygon;
    }

    private Polygon defineDiamondEdge(Point point, Point point2) {
        Polygon polygon = new Polygon();
        polygon.addPoint(point2.x, point2.y);
        double d = Math.atan((float)(point.y - point2.y) / (float)(point2.x - point.x));
        double d2 = Math.atan(1.0);
        double d3 = Math.sqrt(200.0);
        double d4 = 20.0;
        if (point2.x - this.x < 0) {
            d3 = -d3;
            d4 = -d4;
        }
        polygon.addPoint((int)Math.round((double)point2.x - d3 * Math.cos(d + d2)), (int)Math.round((double)point2.y + d3 * Math.sin(d + d2)));
        polygon.addPoint((int)Math.round((double)point2.x - d4 * Math.cos(d)), (int)Math.round((double)point2.y + d4 * Math.sin(d)));
        polygon.addPoint((int)Math.round((double)point2.x - d3 * Math.cos(d - d2)), (int)Math.round((double)point2.y + d3 * Math.sin(d - d2)));
        return polygon;
    }

    protected void drawSharpEnd(Graphics graphics, Point point, Point point2) {
        this.endingShape = this.defineSharpEdge(new Point(point.x + this.width / 2, point.y + this.height / 2), point2, 10, 5);
        graphics.fillPolygon((Polygon)this.endingShape);
    }

    protected void drawWhiteSharpEnd(Graphics graphics, Point point, Point point2) {
        Color color = graphics.getColor();
        this.endingShape = this.defineSharpEdge(new Point(point.x + this.width / 2, point.y + this.height / 2), point2, 14, 7);
        graphics.setColor(Color.white);
        graphics.fillPolygon((Polygon)this.endingShape);
        graphics.setColor(color);
        graphics.drawPolygon((Polygon)this.endingShape);
    }

    protected void drawSquareEnd(Graphics graphics, Point point) {
        this.endingShape = new Rectangle(point.x - 5, point.y - 5, 10, 10);
        graphics.fillRect(point.x - 5, point.y - 5, 10, 10);
    }

    protected void drawRoundEnd(Graphics graphics, Point point) {
        graphics.fillOval(point.x - 5, point.y - 5, 10, 10);
    }

    protected void drawDiamondEnd(Graphics graphics, Point point, Point point2) {
        this.endingShape = this.defineDiamondEdge(new Point(point.x + this.width / 2, point.y + this.height / 2), point2);
        graphics.setColor(Color.white);
        graphics.fillPolygon((Polygon)this.endingShape);
        graphics.setColor(Color.black);
        graphics.drawPolygon((Polygon)this.endingShape);
    }

    protected void fixBounds(Point point, Point point2) {
        this.q = point;
        this.p = point2;
    }

    protected void prepareColor(Graphics graphics) {
        if (this.selected) {
            graphics.setColor(Color.red);
        }
    }

    protected void drawEnding(Graphics graphics, int n, Point point, Point point2) {
        switch (n) {
            case 0: {
                break;
            }
            case 1: {
                this.drawSharpEnd(graphics, point, point2);
                break;
            }
            case 2: {
                this.drawSquareEnd(graphics, point2);
                break;
            }
            case 3: {
                this.drawRoundEnd(graphics, point2);
                break;
            }
            case 4: {
                this.drawDiamondEnd(graphics, point, point2);
                break;
            }
            case 5: {
                this.drawWhiteSharpEnd(graphics, point, point2);
            }
        }
    }

    public void paint(Graphics graphics) {
        this.prepareColor(graphics);
        GObject gObject = ((SArrow)this.getSElement()).getOrigin().getGObject();
        GObject gObject2 = ((SArrow)this.getSElement()).getTarget().getGObject();
        Point point = gObject.getLocation();
        Point point2 = gObject2.getLocation();
        Dimension dimension = gObject.getDimension();
        Dimension dimension2 = gObject2.getDimension();
        if (this.lineStyle == 1) {
            this.x = (point.x + dimension.width / 2 + point2.x + dimension2.width / 2) / 2;
            this.y = (point.y + dimension.height / 2 + point2.y + dimension2.height / 2) / 2;
        }
        this.q = gObject.intersection(this.getLocation());
        this.p = gObject2.intersection(this.getLocation());
        if (this.lineStyle == 1) {
            graphics.drawLine(this.q.x, this.q.y, this.p.x, this.p.y);
        } else {
            graphics.drawLine(this.q.x, this.q.y, this.x, this.y);
            graphics.fillOval(this.x - this.ra, this.y - this.ra, 2 * this.ra, 2 * this.ra);
            graphics.drawLine(this.x, this.y, this.p.x, this.p.y);
        }
        if (this.startingForm == -1 || this.endingForm == -1) {
            this.startingForm = this.startingForm;
            this.endingForm = this.endingForm;
        }
        this.drawEnding(graphics, this.startingForm, this.getLocation(), this.q);
        this.drawEnding(graphics, this.endingForm, this.getLocation(), this.p);
    }

    public void displayName(Graphics graphics) {
        String string = this.getSElement().getLabel();
        if (string == null) {
            string = this.getSElement().getID();
        }
        if (this.displayLabel) {
            switch (this.labelLocation) {
                case 5: {
                    FontMetrics fontMetrics = graphics.getFontMetrics(graphics.getFont());
                    int n = fontMetrics.stringWidth(string);
                    graphics.drawString(string, this.x - n / 2, this.y - 2);
                    break;
                }
                case 6: {
                    graphics.drawString(string, this.x + 4, this.y - 4);
                    break;
                }
                case 4: {
                    FontMetrics fontMetrics = graphics.getFontMetrics(graphics.getFont());
                    int n = fontMetrics.stringWidth(string);
                    graphics.drawString(string, this.x - n / 2, this.y + 10);
                    break;
                }
                case 3: {
                    FontMetrics fontMetrics = graphics.getFontMetrics(graphics.getFont());
                    int n = fontMetrics.stringWidth(string);
                    graphics.drawString(string, this.x - n / 2, this.y - 4);
                    break;
                }
            }
        }
    }

    public void snapToGrid(int n) {
    }

    public boolean contains(Point point) {
        int n = (this.x - point.x) * (this.x - point.x) + (this.y - point.y) * (this.y - point.y);
        int n2 = this.ras * this.ras;
        return n <= n2;
    }

    public boolean isContainedIn(Rectangle rectangle) {
        return rectangle.contains(this.x + this.width / 2, this.y + this.height / 2);
    }

    public boolean isContainedIn(Polygon polygon) {
        return polygon.contains(this.x + this.width / 2, this.y + this.height / 2);
    }

    public Point intersection(Point point) {
        return new Point(this.x + this.width / 2, this.y + this.height / 2);
    }

    public Dimension getDimension() {
        return this.getBounds().getSize();
    }

    public Rectangle getBounds() {
        Rectangle rectangle = new Rectangle(this.p);
        rectangle.add(this.q);
        if (this.lineStyle != 1) {
            Rectangle rectangle2 = new Rectangle(this.x - this.ra, this.y - this.ra, 2 * this.ra, 2 * this.ra);
            rectangle.add(rectangle2);
        }
        if (this.endingShape != null) {
            rectangle.add(this.endingShape.getBounds());
        }
        if (this.midShape != null) {
            rectangle.add(this.midShape.getBounds());
        }
        if (this.startingShape != null) {
            rectangle.add(this.startingShape.getBounds());
        }
        return rectangle;
    }
}

