/*
 * Decompiled with CFR 0.152.
 */
package SEdit;

import SEdit.FileExtension;
import SEdit.Formalism;
import SEdit.SEditMessage;
import SEdit.XMLFormalism;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Vector;
import madkit.kernel.Agent;
import madkit.kernel.Message;

public class FormalismAgent
extends Agent {
    public static final String FORMALISM_FOLDER = "lib/formalisms";
    XMLFormalism xf = new XMLFormalism();
    public Vector formalisms = new Vector();

    public FormalismAgent() {
        File file = new File(System.getProperty("madkit.dir"));
        File file2 = new File(file, FORMALISM_FOLDER);
        if (file2 != null) {
            this.getFromDirectory(file2);
        }
    }

    public void getFromDirectory(File file) {
        Vector vector = new Vector();
        String[] stringArray = file.list(new FileExtension(".fml"));
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                Formalism formalism = this.xf.parse(file.getPath() + File.separatorChar + stringArray[i]);
                formalism.setBase(file.getPath() + File.separatorChar);
                this.updateFormalisms(formalism);
            }
        }
    }

    public void activate() {
        this.createGroup(false, "sedit", null, null);
        this.requestRole("sedit", "formalism-server", null);
        this.println("Yip! the formalism-server is up & running");
    }

    protected void updateFormalisms(Formalism formalism) {
        this.formalisms.addElement(formalism);
    }

    protected void handleMessage(SEditMessage sEditMessage) {
        Object object;
        String string = sEditMessage.getRequest();
        this.println("received message:" + string);
        if (string.equals("load")) {
            this.loadFormalism((String)sEditMessage.getParameter());
        }
        if (string.equals("www-get")) {
            this.downloadFormalism((String)sEditMessage.getParameter());
        }
        if (string.equals("get")) {
            object = this.getFormalism((String)sEditMessage.getParameter());
            this.println("Looking for " + (String)sEditMessage.getParameter());
            SEditMessage sEditMessage2 = new SEditMessage("reply", object, sEditMessage.getFileName());
            this.sendMessage(sEditMessage.getSender(), sEditMessage2);
        }
        if (string.equals("list")) {
            object = new Vector();
            for (int i = 0; i < this.formalisms.size(); ++i) {
                Formalism formalism = (Formalism)this.formalisms.elementAt(i);
                String[] stringArray = new String[]{formalism.getName(), formalism.getDescription()};
                ((Vector)object).addElement(stringArray);
            }
            SEditMessage sEditMessage3 = new SEditMessage("reply", object);
            this.sendMessage(sEditMessage.getSender(), sEditMessage3);
        }
    }

    public Formalism getFormalism(String string) {
        for (int i = 0; i < this.formalisms.size(); ++i) {
            Formalism formalism = (Formalism)this.formalisms.elementAt(i);
            if (!formalism.getName().equals(string)) continue;
            return formalism;
        }
        return null;
    }

    void loadFormalism(String string) {
        this.println(":: loading formalism : " + string);
        Formalism formalism = this.xf.parse(string);
        if (formalism != null) {
            formalism.setBase(string);
            this.updateFormalisms(formalism);
            this.println(":: formalism : " + string + " loaded");
            String[] stringArray = new String[]{formalism.getName(), formalism.getDescription()};
            this.broadcastMessage("sedit", "control-center", new SEditMessage("update", stringArray));
        } else {
            this.println(":: ERROR loading formalism : " + string);
        }
    }

    void downloadFormalism(String string) {
        try {
            this.println(":: loading formalism : " + string);
            URL uRL = new URL(string);
            Formalism formalism = this.xf.parse(string);
            if (formalism != null) {
                formalism.setBase(uRL);
                this.updateFormalisms(formalism);
                this.println(":: formalism : " + string + " loaded");
                String[] stringArray = new String[]{formalism.getName(), formalism.getDescription()};
                this.broadcastMessage("sedit", "control-center", new SEditMessage("update", stringArray));
            } else {
                this.println(":: ERROR loading formalism : " + string);
            }
        }
        catch (MalformedURLException malformedURLException) {
            System.err.println(malformedURLException);
        }
    }

    public void live() {
        while (true) {
            this.println("Waiting for messages");
            Message message = this.waitNextMessage();
            if (!(message instanceof SEditMessage)) continue;
            this.handleMessage((SEditMessage)message);
        }
    }
}

