/*
 * Decompiled with CFR 0.152.
 */
package madkit.share;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import madkit.TreeTools.DirEntry;
import madkit.kernel.AbstractAgent;
import madkit.kernel.AgentAddress;
import madkit.kernel.Message;
import madkit.share.AbstractServerAgent;
import madkit.share.FicDataBase;
import madkit.share.FicMessage;
import madkit.share.FileInfo;
import madkit.share.IndexMessage;
import madkit.share.ListFic;
import madkit.share.ListPluginInfo;
import madkit.share.PluginInfo;
import madkit.share.PluginInfoMessage;
import madkit.share.PluginVersionNumber;
import madkit.share.RequestPluginInfoMessage;
import madkit.share.SmallSenderAgent;

public class PluginServerAgent
extends AbstractServerAgent {
    public String pluginsPath;
    DirEntry dir;
    ListPluginInfo listPluginInfo;

    public FicDataBase getData() {
        return this.dataBase;
    }

    public PluginServerAgent() {
        this.setGroupName("madkit_update");
    }

    public void activate() {
        this.createGroup(true, this.groupName, null, null);
        this.requestRole(this.groupName, this.roleName, null);
        this.live = true;
        this.initDir();
        this.println("group: " + this.getGroupName());
        this.dataBase = new FicDataBase();
        this.listPluginInfo = new ListPluginInfo();
        this.initPluginsDataBase(this.dataBase);
    }

    public void live() {
        while (this.live) {
            Message message = this.waitNextMessage();
            try {
                this.handleMessage(message);
            }
            catch (IOException iOException) {
                System.out.println("Error : SenderAgent --> HandleMessage");
            }
        }
    }

    public void end() {
        for (int i = 0; i < this.smallSenderAgentList.size(); ++i) {
            this.killAgent((AbstractAgent)((SmallSenderAgent)((Object)this.smallSenderAgentList.elementAt(i))));
        }
    }

    void handleMessage(Message message) throws IOException {
        if (message instanceof RequestPluginInfoMessage) {
            this.println("(server) RequestPluginInfoMessage received");
            AgentAddress agentAddress = ((RequestPluginInfoMessage)message).getSender();
            this.sendMessage(agentAddress, new PluginInfoMessage(this.listPluginInfo));
        } else if (message instanceof FicMessage) {
            String string = ((FicMessage)message).getSender().getKernel().getHost().toString();
            AgentAddress agentAddress = ((FicMessage)message).getSender();
            String string2 = ((FicMessage)message).getPath();
            boolean bl = ((FicMessage)message).getUpdatePlugin();
            this.println("(server) Request file " + string2);
            String string3 = this.dataBase.searchRealPath(string2);
            if (string3.equals("error")) {
                this.println("Non authorized file :" + string2);
                return;
            }
            ListFic listFic = new ListFic();
            File file = new File(string3);
            if (file.isDirectory()) {
                if (bl) {
                    this.dirPluginIndex(string2, string3, listFic);
                } else {
                    this.println("cannot cope with non plugin request from: " + message.getSender());
                }
            } else {
                int n = (int)file.length();
                FileInfo fileInfo = new FileInfo(string2, n);
                listFic.getVector().addElement(fileInfo);
            }
            this.sendMessage(agentAddress, new IndexMessage(listFic, this.getAddress(), bl));
        } else {
            super.handleMessage(message);
        }
    }

    public void initDir() {
        this.madkitDirectory = System.getProperty("madkit.dir");
        this.pluginsPath = this.madkitDirectory + File.separator + "plugins";
    }

    public void dirPluginIndex(String string, String string2, ListFic listFic) {
        File file = new File(string2);
        File[] fileArray = file.listFiles();
        if (fileArray != null) {
            for (int i = 0; i < fileArray.length; ++i) {
                File file2 = fileArray[i];
                if (file2.getName().equals("build")) continue;
                if (file2.isDirectory()) {
                    this.dirPluginIndex(string + separator + file2.getName(), string2 + separator + file2.getName(), listFic);
                    continue;
                }
                if (!file2.canRead()) continue;
                int n = (int)file2.length();
                FileInfo fileInfo = new FileInfo(string + separator + file2.getName(), n);
                listFic.getVector().addElement(fileInfo);
            }
        }
    }

    public void initPluginsDataBase(FicDataBase ficDataBase) {
        this.println("Server Plugins Path --> " + this.pluginsPath);
        File file = new File(this.pluginsPath);
        if (file.exists()) {
            ficDataBase.addDir(this.pluginsPath);
            File file2 = new File(this.pluginsPath);
            File[] fileArray = file2.listFiles();
            if (fileArray != null) {
                for (int i = 0; i < fileArray.length; ++i) {
                    File file3 = fileArray[i];
                    String string = file3.getName();
                    File file4 = new File(this.pluginsPath + File.separator + string + File.separator + string + ".properties");
                    if (!file4.exists() || !file4.canRead()) continue;
                    try {
                        String string2;
                        RandomAccessFile randomAccessFile = new RandomAccessFile(file4, "r");
                        while ((string2 = randomAccessFile.readLine()) != null) {
                            int n = string2.indexOf("madkit.plugin.version=");
                            if (n == -1) continue;
                            PluginVersionNumber pluginVersionNumber = new PluginVersionNumber(string2.substring(n + 22, string2.length()));
                            this.listPluginInfo.add(new PluginInfo(string, pluginVersionNumber, "plugins/" + string));
                        }
                        randomAccessFile.close();
                        continue;
                    }
                    catch (IOException iOException) {
                        this.println("(Server) Can't read plugin " + string + " properties ");
                    }
                }
                this.println(this.listPluginInfo.displayToString());
            }
        }
    }
}

