/*
 * Decompiled with CFR 0.152.
 */
package madkit.chat;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.io.Serializable;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import madkit.chat.ChatAgent;
import madkit.kernel.AgentAddress;

public class ChatAgentGUI_JoinBox
extends JDialog
implements ActionListener,
Serializable {
    JPanel pMain = new JPanel();
    BorderLayout borderLayout1 = new BorderLayout();
    JLabel lTop = new JLabel();
    JPanel pCenter = new JPanel();
    JLabel jLabel1 = new JLabel();
    JTextField jTextField1 = new JTextField();
    JButton bJoinOK = new JButton();
    GridLayout gridLayout1 = new GridLayout();
    ChatAgent agentChat;
    String[] tabChNames;
    JComboBox jComboBox1;

    public ChatAgentGUI_JoinBox(Frame frame) {
        this.enableEvents(64L);
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.pack();
    }

    public ChatAgentGUI_JoinBox(ChatAgent chatAgent) {
        this.agentChat = chatAgent;
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.pack();
    }

    protected void processWindowEvent(WindowEvent windowEvent) {
        if (windowEvent.getID() == 201) {
            this.cancel();
        }
        super.processWindowEvent(windowEvent);
    }

    void cancel() {
        this.dispose();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.bJoinOK) {
            this.cancel();
        }
    }

    private void jbInit() throws Exception {
        this.tabChNames = this.agentChat.getChannelsNamesList();
        this.jComboBox1 = this.tabChNames == null ? new JComboBox() : new JComboBox<String>(this.tabChNames);
        this.setTitle("Join");
        this.pMain.setLayout(this.borderLayout1);
        this.lTop.setText("Please, enter or select the channel's name you ");
        this.pCenter.setLayout(this.gridLayout1);
        this.jLabel1.setText("will be happy to join or create.");
        this.jTextField1.setMaximumSize(new Dimension(4, 17));
        this.jTextField1.setToolTipText("write the channel's name you want to join/create here.");
        this.jTextField1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ChatAgentGUI_JoinBox.this.bJoin_actionPerformed(actionEvent);
            }
        });
        this.jComboBox1.setToolTipText("Select the channel's name you want to join in the list.");
        this.bJoinOK.setBorder(BorderFactory.createRaisedBevelBorder());
        this.bJoinOK.setHorizontalTextPosition(2);
        this.bJoinOK.setText("OK Join");
        this.bJoinOK.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ChatAgentGUI_JoinBox.this.bJoin_actionPerformed(actionEvent);
            }
        });
        this.gridLayout1.setRows(5);
        this.gridLayout1.setColumns(2);
        this.getContentPane().add((Component)this.pMain, "Center");
        this.pMain.add((Component)this.lTop, "North");
        this.pMain.add((Component)this.pCenter, "Center");
        this.pCenter.add((Component)this.jLabel1, null);
        this.pCenter.add((Component)this.jComboBox1, null);
        this.pCenter.add((Component)this.jTextField1, null);
        this.pCenter.add((Component)this.bJoinOK, null);
    }

    public void bJoin_actionPerformed(ActionEvent actionEvent) {
        if (!this.jTextField1.getText().equals("")) {
            String string = this.jTextField1.getText();
            AgentAddress[] agentAddressArray = this.agentChat.getAgentsWithRole("Chat", string, "chatter");
            if (!this.agentChat.display.isExistChatPanel(this.jTextField1.getText())) {
                if (agentAddressArray.length == 0) {
                    this.agentChat.display.addNewChatPanel(this.jTextField1.getText());
                    this.agentChat.sendAddChannel(string);
                    this.agentChat.addChannelForChatter(string);
                } else {
                    this.agentChat.display.addNewChatPanel(string);
                    this.agentChat.sendMAJNbrUsrersOfChannel(string);
                    this.agentChat.addChannelForChatter(string);
                }
                this.dispose();
            } else {
                this.jLabel1.setText("Channel already in use on your chat");
            }
        } else {
            String string = (String)this.jComboBox1.getSelectedItem();
            if (!this.agentChat.display.isExistChatPanel(string)) {
                this.agentChat.display.addNewChatPanel(string);
                this.agentChat.sendMAJNbrUsrersOfChannel(string);
                this.agentChat.addChannelForChatter(string);
                this.dispose();
            } else {
                this.jLabel1.setText("Channel already in use on your chat");
            }
        }
    }
}

