/*
 * Decompiled with CFR 0.152.
 */
package madkit.chat;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.border.TitledBorder;
import madkit.chat.ChatAgent;
import madkit.chat.ChatAgentGUI_AboutBox;
import madkit.chat.ChatAgentGUI_BanBox;
import madkit.chat.ChatAgentGUI_JoinBox;
import madkit.chat.ChatAgentGUI_KickBox;
import madkit.chat.ChatAgentGUI_ListBox;
import madkit.chat.ChatAgentGUI_NamesBox;
import madkit.chat.ChatAgentGUI_NickBox;
import madkit.chat.ChatAgentGUI_QueryBox;
import madkit.chat.ChatAgentGUI_RetireBox;
import madkit.chat.ChatAgentGUI_TopicBox;
import madkit.chat.JTextAreaWriter;

public class ChatAgentGUI
extends JRootPane {
    boolean flag = false;
    Vector chattersNameList;
    protected PrintWriter out;
    protected PrintWriter nick;
    protected JTextArea inputArea;
    Hashtable channelOut = new Hashtable();
    Hashtable channelPanel = new Hashtable();
    Hashtable channelNickArea = new Hashtable();
    JPanel contentPane;
    JMenuBar jMenuBar1 = new JMenuBar();
    JMenu jMenuFile = new JMenu();
    JMenuItem jMenuFileExit = new JMenuItem();
    JMenu jMenuHelp = new JMenu();
    JMenuItem jMenuHelpAbout = new JMenuItem();
    JToolBar jToolBar = new JToolBar();
    JButton bOpen = new JButton();
    JButton bSave = new JButton();
    JButton bHelp = new JButton();
    JLabel lBlank = new JLabel();
    JButton bNickname = new JButton();
    ImageIcon image1;
    ImageIcon image2;
    ImageIcon image3;
    ImageIcon chatterImage;
    ImageIcon adminImage;
    JLabel statusBar = new JLabel();
    BorderLayout borderLayout1 = new BorderLayout();
    JPanel jLeftP = new JPanel();
    JPanel jCenterP = new JPanel();
    GridLayout gridLayout2 = new GridLayout();
    TitledBorder titledBorder1;
    BorderLayout borderLayout2 = new BorderLayout();
    JLabel lBottom = new JLabel();
    JPanel pCenter = new JPanel();
    JButton bBan = new JButton();
    JButton bTopic = new JButton();
    JButton bList = new JButton();
    JButton bQuery = new JButton();
    JButton bNames = new JButton();
    JButton bKick = new JButton();
    JToolBar jToolBar1 = new JToolBar();
    JButton bNick = new JButton();
    JButton bJoin = new JButton();
    JLabel lChanelTopic = new JLabel();
    JTabbedPane jTabbedPane2 = new JTabbedPane();
    JSplitPane jSplitPane1 = new JSplitPane();
    JLabel lChanelName = new JLabel();
    GridLayout gridLayout4 = new GridLayout();
    JPanel pMChatUp = new JPanel();
    BorderLayout borderLayout3 = new BorderLayout();
    JPanel pMiniChat = new JPanel();
    JTextField tWriteArea = new JTextField();
    GridBagLayout gridBagLayout1 = new GridBagLayout();
    JScrollPane pChatArea = new JScrollPane();
    JTextArea tChatArea = new JTextArea();
    JScrollPane pNames = new JScrollPane();
    JTextArea tNamesArea = new JTextArea();
    ChatAgent agentChat;
    JPanel panelTMP = new JPanel();

    public PrintWriter stdout() {
        return this.out;
    }

    public PrintWriter stdnick() {
        return this.nick;
    }

    public void println(String string) {
        this.stdout().println(string);
    }

    public void printlnOnChannel(String string, String string2) {
        this.givePrintWriterLinkedWithTabbedPane(string).println(string2);
    }

    public void printNickln(String string) {
        this.stdnick().println(string);
    }

    private ChatAgent getMyAgent() {
        return this.agentChat;
    }

    public ChatAgentGUI(ChatAgent chatAgent) {
        this.agentChat = chatAgent;
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            System.out.println("Erreur lors de l'appel de jbInit() ds la classe ChatAgentGUI");
            exception.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.chattersNameList = new Vector();
        this.out = new PrintWriter((Writer)new JTextAreaWriter(this.tChatArea), true);
        this.nick = new PrintWriter((Writer)new JTextAreaWriter(this.tNamesArea), true);
        this.image1 = new ImageIcon(ChatAgentGUI.class.getResource("/images/toolbars/openFile.gif"));
        this.image2 = new ImageIcon(ChatAgentGUI.class.getResource("/images/toolbars/closeFile.gif"));
        this.image3 = new ImageIcon(ChatAgentGUI.class.getResource("/images/toolbars/help.gif"));
        this.chatterImage = new ImageIcon(ChatAgentGUI.class.getResource("/images/agents/individual_green24.jpg"));
        this.adminImage = new ImageIcon(ChatAgentGUI.class.getResource("/images/agents/individual_red24.jpg"));
        this.contentPane = (JPanel)this.getContentPane();
        this.titledBorder1 = new TitledBorder("");
        this.contentPane.setLayout(this.borderLayout1);
        this.setSize(new Dimension(400, 300));
        this.statusBar.setText(" ");
        this.jMenuFile.setText("File");
        this.jMenuFileExit.setText("Quit");
        this.jMenuFileExit.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ChatAgentGUI.this.jMenuFileExit_actionPerformed(actionEvent);
            }
        });
        this.jMenuHelp.setText("Help");
        this.jMenuHelpAbout.setText("About");
        this.jMenuHelpAbout.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ChatAgentGUI.this.jMenuHelpAbout_actionPerformed(actionEvent);
            }
        });
        this.bOpen.setIcon(this.image1);
        this.bOpen.setText("Open");
        this.bOpen.setToolTipText("Open a file");
        this.bSave.setIcon(this.image2);
        this.bSave.setText("Save");
        this.bSave.setToolTipText("Close a file");
        this.bHelp.setIcon(this.image3);
        this.bHelp.setText("Help");
        this.bHelp.setToolTipText("Help");
        this.lBlank.setText("                      ");
        this.jCenterP.setLayout(this.borderLayout2);
        this.jLeftP.setLayout(this.gridLayout2);
        this.pCenter.setLayout(this.gridBagLayout1);
        this.specifButton(this.bBan, "   Ban  ", 'B', "Ban one user from the chat", 1, true);
        this.bBan.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ChatAgentGUI.this.bBan_actionPerformed(actionEvent);
            }
        });
        this.specifButton(this.bTopic, " Topic  ", 'T', "Change a chanel's topic", 1, false);
        this.bTopic.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ChatAgentGUI.this.bTopic_actionPerformed(actionEvent);
            }
        });
        this.specifButton(this.bList, "  List ", 'L', "List the chat's chanels available", 1, true);
        this.bList.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ChatAgentGUI.this.bList_actionPerformed(actionEvent);
            }
        });
        this.specifButton(this.bQuery, " Query  ", 'Q', "Search one chat's user", 1, true);
        this.bQuery.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ChatAgentGUI.this.bQuery_actionPerformed(actionEvent);
            }
        });
        this.specifButton(this.bNames, "  Names ", 'N', "Display chat's user's names", 1, true);
        this.bNames.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ChatAgentGUI.this.bNames_actionPerformed(actionEvent);
            }
        });
        this.specifButton(this.bKick, "  Kick  ", 'K', "Kick one user out of the chat", 1, true);
        this.bKick.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ChatAgentGUI.this.bKick_actionPerformed(actionEvent);
            }
        });
        this.specifButton(this.bNick, "Remove", 'R', "Your chat nickname", 1, true);
        this.bNick.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ChatAgentGUI.this.bRetire_actionPerformed();
            }
        });
        this.specifButton(this.bJoin, "  Join  ", 'J', "Join a chat channel", 1, true);
        this.bJoin.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ChatAgentGUI.this.bJoin_actionPerformed(actionEvent);
            }
        });
        this.lChanelTopic.setText("Default channel's subject");
        this.lChanelTopic.setHorizontalAlignment(2);
        this.lChanelTopic.setBorder(BorderFactory.createRaisedBevelBorder());
        this.lChanelTopic.setBackground(Color.gray);
        this.jSplitPane1.setDividerSize(8);
        this.jSplitPane1.setOneTouchExpandable(true);
        this.lChanelName.setBackground(Color.gray);
        this.lChanelName.setBorder(BorderFactory.createRaisedBevelBorder());
        this.lChanelName.setHorizontalAlignment(2);
        this.lChanelName.setHorizontalTextPosition(2);
        this.lChanelName.setText("Default channel's name");
        this.gridLayout4.setColumns(3);
        this.pMChatUp.setLayout(this.gridLayout4);
        this.pMiniChat.setLayout(this.borderLayout3);
        this.tWriteArea.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ChatAgentGUI.this.tWriteArea_actionPerformed(actionEvent);
            }
        });
        this.jMenuFile.add(this.jMenuFileExit);
        this.jMenuHelp.add(this.jMenuHelpAbout);
        this.jMenuBar1.add(this.jMenuFile);
        this.jMenuBar1.add(this.jMenuHelp);
        this.setJMenuBar(this.jMenuBar1);
        this.contentPane.add((Component)this.statusBar, "East");
        this.contentPane.add((Component)this.pCenter, "Center");
        this.jToolBar1.add(this.bNick);
        this.jToolBar1.add(this.bJoin);
        this.jToolBar1.add(this.bList);
        this.jToolBar1.add((Component)this.bNames, null);
        this.jToolBar1.add((Component)this.bQuery, null);
        this.jToolBar1.add((Component)this.bKick, null);
        this.jToolBar1.add((Component)this.bBan, null);
        this.jToolBar1.add((Component)this.bTopic, null);
        this.pCenter.add((Component)this.jToolBar1, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 75, 8));
        this.pCenter.add((Component)this.jTabbedPane2, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 158, 56));
        this.jTabbedPane2.addTab("defaultChannel", this.pMiniChat);
        this.jSplitPane1.add((Component)this.pChatArea, "top");
        this.jSplitPane1.add((Component)this.pNames, "bottom");
        this.pNames.getViewport().add((Component)this.tNamesArea, null);
        this.pChatArea.getViewport().add((Component)this.tChatArea, null);
        this.pMiniChat.add((Component)this.tWriteArea, "South");
        this.pMiniChat.add((Component)this.pMChatUp, "North");
        this.pMiniChat.add((Component)this.jSplitPane1, "Center");
        this.pMChatUp.add((Component)this.lChanelName, null);
        this.pMChatUp.add((Component)this.lChanelTopic, null);
        this.contentPane.add((Component)this.lBottom, "South");
        this.jSplitPane1.setDividerLocation(314);
        this.channelOut.put("defaultChannel", this.out);
        this.channelPanel.put("defaultChannel", this.pMiniChat);
        this.allowOnlyNickname();
        this.bNickname.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ChatAgentGUI.this.bNickname_actionPerformed();
            }
        });
    }

    public void addNewChatPanel(String string) {
        final String string2 = string;
        JPanel jPanel = new JPanel();
        BorderLayout borderLayout = new BorderLayout();
        JTextField jTextField = new JTextField();
        JPanel jPanel2 = new JPanel();
        JLabel jLabel = new JLabel();
        JLabel jLabel2 = new JLabel();
        JSplitPane jSplitPane = new JSplitPane();
        JScrollPane jScrollPane = new JScrollPane();
        JScrollPane jScrollPane2 = new JScrollPane();
        final JTextArea jTextArea = new JTextArea();
        JTextArea jTextArea2 = new JTextArea();
        jLabel.setText(string);
        jLabel.setHorizontalAlignment(2);
        jLabel.setBorder(BorderFactory.createRaisedBevelBorder());
        jLabel.setBackground(Color.gray);
        jLabel2.setText("unknown topic");
        jLabel2.setHorizontalAlignment(2);
        jLabel2.setBorder(BorderFactory.createRaisedBevelBorder());
        jLabel2.setBackground(Color.gray);
        jSplitPane.setDividerSize(8);
        jSplitPane.setOneTouchExpandable(true);
        jSplitPane.add((Component)jScrollPane, "top");
        jSplitPane.add((Component)jScrollPane2, "bottom");
        jScrollPane2.getViewport().add((Component)jTextArea, null);
        jScrollPane.getViewport().add((Component)jTextArea2, null);
        final PrintWriter printWriter = new PrintWriter((Writer)new JTextAreaWriter(jTextArea2), true);
        final PrintWriter printWriter2 = new PrintWriter((Writer)new JTextAreaWriter(jTextArea), true);
        jTextField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ChatAgentGUI.this.tWriteArea_actionPerformed(actionEvent, printWriter, string2, printWriter2, jTextArea);
            }
        });
        jSplitPane.setDividerLocation(314);
        jPanel2.setLayout(this.gridLayout4);
        jPanel2.add((Component)jLabel, null);
        jPanel2.add((Component)jLabel2, null);
        jPanel.setLayout(borderLayout);
        jPanel.add((Component)jTextField, "South");
        jPanel.add((Component)jPanel2, "North");
        jPanel.add((Component)jSplitPane, "Center");
        this.jTabbedPane2.addTab(string, jPanel);
        this.channelOut.put(string, printWriter);
        this.channelPanel.put(string, jPanel);
        this.channelNickArea.put(string, printWriter2);
        this.agentChat.createGroup(true, "Chat", string, null, null);
        this.agentChat.requestRole("Chat", string, "chatter", null);
    }

    public void removeChatPanel(String string) {
        if (this.channelPanel.containsKey(string)) {
            JPanel jPanel = (JPanel)this.channelPanel.get(string);
            this.jTabbedPane2.remove(jPanel);
            this.channelOut.remove(string);
            this.channelPanel.remove(string);
            this.agentChat.sendRemoveChannel(string);
        }
    }

    public void removeChatPanelViewOnly(String string) {
        if (this.channelPanel.containsKey(string)) {
            JPanel jPanel = (JPanel)this.channelPanel.get(string);
            this.jTabbedPane2.remove(jPanel);
            this.channelOut.remove(string);
            this.channelPanel.remove(string);
        }
    }

    public boolean isExistChatPanel(String string) {
        boolean bl = this.channelOut.containsKey(string);
        return bl;
    }

    public PrintWriter givePrintWriterLinkedWithTabbedPane(String string) {
        PrintWriter printWriter = null;
        if (!this.channelOut.isEmpty()) {
            printWriter = (PrintWriter)this.channelOut.get(string);
        }
        return printWriter;
    }

    public void addNicknameButton() {
        if (this.agentChat.getChatterRole(this.agentChat.getChatter()).equals("Admin")) {
            this.bNickname.setIcon(this.adminImage);
        } else {
            this.bNickname.setIcon(this.chatterImage);
        }
        this.bNickname.setText(this.agentChat.getChatter());
        this.bNickname.setToolTipText("Your nickname");
        this.jToolBar1.add(this.bNickname);
    }

    public void specifButton(JButton jButton, String string, char c, String string2, int n, boolean bl) {
        jButton.setText(string);
        jButton.setMnemonic(c);
        jButton.setToolTipText(string2);
        jButton.setEnabled(bl);
        if (n == 1) {
            jButton.setBorder(BorderFactory.createRaisedBevelBorder());
        }
    }

    public void allowOnlyNickname() {
        this.bNick.setEnabled(true);
        this.bKick.setEnabled(false);
        this.bList.setEnabled(false);
        this.bTopic.setEnabled(false);
        this.bJoin.setEnabled(false);
        this.bNames.setEnabled(false);
        this.bQuery.setEnabled(false);
        this.bBan.setEnabled(false);
    }

    public void allowChatterRight() {
        this.bNick.setEnabled(true);
        this.bKick.setEnabled(false);
        this.bList.setEnabled(true);
        this.bTopic.setEnabled(true);
        this.bJoin.setEnabled(true);
        this.bNames.setEnabled(true);
        this.bQuery.setEnabled(true);
        this.bBan.setEnabled(false);
    }

    public void allowEverything() {
        this.bNick.setEnabled(true);
        this.bKick.setEnabled(true);
        this.bList.setEnabled(true);
        this.bTopic.setEnabled(true);
        this.bJoin.setEnabled(true);
        this.bNames.setEnabled(true);
        this.bQuery.setEnabled(true);
        this.bBan.setEnabled(true);
    }

    public void jMenuFileExit_actionPerformed(ActionEvent actionEvent) {
    }

    public void jMenuHelpAbout_actionPerformed(ActionEvent actionEvent) {
        ChatAgentGUI_AboutBox chatAgentGUI_AboutBox = new ChatAgentGUI_AboutBox();
        Dimension dimension = chatAgentGUI_AboutBox.getPreferredSize();
        Dimension dimension2 = this.getSize();
        Point point = this.getLocation();
        chatAgentGUI_AboutBox.setModal(false);
        chatAgentGUI_AboutBox.show();
    }

    public void bJoin_actionPerformed(ActionEvent actionEvent) {
        ChatAgentGUI_JoinBox chatAgentGUI_JoinBox = new ChatAgentGUI_JoinBox(this.agentChat);
        Dimension dimension = chatAgentGUI_JoinBox.getPreferredSize();
        Dimension dimension2 = this.getSize();
        Point point = this.getLocation();
        chatAgentGUI_JoinBox.setModal(false);
        chatAgentGUI_JoinBox.show();
    }

    public void bQuery_actionPerformed(ActionEvent actionEvent) {
        ChatAgentGUI_QueryBox chatAgentGUI_QueryBox = new ChatAgentGUI_QueryBox(this.agentChat);
        Dimension dimension = chatAgentGUI_QueryBox.getPreferredSize();
        Dimension dimension2 = this.getSize();
        Point point = this.getLocation();
        chatAgentGUI_QueryBox.setModal(false);
        chatAgentGUI_QueryBox.show();
    }

    public void bKick_actionPerformed(ActionEvent actionEvent) {
        ChatAgentGUI_KickBox chatAgentGUI_KickBox = new ChatAgentGUI_KickBox(this.agentChat);
        Dimension dimension = chatAgentGUI_KickBox.getPreferredSize();
        Dimension dimension2 = this.getSize();
        Point point = this.getLocation();
        chatAgentGUI_KickBox.setModal(false);
        chatAgentGUI_KickBox.show();
    }

    public void bBan_actionPerformed(ActionEvent actionEvent) {
        ChatAgentGUI_BanBox chatAgentGUI_BanBox = new ChatAgentGUI_BanBox(this.agentChat);
        Dimension dimension = chatAgentGUI_BanBox.getPreferredSize();
        Dimension dimension2 = this.getSize();
        Point point = this.getLocation();
        chatAgentGUI_BanBox.setModal(false);
        chatAgentGUI_BanBox.show();
    }

    public void bTopic_actionPerformed(ActionEvent actionEvent) {
        ChatAgentGUI_TopicBox chatAgentGUI_TopicBox = new ChatAgentGUI_TopicBox(this.agentChat);
        Dimension dimension = chatAgentGUI_TopicBox.getPreferredSize();
        Dimension dimension2 = this.getSize();
        Point point = this.getLocation();
        chatAgentGUI_TopicBox.setModal(false);
        chatAgentGUI_TopicBox.show();
    }

    public void bList_actionPerformed(ActionEvent actionEvent) {
        ChatAgentGUI_ListBox chatAgentGUI_ListBox = new ChatAgentGUI_ListBox(this.agentChat);
        Dimension dimension = chatAgentGUI_ListBox.getPreferredSize();
        Dimension dimension2 = this.getSize();
        Point point = this.getLocation();
        chatAgentGUI_ListBox.setModal(false);
        chatAgentGUI_ListBox.show();
    }

    public void bNames_actionPerformed(ActionEvent actionEvent) {
        ChatAgentGUI_NamesBox chatAgentGUI_NamesBox = new ChatAgentGUI_NamesBox(this.agentChat);
        Dimension dimension = chatAgentGUI_NamesBox.getPreferredSize();
        Dimension dimension2 = this.getSize();
        Point point = this.getLocation();
        chatAgentGUI_NamesBox.setModal(false);
        chatAgentGUI_NamesBox.show();
    }

    public void bNick_actionPerformed() {
        this.allowEverything();
        ChatAgentGUI_NickBox chatAgentGUI_NickBox = new ChatAgentGUI_NickBox(this.agentChat, this.nick);
        Dimension dimension = chatAgentGUI_NickBox.getPreferredSize();
        Dimension dimension2 = this.getSize();
        Point point = this.getLocation();
        chatAgentGUI_NickBox.setModal(true);
        chatAgentGUI_NickBox.show();
    }

    public void bRetire_actionPerformed() {
        ChatAgentGUI_RetireBox chatAgentGUI_RetireBox = new ChatAgentGUI_RetireBox(this.agentChat);
        Dimension dimension = chatAgentGUI_RetireBox.getPreferredSize();
        Dimension dimension2 = this.getSize();
        Point point = this.getLocation();
        chatAgentGUI_RetireBox.setModal(true);
        chatAgentGUI_RetireBox.show();
    }

    public void bNickname_actionPerformed() {
        if (this.agentChat.getDebug()) {
            System.out.println("START DISPLAY");
            this.agentChat.printnickChatter();
            System.out.println("END DISPLAY");
        }
    }

    public void tWriteArea_actionPerformed(ActionEvent actionEvent) {
        ChatAgent chatAgent = this.getMyAgent();
        String string = ((JTextField)actionEvent.getSource()).getText();
        if (!string.equals("#CHATLIST")) {
            chatAgent.sendChatMessage(string);
            ((JTextField)actionEvent.getSource()).setText("");
            this.stdout().println("me> " + string);
        } else {
            this.sendChattersNameList();
        }
    }

    public void tWriteArea_actionPerformed(ActionEvent actionEvent, PrintWriter printWriter, String string, PrintWriter printWriter2, JTextArea jTextArea) {
        ChatAgent chatAgent = this.getMyAgent();
        String string2 = ((JTextField)actionEvent.getSource()).getText();
        if (!string2.equals("#CHATLIST")) {
            chatAgent.sendChatMessage(string2, string);
            ((JTextField)actionEvent.getSource()).setText("");
            printWriter.println("me> " + string2);
        } else {
            this.sendChattersNameList();
        }
        this.printNickList(printWriter2, string, jTextArea);
    }

    public void printNickList(PrintWriter printWriter, String string, JTextArea jTextArea) {
        int n;
        jTextArea.setText("");
        String[] stringArray = this.agentChat.getNamesList();
        Vector<String> vector = new Vector<String>();
        for (n = 0; n < stringArray.length; ++n) {
            if (!this.agentChat.isChatterInChannel(stringArray[n], string)) continue;
            vector.add(stringArray[n]);
        }
        for (n = 0; n < vector.size(); ++n) {
            printWriter.println(vector.elementAt(n));
        }
    }

    protected void processWindowEvent(WindowEvent windowEvent) {
        if (windowEvent.getID() == 201) {
            this.jMenuFileExit_actionPerformed(null);
        }
    }

    public void addChatterName(String string) {
        this.printNickln(string);
        this.chattersNameList.addElement(string);
    }

    public void resetNamesArea() {
        this.tNamesArea.setText("");
    }

    public void sendChattersNameList() {
        String string = "";
        for (int i = 0; i <= this.chattersNameList.size() - 1; ++i) {
            string = string + (String)this.chattersNameList.elementAt(i) + "[" + this.getMyAgent().getChatter() + "]" + " ";
        }
        this.getMyAgent().sendChatMessage("#CHATLIST " + string);
    }

    void sendSmiley() {
    }
}

