/*
 * Decompiled with CFR 0.152.
 */
package jsynedit;

import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.undo.CompoundEdit;
import javax.swing.undo.UndoManager;

public class UndoComponent
implements UndoableEditListener {
    private UndoManager undoManager = new UndoManager();
    private CompoundEdit compoundEdit = new CompoundEdit();
    private long time = System.currentTimeMillis();
    private long delayTime = 500L;
    private int undoLimit = 100;
    private boolean modified;
    private boolean textModified;
    public static final long SEQUENCE_DELAY = 500L;
    public static final int MAX_UNDOLIMIT = 100;

    public UndoComponent() {
        this.undoManager.setLimit(this.undoLimit);
        this.modified = false;
        this.textModified = false;
    }

    public void undoableEditHappened(UndoableEditEvent undoableEditEvent) {
        long l = System.currentTimeMillis();
        this.textModified = true;
        if (l - this.time < this.delayTime) {
            this.modified = true;
            this.compoundEdit.addEdit(undoableEditEvent.getEdit());
        } else {
            if (this.modified) {
                this.compoundEdit.end();
                this.undoManager.addEdit(this.compoundEdit);
                this.compoundEdit = new CompoundEdit();
            }
            this.compoundEdit.addEdit(undoableEditEvent.getEdit());
            this.modified = true;
        }
        this.time = l;
    }

    public void undo() {
        if (this.modified) {
            this.compoundEdit.end();
            this.undoManager.addEdit(this.compoundEdit);
            this.compoundEdit = new CompoundEdit();
        }
        if (this.undoManager.canUndo()) {
            this.undoManager.undo();
        }
        this.modified = false;
    }

    public void redo() {
        if (this.undoManager.canRedo()) {
            this.undoManager.redo();
        }
    }

    public void reset() {
        this.undoManager.discardAllEdits();
        this.compoundEdit.die();
        this.compoundEdit = new CompoundEdit();
        this.textModified = false;
    }

    public boolean getTextModified() {
        return this.textModified;
    }

    public void setTextModified(boolean bl) {
        this.textModified = bl;
    }

    public long getSequenceDelay() {
        return this.delayTime;
    }

    public void setSequenceDelay(long l) {
        this.delayTime = l;
    }

    public int getLimit() {
        return this.undoLimit;
    }

    public void setLimit(int n) {
        this.undoLimit = n;
        this.undoManager.setLimit(n);
    }
}

