/*
 * Decompiled with CFR 0.152.
 */
package gnu.options;

import gnu.gui.AbstractOptionPane;
import gnu.options.ColorTable;
import gnu.options.StyleTable;
import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.GridLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.EmptyBorder;
import jsynedit.AbstractEditorPanel;

public class StylesOptions
extends AbstractOptionPane {
    public static final EmptyBorder noFocusBorder = new EmptyBorder(1, 1, 1, 1);
    private ColorTable.ColorTableModel colorModel;
    private ColorTable colorTable;
    private StyleTable.StyleTableModel styleModel;
    private StyleTable styleTable;

    public StylesOptions() {
        super("styles ");
        this.setLayout(new GridLayout(2, 1));
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add("North", new JLabel("Colors:"));
        jPanel.add("Center", this.createColorTableScroller());
        this.add(jPanel);
        this.setLayout(new GridLayout(2, 1));
        jPanel = new JPanel(new BorderLayout());
        jPanel.add("North", new JLabel("Styles:"));
        jPanel.add("Center", this.createStyleTableScroller());
        this.add(jPanel);
    }

    public void save() {
        this.colorModel.save();
        this.styleModel.save();
    }

    public void load() {
        this.colorModel.load();
        this.styleModel.load();
    }

    private JScrollPane createColorTableScroller() {
        this.colorModel = this.createColorTableModel();
        this.colorTable = new ColorTable(this.colorModel);
        Dimension dimension = this.colorTable.getPreferredSize();
        dimension.height = Math.min(dimension.height, 100);
        JScrollPane jScrollPane = new JScrollPane(this.colorTable);
        jScrollPane.setPreferredSize(dimension);
        return jScrollPane;
    }

    private ColorTable.ColorTableModel createColorTableModel() {
        ColorTable.ColorTableModel colorTableModel = new ColorTable.ColorTableModel();
        colorTableModel.addColorChoice("Editor background", AbstractEditorPanel.getProperty("editor.bgColor"));
        colorTableModel.addColorChoice("Editor foreground", AbstractEditorPanel.getProperty("editor.fgColor"));
        colorTableModel.addColorChoice("Caret", AbstractEditorPanel.getProperty("editor.caretColor"));
        colorTableModel.addColorChoice("Selection", AbstractEditorPanel.getProperty("editor.selectionColor"));
        colorTableModel.addColorChoice("Highlight", AbstractEditorPanel.getProperty("editor.highlightColor"));
        colorTableModel.addColorChoice("Line highlight", AbstractEditorPanel.getProperty("editor.lineHighlightColor"));
        colorTableModel.addColorChoice("Interval highlight", AbstractEditorPanel.getProperty("editor.linesHighlightColor"));
        colorTableModel.addColorChoice("Bracket highlight", AbstractEditorPanel.getProperty("editor.bracketHighlightColor"));
        colorTableModel.addColorChoice("Wrap guide", AbstractEditorPanel.getProperty("editor.wrapGuideColor"));
        colorTableModel.addColorChoice("EOL markers", AbstractEditorPanel.getProperty("editor.eolMarkerColor"));
        colorTableModel.addColorChoice("Buttons highlight", "buttons.highlightColor");
        return colorTableModel;
    }

    private JScrollPane createStyleTableScroller() {
        this.styleModel = this.createStyleTableModel();
        this.styleTable = new StyleTable(this.styleModel);
        Dimension dimension = this.styleTable.getPreferredSize();
        dimension.height = Math.min(dimension.height, 100);
        JScrollPane jScrollPane = new JScrollPane(this.styleTable);
        jScrollPane.setPreferredSize(dimension);
        return jScrollPane;
    }

    private StyleTable.StyleTableModel createStyleTableModel() {
        StyleTable.StyleTableModel styleTableModel = new StyleTable.StyleTableModel();
        styleTableModel.addStyleChoice("Comment 1", "color:#00ff00 style:i");
        styleTableModel.addStyleChoice("Comment 2", "color:#00ff00 style:i");
        styleTableModel.addStyleChoice("Literal 1 (cha\u00d3ne)", "color:#00ffff");
        styleTableModel.addStyleChoice("Literal 2 (object)", "color:#650099");
        styleTableModel.addStyleChoice("Label", "color:#cc00cc style:b");
        styleTableModel.addStyleChoice("Keyword 1", "color:#0000ff style:b");
        styleTableModel.addStyleChoice("Keyword 2", "color:#ff9900");
        styleTableModel.addStyleChoice("Keyword 3", "color:#ff9900");
        styleTableModel.addStyleChoice("Operator", "color:#ffc800 style:b");
        styleTableModel.addStyleChoice("Invalid token", "color:#666666 style:b");
        styleTableModel.addStyleChoice("Method", "color:#000000 style:b");
        return styleTableModel;
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.colorModel = null;
        this.colorTable = null;
        this.styleModel = null;
        this.styleTable = null;
    }
}

