/*
 * Decompiled with CFR 0.152.
 */
package gnu.options;

import gnu.gui.AbstractOptionPane;
import gnu.gui.FontSelector;
import gnu.gui.JextCheckBox;
import gnu.gui.JextHighlightButton;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.print.PageFormat;
import java.awt.print.Paper;
import java.awt.print.PrinterJob;
import jsynedit.AbstractEditorPanel;

public class PrintOptions
extends AbstractOptionPane
implements ActionListener {
    private FontSelector fonts;
    private JextHighlightButton pageLayout;
    private PageFormat pgfmt = new PageFormat();
    private JextCheckBox lineNumbers;
    private JextCheckBox wrap;
    private JextCheckBox syntax;
    private JextCheckBox header;
    private JextCheckBox footer;

    public PrintOptions() {
        super("print");
        this.fonts = new FontSelector("print");
        this.addComponent(AbstractEditorPanel.getProperty("options.fonts.label"), this.fonts);
        this.lineNumbers = new JextCheckBox(AbstractEditorPanel.getProperty("print.printLineNumbers.label"));
        this.addComponent(this.lineNumbers);
        this.wrap = new JextCheckBox(AbstractEditorPanel.getProperty("print.wrapText.label"));
        this.addComponent(this.wrap);
        this.header = new JextCheckBox(AbstractEditorPanel.getProperty("print.printHeader.label"));
        this.addComponent(this.header);
        this.footer = new JextCheckBox(AbstractEditorPanel.getProperty("print.printFooter.label"));
        this.addComponent(this.footer);
        this.syntax = new JextCheckBox(AbstractEditorPanel.getProperty("print.printSyntax.label"));
        this.addComponent(this.syntax);
        this.syntax.addActionListener(this);
        this.pageLayout = new JextHighlightButton(AbstractEditorPanel.getProperty("print.pageLayout.label"));
        this.pageLayout.addActionListener(this);
        this.add(this.pageLayout);
        this.load();
    }

    public void load() {
        this.fonts.load();
        this.lineNumbers.setSelected(AbstractEditorPanel.getBooleanProperty("print.lineNumbers"));
        this.wrap.setSelected(AbstractEditorPanel.getBooleanProperty("print.wrapText"));
        this.header.setSelected(AbstractEditorPanel.getBooleanProperty("print.header"));
        this.footer.setSelected(AbstractEditorPanel.getBooleanProperty("print.footer"));
        this.syntax.setSelected(AbstractEditorPanel.getBooleanProperty("print.syntax"));
        Paper paper = this.pgfmt.getPaper();
        this.pgfmt.setOrientation(Integer.parseInt(AbstractEditorPanel.getProperty("print.pageOrientation")));
        double d = Double.parseDouble(AbstractEditorPanel.getProperty("print.pageWidth"));
        double d2 = Double.parseDouble(AbstractEditorPanel.getProperty("print.pageHeight"));
        double d3 = Double.parseDouble(AbstractEditorPanel.getProperty("print.pageImgX"));
        double d4 = Double.parseDouble(AbstractEditorPanel.getProperty("print.pageImgY"));
        double d5 = Double.parseDouble(AbstractEditorPanel.getProperty("print.pageImgWidth"));
        double d6 = Double.parseDouble(AbstractEditorPanel.getProperty("print.pageImgHeight"));
        paper.setSize(d, d2);
        paper.setImageableArea(d3, d4, d5, d6);
        this.pgfmt.setPaper(paper);
        this.handleComponents();
    }

    private void handleComponents() {
        if (this.syntax.isSelected()) {
            this.footer.setEnabled(true);
            this.pageLayout.setEnabled(false);
            this.wrap.setEnabled(false);
        } else {
            this.footer.setEnabled(false);
            this.pageLayout.setEnabled(true);
            this.wrap.setEnabled(true);
        }
    }

    public void save() {
        AbstractEditorPanel.setProperty("print.lineNumbers", this.lineNumbers.isSelected() ? "on" : "off");
        AbstractEditorPanel.setProperty("print.wrapText", this.wrap.isSelected() ? "on" : "off");
        AbstractEditorPanel.setProperty("print.header", this.header.isSelected() ? "on" : "off");
        AbstractEditorPanel.setProperty("print.footer", this.footer.isSelected() ? "on" : "off");
        AbstractEditorPanel.setProperty("print.syntax", this.syntax.isSelected() ? "on" : "off");
        Paper paper = this.pgfmt.getPaper();
        AbstractEditorPanel.setProperty("print.pageOrientation", Integer.toString(this.pgfmt.getOrientation()));
        AbstractEditorPanel.setProperty("print.pageWidth", Double.toString(paper.getWidth()));
        AbstractEditorPanel.setProperty("print.pageHeight", Double.toString(paper.getHeight()));
        AbstractEditorPanel.setProperty("print.pageImgX", Double.toString(paper.getImageableX()));
        AbstractEditorPanel.setProperty("print.pageImgY", Double.toString(paper.getImageableY()));
        AbstractEditorPanel.setProperty("print.pageImgWidth", Double.toString(paper.getImageableWidth()));
        AbstractEditorPanel.setProperty("print.pageImgHeight", Double.toString(paper.getImageableHeight()));
        this.fonts.save();
    }

    public void pageLayout() {
        PrinterJob printerJob = PrinterJob.getPrinterJob();
        this.pgfmt = printerJob.pageDialog(this.pgfmt);
        this.pgfmt = printerJob.validatePage(this.pgfmt);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.pageLayout) {
            this.pageLayout();
        } else if (object == this.syntax) {
            this.handleComponents();
        }
    }
}

