/*
 * Decompiled with CFR 0.152.
 */
package gnu.options;

import gnu.Plugin;
import gnu.UUtilities;
import gnu.gui.AbstractOptionPane;
import gnu.gui.JextHighlightButton;
import gnu.gui.OptionGroup;
import gnu.gui.OptionPane;
import gnu.java.BeautifierOptions;
import gnu.jbrowser.JBrowseOptionPane;
import gnu.options.EditorOptions;
import gnu.options.GeneralOptions;
import gnu.options.PrintOptions;
import gnu.options.StylesOptions;
import gnu.options.UndoOptions;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.BorderFactory;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.EventListenerList;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import jsynedit.AbstractEditorPanel;

public class OptionsDialog
extends JDialog
implements ActionListener,
TreeSelectionListener {
    private JTree paneTree;
    private JPanel cardPanel;
    private JLabel currentLabel;
    private JextHighlightButton ok;
    private JextHighlightButton cancel;
    private JextHighlightButton apply;
    private OptionGroup jextGroup;
    private OptionGroup pluginsGroup;
    private OptionGroup javaGroup;
    private static OptionsDialog theInstance;
    private OptionTreeModel theTree;
    private boolean toReload = false;
    private boolean isLoadingPlugs;
    private String currPaneName;
    private Plugin currPlugin;
    private ArrayList cachPlugPanes;
    private ArrayList notCachPlugPanes;
    private ArrayList notCachPlugin;
    private AbstractEditorPanel parent;

    static OptionsDialog getInstance() {
        return theInstance;
    }

    public static void showOptionDialog(AbstractEditorPanel abstractEditorPanel) {
        if (theInstance == null) {
            theInstance = new OptionsDialog(abstractEditorPanel);
        } else {
            theInstance.reload();
        }
        theInstance.setVisible(true);
    }

    public OptionsDialog(AbstractEditorPanel abstractEditorPanel) {
        this.parent = abstractEditorPanel;
        this.setTitle("Options");
        this.parent.showWaitCursor();
        this.cachPlugPanes = new ArrayList(20);
        this.notCachPlugPanes = new ArrayList(20);
        this.notCachPlugin = new ArrayList(20);
        this.getContentPane().setLayout(new BorderLayout());
        ((JPanel)this.getContentPane()).setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        JPanel jPanel = new JPanel(new BorderLayout(4, 8));
        jPanel.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        this.getContentPane().add((Component)jPanel, "Center");
        this.currentLabel = new JLabel();
        this.currentLabel.setHorizontalAlignment(2);
        this.currentLabel.setBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, Color.black));
        jPanel.add((Component)this.currentLabel, "North");
        this.cardPanel = new JPanel(new CardLayout());
        jPanel.add((Component)this.cardPanel, "Center");
        this.theTree = this.createOptionTreeModel();
        this.paneTree = new JTree(this.theTree);
        this.paneTree.setCellRenderer(new PaneNameRenderer());
        this.paneTree.putClientProperty("JTree.lineStyle", "Angled");
        this.paneTree.setShowsRootHandles(true);
        this.paneTree.setRootVisible(false);
        this.getContentPane().add((Component)new JScrollPane(this.paneTree, 22, 30), "West");
        JPanel jPanel2 = new JPanel();
        this.ok = new JextHighlightButton("Ok");
        this.ok.addActionListener(this);
        jPanel2.add(this.ok);
        this.getRootPane().setDefaultButton(this.ok);
        this.cancel = new JextHighlightButton("Cancel");
        this.cancel.addActionListener(this);
        jPanel2.add(this.cancel);
        this.apply = new JextHighlightButton("Apply");
        this.apply.addActionListener(this);
        jPanel2.add(this.apply);
        this.getContentPane().add((Component)jPanel2, "South");
        this.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                switch (keyEvent.getKeyCode()) {
                    case 10: {
                        OptionsDialog.this.ok();
                        break;
                    }
                    case 27: {
                        OptionsDialog.this.cancel();
                    }
                }
            }
        });
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                OptionsDialog.this.cancel();
            }
        });
        TreePath treePath = new TreePath(new Object[]{this.theTree.getRoot(), this.jextGroup, this.jextGroup.getMember(0)});
        this.paneTree.getSelectionModel().addTreeSelectionListener(this);
        this.paneTree.setSelectionPath(treePath);
        this.paneTree.addMouseListener(new MouseHandler());
        this.pack();
        UUtilities.centerComponent(this);
        this.parent.hideWaitCursor();
    }

    private void ok(boolean bl) {
        OptionTreeModel optionTreeModel = (OptionTreeModel)this.paneTree.getModel();
        ((OptionGroup)optionTreeModel.getRoot()).save();
        this.parent.propertiesChanged();
        if (bl) {
            this.setVisible(false);
        }
    }

    private void ok() {
        this.ok(true);
    }

    private void cancel() {
        this.toReload = true;
        this.setVisible(false);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.ok) {
            this.ok();
        } else if (object == this.cancel) {
            this.cancel();
        } else if (object == this.apply) {
            this.ok(false);
        }
    }

    private void reload() {
        if (this.toReload) {
            this.parent.showWaitCursor();
            this.reloadStdPanes();
            this.reloadPluginPanes();
            this.toReload = false;
            this.parent.hideWaitCursor();
        }
    }

    private void reloadStdPanes() {
        ArrayList arrayList = this.jextGroup.getMembers();
        for (int i = 0; i < arrayList.size(); ++i) {
            ((AbstractOptionPane)arrayList.get(i)).load();
        }
    }

    private void reloadPluginPanes() {
        Object object;
        ((CardLayout)this.cardPanel.getLayout()).show(this.cardPanel, ((OptionPane)this.jextGroup.getMember(0)).getName());
        Iterator iterator = this.cachPlugPanes.iterator();
        while (iterator.hasNext()) {
            object = null;
            try {
                object = (OptionPane)iterator.next();
                object.load();
            }
            catch (AbstractMethodError abstractMethodError) {
                abstractMethodError.printStackTrace();
                UUtilities.showError("The option pane of the plugin containing " + object.getClass().toString() + " is not supported, and you will not see it in the option dialog. This is related to new Jext " + "release(from 3.2pre3). You should make aware of this Romain Guy, the plugin's author or " + "Blaisorblade <blaisorblade_work (at) yahoo.it, who will provide an upgraded version " + "of the plugin.Thanks");
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
        iterator = this.notCachPlugPanes.iterator();
        while (iterator.hasNext()) {
            this.cardPanel.remove(((OptionPane)iterator.next()).getComponent());
        }
        iterator = this.notCachPlugin.iterator();
        while (iterator.hasNext()) {
            object = null;
            try {
                object = (Plugin)iterator.next();
                object.createOptionPanes(this);
            }
            catch (AbstractMethodError abstractMethodError) {
                abstractMethodError.printStackTrace();
                UUtilities.showError("The option pane of the plugin containing " + object.getClass().toString() + " is not supported, and you will not see it in the option dialog. This is related to new Jext " + "release(from 3.2pre3). You should make aware of this Romain Guy, the plugin's author or " + "Blaisorblade <blaisorblade_work (at) yahoo.it, who will provide an upgraded version " + "of the plugin.Thanks");
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
        ((CardLayout)this.cardPanel.getLayout()).show(this.cardPanel, this.currPaneName);
    }

    public void addOptionGroup(OptionGroup optionGroup) {
        this.addOptionGroup(optionGroup, this.pluginsGroup);
    }

    public void addOptionPane(OptionPane optionPane) {
        this.addOptionPane(optionPane, this.pluginsGroup);
    }

    private void addOptionGroup(OptionGroup optionGroup, OptionGroup optionGroup2) {
        ArrayList arrayList = optionGroup.getMembers();
        for (int i = 0; i < arrayList.size(); ++i) {
            Object e = arrayList.get(i);
            if (e instanceof OptionPane) {
                this.addOptionPane((OptionPane)e, optionGroup);
                continue;
            }
            if (!(e instanceof OptionGroup)) continue;
            this.addOptionGroup((OptionGroup)e, optionGroup);
        }
        optionGroup2.addOptionGroup(optionGroup);
    }

    private void addOptionPane(OptionPane optionPane, OptionGroup optionGroup) {
        String string = optionPane.getName();
        this.cardPanel.add(optionPane.getComponent(), string);
        optionGroup.addOptionPane(optionPane);
        if (this.isLoadingPlugs) {
            if (optionPane.isCacheable()) {
                this.cachPlugPanes.add(optionPane);
            } else {
                this.notCachPlugPanes.add(optionPane);
                if (this.currPlugin != null) {
                    this.notCachPlugin.add(this.currPlugin);
                    this.currPlugin = null;
                }
            }
        }
    }

    private OptionTreeModel createOptionTreeModel() {
        OptionTreeModel optionTreeModel = new OptionTreeModel();
        OptionGroup optionGroup = (OptionGroup)optionTreeModel.getRoot();
        this.jextGroup = new OptionGroup("Editor");
        this.addOptionPane(new GeneralOptions(), this.jextGroup);
        this.addOptionPane(new EditorOptions(), this.jextGroup);
        this.addOptionPane(new UndoOptions(), this.jextGroup);
        this.addOptionPane(new PrintOptions(), this.jextGroup);
        this.addOptionPane(new StylesOptions(), this.jextGroup);
        this.addOptionGroup(this.jextGroup, optionGroup);
        this.javaGroup = new OptionGroup("Java");
        this.addOptionPane(new BeautifierOptions(), this.javaGroup);
        this.addOptionPane(new JBrowseOptionPane(), this.javaGroup);
        this.addOptionGroup(this.javaGroup, optionGroup);
        return optionTreeModel;
    }

    public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
        int n;
        TreePath treePath = treeSelectionEvent.getPath();
        if (treePath == null || !(treePath.getLastPathComponent() instanceof OptionPane)) {
            return;
        }
        Object[] objectArray = treePath.getPath();
        StringBuffer stringBuffer = new StringBuffer();
        this.currPaneName = null;
        int n2 = objectArray.length - 1;
        int n3 = n = this.paneTree.isRootVisible() ? 0 : 1;
        while (n <= n2) {
            block11: {
                block10: {
                    block9: {
                        if (!(objectArray[n] instanceof OptionPane)) break block9;
                        this.currPaneName = ((OptionPane)objectArray[n]).getName();
                        break block10;
                    }
                    if (!(objectArray[n] instanceof OptionGroup)) break block11;
                    this.currPaneName = ((OptionGroup)objectArray[n]).getName();
                }
                if (this.currPaneName != null) {
                    String string = this.currPaneName;
                    if (string == null) {
                        stringBuffer.append(this.currPaneName);
                    } else {
                        stringBuffer.append(string);
                    }
                }
                if (n != n2) {
                    stringBuffer.append(": ");
                }
            }
            ++n;
        }
        this.currentLabel.setText(stringBuffer.toString());
        ((CardLayout)this.cardPanel.getLayout()).show(this.cardPanel, this.currPaneName);
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.paneTree = null;
        this.cardPanel = null;
        this.currentLabel = null;
        this.ok = null;
        this.cancel = null;
        this.apply = null;
        this.jextGroup = null;
        this.pluginsGroup = null;
        this.theTree = null;
        theInstance = null;
        this.currPlugin = null;
        this.cachPlugPanes.clear();
        this.cachPlugPanes = null;
        this.notCachPlugPanes.clear();
        this.notCachPlugPanes = null;
        this.notCachPlugin.clear();
        this.notCachPlugin = null;
        this.currPaneName = null;
        this.parent = null;
    }

    class OptionTreeModel
    implements TreeModel {
        private OptionGroup root = new OptionGroup("root");
        private EventListenerList listenerList = new EventListenerList();

        OptionTreeModel() {
        }

        public void addTreeModelListener(TreeModelListener treeModelListener) {
            this.listenerList.add(TreeModelListener.class, treeModelListener);
        }

        public void removeTreeModelListener(TreeModelListener treeModelListener) {
            this.listenerList.remove(TreeModelListener.class, treeModelListener);
        }

        public Object getChild(Object object, int n) {
            if (object instanceof OptionGroup) {
                return ((OptionGroup)object).getMember(n);
            }
            return null;
        }

        public int getChildCount(Object object) {
            if (object instanceof OptionGroup) {
                return ((OptionGroup)object).getMemberCount();
            }
            return 0;
        }

        public int getIndexOfChild(Object object, Object object2) {
            if (object instanceof OptionGroup) {
                return ((OptionGroup)object).getMemberIndex(object2);
            }
            return -1;
        }

        public Object getRoot() {
            return this.root;
        }

        public boolean isLeaf(Object object) {
            return object instanceof OptionPane;
        }

        public void valueForPathChanged(TreePath treePath, Object object) {
        }

        protected void fireNodesChanged(Object object, Object[] objectArray, int[] nArray, Object[] objectArray2) {
            Object[] objectArray3 = this.listenerList.getListenerList();
            TreeModelEvent treeModelEvent = null;
            for (int i = objectArray3.length - 2; i >= 0; i -= 2) {
                if (objectArray3[i] != TreeModelListener.class) continue;
                if (treeModelEvent == null) {
                    treeModelEvent = new TreeModelEvent(object, objectArray, nArray, objectArray2);
                }
                ((TreeModelListener)objectArray3[i + 1]).treeNodesChanged(treeModelEvent);
            }
        }

        protected void fireNodesInserted(Object object, Object[] objectArray, int[] nArray, Object[] objectArray2) {
            Object[] objectArray3 = this.listenerList.getListenerList();
            TreeModelEvent treeModelEvent = null;
            for (int i = objectArray3.length - 2; i >= 0; i -= 2) {
                if (objectArray3[i] != TreeModelListener.class) continue;
                if (treeModelEvent == null) {
                    treeModelEvent = new TreeModelEvent(object, objectArray, nArray, objectArray2);
                }
                ((TreeModelListener)objectArray3[i + 1]).treeNodesInserted(treeModelEvent);
            }
        }

        protected void fireNodesRemoved(Object object, Object[] objectArray, int[] nArray, Object[] objectArray2) {
            Object[] objectArray3 = this.listenerList.getListenerList();
            TreeModelEvent treeModelEvent = null;
            for (int i = objectArray3.length - 2; i >= 0; i -= 2) {
                if (objectArray3[i] != TreeModelListener.class) continue;
                if (treeModelEvent == null) {
                    treeModelEvent = new TreeModelEvent(object, objectArray, nArray, objectArray2);
                }
                ((TreeModelListener)objectArray3[i + 1]).treeNodesRemoved(treeModelEvent);
            }
        }

        protected void fireTreeStructureChanged(Object object, Object[] objectArray, int[] nArray, Object[] objectArray2) {
            Object[] objectArray3 = this.listenerList.getListenerList();
            TreeModelEvent treeModelEvent = null;
            for (int i = objectArray3.length - 2; i >= 0; i -= 2) {
                if (objectArray3[i] != TreeModelListener.class) continue;
                if (treeModelEvent == null) {
                    treeModelEvent = new TreeModelEvent(object, objectArray, nArray, objectArray2);
                }
                ((TreeModelListener)objectArray3[i + 1]).treeStructureChanged(treeModelEvent);
            }
        }
    }

    class PaneNameRenderer
    extends JLabel
    implements TreeCellRenderer {
        private Border noFocusBorder = BorderFactory.createEmptyBorder(1, 1, 1, 1);
        private Border focusBorder = BorderFactory.createLineBorder(UIManager.getColor("Tree.selectionBorderColor"));
        private Font paneFont;
        private Font groupFont;

        public PaneNameRenderer() {
            this.setOpaque(true);
            this.paneFont = UIManager.getFont("Tree.font");
            this.groupFont = new Font(this.paneFont.getName(), this.paneFont.getStyle() | 1, this.paneFont.getSize());
        }

        public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
            if (bl) {
                this.setBackground(UIManager.getColor("Tree.selectionBackground"));
                this.setForeground(UIManager.getColor("Tree.selectionForeground"));
            } else {
                this.setBackground(jTree.getBackground());
                this.setForeground(jTree.getForeground());
            }
            String string = null;
            if (object instanceof OptionGroup) {
                string = ((OptionGroup)object).getName();
                this.setFont(this.groupFont);
            } else if (object instanceof OptionPane) {
                string = ((OptionPane)object).getName();
                this.setFont(this.paneFont);
            }
            if (string == null) {
                this.setText(null);
            } else {
                String string2 = string;
                if (string2 == null) {
                    this.setText(string);
                } else {
                    this.setText(string2);
                }
            }
            this.setBorder(bl4 ? this.focusBorder : this.noFocusBorder);
            return this;
        }
    }

    class MouseHandler
    extends MouseAdapter {
        MouseHandler() {
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            TreePath treePath = OptionsDialog.this.paneTree.getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
            if (treePath == null) {
                return;
            }
            Object object = treePath.getLastPathComponent();
            if (object instanceof OptionGroup) {
                if (OptionsDialog.this.paneTree.isCollapsed(treePath)) {
                    OptionsDialog.this.paneTree.expandPath(treePath);
                } else {
                    OptionsDialog.this.paneTree.collapsePath(treePath);
                }
            }
        }
    }
}

