/*
 * Decompiled with CFR 0.152.
 */
package marketorg;

import madkit.kernel.Agent;
import madkit.kernel.AgentAddress;
import madkit.kernel.Message;
import madkit.messages.ACLMessage;

public class Client
extends Agent {
    AgentAddress broker = null;
    String produit;

    public void setBroker(AgentAddress agentAddress) {
        this.broker = agentAddress;
    }

    public AgentAddress getBroker() {
        return this.broker;
    }

    public void activate() {
        this.createGroup(true, "travel", "travel-clients", null, null);
        this.requestRole("travel", "travel-clients", "client", null);
        this.produit = Math.random() > 0.5 ? "plane" : "train";
        this.println("Looking for a " + this.produit + " ticket");
        while (this.broker == null) {
            this.broker = this.getAgentWithRole("travel", "travel-clients", "broker");
            this.pause(500);
        }
        this.println("Found a broker:" + this.broker);
    }

    public void live() {
        this.println("Sending ticket request:" + this.produit);
        this.sendMessage(this.broker, (Message)new ACLMessage("REQUEST", this.produit));
        this.println("Waiting for an offer...");
        while (true) {
            Message message;
            if ((message = this.waitNextMessage()) instanceof ACLMessage) {
                this.handleMessage((ACLMessage)message);
                continue;
            }
            System.err.println("ERROR: invalid message type: " + message);
        }
    }

    protected void handleMessage(ACLMessage aCLMessage) {
        try {
            this.println("Receiving broker answer");
            if (aCLMessage.getAct().equalsIgnoreCase("MAKE-CONTRACT")) {
                String string = aCLMessage.getContent().toString();
                this.createGroup(true, "travel", string, null, null);
                this.requestRole("travel", string, "client", null);
                this.println("Preparing contract: " + string);
                AgentAddress agentAddress = null;
                while (agentAddress == null) {
                    agentAddress = this.getAgentWithRole("travel", string, "service");
                    this.pause(100);
                }
                this.println("Asking confirmation");
                this.sendMessage(agentAddress, (Message)new ACLMessage("VALIDATE"));
            } else if (aCLMessage.getAct().equalsIgnoreCase("ACCEPT-CONTRACT")) {
                this.println("Contract OK.");
            }
        }
        catch (Exception exception) {
            System.err.println(exception.toString());
        }
    }
}

