/*
 * Decompiled with CFR 0.152.
 */
package bsh.commands;

import bsh.Interpreter;
import bsh.NameSpace;
import java.io.File;
import java.io.IOException;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Vector;

public class dir {
    static final String[] months = new String[]{"Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"};

    public static String usage() {
        return "usage: dir( String dir )\n       dir()";
    }

    public static void invoke(Interpreter env, NameSpace namespace) {
        String dir2 = ".";
        dir.invoke(env, namespace, dir2);
    }

    public static void invoke(Interpreter env, NameSpace namespace, String dir2) {
        File file;
        try {
            file = env.pathToFile(dir2);
        }
        catch (IOException e) {
            env.println("error reading path: " + e);
            return;
        }
        if (!file.exists() || !file.canRead()) {
            env.println("Can't read " + file);
            return;
        }
        if (!file.isDirectory()) {
            env.println("'" + dir2 + "' is not a directory");
        }
        String[] files = file.list();
        files = dir.bubbleSort(files);
        int i = 0;
        while (i < files.length) {
            File f = new File(String.valueOf(dir2) + File.separator + files[i]);
            StringBuffer sb = new StringBuffer();
            sb.append(f.canRead() ? "r" : "-");
            sb.append(f.canWrite() ? "w" : "-");
            sb.append("_");
            sb.append(" ");
            Date d = new Date(f.lastModified());
            GregorianCalendar c = new GregorianCalendar();
            c.setTime(d);
            int day = c.get(5);
            sb.append(String.valueOf(months[c.get(2)]) + " " + day);
            if (day < 10) {
                sb.append(" ");
            }
            sb.append(" ");
            int fieldlen = 8;
            StringBuffer len = new StringBuffer();
            int j = 0;
            while (j < fieldlen) {
                len.append(" ");
                ++j;
            }
            len.insert(0, f.length());
            len.setLength(fieldlen);
            int si = len.toString().indexOf(" ");
            if (si != -1) {
                String pad = len.toString().substring(si);
                len.setLength(si);
                len.insert(0, pad);
            }
            sb.append(len.toString());
            sb.append(" " + f.getName());
            if (f.isDirectory()) {
                sb.append("/");
            }
            env.println(sb.toString());
            ++i;
        }
    }

    public static String[] bubbleSort(String[] in) {
        Vector<String> v = new Vector<String>();
        int i = 0;
        while (i < in.length) {
            v.addElement(in[i]);
            ++i;
        }
        int n = v.size();
        boolean swap = true;
        while (swap) {
            swap = false;
            int i2 = 0;
            while (i2 < n - 1) {
                if (((String)v.elementAt(i2)).compareTo((String)v.elementAt(i2 + 1)) > 0) {
                    String tmp = (String)v.elementAt(i2 + 1);
                    v.removeElementAt(i2 + 1);
                    v.insertElementAt(tmp, i2);
                    swap = true;
                }
                ++i2;
            }
        }
        Object[] out = new String[n];
        v.copyInto(out);
        return out;
    }
}

