/*
 * Decompiled with CFR 0.152.
 */
package bsh;

import bsh.BshMethod;
import bsh.CallStack;
import bsh.EvalError;
import bsh.Interpreter;
import bsh.NameSpace;
import bsh.Primitive;
import bsh.Reflect;
import bsh.This;
import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Hashtable;

class XThis
extends This {
    Hashtable interfaces;
    InvocationHandler invocationHandler = new Handler();

    XThis(NameSpace namespace, Interpreter declaringInterp) {
        super(namespace, declaringInterp);
    }

    public String toString() {
        return "'this' reference (XThis) to Bsh object: " + this.namespace.name;
    }

    String toStringShowInts(Class[] ints) {
        StringBuffer sb = new StringBuffer(String.valueOf(this.toString()) + "\nimplements:");
        int i = 0;
        while (i < ints.length) {
            sb.append(" " + ints[i].getName() + (ints.length > 1 ? "," : ""));
            ++i;
        }
        return sb.toString();
    }

    public Object getInterface(Class clas) {
        Object interf;
        if (this.interfaces == null) {
            this.interfaces = new Hashtable();
        }
        if ((interf = this.interfaces.get(clas)) == null) {
            interf = Proxy.newProxyInstance(clas.getClassLoader(), new Class[]{clas}, this.invocationHandler);
            this.interfaces.put(clas, interf);
        }
        return interf;
    }

    class Handler
    implements InvocationHandler,
    Serializable {
        Handler() {
        }

        public Object invoke(Object proxy, Method method, Object[] args) throws EvalError {
            try {
                return this.invokeImpl(proxy, method, args);
            }
            catch (EvalError ee) {
                if (Interpreter.DEBUG) {
                    Interpreter.debug("EvalError in scripted interface: " + XThis.this.toString() + ": " + ee);
                }
                throw ee;
            }
        }

        public Object invokeImpl(Object proxy, Method method, Object[] args) throws EvalError {
            CallStack callstack = XThis.this.newCallStack();
            Class[] sig = Reflect.getTypes(args);
            BshMethod bmethod = XThis.this.namespace.getMethod(method.getName(), sig);
            if (bmethod != null) {
                return Primitive.unwrap(bmethod.invokeDeclaredMethod(args, XThis.this.declaringInterpreter, callstack, null));
            }
            bmethod = XThis.this.namespace.getMethod("invoke", new Class[2]);
            if (bmethod != null) {
                return Primitive.unwrap(bmethod.invokeDeclaredMethod(new Object[]{method.getName(), args}, XThis.this.declaringInterpreter, callstack, null));
            }
            if (method.getName().equals("toString")) {
                return XThis.this.toStringShowInts(proxy.getClass().getInterfaces());
            }
            if (method.getName().equals("hashCode")) {
                return new Integer(this.hashCode());
            }
            if (method.getName().equals("equals")) {
                Object obj = args[0];
                return new Boolean(proxy == obj);
            }
            throw new EvalError("Bsh script method: " + method.getName() + " not found in namespace: " + XThis.this.namespace.name);
        }
    }
}

