/*
 * Decompiled with CFR 0.152.
 */
package bsh;

import bsh.BshClassManager;
import bsh.BshMethod;
import bsh.CallStack;
import bsh.EvalError;
import bsh.Interpreter;
import bsh.InterpreterError;
import bsh.LHS;
import bsh.NameSpace;
import bsh.Primitive;
import bsh.Reflect;
import bsh.ReflectError;
import bsh.SimpleNode;
import bsh.TargetError;
import bsh.This;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;

class Name
implements Serializable {
    public NameSpace namespace;
    String value = null;
    private String evalName;
    private Object evalBaseObject;
    private int callstackDepth;
    private boolean literalThisReference;
    private boolean literalCallerReference;
    static /* synthetic */ Class class$0;

    private void reset() {
        this.evalName = this.value;
        this.evalBaseObject = null;
        this.callstackDepth = 0;
        this.literalThisReference = false;
        this.literalCallerReference = false;
    }

    public Name(NameSpace namespace, String s) {
        this.namespace = namespace;
        this.value = s;
    }

    public Object toObject(CallStack callstack, Interpreter interpreter) throws EvalError {
        return this.toObject(callstack, interpreter, false);
    }

    public synchronized Object toObject(CallStack callstack, Interpreter interpreter, boolean forceClass) throws EvalError {
        this.reset();
        Object obj = null;
        while (this.evalName != null) {
            obj = this.consumeNextObjectField(callstack, interpreter, forceClass);
        }
        if (obj == null) {
            throw new InterpreterError("null value in toObject()");
        }
        return obj;
    }

    private Object consumeNextObjectField(CallStack callstack, Interpreter interpreter, boolean forceClass) throws EvalError {
        Class clas;
        Object obj;
        if (this.evalBaseObject == null && !Name.isCompound(this.evalName) && !forceClass && (obj = this.resolveThisFieldReference(callstack, this.namespace, interpreter, this.evalName, false)) != Primitive.VOID) {
            this.evalName = null;
            this.evalBaseObject = obj;
            return this.evalBaseObject;
        }
        if ((this.evalBaseObject == null || this.evalBaseObject instanceof This) && !forceClass) {
            Object obj2;
            String varName = Name.prefix(this.evalName, 1);
            if (Interpreter.DEBUG) {
                Interpreter.debug("trying to resolve variable: " + varName);
            }
            if ((obj2 = this.evalBaseObject == null ? this.resolveThisFieldReference(callstack, this.namespace, interpreter, varName, false) : this.resolveThisFieldReference(callstack, ((This)this.evalBaseObject).namespace, interpreter, varName, true)) != Primitive.VOID) {
                if (Interpreter.DEBUG) {
                    Interpreter.debug("resolved variable: " + varName + " in namespace: " + this.namespace);
                }
                this.evalName = Name.suffix(this.evalName);
                this.evalBaseObject = obj2;
                return this.evalBaseObject;
            }
        }
        if (this.evalBaseObject == null) {
            if (Interpreter.DEBUG) {
                Interpreter.debug("trying class: " + this.evalName);
            }
            clas = null;
            int i = 1;
            while (i <= Name.countParts(this.evalName)) {
                clas = this.namespace.getClass(Name.prefix(this.evalName, i));
                if (clas != null) break;
                ++i;
            }
            if (clas != null) {
                this.evalName = Name.suffix(this.evalName, Name.countParts(this.evalName) - i);
                this.evalBaseObject = new ClassIdentifier(clas);
                return this.evalBaseObject;
            }
            if (Interpreter.DEBUG) {
                Interpreter.debug("not a class, trying var prefix " + this.evalName);
            }
        }
        if (this.evalBaseObject == null) {
            if (!Name.isCompound(this.evalName)) {
                this.evalName = null;
                this.evalBaseObject = Primitive.VOID;
                return this.evalBaseObject;
            }
            throw new EvalError("Class or variable not found:" + this.evalName);
        }
        if (this.evalBaseObject == Primitive.NULL) {
            throw new TargetError("Null Pointer while evaluating: " + this.value, new NullPointerException());
        }
        if (this.evalBaseObject == Primitive.VOID) {
            throw new EvalError("Undefined variable or class name while evaluating: " + this.value);
        }
        if (this.evalBaseObject instanceof Primitive) {
            throw new EvalError("Can't treat primitive like an object. Error while evaluating: " + this.value);
        }
        if (this.evalBaseObject instanceof ClassIdentifier) {
            String iclass;
            Class c;
            Object obj3;
            String field;
            block25: {
                clas = ((ClassIdentifier)this.evalBaseObject).getTargetClass();
                field = Name.prefix(this.evalName, 1);
                obj3 = null;
                try {
                    if (Interpreter.DEBUG) {
                        Interpreter.debug("Name call to getStaticField, class: " + clas + ", field:" + field);
                    }
                    obj3 = Reflect.getStaticField(clas, field);
                }
                catch (ReflectError e) {
                    if (!Interpreter.DEBUG) break block25;
                    Interpreter.debug("field reflect error: " + e);
                }
            }
            if (obj3 == null && (c = this.namespace.getClass(iclass = String.valueOf(clas.getName()) + "$" + field)) != null) {
                obj3 = new ClassIdentifier(c);
            }
            if (obj3 == null) {
                throw new EvalError("No static field or inner class: " + field + " of " + clas);
            }
            this.evalName = Name.suffix(this.evalName);
            this.evalBaseObject = obj3;
            return this.evalBaseObject;
        }
        if (forceClass) {
            throw new EvalError(String.valueOf(this.value) + " does not resolve to a class name.");
        }
        String field = Name.prefix(this.evalName, 1);
        if (field.equals("length") && this.evalBaseObject.getClass().isArray()) {
            Primitive obj4 = new Primitive(Array.getLength(this.evalBaseObject));
            this.evalName = Name.suffix(this.evalName);
            this.evalBaseObject = obj4;
            return this.evalBaseObject;
        }
        try {
            Object obj5 = Reflect.getObjectField(this.evalBaseObject, field);
            this.evalName = Name.suffix(this.evalName);
            this.evalBaseObject = obj5;
            return this.evalBaseObject;
        }
        catch (ReflectError reflectError) {
            throw new EvalError("Cannot access field: " + field + ", on object: " + this.evalBaseObject);
        }
    }

    Object resolveThisFieldReference(CallStack callstack, NameSpace thisNamespace, Interpreter interpreter, String varName, boolean specialFieldsVisible) throws EvalError {
        Object obj = null;
        boolean wasThis = false;
        boolean wasCaller = false;
        if (varName.equals("this")) {
            if (specialFieldsVisible) {
                throw new EvalError("Redundant to call .this on This type");
            }
            obj = thisNamespace.getThis(interpreter);
            wasThis = true;
        }
        if (obj == null) {
            if (varName.equals("super")) {
                obj = thisNamespace.getSuper().getThis(interpreter);
            } else if (varName.equals("global")) {
                obj = thisNamespace.getGlobal().getThis(interpreter);
            }
        }
        if (obj == null && specialFieldsVisible) {
            if (varName.equals("namespace")) {
                obj = thisNamespace;
            } else if (varName.equals("variables")) {
                obj = thisNamespace.getVariableNames();
            } else if (varName.equals("methods")) {
                obj = thisNamespace.getMethodNames();
            } else if (varName.equals("interpreter")) {
                if (this.literalThisReference) {
                    obj = interpreter;
                } else {
                    throw new EvalError("Can only call .interpreter on literal 'this'");
                }
            }
        }
        if (obj == null && specialFieldsVisible && varName.equals("caller")) {
            if (this.literalThisReference || this.literalCallerReference) {
                if (callstack == null) {
                    throw new InterpreterError("no callstack");
                }
            } else {
                throw new EvalError("Can only call .caller on literal 'this' or literal '.caller'");
            }
            obj = callstack.get(++this.callstackDepth).getThis(interpreter);
            wasCaller = true;
        }
        if (obj == null && specialFieldsVisible && varName.equals("callstack")) {
            if (this.literalThisReference) {
                if (callstack == null) {
                    throw new InterpreterError("no callstack");
                }
                obj = callstack;
            } else {
                throw new EvalError("Can only call .callstack on literal 'this'");
            }
        }
        if (obj == null) {
            obj = thisNamespace.getVariable(varName);
        }
        this.literalThisReference = wasThis;
        this.literalCallerReference = wasCaller;
        return obj;
    }

    public synchronized Class toClass() throws EvalError {
        this.reset();
        Class clas = this.namespace.getClass(this.evalName);
        if (clas == null) {
            Object obj = null;
            try {
                obj = this.toObject(null, null, true);
            }
            catch (EvalError evalError) {
                // empty catch block
            }
            if (obj instanceof ClassIdentifier) {
                clas = ((ClassIdentifier)obj).getTargetClass();
            }
        }
        if (clas == null) {
            throw new EvalError("Class: " + this.value + " not found in namespace");
        }
        return clas;
    }

    public synchronized LHS toLHS(CallStack callstack, Interpreter interpreter) throws EvalError {
        this.reset();
        if (!Name.isCompound(this.evalName)) {
            return new LHS(this.namespace, this.evalName);
        }
        Object obj = null;
        try {
            while (Name.isCompound(this.evalName)) {
                obj = this.consumeNextObjectField(callstack, interpreter, false);
            }
        }
        catch (EvalError e) {
            throw new EvalError("LHS evaluation: " + e);
        }
        if (obj == null) {
            throw new InterpreterError("internal error 2893749283");
        }
        if (obj instanceof This) {
            Interpreter.debug("found This reference evaluating LHS");
            return new LHS(((This)obj).namespace, this.evalName);
        }
        if (this.evalName != null) {
            try {
                if (obj instanceof ClassIdentifier) {
                    Class clas = ((ClassIdentifier)obj).getTargetClass();
                    return Reflect.getLHSStaticField(clas, this.evalName);
                }
                return Reflect.getLHSObjectField(obj, this.evalName);
            }
            catch (ReflectError e) {
                throw new EvalError("Field access: " + e);
            }
        }
        throw new InterpreterError("Internal error in lhs...");
    }

    private BshMethod toLocalMethod(Object[] args) {
        Class[] sig = Reflect.getTypes(args);
        return this.namespace.getMethod(this.value, sig);
    }

    public Object invokeMethod(Interpreter interpreter, Object[] args, CallStack callstack, SimpleNode callerInfo) throws EvalError, ReflectError, InvocationTargetException {
        Class clas;
        if (!Name.isCompound(this.value)) {
            return this.invokeLocalMethod(interpreter, args, callstack, callerInfo);
        }
        Name targetName = this.namespace.getNameResolver(Name.prefix(this.value));
        String methodName = Name.suffix(this.value, 1);
        Object obj = targetName.toObject(callstack, interpreter);
        if (obj == Primitive.VOID) {
            throw new EvalError("Attempt to invoke method: " + methodName + "() on undefined variable or class name: " + targetName);
        }
        if (!(obj instanceof ClassIdentifier)) {
            if (obj instanceof Primitive) {
                if (obj == Primitive.NULL) {
                    throw new TargetError("Null Pointer in Method Invocation", new NullPointerException());
                }
                interpreter.error("Attempt to access method on primitive... allowing bsh.Primitive to peek through for debugging");
            }
            return Reflect.invokeObjectMethod(interpreter, obj, methodName, args, callerInfo);
        }
        if (Interpreter.DEBUG) {
            Interpreter.debug("invokeMethod: trying static - " + targetName);
        }
        if ((clas = ((ClassIdentifier)obj).getTargetClass()) != null) {
            return Reflect.invokeStaticMethod(clas, methodName, args);
        }
        throw new EvalError("unknown target: " + targetName);
    }

    public Object invokeLocalMethod(Interpreter interpreter, Object[] args, CallStack callstack, SimpleNode callerInfo) throws EvalError, ReflectError, InvocationTargetException {
        InputStream in;
        BshMethod meth;
        if (Interpreter.DEBUG) {
            Interpreter.debug("invoke local method: " + this.value);
        }
        if ((meth = this.toLocalMethod(args)) != null) {
            return meth.invokeDeclaredMethod(args, interpreter, callstack, callerInfo);
        }
        if (Interpreter.DEBUG) {
            Interpreter.debug("no locally declared method: " + this.value);
        }
        String commandName = "commands/" + this.value + ".bsh";
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("[Lbsh.Interpreter;").getComponentType();
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((in = clazz.getResourceAsStream(commandName)) != null) {
            if (Interpreter.DEBUG) {
                Interpreter.debug("loading resource: " + commandName);
            }
            if (interpreter == null) {
                throw new InterpreterError("2234432 interpreter = null");
            }
            interpreter.eval(new InputStreamReader(in), this.namespace, commandName);
            meth = this.toLocalMethod(args);
            if (meth != null) {
                return meth.invokeDeclaredMethod(args, interpreter, callstack, callerInfo);
            }
            throw new EvalError("Loaded resource: " + commandName + "had an error or did not contain the correct method");
        }
        commandName = "bsh.commands." + this.value;
        Class c = BshClassManager.classForName(commandName);
        if (c == null) {
            throw new EvalError("Command not found: " + this.value);
        }
        Object[] invokeArgs = new Object[args.length + 2];
        invokeArgs[0] = interpreter;
        invokeArgs[1] = this.namespace;
        System.arraycopy(args, 0, invokeArgs, 2, args.length);
        try {
            return Reflect.invokeStaticMethod(c, "invoke", invokeArgs);
        }
        catch (ReflectError e) {
            if (Interpreter.DEBUG) {
                Interpreter.debug("invoke command args error:" + e);
            }
            try {
                String s = (String)Reflect.invokeStaticMethod(c, "usage", null);
                interpreter.println(s);
                return Primitive.VOID;
            }
            catch (ReflectError e2) {
                if (Interpreter.DEBUG) {
                    Interpreter.debug("usage threw: " + e2);
                }
                throw new EvalError("Wrong number or type of args for command");
            }
        }
    }

    static boolean isCompound(String value) {
        return Name.countParts(value) > 1;
    }

    static int countParts(String value) {
        if (value == null) {
            return 0;
        }
        int count = 0;
        int index = -1;
        while ((index = value.indexOf(46, index + 1)) != -1) {
            ++count;
        }
        return count + 1;
    }

    static String prefix(String value) {
        if (!Name.isCompound(value)) {
            return null;
        }
        return Name.prefix(value, Name.countParts(value) - 1);
    }

    static String prefix(String value, int parts) {
        if (parts < 1) {
            return null;
        }
        int count = 0;
        int index = -1;
        while ((index = value.indexOf(46, index + 1)) != -1 && ++count < parts) {
        }
        return index == -1 ? value : value.substring(0, index);
    }

    static String suffix(String name) {
        if (!Name.isCompound(name)) {
            return null;
        }
        return Name.suffix(name, Name.countParts(name) - 1);
    }

    public static String suffix(String value, int parts) {
        if (parts < 1) {
            return null;
        }
        int count = 0;
        int index = value.length() + 1;
        while ((index = value.lastIndexOf(46, index - 1)) != -1 && ++count < parts) {
        }
        return index == -1 ? value : value.substring(index + 1);
    }

    public String toString() {
        return this.value;
    }

    static class ClassIdentifier {
        Class clas;

        public ClassIdentifier(Class clas) {
            this.clas = clas;
        }

        public Class getTargetClass() {
            return this.clas;
        }

        public String toString() {
            return "Class Identifier: " + this.clas.getName();
        }
    }
}

