/*
 * Decompiled with CFR 0.152.
 */
package bsh;

import bsh.EvalError;
import bsh.Interpreter;
import bsh.InterpreterError;
import bsh.NameSpace;
import bsh.ParserConstants;
import bsh.Primitive;
import bsh.Reflect;
import bsh.ReflectError;
import bsh.TargetError;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.Hashtable;

class LHS
implements ParserConstants,
Serializable {
    NameSpace nameSpace;
    static final int VARIABLE = 0;
    static final int FIELD = 1;
    static final int PROPERTY = 2;
    static final int INDEX = 3;
    int type;
    String varName;
    String propName;
    Field field;
    Object object;
    int index;

    LHS(NameSpace nameSpace, String varName) {
        this.type = 0;
        this.varName = varName;
        this.nameSpace = nameSpace;
    }

    LHS(Field field) {
        this.type = 1;
        this.object = null;
        this.field = field;
    }

    LHS(Object object, Field field) {
        if (object == null) {
            throw new NullPointerException("constructed empty LHS");
        }
        this.type = 1;
        this.object = object;
        this.field = field;
    }

    LHS(Object object, String propName) {
        if (object == null) {
            throw new NullPointerException("constructed empty LHS");
        }
        this.type = 2;
        this.object = object;
        this.propName = propName;
    }

    LHS(Object array, int index) {
        if (array == null) {
            throw new NullPointerException("constructed empty LHS");
        }
        this.type = 3;
        this.object = array;
        this.index = index;
    }

    public Object getValue() throws EvalError {
        if (this.type == 0) {
            return this.nameSpace.getVariable(this.varName);
        }
        if (this.type == 1) {
            try {
                return this.field.get(this.object);
            }
            catch (IllegalAccessException e2) {
                throw new EvalError("Can't read field: " + this.field);
            }
        }
        if (this.type == 2) {
            try {
                return Reflect.getObjectProperty(this.object, this.propName);
            }
            catch (ReflectError e) {
                Interpreter.debug(e.getMessage());
                throw new EvalError("No such property: " + this.propName);
            }
        }
        if (this.type == 3) {
            try {
                return Reflect.getIndex(this.object, this.index);
            }
            catch (Exception e) {
                throw new EvalError("Array access: " + e);
            }
        }
        throw new InterpreterError("LHS type");
    }

    public Object assign(Object val) throws EvalError {
        if (this.type == 0) {
            this.nameSpace.setVariable(this.varName, val);
        } else {
            if (this.type == 1) {
                try {
                    if (val instanceof Primitive) {
                        val = ((Primitive)val).getValue();
                    }
                    this.field.set(this.object, val);
                    return val;
                }
                catch (NullPointerException e) {
                    throw new EvalError("LHS (" + this.field.getName() + ") not a static field.");
                }
                catch (IllegalAccessException e2) {
                    throw new EvalError("LHS (" + this.field.getName() + ") can't access field.");
                }
                catch (IllegalArgumentException e3) {
                    throw new EvalError("Argument type mismatch. " + (val == null ? "null" : val.getClass().getName()) + " not assignable to field " + this.field.getName());
                }
            }
            if (this.type == 2) {
                if (this.object instanceof Hashtable) {
                    ((Hashtable)this.object).put(this.propName, val);
                } else {
                    try {
                        Reflect.setObjectProperty(this.object, this.propName, val);
                    }
                    catch (ReflectError e) {
                        Interpreter.debug("Assignment: " + e.getMessage());
                        throw new EvalError("No such property: " + this.propName);
                    }
                }
            } else if (this.type == 3) {
                try {
                    Reflect.setIndex(this.object, this.index, val);
                }
                catch (TargetError e1) {
                    throw e1;
                }
                catch (Exception e) {
                    throw new EvalError("Assignment: " + e.getMessage());
                }
            }
        }
        return val;
    }

    public String toString() {
        return "LHS";
    }
}

