/*
 * Decompiled with CFR 0.152.
 */
package bsh;

import bsh.ASCII_UCodeESC_CharStream;
import bsh.BshClassManager;
import bsh.CallStack;
import bsh.CommandLineReader;
import bsh.ConsoleInterface;
import bsh.EvalError;
import bsh.InterpreterError;
import bsh.JJTParserState;
import bsh.LHS;
import bsh.NameSpace;
import bsh.ParseException;
import bsh.Parser;
import bsh.Primitive;
import bsh.ReturnControl;
import bsh.SimpleNode;
import bsh.TargetError;
import bsh.This;
import bsh.TokenMgrError;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.PrintStream;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;

public class Interpreter
implements Runnable,
ConsoleInterface,
Serializable {
    public static final String VERSION = "1.2.7";
    public static boolean DEBUG;
    public static boolean TRACE;
    static transient PrintStream debug;
    static This systemObject;
    public static boolean strictJava;
    transient Parser parser;
    NameSpace globalNameSpace;
    transient Reader in;
    transient PrintStream out;
    transient PrintStream err;
    ConsoleInterface console;
    Interpreter parent;
    String sourceFileInfo;
    public boolean noExitOnEOF;
    private boolean evalOnly;
    private boolean interactive;

    static {
        Interpreter.staticInit();
        strictJava = false;
    }

    public Interpreter(Reader in, PrintStream out, PrintStream err, boolean interactive, NameSpace namespace, Interpreter parent, String sourceFileInfo) {
        this.parser = new Parser(in);
        long t1 = System.currentTimeMillis();
        this.in = in;
        this.out = out;
        this.err = err;
        this.interactive = interactive;
        debug = err;
        this.parent = parent;
        this.sourceFileInfo = sourceFileInfo;
        this.globalNameSpace = namespace == null ? new NameSpace("global") : namespace;
        if (!(this.getu("bsh") instanceof This)) {
            this.initRootSystemObject();
        }
        if (interactive) {
            this.loadRCFiles();
        }
        long t2 = System.currentTimeMillis();
        if (DEBUG) {
            Interpreter.debug("Time to initialize interpreter: " + (t2 - t1));
        }
    }

    public Interpreter(Reader in, PrintStream out, PrintStream err, boolean interactive, NameSpace namespace) {
        this(in, out, err, interactive, namespace, null, null);
    }

    public Interpreter(Reader in, PrintStream out, PrintStream err, boolean interactive) {
        this(in, out, err, interactive, null);
    }

    public Interpreter(ConsoleInterface console, NameSpace globalNameSpace) {
        this(console.getIn(), console.getOut(), console.getErr(), true, globalNameSpace);
        this.setConsole(console);
    }

    public Interpreter(ConsoleInterface console) {
        this(console, null);
    }

    public Interpreter() {
        this(new StringReader(""), System.out, System.err, false, null);
        this.evalOnly = true;
        this.setu("bsh.evalOnly", new Primitive(true));
    }

    public void setConsole(ConsoleInterface console) {
        this.console = console;
        this.setu("bsh.console", console);
        this.setOut(console.getOut());
        this.setErr(console.getErr());
    }

    private void initRootSystemObject() {
        this.setu("bsh", new NameSpace("Bsh Object").getThis(this));
        if (systemObject == null) {
            systemObject = new NameSpace("Bsh System Object").getThis(this);
        }
        this.setu("bsh.system", systemObject);
        This helpText = new NameSpace("Bsh Command Help Text").getThis(this);
        this.setu("bsh.help", helpText);
        try {
            this.setu("bsh.cwd", System.getProperty("user.dir"));
        }
        catch (SecurityException e) {
            this.setu("bsh.cwd", ".");
        }
        this.setu("bsh.interactive", new Primitive(this.interactive));
        this.setu("bsh.evalOnly", new Primitive(this.evalOnly));
    }

    public void setNameSpace(NameSpace globalNameSpace) {
        this.globalNameSpace = globalNameSpace;
    }

    public NameSpace getNameSpace() {
        return this.globalNameSpace;
    }

    public static void main(String[] args) {
        if (args.length > 0) {
            String[] bshArgs;
            String filename = args[0];
            if (args.length > 1) {
                bshArgs = new String[args.length - 1];
                System.arraycopy(args, 1, bshArgs, 0, args.length - 1);
            } else {
                bshArgs = new String[]{};
            }
            Interpreter interpreter = new Interpreter();
            interpreter.setu("bsh.args", bshArgs);
            try {
                interpreter.source(filename, interpreter.globalNameSpace);
            }
            catch (FileNotFoundException e) {
                System.out.println("File not found: " + e);
            }
            catch (TargetError e) {
                System.out.println("Script threw exception: " + e);
                if (e.inNativeCode()) {
                    e.printStackTrace(DEBUG, System.err);
                }
            }
            catch (EvalError e) {
                System.out.println("Evaluation Error: " + e);
            }
            catch (IOException e) {
                System.out.println("I/O Error: " + e);
            }
        } else {
            InputStream src = System.getProperty("os.name").startsWith("Windows") && System.getProperty("java.version").startsWith("1.1.") ? new FilterInputStream(System.in){

                public int available() throws IOException {
                    return 0;
                }
            } : System.in;
            CommandLineReader in = new CommandLineReader(new InputStreamReader(src));
            Interpreter interpreter = new Interpreter(in, System.out, System.err, true);
            interpreter.run();
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        if (this.evalOnly) {
            throw new RuntimeException("bsh Interpreter: No stream");
        }
        if (this.interactive) {
            try {
                this.eval("printBanner();");
            }
            catch (EvalError e) {
                this.println("BeanShell 1.2.7 - by Pat Niemeyer (pat@pat.net)");
            }
        }
        boolean eof = false;
        CallStack callstack = new CallStack();
        callstack.push(this.globalNameSpace);
        while (true) {
            Object var6_13;
            if (eof) {
                if (this.interactive && !this.noExitOnEOF) {
                    System.exit(0);
                }
                return;
            }
            try {
                try {
                    System.out.flush();
                    System.err.flush();
                    Thread.yield();
                    if (this.interactive) {
                        this.print("bsh % ");
                    }
                    eof = this.Line();
                    if (this.get_jjtree().nodeArity() > 0) {
                        SimpleNode node = (SimpleNode)this.get_jjtree().rootNode();
                        if (DEBUG) {
                            node.dump(">");
                        }
                        Object ret = node.eval(callstack, this);
                        if (callstack.depth() > 1) {
                            throw new InterpreterError("Callstack growing: " + callstack);
                        }
                        if (ret instanceof ReturnControl) {
                            ret = ((ReturnControl)ret).value;
                        }
                        if (ret != Primitive.VOID) {
                            this.setVariable("$_", ret);
                            Object show = this.getu("bsh.show");
                            if (show instanceof Boolean && ((Boolean)show).booleanValue()) {
                                this.println("<" + ret + ">");
                            }
                        }
                    }
                }
                catch (ParseException e) {
                    this.error("Parser Error: " + e.getMessage(DEBUG));
                    if (DEBUG) {
                        e.printStackTrace();
                    }
                    if (!this.interactive) {
                        eof = true;
                    }
                    this.parser.reInitInput(this.in);
                }
                catch (InterpreterError e) {
                    this.error("Internal Error: " + e.getMessage());
                    e.printStackTrace();
                    if (!this.interactive) {
                        eof = true;
                    }
                }
                catch (TargetError e) {
                    this.error("// Uncaught Exception: " + e);
                    if (e.inNativeCode()) {
                        e.printStackTrace(DEBUG, this.err);
                    }
                    if (!this.interactive) {
                        eof = true;
                    }
                    this.setVariable("$_e", e.getTarget());
                }
                catch (EvalError e) {
                    if (this.interactive) {
                        this.error(e.toString());
                    } else {
                        this.error(e.getMessage());
                    }
                    if (DEBUG) {
                        e.printStackTrace();
                    }
                    if (!this.interactive) {
                        eof = true;
                    }
                }
                catch (Exception e) {
                    this.error("Unknown error: " + e);
                    e.printStackTrace();
                    if (!this.interactive) {
                        eof = true;
                    }
                }
                catch (TokenMgrError e) {
                    this.error("Error parsing input: " + e);
                    this.parser.reInitTokenInput(this.in);
                    if (!this.interactive) {
                        eof = true;
                    }
                }
            }
            catch (Throwable throwable) {
                var6_13 = null;
                this.get_jjtree().reset();
                if (callstack.depth() > 1) {
                    callstack.clear();
                    callstack.push(this.globalNameSpace);
                }
                throw throwable;
            }
            {
                var6_13 = null;
                this.get_jjtree().reset();
                if (callstack.depth() <= 1) continue;
                callstack.clear();
                callstack.push(this.globalNameSpace);
                continue;
            }
            break;
        }
    }

    public Object source(String filename, NameSpace nameSpace) throws FileNotFoundException, IOException, EvalError {
        Object object;
        File file = this.pathToFile(filename);
        if (DEBUG) {
            Interpreter.debug("Sourcing file: " + file);
        }
        BufferedReader sourceIn = new BufferedReader(new FileReader(file));
        try {
            object = this.eval(sourceIn, nameSpace, filename);
            Object var5_6 = null;
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            ((Reader)sourceIn).close();
            throw throwable;
        }
        ((Reader)sourceIn).close();
        return object;
    }

    public Object source(String filename) throws FileNotFoundException, IOException, EvalError {
        return this.source(filename, this.globalNameSpace);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object eval(Reader in, NameSpace nameSpace, String sourceFileInfo) throws EvalError {
        Object retVal = null;
        if (DEBUG) {
            Interpreter.debug("eval: nameSpace = " + nameSpace);
        }
        Interpreter localInterpreter = new Interpreter(in, this.out, this.err, false, nameSpace, this, sourceFileInfo);
        CallStack callstack = new CallStack();
        callstack.push(nameSpace);
        boolean eof = false;
        while (!eof) {
            Object var10_16;
            SimpleNode node = null;
            try {
                try {
                    eof = localInterpreter.Line();
                    if (localInterpreter.get_jjtree().nodeArity() > 0) {
                        node = (SimpleNode)localInterpreter.get_jjtree().rootNode();
                        node.setSourceFile(sourceFileInfo);
                        if (TRACE) {
                            this.println("// " + node.getText());
                        }
                        retVal = node.eval(callstack, localInterpreter);
                        if (callstack.depth() > 1) {
                            throw new InterpreterError("Callstack growing: " + callstack);
                        }
                        if (retVal instanceof ReturnControl) {
                            retVal = ((ReturnControl)retVal).value;
                            var10_16 = null;
                            localInterpreter.get_jjtree().reset();
                            if (callstack.depth() <= 1) return Primitive.unwrap(retVal);
                            callstack.clear();
                            callstack.push(nameSpace);
                            return Primitive.unwrap(retVal);
                        }
                    }
                }
                catch (ParseException e) {
                    if (DEBUG) {
                        this.error(e.getMessage(DEBUG));
                    }
                    e.setErrorSourceFile(sourceFileInfo);
                    throw e;
                }
                catch (InterpreterError e) {
                    e.printStackTrace();
                    throw new EvalError("Sourced file: " + sourceFileInfo + " internal Error: " + e.getMessage(), node);
                }
                catch (TargetError e) {
                    if (e.getNode() == null) {
                        e.setNode(node);
                    }
                    e.reThrow("Sourced file: " + sourceFileInfo);
                }
                catch (EvalError e) {
                    if (DEBUG) {
                        e.printStackTrace();
                    }
                    if (e.getNode() == null) {
                        e.setNode(node);
                    }
                    e.reThrow("Sourced file: " + sourceFileInfo);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    throw new EvalError("Sourced file: " + sourceFileInfo + " unknown error: " + e.getMessage(), node);
                }
                catch (TokenMgrError e) {
                    throw new EvalError("Sourced file: " + sourceFileInfo + " Token Parsing Error: " + e.getMessage(), node);
                }
                var10_16 = null;
                localInterpreter.get_jjtree().reset();
                if (callstack.depth() <= 1) continue;
                callstack.clear();
                callstack.push(nameSpace);
            }
            catch (Throwable throwable) {
                var10_16 = null;
                localInterpreter.get_jjtree().reset();
                if (callstack.depth() <= 1) throw throwable;
                callstack.clear();
                callstack.push(nameSpace);
                throw throwable;
            }
        }
        return Primitive.unwrap(retVal);
    }

    public Object eval(Reader in) throws EvalError {
        return this.eval(in, this.globalNameSpace, "eval stream");
    }

    public Object eval(String statement) throws EvalError {
        if (DEBUG) {
            Interpreter.debug("eval(String): " + statement);
        }
        return this.eval(statement, this.globalNameSpace);
    }

    public Object eval(String statement, NameSpace nameSpace) throws EvalError {
        String s = statement.endsWith(";") ? statement : String.valueOf(statement) + ";";
        return this.eval(new StringReader(s), nameSpace, "<Inline eval of: " + s + " >");
    }

    public final void error(String s) {
        if (this.console != null) {
            this.console.error("// Error: " + s + "\n");
        } else {
            this.err.println("// Error: " + s);
            this.err.flush();
        }
    }

    public Reader getIn() {
        return this.in;
    }

    public PrintStream getOut() {
        return this.out;
    }

    public PrintStream getErr() {
        return this.err;
    }

    public final void println(String s) {
        this.print(String.valueOf(s) + "\n");
    }

    public final void print(String s) {
        if (this.console != null) {
            this.console.print(s);
        } else {
            this.out.print(s);
            this.out.flush();
        }
    }

    public static final void debug(String s) {
        if (DEBUG) {
            debug.println("// Debug: " + s);
        }
    }

    public Object get(String name) throws EvalError {
        Object ret = this.globalNameSpace.get(name, this);
        return Primitive.unwrap(ret);
    }

    Object getu(String name) {
        try {
            return this.get(name);
        }
        catch (EvalError e) {
            throw new InterpreterError("set: " + e);
        }
    }

    public void set(String name, Object value) throws EvalError {
        if (value == null) {
            value = Primitive.NULL;
        }
        CallStack callstack = new CallStack();
        LHS lhs = this.globalNameSpace.getNameResolver(name).toLHS(callstack, this);
        lhs.assign(value);
    }

    void setu(String name, Object value) {
        try {
            this.set(name, value);
        }
        catch (EvalError e) {
            throw new InterpreterError("set: " + e);
        }
    }

    public void set(String name, long value) throws EvalError {
        this.set(name, new Primitive(value));
    }

    public void set(String name, int value) throws EvalError {
        this.set(name, new Primitive(value));
    }

    public void set(String name, double value) throws EvalError {
        this.set(name, new Primitive(value));
    }

    public void set(String name, float value) throws EvalError {
        this.set(name, new Primitive(value));
    }

    public void set(String name, boolean value) throws EvalError {
        this.set(name, new Primitive(value));
    }

    public void unset(String name) throws EvalError {
        CallStack callstack = new CallStack();
        LHS lhs = this.globalNameSpace.getNameResolver(name).toLHS(callstack, this);
        if (lhs.type != 0) {
            throw new EvalError("Can't unset, not a variable: " + name);
        }
        lhs.assign(null);
    }

    public Object getVariable(String name) {
        Object obj = this.globalNameSpace.getVariable(name);
        return Primitive.unwrap(obj);
    }

    public void setVariable(String name, Object value) {
        try {
            this.globalNameSpace.setVariable(name, value);
        }
        catch (EvalError e) {
            this.error(e.toString());
        }
    }

    public void setVariable(String name, int value) {
        try {
            this.globalNameSpace.setVariable(name, new Primitive(value));
        }
        catch (EvalError e) {
            this.error(e.toString());
        }
    }

    public void setVariable(String name, float value) {
        try {
            this.globalNameSpace.setVariable(name, new Primitive(value));
        }
        catch (EvalError e) {
            this.error(e.toString());
        }
    }

    public void setVariable(String name, boolean value) {
        try {
            this.globalNameSpace.setVariable(name, new Primitive(value));
        }
        catch (EvalError e) {
            this.error(e.toString());
        }
    }

    public Object getInterface(Class interf) throws EvalError {
        return this.globalNameSpace.getThis(this).getInterface(interf);
    }

    private JJTParserState get_jjtree() {
        return this.parser.jjtree;
    }

    private ASCII_UCodeESC_CharStream get_jj_input_stream() {
        return this.parser.jj_input_stream;
    }

    private boolean Line() throws ParseException {
        return this.parser.Line();
    }

    void loadRCFiles() {
        block2: {
            try {
                String rcfile = String.valueOf(System.getProperty("user.home")) + File.separator + ".bshrc";
                this.source(rcfile, this.globalNameSpace);
            }
            catch (Exception e) {
                if (!DEBUG) break block2;
                Interpreter.debug("Could not find rc file: " + e);
            }
        }
    }

    public File pathToFile(String fileName) throws IOException {
        File file = new File(fileName);
        if (!file.isAbsolute()) {
            String cwd = (String)this.getu("bsh.cwd");
            file = new File(String.valueOf(cwd) + File.separator + fileName);
        }
        return new File(file.getCanonicalPath());
    }

    public static void redirectOutputToFile(String filename) {
        try {
            PrintStream pout = new PrintStream(new FileOutputStream(filename));
            System.setOut(pout);
            System.setErr(pout);
        }
        catch (IOException e) {
            System.err.println("Can't redirect output to file: " + filename);
        }
    }

    public void setClassLoader(ClassLoader externalCL) {
        BshClassManager.setClassLoader(externalCL);
    }

    static void staticInit() {
        try {
            debug = System.err;
            DEBUG = Boolean.getBoolean("debug");
            TRACE = Boolean.getBoolean("trace");
            String outfilename = System.getProperty("outfile");
            if (outfilename != null) {
                Interpreter.redirectOutputToFile(outfilename);
            }
        }
        catch (SecurityException e) {
            System.err.println("Could not init static:" + e);
        }
        catch (Exception e) {
            System.err.println("Could not init static(2):" + e);
        }
        catch (Throwable e) {
            System.err.println("Could not init static(3):" + e);
        }
    }

    public String getSourceFileInfo() {
        if (this.sourceFileInfo != null) {
            return this.sourceFileInfo;
        }
        return "<unknown source>";
    }

    public Interpreter getParent() {
        return this.parent;
    }

    public void setOut(PrintStream out) {
        this.out = out;
    }

    public void setErr(PrintStream out) {
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        if (this.console != null) {
            this.setOut(this.console.getOut());
            this.setErr(this.console.getErr());
        } else {
            this.setOut(System.out);
            this.setErr(System.err);
        }
    }
}

