/*
 * Decompiled with CFR 0.152.
 */
package bsh;

import bsh.ClassPathException;
import bsh.EvalError;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.URL;
import java.util.Hashtable;

public abstract class BshClassManager {
    private static BshClassManager manager;
    private static boolean checkedForManager;
    private static Object NOVALUE;
    private static ClassLoader externalClassLoader;
    protected static transient Hashtable absoluteClassCache;
    protected static transient Hashtable absoluteNonClasses;

    static {
        NOVALUE = new Object();
        absoluteClassCache = new Hashtable();
        absoluteNonClasses = new Hashtable();
    }

    public static BshClassManager getClassManager() {
        if (!checkedForManager && manager == null) {
            try {
                if (BshClassManager.plainClassForName("java.lang.ref.WeakReference") != null && BshClassManager.plainClassForName("java.util.HashMap") != null) {
                    Class bcm = BshClassManager.plainClassForName("bsh.classpath.ClassManagerImpl");
                    manager = (BshClassManager)bcm.newInstance();
                }
            }
            catch (ClassNotFoundException bcm) {
            }
            catch (Exception e) {
                System.err.println("Error loading classmanager: " + e);
            }
        }
        checkedForManager = true;
        return manager;
    }

    public static boolean classExists(String name) {
        return BshClassManager.classForName(name) != null;
    }

    public static Class classForName(String name) {
        BshClassManager manager = BshClassManager.getClassManager();
        if (manager != null) {
            return manager.getClassForName(name);
        }
        try {
            return BshClassManager.plainClassForName(name);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    public static Class plainClassForName(String name) throws ClassNotFoundException {
        try {
            BshClassManager bcm;
            Class<Object> c = externalClassLoader != null ? externalClassLoader.loadClass(name) : ((bcm = manager) != null ? bcm.getPlainClassForName(name) : Class.forName(name));
            BshClassManager.cacheClassInfo(name, c);
            return c;
        }
        catch (NoClassDefFoundError e) {
            BshClassManager.cacheClassInfo(name, null);
            throw new ClassNotFoundException(e.toString());
        }
    }

    public static void cacheClassInfo(String name, Class value) {
        if (value != null) {
            absoluteClassCache.put(name, value);
        } else {
            absoluteNonClasses.put(name, NOVALUE);
        }
    }

    protected void clearCaches() {
        absoluteNonClasses = new Hashtable();
        absoluteClassCache = new Hashtable();
    }

    public static void addCMListener(Listener l) {
        BshClassManager.getClassManager();
        if (manager != null) {
            manager.addListener(l);
        }
    }

    public static void setClassLoader(ClassLoader externalCL) {
        externalClassLoader = externalCL;
        BshClassManager bcm = BshClassManager.getClassManager();
        if (bcm != null) {
            bcm.classLoaderChanged();
        }
    }

    public abstract Class getClassForName(String var1);

    public abstract Class getPlainClassForName(String var1) throws ClassNotFoundException;

    public abstract ClassLoader getBaseLoader();

    public abstract ClassLoader getLoaderForClass(String var1);

    public abstract void addClassPath(URL var1) throws IOException;

    public abstract void reset();

    public abstract void setClassPath(URL[] var1);

    public abstract void reloadAllClasses() throws ClassPathException;

    public abstract void reloadClasses(String[] var1) throws ClassPathException;

    public abstract void reloadPackage(String var1) throws ClassPathException;

    public abstract void doSuperImport() throws EvalError;

    public abstract String getClassNameByUnqName(String var1) throws ClassPathException;

    public abstract void addListener(Listener var1);

    public abstract void removeListener(Listener var1);

    public abstract void dump(PrintWriter var1);

    protected abstract void classLoaderChanged();

    public static interface Listener {
        public void classLoaderChanged();
    }
}

