/*
 * Decompiled with CFR 0.152.
 */
package bsh;

import bsh.BSHAmbiguousName;
import bsh.BSHArguments;
import bsh.CallStack;
import bsh.EvalError;
import bsh.Interpreter;
import bsh.Name;
import bsh.NameSpace;
import bsh.ReflectError;
import bsh.SimpleNode;
import bsh.TargetError;
import java.lang.reflect.InvocationTargetException;

class BSHMethodInvocation
extends SimpleNode {
    BSHMethodInvocation(int id) {
        super(id);
    }

    public Object eval(CallStack callstack, Interpreter interpreter) throws EvalError {
        NameSpace namespace = callstack.top();
        Name name = ((BSHAmbiguousName)this.jjtGetChild(0)).getName(namespace);
        Object[] args = ((BSHArguments)this.jjtGetChild(1)).getArguments(callstack, interpreter);
        try {
            return name.invokeMethod(interpreter, args, callstack, this);
        }
        catch (ReflectError e) {
            throw new EvalError("Error in method invocation: " + e.getMessage(), this);
        }
        catch (InvocationTargetException e) {
            String msg = "Method Invocation " + name;
            Throwable te = e.getTargetException();
            boolean isNative = true;
            if (te instanceof EvalError) {
                isNative = te instanceof TargetError ? ((TargetError)te).inNativeCode() : false;
            }
            throw new TargetError(msg, te, this, isNative);
        }
        catch (EvalError ee) {
            ee.reThrow(this);
            throw new Error("should be unreachable...");
        }
    }
}

