/*
 * Decompiled with CFR 0.152.
 */
package bsh;

import bsh.BSHLHSPrimaryExpression;
import bsh.CallStack;
import bsh.EvalError;
import bsh.Interpreter;
import bsh.InterpreterError;
import bsh.LHS;
import bsh.ParserConstants;
import bsh.Primitive;
import bsh.SimpleNode;

class BSHAssignment
extends SimpleNode
implements ParserConstants {
    public int operator;

    BSHAssignment(int id) {
        super(id);
    }

    public Object eval(CallStack callstack, Interpreter interpreter) throws EvalError {
        BSHLHSPrimaryExpression lhsNode = (BSHLHSPrimaryExpression)this.jjtGetChild(0);
        if (lhsNode == null) {
            throw new InterpreterError("Error, null LHSnode");
        }
        LHS lhs = lhsNode.toLHS(callstack, interpreter);
        if (lhs == null) {
            throw new InterpreterError("Error, null LHS");
        }
        Object rhs = ((SimpleNode)this.jjtGetChild(1)).eval(callstack, interpreter);
        if (rhs == Primitive.VOID) {
            throw new EvalError("Void assignment.", this);
        }
        switch (this.operator) {
            case 70: {
                try {
                    return lhs.assign(rhs);
                }
                catch (EvalError e) {
                    e.reThrow(this);
                }
            }
            case 107: {
                return lhs.assign(this.operation(lhs.getValue(), rhs, 91));
            }
            case 108: {
                return lhs.assign(this.operation(lhs.getValue(), rhs, 92));
            }
            case 109: {
                return lhs.assign(this.operation(lhs.getValue(), rhs, 93));
            }
            case 110: {
                return lhs.assign(this.operation(lhs.getValue(), rhs, 94));
            }
            case 111: 
            case 112: {
                return lhs.assign(this.operation(lhs.getValue(), rhs, 95));
            }
            case 113: 
            case 114: {
                return lhs.assign(this.operation(lhs.getValue(), rhs, 97));
            }
            case 115: {
                return lhs.assign(this.operation(lhs.getValue(), rhs, 99));
            }
            case 116: {
                return lhs.assign(this.operation(lhs.getValue(), rhs, 100));
            }
            case 117: 
            case 118: {
                return lhs.assign(this.operation(lhs.getValue(), rhs, 101));
            }
            case 119: 
            case 120: {
                return lhs.assign(this.operation(lhs.getValue(), rhs, 103));
            }
            case 121: 
            case 122: {
                return lhs.assign(this.operation(lhs.getValue(), rhs, 105));
            }
        }
        throw new InterpreterError("unimplemented operator in assignment BSH");
    }

    private Object operation(Object lhs, Object rhs, int kind) throws EvalError {
        if (lhs instanceof String && rhs != Primitive.VOID) {
            if (kind != 91) {
                throw new EvalError("Use of non + operator with String LHS", this);
            }
            return String.valueOf((String)lhs) + rhs;
        }
        if (lhs instanceof Primitive || rhs instanceof Primitive) {
            if (lhs == Primitive.VOID || rhs == Primitive.VOID) {
                throw new EvalError("Illegal use of undefined object or 'void' literal", this);
            }
            if (lhs == Primitive.NULL || rhs == Primitive.NULL) {
                throw new EvalError("Illegal use of null object or 'null' literal", this);
            }
        }
        if ((lhs instanceof Boolean || lhs instanceof Character || lhs instanceof Number || lhs instanceof Primitive) && (rhs instanceof Boolean || rhs instanceof Character || rhs instanceof Number || rhs instanceof Primitive)) {
            return Primitive.binaryOperation(lhs, rhs, kind);
        }
        throw new EvalError("Non primitive value in operator: " + lhs.getClass() + " " + ParserConstants.tokenImage[kind] + " " + rhs.getClass(), this);
    }
}

