/*
 * Decompiled with CFR 0.152.
 */
package bsh;

import bsh.BSHArrayInitializer;
import bsh.CallStack;
import bsh.EvalError;
import bsh.Interpreter;
import bsh.Primitive;
import bsh.Reflect;
import bsh.SimpleNode;
import java.lang.reflect.Array;

class BSHArrayDimensions
extends SimpleNode {
    public Class baseType;
    private int arrayDims;
    public int[] dimensions;

    BSHArrayDimensions(int id) {
        super(id);
    }

    public void addArrayDimension() {
        ++this.arrayDims;
    }

    public Object eval(Class type, CallStack callstack, Interpreter interpreter) throws EvalError {
        if (Interpreter.DEBUG) {
            Interpreter.debug("array base type = " + type);
        }
        this.baseType = type;
        return this.eval(callstack, interpreter);
    }

    public Object eval(CallStack callstack, Interpreter interpreter) throws EvalError {
        SimpleNode child = (SimpleNode)this.jjtGetChild(0);
        if (child instanceof BSHArrayInitializer) {
            if (this.baseType == null) {
                throw new EvalError("Internal Array Eval err:  unknown base type", this);
            }
            Object initValue = ((BSHArrayInitializer)child).eval(this.baseType, this.arrayDims, callstack, interpreter);
            Class<?> arrayClass = initValue.getClass();
            this.dimensions = new int[Reflect.getArrayDimensions(arrayClass)];
            if (this.dimensions.length != this.arrayDims) {
                throw new EvalError("Incompatible initializer. Allocation calls for a " + this.arrayDims + " dimensional array, but initializer is a " + this.dimensions.length + " dimensional array", this);
            }
            Object arraySlice = initValue;
            int i = 0;
            while (i < this.dimensions.length) {
                this.dimensions[i] = Array.getLength(arraySlice);
                if (this.dimensions[i] > 0) {
                    arraySlice = Array.get(arraySlice, 0);
                }
                ++i;
            }
            return initValue;
        }
        this.dimensions = new int[this.jjtGetNumChildren()];
        int i = 0;
        while (i < this.dimensions.length) {
            try {
                Object length = ((SimpleNode)this.jjtGetChild(i)).eval(callstack, interpreter);
                this.dimensions[i] = ((Primitive)length).intValue();
            }
            catch (Exception e) {
                throw new EvalError("Array index: " + i + " does not evaluate to an integer", this);
            }
            ++i;
        }
        return Primitive.VOID;
    }
}

