/*
 * Decompiled with CFR 0.152.
 */
package org.python.core;

import org.python.core.Py;
import org.python.core.PyArray;
import org.python.core.PyClass;
import org.python.core.PyException;
import org.python.core.PyInteger;
import org.python.core.PyList;
import org.python.core.PyLong;
import org.python.core.PyObject;
import org.python.core.PySlice;
import org.python.core.PyTuple;
import org.python.core.SeqFuncs;

public abstract class PySequence
extends PyObject {
    public static void classDictInit(PyObject pyObject) {
        pyObject.__setitem__("__nonzero__", (PyObject)new SeqFuncs("__nonzero__", 1, 0));
        pyObject.__setitem__("__getitem__", (PyObject)new SeqFuncs("__getitem__", 11, 1));
        pyObject.__setitem__("__delitem__", (PyObject)new SeqFuncs("__delitem__", 12, 1));
        pyObject.__setitem__("__mul__", (PyObject)new SeqFuncs("__mul__", 13, 1));
        pyObject.__setitem__("__rmul__", (PyObject)new SeqFuncs("__rmul__", 14, 1));
        pyObject.__setitem__("__cmp__", (PyObject)new SeqFuncs("__cmp__", 15, 1));
        pyObject.__setitem__("__setitem__", (PyObject)new SeqFuncs("__setitem__", 21, 2));
        pyObject.__setitem__("__getslice__", (PyObject)new SeqFuncs("__getslice__", 31, 3));
        pyObject.__setitem__("__delslice__", (PyObject)new SeqFuncs("__delslice__", 32, 3));
        pyObject.__setitem__("__setslice__", (PyObject)new SeqFuncs("__setslice__", 41, 4));
        pyObject.__setitem__("classDictInit", null);
    }

    protected abstract PyObject get(int var1);

    protected abstract PyObject getslice(int var1, int var2, int var3);

    protected abstract PyObject repeat(int var1);

    protected void set(int n, PyObject pyObject) {
        throw Py.TypeError("can't assign to immutable object");
    }

    protected void setslice(int n, int n2, int n3, PyObject pyObject) {
        throw Py.TypeError("can't assign to immutable object");
    }

    protected void del(int n) throws PyException {
        throw Py.TypeError("can't remove from immutable object");
    }

    protected void delRange(int n, int n2, int n3) {
        throw Py.TypeError("can't remove from immutable object");
    }

    public boolean __nonzero__() {
        return this.__len__() != 0;
    }

    public synchronized PyObject __eq__(PyObject pyObject) {
        int n;
        if (pyObject.__class__ != this.__class__) {
            return null;
        }
        int n2 = this.__len__();
        if (n2 != (n = pyObject.__len__())) {
            return Py.Zero;
        }
        int n3 = PySequence.cmp(this, n2, pyObject, n);
        return n3 < 0 ? Py.One : Py.Zero;
    }

    public synchronized PyObject __ne__(PyObject pyObject) {
        int n;
        if (pyObject.__class__ != this.__class__) {
            return null;
        }
        int n2 = this.__len__();
        if (n2 != (n = pyObject.__len__())) {
            return Py.One;
        }
        int n3 = PySequence.cmp(this, n2, pyObject, n);
        return n3 < 0 ? Py.Zero : Py.One;
    }

    public synchronized PyObject __lt__(PyObject pyObject) {
        if (pyObject.__class__ != this.__class__) {
            return null;
        }
        int n = PySequence.cmp(this, -1, pyObject, -1);
        if (n < 0) {
            return n == -1 ? Py.One : Py.Zero;
        }
        return this.__finditem__(n)._lt(pyObject.__finditem__(n));
    }

    public synchronized PyObject __le__(PyObject pyObject) {
        if (pyObject.__class__ != this.__class__) {
            return null;
        }
        int n = PySequence.cmp(this, -1, pyObject, -1);
        if (n < 0) {
            return n == -1 || n == -2 ? Py.One : Py.Zero;
        }
        return this.__finditem__(n)._le(pyObject.__finditem__(n));
    }

    public synchronized PyObject __gt__(PyObject pyObject) {
        if (pyObject.__class__ != this.__class__) {
            return null;
        }
        int n = PySequence.cmp(this, -1, pyObject, -1);
        if (n < 0) {
            return n == -3 ? Py.One : Py.Zero;
        }
        return this.__finditem__(n)._gt(pyObject.__finditem__(n));
    }

    public synchronized PyObject __ge__(PyObject pyObject) {
        if (pyObject.__class__ != this.__class__) {
            return null;
        }
        int n = PySequence.cmp(this, -1, pyObject, -1);
        if (n < 0) {
            return n == -3 || n == -2 ? Py.One : Py.Zero;
        }
        return this.__finditem__(n)._ge(pyObject.__finditem__(n));
    }

    private static int cmp(PyObject pyObject, int n, PyObject pyObject2, int n2) {
        if (n < 0) {
            n = pyObject.__len__();
        }
        if (n2 < 0) {
            n2 = pyObject2.__len__();
        }
        int n3 = 0;
        while (n3 < n && n3 < n2) {
            if (!pyObject.__getitem__(n3)._eq(pyObject2.__getitem__(n3)).__nonzero__()) {
                return n3;
            }
            ++n3;
        }
        if (n == n2) {
            return -2;
        }
        return n < n2 ? -1 : -3;
    }

    protected static PyObject fastSequence(PyObject pyObject, String string) {
        PyObject pyObject2;
        if (pyObject instanceof PyList || pyObject instanceof PyTuple) {
            return pyObject;
        }
        if (!pyObject.isSequenceType()) {
            throw Py.TypeError(string);
        }
        int n = pyObject.__len__();
        PyList pyList = new PyList();
        int n2 = 0;
        while ((pyObject2 = pyList.__finditem__(n2)) != null) {
            pyList.append(pyObject2);
            ++n2;
        }
        return pyList;
    }

    protected static final int sliceLength(int n, int n2, int n3) {
        int n4 = n3 > 0 ? (n2 - n + n3 - 1) / n3 : (n2 - n + n3 + 1) / n3;
        if (n4 < 0) {
            return 0;
        }
        return n4;
    }

    private static final int getIndex(PyObject pyObject, int n) {
        block6: {
            if (pyObject == Py.None || pyObject == null) {
                return n;
            }
            if (pyObject instanceof PyLong) {
                try {
                    pyObject = pyObject.__int__();
                }
                catch (PyException pyException) {
                    if (!Py.matchException(pyException, Py.OverflowError)) break block6;
                    if (new PyLong(0L).__cmp__(pyObject) < 0) {
                        return Integer.MAX_VALUE;
                    }
                    return 0;
                }
            }
        }
        if (!(pyObject instanceof PyInteger)) {
            throw Py.TypeError("slice index must be int");
        }
        return ((PyInteger)pyObject).getValue();
    }

    protected int fixindex(int n) {
        int n2 = this.__len__();
        if (n < 0) {
            n += n2;
        }
        if (n < 0 || n >= n2) {
            return -1;
        }
        return n;
    }

    public synchronized PyObject __finditem__(int n) {
        if ((n = this.fixindex(n)) == -1) {
            return null;
        }
        return this.get(n);
    }

    public PyObject __finditem__(PyObject pyObject) {
        if (pyObject instanceof PyInteger) {
            return this.__finditem__(((PyInteger)pyObject).getValue());
        }
        if (pyObject instanceof PySlice) {
            PySlice pySlice = (PySlice)pyObject;
            return this.__getslice__(pySlice.start, pySlice.stop, pySlice.step);
        }
        if (pyObject instanceof PyLong) {
            return this.__finditem__(pyObject.__int__().getValue());
        }
        throw Py.TypeError("sequence subscript must be integer or slice");
    }

    public PyObject __getitem__(PyObject pyObject) {
        PyObject pyObject2 = this.__finditem__(pyObject);
        if (pyObject2 == null) {
            throw Py.IndexError("index out of range: " + pyObject);
        }
        return pyObject2;
    }

    public boolean isMappingType() {
        return false;
    }

    public boolean isNumberType() {
        return false;
    }

    protected static final int getStep(PyObject pyObject) {
        int n = PySequence.getIndex(pyObject, 1);
        if (n == 0) {
            throw Py.TypeError("slice step of zero not allowed");
        }
        return n;
    }

    protected static final int getStart(PyObject pyObject, int n, int n2) {
        int n3 = n < 0 ? PySequence.getIndex(pyObject, n2 - 1) : PySequence.getIndex(pyObject, 0);
        if (n3 < 0 && (n3 += n2) < 0) {
            n3 = 0;
        }
        if (n3 > n2) {
            n3 = n2;
        }
        return n3;
    }

    protected static final int getStop(PyObject pyObject, int n, int n2, int n3) {
        int n4;
        if (n2 < 0) {
            n4 = PySequence.getIndex(pyObject, -1);
            if (n4 < -1) {
                n4 = n3 + n4;
            }
            if (n4 < -1) {
                n4 = -1;
            }
        } else {
            n4 = PySequence.getIndex(pyObject, n3);
            if (n4 < 0) {
                n4 = n3 + n4;
            }
            if (n4 < 0) {
                n4 = 0;
            }
        }
        if (n4 > n3) {
            n4 = n3;
        }
        return n4;
    }

    public synchronized PyObject __getslice__(PyObject pyObject, PyObject pyObject2, PyObject pyObject3) {
        int n = this.__len__();
        int n2 = PySequence.getStep(pyObject3);
        int n3 = PySequence.getStart(pyObject, n2, n);
        int n4 = PySequence.getStop(pyObject2, n3, n2, n);
        return this.getslice(n3, n4, n2);
    }

    public synchronized void __setslice__(PyObject pyObject, PyObject pyObject2, PyObject pyObject3, PyObject pyObject4) {
        int n = this.__len__();
        int n2 = PySequence.getStep(pyObject3);
        int n3 = PySequence.getStart(pyObject, n2, n);
        int n4 = PySequence.getStop(pyObject2, n3, n2, n);
        this.setslice(n3, n4, n2, pyObject4);
    }

    public synchronized void __delslice__(PyObject pyObject, PyObject pyObject2, PyObject pyObject3) {
        int n = this.__len__();
        int n2 = PySequence.getStep(pyObject3);
        int n3 = PySequence.getStart(pyObject, n2, n);
        int n4 = PySequence.getStop(pyObject2, n3, n2, n);
        this.delRange(n3, n4, n2);
    }

    public synchronized void __setitem__(int n, PyObject pyObject) {
        int n2 = this.fixindex(n);
        if (n2 == -1) {
            throw Py.IndexError("index out of range: " + n2);
        }
        this.set(n2, pyObject);
    }

    public void __setitem__(PyObject pyObject, PyObject pyObject2) {
        if (pyObject instanceof PyInteger) {
            this.__setitem__(((PyInteger)pyObject).getValue(), pyObject2);
        } else if (pyObject instanceof PySlice) {
            PySlice pySlice = (PySlice)pyObject;
            this.__setslice__(pySlice.start, pySlice.stop, pySlice.step, pyObject2);
        } else if (pyObject instanceof PyLong) {
            this.__setitem__(pyObject.__int__().getValue(), pyObject2);
        } else {
            throw Py.TypeError("sequence subscript must be integer or slice");
        }
    }

    public synchronized void __delitem__(PyObject pyObject) {
        if (pyObject instanceof PyInteger) {
            int n = this.fixindex(((PyInteger)pyObject).getValue());
            if (n == -1) {
                throw Py.IndexError("index out of range: " + n);
            }
            this.del(n);
        } else if (pyObject instanceof PySlice) {
            PySlice pySlice = (PySlice)pyObject;
            this.__delslice__(pySlice.start, pySlice.stop, pySlice.step);
        } else if (pyObject instanceof PyLong) {
            int n = this.fixindex(pyObject.__int__().getValue());
            if (n == -1) {
                throw Py.IndexError("index out of range: " + n);
            }
            this.del(n);
        } else {
            throw Py.TypeError("sequence subscript must be integer or slice");
        }
    }

    public synchronized Object __tojava__(Class clazz) {
        if (clazz.isArray()) {
            Class<?> clazz2 = clazz.getComponentType();
            try {
                int n = this.__len__();
                PyArray pyArray = new PyArray(clazz2, n);
                int n2 = 0;
                while (n2 < n) {
                    PyObject pyObject = this.get(n2);
                    pyArray.set(n2, pyObject);
                    ++n2;
                }
                return pyArray.data;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return super.__tojava__(clazz);
    }

    public PySequence() {
    }

    public PySequence(PyClass pyClass) {
        super(pyClass);
    }
}

