/*
 * Decompiled with CFR 0.152.
 */
package org.python.core;

import org.python.core.Py;
import org.python.core.PyClass;
import org.python.core.PyComplex;
import org.python.core.PyInteger;
import org.python.core.PyLong;
import org.python.core.PyObject;
import org.python.core.PyTuple;

public class PyFloat
extends PyObject {
    public static PyClass __class__;
    private double value;
    private static /* synthetic */ Class class$Ljava$lang$Number;
    private static /* synthetic */ Class class$Ljava$lang$Double;
    private static /* synthetic */ Class class$Ljava$lang$Object;
    private static /* synthetic */ Class class$Ljava$io$Serializable;
    private static /* synthetic */ Class class$Ljava$lang$Float;

    protected String safeRepr() {
        return "'float' object";
    }

    public double getValue() {
        return this.value;
    }

    public String toString() {
        String string = Double.toString(this.value);
        if (string.indexOf(69) == -1) {
            int n;
            while ((n = string.length()) > 2 && string.charAt(n - 1) == '0' && string.charAt(n - 2) != '.') {
                string = string.substring(0, n - 1);
            }
        }
        return string;
    }

    public int hashCode() {
        double d = Math.floor(this.value);
        double d2 = this.value - d;
        if (d2 == 0.0) {
            if (d <= 2.147483647E9 && d >= -2.147483648E9) {
                return (int)this.value;
            }
            return this.__long__().hashCode();
        }
        long l = Double.doubleToLongBits(this.value);
        return (int)l ^ (int)(l >> 32);
    }

    public boolean __nonzero__() {
        return this.value != 0.0;
    }

    public Object __tojava__(Class clazz) {
        if (clazz == Double.TYPE || clazz == (class$Ljava$lang$Number != null ? class$Ljava$lang$Number : (class$Ljava$lang$Number = PyFloat.class$("java.lang.Number"))) || clazz == (class$Ljava$lang$Double != null ? class$Ljava$lang$Double : (class$Ljava$lang$Double = PyFloat.class$("java.lang.Double"))) || clazz == (class$Ljava$lang$Object != null ? class$Ljava$lang$Object : (class$Ljava$lang$Object = PyFloat.class$("java.lang.Object"))) || clazz == (class$Ljava$io$Serializable != null ? class$Ljava$io$Serializable : (class$Ljava$io$Serializable = PyFloat.class$("java.io.Serializable")))) {
            return new Double(this.value);
        }
        if (clazz == Float.TYPE || clazz == (class$Ljava$lang$Float != null ? class$Ljava$lang$Float : (class$Ljava$lang$Float = PyFloat.class$("java.lang.Float")))) {
            return new Float(this.value);
        }
        return super.__tojava__(clazz);
    }

    public int __cmp__(PyObject pyObject) {
        double d = ((PyFloat)pyObject).value;
        return this.value < d ? -1 : (this.value > d ? 1 : 0);
    }

    public Object __coerce_ex__(PyObject pyObject) {
        if (pyObject instanceof PyFloat) {
            return pyObject;
        }
        if (pyObject instanceof PyInteger) {
            return new PyFloat((double)((PyInteger)pyObject).getValue());
        }
        if (pyObject instanceof PyLong) {
            return new PyFloat(((PyLong)pyObject).doubleValue());
        }
        return Py.None;
    }

    private static final boolean canCoerce(PyObject pyObject) {
        return pyObject instanceof PyFloat || pyObject instanceof PyInteger || pyObject instanceof PyLong;
    }

    private static final double coerce(PyObject pyObject) {
        if (pyObject instanceof PyFloat) {
            return ((PyFloat)pyObject).value;
        }
        if (pyObject instanceof PyInteger) {
            return ((PyInteger)pyObject).getValue();
        }
        if (pyObject instanceof PyLong) {
            return ((PyLong)pyObject).doubleValue();
        }
        throw Py.TypeError("xxx");
    }

    public PyObject __add__(PyObject pyObject) {
        if (!PyFloat.canCoerce(pyObject)) {
            return null;
        }
        double d = PyFloat.coerce(pyObject);
        return new PyFloat(this.value + d);
    }

    public PyObject __radd__(PyObject pyObject) {
        return this.__add__(pyObject);
    }

    public PyObject __sub__(PyObject pyObject) {
        if (!PyFloat.canCoerce(pyObject)) {
            return null;
        }
        double d = PyFloat.coerce(pyObject);
        return new PyFloat(this.value - d);
    }

    public PyObject __rsub__(PyObject pyObject) {
        if (!PyFloat.canCoerce(pyObject)) {
            return null;
        }
        double d = PyFloat.coerce(pyObject);
        return new PyFloat(d - this.value);
    }

    public PyObject __mul__(PyObject pyObject) {
        if (!PyFloat.canCoerce(pyObject)) {
            return null;
        }
        double d = PyFloat.coerce(pyObject);
        return new PyFloat(this.value * d);
    }

    public PyObject __rmul__(PyObject pyObject) {
        return this.__mul__(pyObject);
    }

    public PyObject __div__(PyObject pyObject) {
        if (!PyFloat.canCoerce(pyObject)) {
            return null;
        }
        double d = PyFloat.coerce(pyObject);
        if (d == 0.0) {
            throw Py.ZeroDivisionError("float division");
        }
        return new PyFloat(this.value / d);
    }

    public PyObject __rdiv__(PyObject pyObject) {
        if (!PyFloat.canCoerce(pyObject)) {
            return null;
        }
        double d = PyFloat.coerce(pyObject);
        if (this.value == 0.0) {
            throw Py.ZeroDivisionError("float division");
        }
        return new PyFloat(d / this.value);
    }

    private static double modulo(double d, double d2) {
        if (d2 == 0.0) {
            throw Py.ZeroDivisionError("float modulo");
        }
        double d3 = Math.IEEEremainder(d, d2);
        if (d3 * d2 < 0.0) {
            d3 += d2;
        }
        return d3;
    }

    public PyObject __mod__(PyObject pyObject) {
        if (!PyFloat.canCoerce(pyObject)) {
            return null;
        }
        double d = PyFloat.coerce(pyObject);
        return new PyFloat(PyFloat.modulo(this.value, d));
    }

    public PyObject __rmod__(PyObject pyObject) {
        if (!PyFloat.canCoerce(pyObject)) {
            return null;
        }
        double d = PyFloat.coerce(pyObject);
        return new PyFloat(PyFloat.modulo(d, this.value));
    }

    public PyObject __divmod__(PyObject pyObject) {
        if (!PyFloat.canCoerce(pyObject)) {
            return null;
        }
        double d = PyFloat.coerce(pyObject);
        if (d == 0.0) {
            throw Py.ZeroDivisionError("float division");
        }
        double d2 = Math.floor(this.value / d);
        return new PyTuple(new PyObject[]{new PyFloat(d2), new PyFloat(this.value - d2 * d)});
    }

    public PyObject __rdivmod__(PyObject pyObject) {
        if (!PyFloat.canCoerce(pyObject)) {
            return null;
        }
        double d = PyFloat.coerce(pyObject);
        if (this.value == 0.0) {
            throw Py.ZeroDivisionError("float division");
        }
        double d2 = Math.floor(d / this.value);
        return new PyTuple(new PyObject[]{new PyFloat(d2), new PyFloat(d - d2 * this.value)});
    }

    public PyObject __pow__(PyObject pyObject, PyObject pyObject2) {
        if (!PyFloat.canCoerce(pyObject)) {
            return null;
        }
        if (pyObject2 != null && !PyFloat.canCoerce(pyObject2)) {
            return null;
        }
        return PyFloat._pow(this.value, PyFloat.coerce(pyObject), pyObject2);
    }

    public PyObject __rpow__(PyObject pyObject) {
        if (!PyFloat.canCoerce(pyObject)) {
            return null;
        }
        return PyFloat._pow(PyFloat.coerce(pyObject), this.value, null);
    }

    private static PyFloat _pow(double d, double d2, PyObject pyObject) {
        if (d2 == 0.0) {
            if (pyObject != null) {
                return new PyFloat(PyFloat.modulo(1.0, PyFloat.coerce(pyObject)));
            }
            return new PyFloat(1.0);
        }
        if (d == 0.0) {
            if (d2 < 0.0) {
                throw Py.ZeroDivisionError("0.0 cannot be raised to a negative power");
            }
            return new PyFloat(0.0f);
        }
        double d3 = Math.pow(d, d2);
        if (pyObject == null) {
            return new PyFloat(d3);
        }
        return new PyFloat(PyFloat.modulo(d3, PyFloat.coerce(pyObject)));
    }

    public PyObject __neg__() {
        return new PyFloat(-this.value);
    }

    public PyObject __pos__() {
        return this;
    }

    public PyObject __abs__() {
        if (this.value >= 0.0) {
            return this;
        }
        return this.__neg__();
    }

    public PyInteger __int__() {
        if (this.value <= 2.147483647E9 && this.value >= -2.147483648E9) {
            return new PyInteger((int)this.value);
        }
        throw Py.OverflowError("float too large to convert");
    }

    public PyLong __long__() {
        return new PyLong(this.value);
    }

    public PyFloat __float__() {
        return this;
    }

    public PyComplex __complex__() {
        return new PyComplex(this.value, 0.0);
    }

    public boolean isMappingType() {
        return false;
    }

    public boolean isSequenceType() {
        return false;
    }

    protected PyClass getPyClass() {
        return __class__;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public PyFloat(double d) {
        this.value = d;
    }

    public PyFloat(float f) {
        this((double)f);
    }
}

