/*
 * Decompiled with CFR 0.152.
 */
package org.python.compiler;

import java.io.IOException;
import java.util.Hashtable;
import java.util.Stack;
import java.util.Vector;
import org.python.compiler.Code;
import org.python.compiler.CompilationContext;
import org.python.compiler.ConstantPool;
import org.python.compiler.Future;
import org.python.compiler.Label;
import org.python.compiler.Module;
import org.python.compiler.ScopeInfo;
import org.python.compiler.ScopesCompiler;
import org.python.compiler.SymInfo;
import org.python.core.CompilerFlags;
import org.python.core.Py;
import org.python.core.PyException;
import org.python.parser.ParseException;
import org.python.parser.SimpleNode;
import org.python.parser.Visitor;

public class CodeCompiler
extends Visitor
implements CompilationContext {
    public static final Object Exit = new Integer(1);
    public static final Object NoExit;
    public static final int GET = 0;
    public static final int SET = 1;
    public static final int DEL = 2;
    public static final int AUGGET = 3;
    public static final int AUGSET = 4;
    public static final Object DoFinally;
    public Module module;
    public Code code;
    public ConstantPool pool;
    public CodeCompiler mrefs;
    int mode;
    int temporary;
    public boolean fast_locals;
    public boolean print_results;
    public Future futures;
    public Hashtable tbl;
    public ScopeInfo my_scope;
    boolean optimizeGlobals = true;
    public Vector names;
    public String className;
    public Stack continueLabels;
    public Stack breakLabels;
    public Stack finallyLabels;
    public Stack listComprehensionExprs;
    public Stack listComprehensionAppends;
    public int PyNone;
    public int setline;
    public int EmptyObjects;
    int getclosure;
    int f_globals;
    int PyFunction_init;
    int PyFunction_closure_init;
    public int printResult;
    public int print1;
    public int print2;
    public int print3;
    public int print4;
    public int print5;
    public int print6;
    public int makeException0;
    public int makeException1;
    public int makeException2;
    public int makeException3;
    public int importOne;
    public int importOneAs;
    public int importAll;
    public int importFrom;
    public int exec;
    public int assert1;
    public int assert2;
    public int nonzero;
    public int safe_getitem = 0;
    public int match_exception;
    public int add_traceback;
    public int set_exception;
    public Integer less;
    public Integer greater;
    public Integer equal;
    public Integer less_equal;
    public Integer greater_equal;
    public Integer notequal;
    public Integer in;
    public Integer not_in;
    public Integer is;
    public Integer is_not;
    public int invokea0;
    public int invokea1;
    public int invokea2;
    public int invoke2;
    public int callextra;
    public int call1;
    public int call2;
    public int calla0;
    public int calla1;
    public int calla2;
    public int calla3;
    public int calla4;
    public int getslice;
    public int setslice;
    public int delslice;
    public int getitem;
    public int delitem;
    public int setitem;
    public int getattr;
    public int delattr;
    public int setattr;
    public int getitem2;
    public int unpackSequence;
    public int PyTuple_init;
    public int PyList_init;
    public int PyDictionary_init;
    public int PyList_init2;
    public int PyFunction_init1;
    public int PyFunction_closure_init1;
    public int Ellipsis;
    public int PySlice_init;
    public int makeClass;
    public int makeClass_closure;
    int getglobal;
    int getlocal1;
    int getlocal2;
    int setglobal;
    int setlocal1;
    int setlocal2;
    int delglobal;
    int dellocal1;
    int dellocal2;
    int getderef;
    int setderef;

    public Future getFutures() {
        return this.futures;
    }

    public String getFilename() {
        return this.module.sfilename;
    }

    public void getNone() throws IOException {
        if (this.mrefs.PyNone == 0) {
            this.mrefs.PyNone = this.pool.Fieldref("org/python/core/Py", "None", "Lorg/python/core/PyObject;");
        }
        this.code.getstatic(this.mrefs.PyNone);
    }

    public void loadFrame() throws Exception {
        this.code.aload(1);
    }

    public int storeTop() throws Exception {
        int n = this.code.getLocal();
        this.code.astore(n);
        return n;
    }

    public void setline(int n) throws Exception {
        if (this.module.linenumbers) {
            this.code.setline(n);
            this.loadFrame();
            this.code.iconst(n);
            if (this.mrefs.setline == 0) {
                this.mrefs.setline = this.pool.Methodref("org/python/core/PyFrame", "setline", "(I)V");
            }
            this.code.invokevirtual(this.mrefs.setline);
        }
    }

    public void setline(SimpleNode simpleNode) throws Exception {
        this.setline(simpleNode.beginLine);
    }

    public void set(SimpleNode simpleNode) throws Exception {
        int n = this.storeTop();
        this.set(simpleNode, n);
        this.code.freeLocal(n);
    }

    public void set(SimpleNode simpleNode, int n) throws Exception {
        if (this.mode == 1) {
            int n2 = this.temporary;
            this.temporary = n;
            simpleNode.visit(this);
            this.temporary = n2;
        } else {
            this.temporary = n;
            this.mode = 1;
            simpleNode.visit(this);
            this.mode = 0;
        }
    }

    private void saveAugTmps(SimpleNode simpleNode, int n) throws Exception {
        if (n >= 4) {
            simpleNode.aug_tmp4 = this.code.getLocal();
            this.code.astore(simpleNode.aug_tmp4);
        }
        if (n >= 3) {
            simpleNode.aug_tmp3 = this.code.getLocal();
            this.code.astore(simpleNode.aug_tmp3);
        }
        if (n >= 2) {
            simpleNode.aug_tmp2 = this.code.getLocal();
            this.code.astore(simpleNode.aug_tmp2);
        }
        simpleNode.aug_tmp1 = this.code.getLocal();
        this.code.astore(simpleNode.aug_tmp1);
        this.code.aload(simpleNode.aug_tmp1);
        if (n >= 2) {
            this.code.aload(simpleNode.aug_tmp2);
        }
        if (n >= 3) {
            this.code.aload(simpleNode.aug_tmp3);
        }
        if (n >= 4) {
            this.code.aload(simpleNode.aug_tmp4);
        }
    }

    private void restoreAugTmps(SimpleNode simpleNode, int n) throws Exception {
        this.code.aload(simpleNode.aug_tmp1);
        this.code.freeLocal(simpleNode.aug_tmp1);
        if (n == 1) {
            return;
        }
        this.code.aload(simpleNode.aug_tmp2);
        this.code.freeLocal(simpleNode.aug_tmp2);
        if (n == 2) {
            return;
        }
        this.code.aload(simpleNode.aug_tmp3);
        this.code.freeLocal(simpleNode.aug_tmp3);
        if (n == 3) {
            return;
        }
        this.code.aload(simpleNode.aug_tmp4);
        this.code.freeLocal(simpleNode.aug_tmp4);
        if (n == 4) {
            return;
        }
    }

    public void error(String string, boolean bl, SimpleNode simpleNode) throws Exception {
        block3: {
            if (!bl) {
                try {
                    Py.warning(Py.SyntaxWarning, string, this.module.sfilename != null ? this.module.sfilename : "?", simpleNode.beginLine, null, Py.None);
                    return;
                }
                catch (PyException pyException) {
                    if (Py.matchException(pyException, Py.SyntaxWarning)) break block3;
                    throw pyException;
                }
            }
        }
        throw new ParseException(string, simpleNode);
    }

    public void parse(SimpleNode simpleNode, Code code, boolean bl, String string, boolean bl2, ScopeInfo scopeInfo, CompilerFlags compilerFlags) throws Exception {
        this.fast_locals = bl;
        this.className = string;
        this.code = code;
        if (scopeInfo == null) {
            this.futures = new Future();
            this.futures.preprocessFutures(simpleNode, compilerFlags);
            new ScopesCompiler(this).parse(simpleNode);
            scopeInfo = simpleNode.scope;
        }
        this.my_scope = scopeInfo;
        this.names = scopeInfo.names;
        this.tbl = scopeInfo.tbl;
        this.optimizeGlobals = bl && !scopeInfo.exec && !scopeInfo.from_import_star;
        this.mode = 0;
        Object object = simpleNode.visit(this);
        if (bl2) {
            this.loadFrame();
            code.invokevirtual("org/python/core/PyFrame", "getf_locals", "()Lorg/python/core/PyObject;");
            code.areturn();
        } else if (object == null) {
            this.getNone();
            code.areturn();
        }
    }

    public Object single_input(SimpleNode simpleNode) throws Exception {
        return this.suite(simpleNode);
    }

    public Object file_input(SimpleNode simpleNode) throws Exception {
        if (this.mrefs.setglobal == 0) {
            this.mrefs.setglobal = this.code.pool.Methodref("org/python/core/PyFrame", "setglobal", "(Ljava/lang/String;Lorg/python/core/PyObject;)V");
        }
        if (simpleNode.getNumChildren() > 0 && simpleNode.getChild((int)0).id == 10 && simpleNode.getChild((int)0).getChild((int)0).id == 95) {
            this.loadFrame();
            this.code.ldc("__doc__");
            simpleNode.getChild(0).getChild(0).visit(this);
            this.code.invokevirtual(this.mrefs.setglobal);
        }
        if (this.module.setFile) {
            this.loadFrame();
            this.code.ldc("__file__");
            this.module.filename.get(this.code);
            this.code.invokevirtual(this.mrefs.setglobal);
        }
        return this.suite(simpleNode);
    }

    public Object eval_input(SimpleNode simpleNode) throws Exception {
        return this.return_stmt(simpleNode, true);
    }

    public void makeArray(SimpleNode[] simpleNodeArray) throws Exception {
        int n = simpleNodeArray == null ? 0 : simpleNodeArray.length;
        if (n > 0 && simpleNodeArray[n - 1].id == 84) {
            --n;
        }
        if (n == 0) {
            if (this.mrefs.EmptyObjects == 0) {
                this.mrefs.EmptyObjects = this.code.pool.Fieldref("org/python/core/Py", "EmptyObjects", "[Lorg/python/core/PyObject;");
            }
            this.code.getstatic(this.mrefs.EmptyObjects);
        } else {
            int n2 = this.code.getLocal();
            this.code.iconst(n);
            this.code.anewarray(this.code.pool.Class("org/python/core/PyObject"));
            this.code.astore(n2);
            int n3 = 0;
            while (n3 < n) {
                this.code.aload(n2);
                this.code.iconst(n3);
                simpleNodeArray[n3].visit(this);
                this.code.aastore();
                ++n3;
            }
            this.code.aload(n2);
            this.code.freeLocal(n2);
        }
    }

    public void getDocString(SimpleNode simpleNode) throws Exception {
        if (simpleNode.getNumChildren() > 0 && simpleNode.getChild((int)0).id == 10 && simpleNode.getChild((int)0).getChild((int)0).id == 95) {
            simpleNode.getChild(0).getChild(0).visit(this);
        } else {
            this.code.aconst_null();
        }
    }

    public boolean makeClosure(Vector vector) throws Exception {
        if (vector == null) {
            return false;
        }
        int n = vector.size();
        if (n == 0) {
            return false;
        }
        if (this.mrefs.getclosure == 0) {
            this.mrefs.getclosure = this.code.pool.Methodref("org/python/core/PyFrame", "getclosure", "(I)Lorg/python/core/PyObject;");
        }
        int n2 = this.code.getLocal();
        this.code.iconst(n);
        this.code.anewarray(this.code.pool.Class("org/python/core/PyObject"));
        this.code.astore(n2);
        int n3 = 0;
        while (n3 < n) {
            this.code.aload(n2);
            this.code.iconst(n3);
            this.code.aload(1);
            this.code.iconst(((SymInfo)this.tbl.get(vector.elementAt((int)n3))).env_index);
            this.code.invokevirtual(this.getclosure);
            this.code.aastore();
            ++n3;
        }
        this.code.aload(n2);
        this.code.freeLocal(n2);
        return true;
    }

    public Object funcdef(SimpleNode simpleNode) throws Exception {
        String string = this.getName(simpleNode.getChild(0));
        SimpleNode simpleNode2 = simpleNode.getNumChildren() == 3 ? simpleNode.getChild(2) : simpleNode.getChild(1);
        this.setline(simpleNode);
        this.code.new_(this.code.pool.Class("org/python/core/PyFunction"));
        this.code.dup();
        this.loadFrame();
        if (this.mrefs.f_globals == 0) {
            this.mrefs.f_globals = this.code.pool.Fieldref("org/python/core/PyFrame", "f_globals", "Lorg/python/core/PyObject;");
        }
        this.code.getfield(this.mrefs.f_globals);
        this.makeArray(simpleNode.scope.ac.getDefaults());
        simpleNode.scope.setup_closure(this.my_scope);
        simpleNode.scope.dump();
        this.module.PyCode(simpleNode2, string, true, this.className, false, false, simpleNode.beginLine, simpleNode.scope).get(this.code);
        Vector vector = simpleNode.scope.freevars;
        simpleNode.scope = null;
        this.getDocString(simpleNode2);
        if (!this.makeClosure(vector)) {
            if (this.mrefs.PyFunction_init == 0) {
                this.mrefs.PyFunction_init = this.code.pool.Methodref("org/python/core/PyFunction", "<init>", "(Lorg/python/core/PyObject;[Lorg/python/core/PyObject;Lorg/python/core/PyCode;Lorg/python/core/PyObject;)V");
            }
            this.code.invokespecial(this.mrefs.PyFunction_init);
        } else {
            if (this.mrefs.PyFunction_closure_init == 0) {
                this.mrefs.PyFunction_closure_init = this.code.pool.Methodref("org/python/core/PyFunction", "<init>", "(Lorg/python/core/PyObject;[Lorg/python/core/PyObject;Lorg/python/core/PyCode;Lorg/python/core/PyObject;[Lorg/python/core/PyObject;)V");
            }
            this.code.invokespecial(this.mrefs.PyFunction_closure_init);
        }
        this.set(simpleNode.getChild(0));
        return null;
    }

    public Object expr_stmt(SimpleNode simpleNode) throws Exception {
        this.setline(simpleNode);
        int n = simpleNode.getNumChildren();
        if (n == 1 && simpleNode.getChild((int)0).id >= 11 && simpleNode.getChild((int)0).id <= 21) {
            simpleNode.getChild(0).visit(this);
            return null;
        }
        simpleNode.getChild(n - 1).visit(this);
        if (n == 1) {
            if (this.print_results) {
                if (this.mrefs.printResult == 0) {
                    this.mrefs.printResult = this.code.pool.Methodref("org/python/core/Py", "printResult", "(Lorg/python/core/PyObject;)V");
                }
                this.code.invokestatic(this.mrefs.printResult);
            } else {
                this.code.pop();
            }
            return null;
        }
        if (n == 2) {
            this.set(simpleNode.getChild(0));
            return null;
        }
        int n2 = this.storeTop();
        int n3 = n - 2;
        while (n3 >= 0) {
            this.set(simpleNode.getChild(n3), n2);
            --n3;
        }
        this.code.freeLocal(n2);
        return null;
    }

    public Object print_ext(SimpleNode simpleNode) throws Exception {
        simpleNode.getChild(0).visit(this);
        return null;
    }

    public Object print_stmt(SimpleNode simpleNode) throws Exception {
        int n;
        int n2;
        int n3;
        this.setline(simpleNode);
        int n4 = simpleNode.getNumChildren();
        int n5 = -1;
        int n6 = 0;
        int n7 = 0;
        boolean bl = false;
        if (simpleNode.getNumChildren() > 0 && simpleNode.getChild((int)0).id == 23) {
            bl = true;
            simpleNode.getChild(0).visit(this);
            n5 = this.storeTop();
            n6 = 1;
            n7 = 1;
            if (this.mrefs.print4 == 0) {
                this.mrefs.print4 = this.pool.Methodref("org/python/core/Py", "printComma", "(Lorg/python/core/PyObject;Lorg/python/core/PyObject;)V");
            }
            n3 = this.mrefs.print4;
            if (this.mrefs.print5 == 0) {
                this.mrefs.print5 = this.pool.Methodref("org/python/core/Py", "println", "(Lorg/python/core/PyObject;Lorg/python/core/PyObject;)V");
            }
            n2 = this.mrefs.print5;
            if (this.mrefs.print6 == 0) {
                this.mrefs.print6 = this.pool.Methodref("org/python/core/Py", "printlnv", "(Lorg/python/core/PyObject;)V");
            }
            n = this.mrefs.print6;
        } else {
            if (this.mrefs.print1 == 0) {
                this.mrefs.print1 = this.pool.Methodref("org/python/core/Py", "printComma", "(Lorg/python/core/PyObject;)V");
            }
            n3 = this.mrefs.print1;
            if (this.mrefs.print2 == 0) {
                this.mrefs.print2 = this.pool.Methodref("org/python/core/Py", "println", "(Lorg/python/core/PyObject;)V");
            }
            n2 = this.mrefs.print2;
            if (this.mrefs.print3 == 0) {
                this.mrefs.print3 = this.pool.Methodref("org/python/core/Py", "println", "()V");
            }
            n = this.mrefs.print3;
        }
        while (n6 < n4 - 1) {
            if (bl) {
                this.code.aload(n5);
            }
            simpleNode.getChild(n6).visit(this);
            this.code.invokestatic(n3);
            ++n6;
        }
        if (simpleNode.getNumChildren() == n7) {
            if (bl) {
                this.code.aload(n5);
            }
            this.code.invokestatic(n);
        } else if (simpleNode.getChild((int)(n4 - 1)).id != 84) {
            if (bl) {
                this.code.aload(n5);
            }
            simpleNode.getChild(n4 - 1).visit(this);
            this.code.invokestatic(n2);
        }
        if (bl) {
            this.code.freeLocal(n5);
        }
        return null;
    }

    public Object del_stmt(SimpleNode simpleNode) throws Exception {
        this.setline(simpleNode);
        this.mode = 2;
        simpleNode.getChild(0).visit(this);
        this.mode = 0;
        return null;
    }

    public Object pass_stmt(SimpleNode simpleNode) throws Exception {
        this.setline(simpleNode);
        return null;
    }

    public Object break_stmt(SimpleNode simpleNode) throws Exception {
        if (this.breakLabels.empty()) {
            throw new ParseException("'break' outside loop", simpleNode);
        }
        Object e = this.breakLabels.peek();
        if (e == DoFinally) {
            this.code.jsr((Label)this.finallyLabels.peek());
            Object e2 = e;
            this.breakLabels.pop();
            e = this.breakLabels.peek();
            this.breakLabels.push(e2);
        }
        this.code.goto_((Label)e);
        return null;
    }

    public Object continue_stmt(SimpleNode simpleNode) throws Exception {
        if (this.continueLabels.empty()) {
            throw new ParseException("'continue' outside loop", simpleNode);
        }
        Object e = this.continueLabels.peek();
        if (e == DoFinally) {
            this.code.jsr((Label)this.finallyLabels.peek());
            Object e2 = e;
            this.continueLabels.pop();
            e = this.continueLabels.peek();
            this.continueLabels.push(e2);
        }
        this.code.goto_((Label)e);
        return null;
    }

    public Object return_stmt(SimpleNode simpleNode) throws Exception {
        return this.return_stmt(simpleNode, false);
    }

    public Object return_stmt(SimpleNode simpleNode, boolean bl) throws Exception {
        this.setline(simpleNode);
        if (!bl && !this.fast_locals) {
            throw new ParseException("'return' outside function", simpleNode);
        }
        if (simpleNode.getNumChildren() == 1) {
            simpleNode.getChild(0).visit(this);
        } else {
            this.getNone();
        }
        int n = this.code.getLocal();
        this.code.astore(n);
        if (!this.finallyLabels.empty()) {
            this.code.jsr((Label)this.finallyLabels.peek());
        }
        this.code.aload(n);
        this.code.areturn();
        return Exit;
    }

    public Object raise_stmt(SimpleNode simpleNode) throws Exception {
        this.setline(simpleNode);
        int n = simpleNode.getNumChildren();
        int n2 = 0;
        while (n2 < n) {
            simpleNode.getChild(n2).visit(this);
            ++n2;
        }
        switch (n) {
            case 0: {
                if (this.mrefs.makeException0 == 0) {
                    this.mrefs.makeException0 = this.code.pool.Methodref("org/python/core/Py", "makeException", "()Lorg/python/core/PyException;");
                }
                this.code.invokestatic(this.mrefs.makeException0);
                break;
            }
            case 1: {
                if (this.mrefs.makeException1 == 0) {
                    this.mrefs.makeException1 = this.code.pool.Methodref("org/python/core/Py", "makeException", "(Lorg/python/core/PyObject;)Lorg/python/core/PyException;");
                }
                this.code.invokestatic(this.mrefs.makeException1);
                break;
            }
            case 2: {
                if (this.mrefs.makeException2 == 0) {
                    this.mrefs.makeException2 = this.code.pool.Methodref("org/python/core/Py", "makeException", "(Lorg/python/core/PyObject;Lorg/python/core/PyObject;)Lorg/python/core/PyException;");
                }
                this.code.invokestatic(this.mrefs.makeException2);
                break;
            }
            case 3: {
                if (this.mrefs.makeException3 == 0) {
                    this.mrefs.makeException3 = this.code.pool.Methodref("org/python/core/Py", "makeException", "(Lorg/python/core/PyObject;Lorg/python/core/PyObject;Lorg/python/core/PyObject;)Lorg/python/core/PyException;");
                }
                this.code.invokestatic(this.mrefs.makeException3);
                break;
            }
        }
        this.code.athrow();
        return Exit;
    }

    public Object Import(SimpleNode simpleNode) throws Exception {
        this.setline(simpleNode);
        int n = simpleNode.getNumChildren();
        int n2 = 0;
        while (n2 < n) {
            SimpleNode simpleNode2;
            String string;
            SimpleNode simpleNode3 = simpleNode.getChild(n2);
            if (simpleNode3.id == 32) {
                string = (String)simpleNode3.getChild(0).visit(this);
                simpleNode2 = simpleNode3.getChild(1);
                this.code.ldc(string);
                this.loadFrame();
                if (this.mrefs.importOneAs == 0) {
                    this.mrefs.importOneAs = this.code.pool.Methodref("org/python/core/imp", "importOneAs", "(Ljava/lang/String;Lorg/python/core/PyFrame;)Lorg/python/core/PyObject;");
                }
                this.code.invokestatic(this.mrefs.importOneAs);
            } else {
                string = (String)simpleNode3.visit(this);
                simpleNode2 = simpleNode3.getChild(0);
                this.code.ldc(string);
                this.loadFrame();
                if (this.mrefs.importOne == 0) {
                    this.mrefs.importOne = this.code.pool.Methodref("org/python/core/imp", "importOne", "(Ljava/lang/String;Lorg/python/core/PyFrame;)Lorg/python/core/PyObject;");
                }
                this.code.invokestatic(this.mrefs.importOne);
            }
            this.set(simpleNode2);
            ++n2;
        }
        return null;
    }

    public Object ImportFrom(SimpleNode simpleNode) throws Exception {
        Future.checkFromFuture(simpleNode);
        this.setline(simpleNode);
        String string = (String)simpleNode.getChild(0).visit(this);
        this.code.ldc(string);
        int n = simpleNode.getNumChildren();
        if (n > 1) {
            String[] stringArray = new String[n - 1];
            SimpleNode[] simpleNodeArray = new SimpleNode[n - 1];
            int n2 = 0;
            while (n2 < n - 1) {
                SimpleNode simpleNode2 = simpleNode.getChild(n2 + 1);
                if (simpleNode2.id == 34) {
                    stringArray[n2] = (String)simpleNode2.getChild(0).getInfo();
                    simpleNodeArray[n2] = simpleNode2.getChild(1);
                } else {
                    stringArray[n2] = (String)simpleNode2.getInfo();
                    simpleNodeArray[n2] = simpleNode2;
                }
                ++n2;
            }
            CodeCompiler.makeStrings(this.code, stringArray, stringArray.length);
            this.loadFrame();
            if (this.mrefs.importFrom == 0) {
                this.mrefs.importFrom = this.code.pool.Methodref("org/python/core/imp", "importFrom", "(Ljava/lang/String;[Ljava/lang/String;Lorg/python/core/PyFrame;)[Lorg/python/core/PyObject;");
            }
            this.code.invokestatic(this.mrefs.importFrom);
            n2 = this.storeTop();
            int n3 = 0;
            while (n3 < n - 1) {
                this.code.aload(n2);
                this.code.iconst(n3);
                this.code.aaload();
                this.set(simpleNodeArray[n3]);
                ++n3;
            }
            this.code.freeLocal(n2);
        } else {
            this.loadFrame();
            if (this.mrefs.importAll == 0) {
                this.mrefs.importAll = this.code.pool.Methodref("org/python/core/imp", "importAll", "(Ljava/lang/String;Lorg/python/core/PyFrame;)V");
            }
            this.code.invokestatic(this.mrefs.importAll);
        }
        return null;
    }

    public Object dotted_name(SimpleNode simpleNode) throws Exception {
        int n = simpleNode.getNumChildren();
        String string = (String)simpleNode.getChild(0).getInfo();
        int n2 = 1;
        while (n2 < n) {
            string = string + "." + (String)simpleNode.getChild(n2).getInfo();
            ++n2;
        }
        return string;
    }

    public Object global_stmt(SimpleNode simpleNode) throws Exception {
        return null;
    }

    public Object exec_stmt(SimpleNode simpleNode) throws Exception {
        this.setline(simpleNode);
        simpleNode.getChild(0).visit(this);
        if (simpleNode.getNumChildren() > 1) {
            simpleNode.getChild(1).visit(this);
        } else {
            this.code.aconst_null();
        }
        if (simpleNode.getNumChildren() > 2) {
            simpleNode.getChild(2).visit(this);
        } else {
            this.code.aconst_null();
        }
        if (this.mrefs.exec == 0) {
            this.mrefs.exec = this.code.pool.Methodref("org/python/core/Py", "exec", "(Lorg/python/core/PyObject;Lorg/python/core/PyObject;Lorg/python/core/PyObject;)V");
        }
        this.code.invokestatic(this.mrefs.exec);
        return null;
    }

    public Object assert_stmt(SimpleNode simpleNode) throws Exception {
        this.setline(simpleNode);
        Label label = this.code.getLabel();
        this.loadFrame();
        this.emitGetGlobal("__debug__");
        if (this.mrefs.nonzero == 0) {
            this.mrefs.nonzero = this.code.pool.Methodref("org/python/core/PyObject", "__nonzero__", "()Z");
        }
        this.code.invokevirtual(this.mrefs.nonzero);
        this.code.ifeq(label);
        simpleNode.getChild(0).visit(this);
        if (simpleNode.getNumChildren() == 2) {
            simpleNode.getChild(1).visit(this);
            if (this.mrefs.assert2 == 0) {
                this.mrefs.assert2 = this.code.pool.Methodref("org/python/core/Py", "assert", "(Lorg/python/core/PyObject;Lorg/python/core/PyObject;)V");
            }
            this.code.invokestatic(this.mrefs.assert2);
        } else {
            if (this.mrefs.assert1 == 0) {
                this.mrefs.assert1 = this.code.pool.Methodref("org/python/core/Py", "assert", "(Lorg/python/core/PyObject;)V");
            }
            this.code.invokestatic(this.mrefs.assert1);
        }
        label.setPosition();
        return null;
    }

    public Object doTest(Label label, SimpleNode simpleNode, int n) throws Exception {
        SimpleNode simpleNode2 = simpleNode.getChild(n);
        SimpleNode simpleNode3 = simpleNode.getChild(n + 1);
        Label label2 = this.code.getLabel();
        this.setline(simpleNode2);
        simpleNode2.visit(this);
        if (this.mrefs.nonzero == 0) {
            this.mrefs.nonzero = this.code.pool.Methodref("org/python/core/PyObject", "__nonzero__", "()Z");
        }
        this.code.invokevirtual(this.mrefs.nonzero);
        this.code.ifeq(label2);
        Object object = simpleNode3.visit(this);
        if (label != null && object == null) {
            this.code.goto_(label);
        }
        label2.setPosition();
        int n2 = simpleNode.getNumChildren() - n - 2;
        if (n2 > 1) {
            return this.doTest(label, simpleNode, n + 2) != null ? object : null;
        }
        if (n2 == 1) {
            return simpleNode.getChild(n + 2).visit(this) != null ? object : null;
        }
        return null;
    }

    public Object if_stmt(SimpleNode simpleNode) throws Exception {
        int n = simpleNode.getNumChildren();
        Label label = null;
        if (n > 2) {
            label = this.code.getLabel();
        }
        Object object = this.doTest(label, simpleNode, 0);
        if (label != null) {
            label.setPosition();
        }
        return object;
    }

    public void beginLoop() {
        this.continueLabels.push(this.code.getLabel());
        this.breakLabels.push(this.code.getLabel());
    }

    public void finishLoop() {
        this.continueLabels.pop();
        this.breakLabels.pop();
    }

    public Object while_stmt(SimpleNode simpleNode) throws Exception {
        this.beginLoop();
        Label label = (Label)this.continueLabels.peek();
        Label label2 = (Label)this.breakLabels.peek();
        Label label3 = this.code.getLabel();
        this.code.goto_(label);
        label3.setPosition();
        simpleNode.getChild(1).visit(this);
        label.setPosition();
        this.setline(simpleNode);
        simpleNode.getChild(0).visit(this);
        if (this.mrefs.nonzero == 0) {
            this.mrefs.nonzero = this.code.pool.Methodref("org/python/core/PyObject", "__nonzero__", "()Z");
        }
        this.code.invokevirtual(this.mrefs.nonzero);
        this.code.ifne(label3);
        this.finishLoop();
        if (simpleNode.getNumChildren() == 3) {
            simpleNode.getChild(2).visit(this);
        }
        label2.setPosition();
        return null;
    }

    public Object for_stmt(SimpleNode simpleNode) throws Exception {
        this.beginLoop();
        Label label = (Label)this.continueLabels.peek();
        Label label2 = (Label)this.breakLabels.peek();
        Label label3 = this.code.getLabel();
        Label label4 = this.code.getLabel();
        int n = this.code.getLocal();
        int n2 = this.code.getLocal();
        int n3 = this.code.getLocal();
        this.setline(simpleNode);
        simpleNode.getChild(1).visit(this);
        this.code.astore(n);
        this.code.iconst(0);
        this.code.istore(n2);
        this.code.goto_(label4);
        label3.setPosition();
        this.set(simpleNode.getChild(0), n3);
        simpleNode.getChild(2).visit(this);
        label.setPosition();
        this.code.iinc(n2, 1);
        label4.setPosition();
        this.setline(simpleNode);
        this.code.aload(n);
        this.code.iload(n2);
        if (this.mrefs.safe_getitem == 0) {
            this.mrefs.safe_getitem = this.code.pool.Methodref("org/python/core/PyObject", "__finditem__", "(I)Lorg/python/core/PyObject;");
        }
        this.code.invokevirtual(this.mrefs.safe_getitem);
        this.code.astore(n3);
        this.code.aload(n3);
        this.code.ifnonnull(label3);
        this.finishLoop();
        if (simpleNode.getNumChildren() > 3) {
            simpleNode.getChild(3).visit(this);
        }
        label2.setPosition();
        this.code.freeLocal(n);
        this.code.freeLocal(n2);
        this.code.freeLocal(n3);
        return null;
    }

    public void exceptionTest(int n, Label label, SimpleNode simpleNode, int n2) throws Exception {
        SimpleNode simpleNode2 = simpleNode.getChild(n2);
        SimpleNode simpleNode3 = simpleNode.getChild(n2 + 1);
        this.setline(simpleNode2);
        Label label2 = this.code.getLabel();
        if (simpleNode2.getNumChildren() > 0) {
            this.code.aload(n);
            simpleNode2.getChild(0).visit(this);
            if (this.mrefs.match_exception == 0) {
                this.mrefs.match_exception = this.code.pool.Methodref("org/python/core/Py", "matchException", "(Lorg/python/core/PyException;Lorg/python/core/PyObject;)Z");
            }
            this.code.invokestatic(this.mrefs.match_exception);
            this.code.ifeq(label2);
        } else if (simpleNode.getNumChildren() > n2 + 3) {
            throw new ParseException("bare except must be last except clause", simpleNode2);
        }
        if (simpleNode2.getNumChildren() > 1) {
            this.code.aload(n);
            this.code.getfield(this.code.pool.Fieldref("org/python/core/PyException", "value", "Lorg/python/core/PyObject;"));
            this.set(simpleNode2.getChild(1));
        }
        simpleNode3.visit(this);
        this.code.goto_(label);
        label2.setPosition();
        if (simpleNode.getNumChildren() > n2 + 3) {
            this.exceptionTest(n, label, simpleNode, n2 + 2);
        } else {
            this.code.aload(n);
            this.code.athrow();
        }
    }

    public Object tryFinally(SimpleNode simpleNode, SimpleNode simpleNode2) throws Exception {
        Label label = this.code.getLabel();
        Label label2 = this.code.getLabel();
        Label label3 = this.code.getLabel();
        Label label4 = this.code.getLabel();
        Label label5 = this.code.getLabel();
        Label label6 = this.code.getLabel();
        this.continueLabels.push(DoFinally);
        this.breakLabels.push(DoFinally);
        this.finallyLabels.push(label4);
        label.setPosition();
        Object object = simpleNode.visit(this);
        label2.setPosition();
        if (object == null) {
            this.code.jsr(label4);
            this.code.goto_(label5);
        }
        this.continueLabels.pop();
        this.breakLabels.pop();
        this.finallyLabels.pop();
        label3.setPosition();
        this.code.stack = 1;
        int n = this.code.getLocal();
        this.code.astore(n);
        this.code.aload(n);
        this.loadFrame();
        if (this.mrefs.add_traceback == 0) {
            this.mrefs.add_traceback = this.code.pool.Methodref("org/python/core/Py", "addTraceback", "(Ljava/lang/Throwable;Lorg/python/core/PyFrame;)V");
        }
        this.code.invokestatic(this.mrefs.add_traceback);
        this.code.jsr(label4);
        this.code.aload(n);
        this.code.athrow();
        label4.setPosition();
        this.code.stack = 1;
        int n2 = this.code.getLocal();
        this.code.astore(n2);
        this.code.iconst(1);
        this.code.ifeq(label6);
        object = simpleNode2.visit(this);
        label6.setPosition();
        this.code.ret(n2);
        label5.setPosition();
        this.code.freeLocal(n2);
        this.code.freeLocal(n);
        this.code.addExceptionHandler(label, label2, label3, this.code.pool.Class("java/lang/Throwable"));
        return null;
    }

    public Object try_stmt(SimpleNode simpleNode) throws Exception {
        int n = simpleNode.getNumChildren();
        if (n == 2) {
            return this.tryFinally(simpleNode.getChild(0), simpleNode.getChild(1));
        }
        Label label = this.code.getLabel();
        Label label2 = this.code.getLabel();
        Label label3 = this.code.getLabel();
        Label label4 = this.code.getLabel();
        label.setPosition();
        simpleNode.getChild(0).visit(this);
        label2.setPosition();
        this.code.goto_(label4);
        label3.setPosition();
        this.code.stack = 1;
        this.loadFrame();
        if (this.mrefs.set_exception == 0) {
            this.mrefs.set_exception = this.code.pool.Methodref("org/python/core/Py", "setException", "(Ljava/lang/Throwable;Lorg/python/core/PyFrame;)Lorg/python/core/PyException;");
        }
        this.code.invokestatic(this.mrefs.set_exception);
        int n2 = this.storeTop();
        if (n % 2 != 0) {
            this.exceptionTest(n2, label4, simpleNode, 1);
            label4.setPosition();
        } else {
            Label label5 = this.code.getLabel();
            this.exceptionTest(n2, label5, simpleNode, 1);
            label4.setPosition();
            simpleNode.getChild(n - 1).visit(this);
            label5.setPosition();
        }
        this.code.freeLocal(n2);
        this.code.addExceptionHandler(label, label2, label3, this.code.pool.Class("java/lang/Throwable"));
        return null;
    }

    public Object except_clause(SimpleNode simpleNode) throws Exception {
        throw new ParseException("Unhandled Node: " + simpleNode, simpleNode);
    }

    public Object suite(SimpleNode simpleNode) throws Exception {
        int n = simpleNode.getNumChildren();
        int n2 = 0;
        while (n2 < n) {
            Object object = simpleNode.getChild(n2).visit(this);
            if (object != null) {
                return Exit;
            }
            ++n2;
        }
        return null;
    }

    public Object or_boolean(SimpleNode simpleNode) throws Exception {
        Label label = this.code.getLabel();
        simpleNode.getChild(0).visit(this);
        this.code.dup();
        if (this.mrefs.nonzero == 0) {
            this.mrefs.nonzero = this.code.pool.Methodref("org/python/core/PyObject", "__nonzero__", "()Z");
        }
        this.code.invokevirtual(this.mrefs.nonzero);
        this.code.ifne(label);
        this.code.pop();
        simpleNode.getChild(1).visit(this);
        label.setPosition();
        return null;
    }

    public Object and_boolean(SimpleNode simpleNode) throws Exception {
        Label label = this.code.getLabel();
        simpleNode.getChild(0).visit(this);
        this.code.dup();
        if (this.mrefs.nonzero == 0) {
            this.mrefs.nonzero = this.code.pool.Methodref("org/python/core/PyObject", "__nonzero__", "()Z");
        }
        this.code.invokevirtual(this.mrefs.nonzero);
        this.code.ifeq(label);
        this.code.pop();
        simpleNode.getChild(1).visit(this);
        label.setPosition();
        return null;
    }

    public Object not_1op(SimpleNode simpleNode) throws Exception {
        return this.unaryop(simpleNode, "__not__");
    }

    public Object comparision(SimpleNode simpleNode) throws Exception {
        int n = simpleNode.getNumChildren();
        int n2 = this.code.getLocal();
        int n3 = this.code.getLocal();
        if (this.mrefs.nonzero == 0) {
            this.mrefs.nonzero = this.code.pool.Methodref("org/python/core/PyObject", "__nonzero__", "()Z");
        }
        Label label = this.code.getLabel();
        simpleNode.getChild(0).visit(this);
        int n4 = 1;
        while (n4 < n - 2) {
            simpleNode.getChild(n4 + 1).visit(this);
            this.code.dup();
            this.code.astore(n2);
            this.code.invokevirtual((Integer)simpleNode.getChild(n4).visit(this));
            this.code.dup();
            this.code.astore(n3);
            this.code.invokevirtual(this.mrefs.nonzero);
            this.code.ifeq(label);
            this.code.aload(n2);
            n4 += 2;
        }
        simpleNode.getChild(n - 1).visit(this);
        this.code.invokevirtual((Integer)simpleNode.getChild(n - 2).visit(this));
        if (n > 3) {
            this.code.astore(n3);
            label.setPosition();
            this.code.aload(n3);
        }
        this.code.freeLocal(n2);
        this.code.freeLocal(n3);
        return null;
    }

    public int make_binop(String string) throws Exception {
        return this.code.pool.Methodref("org/python/core/PyObject", string, "(Lorg/python/core/PyObject;)Lorg/python/core/PyObject;");
    }

    public Object less_cmp(SimpleNode simpleNode) throws Exception {
        if (this.mrefs.less == null) {
            this.less = new Integer(this.make_binop("_lt"));
        }
        return this.mrefs.less;
    }

    public Object greater_cmp(SimpleNode simpleNode) throws Exception {
        if (this.mrefs.greater == null) {
            this.greater = new Integer(this.make_binop("_gt"));
        }
        return this.mrefs.greater;
    }

    public Object equal_cmp(SimpleNode simpleNode) throws Exception {
        if (this.mrefs.equal == null) {
            this.equal = new Integer(this.make_binop("_eq"));
        }
        return this.mrefs.equal;
    }

    public Object less_equal_cmp(SimpleNode simpleNode) throws Exception {
        if (this.mrefs.less_equal == null) {
            this.less_equal = new Integer(this.make_binop("_le"));
        }
        return this.mrefs.less_equal;
    }

    public Object greater_equal_cmp(SimpleNode simpleNode) throws Exception {
        if (this.mrefs.greater_equal == null) {
            this.greater_equal = new Integer(this.make_binop("_ge"));
        }
        return this.mrefs.greater_equal;
    }

    public Object notequal_cmp(SimpleNode simpleNode) throws Exception {
        if (this.mrefs.notequal == null) {
            this.notequal = new Integer(this.make_binop("_ne"));
        }
        return this.mrefs.notequal;
    }

    public Object in_cmp(SimpleNode simpleNode) throws Exception {
        if (this.mrefs.in == null) {
            this.in = new Integer(this.make_binop("_in"));
        }
        return this.mrefs.in;
    }

    public Object not_in_cmp(SimpleNode simpleNode) throws Exception {
        if (this.mrefs.not_in == null) {
            this.not_in = new Integer(this.make_binop("_notin"));
        }
        return this.mrefs.not_in;
    }

    public Object is_cmp(SimpleNode simpleNode) throws Exception {
        if (this.mrefs.is == null) {
            this.is = new Integer(this.make_binop("_is"));
        }
        return this.mrefs.is;
    }

    public Object is_not_cmp(SimpleNode simpleNode) throws Exception {
        if (this.mrefs.is_not == null) {
            this.is_not = new Integer(this.make_binop("_isnot"));
        }
        return this.mrefs.is_not;
    }

    public Object binaryop(SimpleNode simpleNode, String string) throws Exception {
        simpleNode.getChild(0).visit(this);
        simpleNode.getChild(1).visit(this);
        this.code.invokevirtual("org/python/core/PyObject", string, "(Lorg/python/core/PyObject;)Lorg/python/core/PyObject;");
        return null;
    }

    public Object unaryop(SimpleNode simpleNode, String string) throws Exception {
        simpleNode.getChild(0).visit(this);
        this.code.invokevirtual("org/python/core/PyObject", string, "()Lorg/python/core/PyObject;");
        return null;
    }

    public Object or_2op(SimpleNode simpleNode) throws Exception {
        return this.binaryop(simpleNode, "_or");
    }

    public Object xor_2op(SimpleNode simpleNode) throws Exception {
        return this.binaryop(simpleNode, "_xor");
    }

    public Object and_2op(SimpleNode simpleNode) throws Exception {
        return this.binaryop(simpleNode, "_and");
    }

    public Object lshift_2op(SimpleNode simpleNode) throws Exception {
        return this.binaryop(simpleNode, "_lshift");
    }

    public Object rshift_2op(SimpleNode simpleNode) throws Exception {
        return this.binaryop(simpleNode, "_rshift");
    }

    public Object add_2op(SimpleNode simpleNode) throws Exception {
        return this.binaryop(simpleNode, "_add");
    }

    public Object strjoin(SimpleNode simpleNode) throws Exception {
        return this.binaryop(simpleNode, "__add__");
    }

    public Object sub_2op(SimpleNode simpleNode) throws Exception {
        return this.binaryop(simpleNode, "_sub");
    }

    public Object mul_2op(SimpleNode simpleNode) throws Exception {
        return this.binaryop(simpleNode, "_mul");
    }

    public Object div_2op(SimpleNode simpleNode) throws Exception {
        return this.binaryop(simpleNode, "_div");
    }

    public Object mod_2op(SimpleNode simpleNode) throws Exception {
        return this.binaryop(simpleNode, "_mod");
    }

    public Object pos_1op(SimpleNode simpleNode) throws Exception {
        return this.unaryop(simpleNode, "__pos__");
    }

    public Object neg_1op(SimpleNode simpleNode) throws Exception {
        return this.unaryop(simpleNode, "__neg__");
    }

    public Object invert_1op(SimpleNode simpleNode) throws Exception {
        return this.unaryop(simpleNode, "__invert__");
    }

    public Object pow_2op(SimpleNode simpleNode) throws Exception {
        return this.binaryop(simpleNode, "_pow");
    }

    public Object aug_binaryop(SimpleNode simpleNode, String string) throws Exception {
        simpleNode.getChild(1).visit(this);
        int n = this.storeTop();
        this.mode = 3;
        simpleNode.getChild(0).visit(this);
        this.code.aload(n);
        this.code.invokevirtual("org/python/core/PyObject", string, "(Lorg/python/core/PyObject;)Lorg/python/core/PyObject;");
        this.code.freeLocal(n);
        this.temporary = this.storeTop();
        this.mode = 4;
        simpleNode.getChild(0).visit(this);
        this.mode = 0;
        return null;
    }

    public Object aug_plus(SimpleNode simpleNode) throws Exception {
        return this.aug_binaryop(simpleNode, "__iadd__");
    }

    public Object aug_minus(SimpleNode simpleNode) throws Exception {
        return this.aug_binaryop(simpleNode, "__isub__");
    }

    public Object aug_multiply(SimpleNode simpleNode) throws Exception {
        return this.aug_binaryop(simpleNode, "__imul__");
    }

    public Object aug_divide(SimpleNode simpleNode) throws Exception {
        return this.aug_binaryop(simpleNode, "__idiv__");
    }

    public Object aug_modulo(SimpleNode simpleNode) throws Exception {
        return this.aug_binaryop(simpleNode, "__imod__");
    }

    public Object aug_and(SimpleNode simpleNode) throws Exception {
        return this.aug_binaryop(simpleNode, "__iand__");
    }

    public Object aug_or(SimpleNode simpleNode) throws Exception {
        return this.aug_binaryop(simpleNode, "__ior__");
    }

    public Object aug_xor(SimpleNode simpleNode) throws Exception {
        return this.aug_binaryop(simpleNode, "__ixor__");
    }

    public Object aug_lshift(SimpleNode simpleNode) throws Exception {
        return this.aug_binaryop(simpleNode, "__ilshift__");
    }

    public Object aug_rshift(SimpleNode simpleNode) throws Exception {
        return this.aug_binaryop(simpleNode, "__irshift__");
    }

    public Object aug_power(SimpleNode simpleNode) throws Exception {
        return this.aug_binaryop(simpleNode, "__ipow__");
    }

    public static void makeStrings(Code code, String[] stringArray, int n) throws IOException {
        code.iconst(n);
        code.anewarray(code.pool.Class("java/lang/String"));
        int n2 = code.getLocal();
        code.astore(n2);
        int n3 = 0;
        while (n3 < n) {
            code.aload(n2);
            code.iconst(n3);
            code.ldc(stringArray[n3]);
            code.aastore();
            ++n3;
        }
        code.aload(n2);
        code.freeLocal(n2);
    }

    public Object Invoke(SimpleNode simpleNode, SimpleNode simpleNode2, SimpleNode[] simpleNodeArray) throws Exception {
        String string = this.getName(simpleNode2);
        simpleNode.visit(this);
        this.code.ldc(string);
        switch (simpleNodeArray.length) {
            case 0: {
                if (this.mrefs.invokea0 == 0) {
                    this.mrefs.invokea0 = this.code.pool.Methodref("org/python/core/PyObject", "invoke", "(Ljava/lang/String;)Lorg/python/core/PyObject;");
                }
                this.code.invokevirtual(this.mrefs.invokea0);
                break;
            }
            case 1: {
                if (this.mrefs.invokea1 == 0) {
                    this.mrefs.invokea1 = this.code.pool.Methodref("org/python/core/PyObject", "invoke", "(Ljava/lang/String;Lorg/python/core/PyObject;)Lorg/python/core/PyObject;");
                }
                simpleNodeArray[0].visit(this);
                this.code.invokevirtual(this.mrefs.invokea1);
                break;
            }
            case 2: {
                if (this.mrefs.invokea2 == 0) {
                    this.mrefs.invokea2 = this.code.pool.Methodref("org/python/core/PyObject", "invoke", "(Ljava/lang/String;Lorg/python/core/PyObject;Lorg/python/core/PyObject;)Lorg/python/core/PyObject;");
                }
                simpleNodeArray[0].visit(this);
                simpleNodeArray[1].visit(this);
                this.code.invokevirtual(this.mrefs.invokea2);
                break;
            }
            default: {
                this.makeArray(simpleNodeArray);
                if (this.mrefs.invoke2 == 0) {
                    this.mrefs.invoke2 = this.code.pool.Methodref("org/python/core/PyObject", "invoke", "(Ljava/lang/String;[Lorg/python/core/PyObject;)Lorg/python/core/PyObject;");
                }
                this.code.invokevirtual(this.mrefs.invoke2);
                break;
            }
        }
        return null;
    }

    public Object Call_Op(SimpleNode simpleNode) throws Exception {
        SimpleNode[] simpleNodeArray;
        SimpleNode simpleNode2 = simpleNode.getChild(0);
        SimpleNode simpleNode3 = null;
        if (simpleNode.getNumChildren() > 1) {
            simpleNode3 = simpleNode.getChild(1);
        }
        String[] stringArray = null;
        int n = 0;
        SimpleNode simpleNode4 = null;
        SimpleNode simpleNode5 = null;
        if (simpleNode3 != null) {
            int n2 = simpleNode3.getNumChildren();
            SimpleNode simpleNode6 = simpleNode3.getChild(n2 - 1);
            if (simpleNode6.id == 89) {
                --n2;
                simpleNode5 = simpleNode6;
            }
            if (n2 > 0) {
                simpleNode6 = simpleNode3.getChild(n2 - 1);
                if (simpleNode6.id == 88) {
                    --n2;
                    simpleNode4 = simpleNode6;
                }
            }
            simpleNodeArray = new SimpleNode[n2];
            stringArray = new String[n2];
            int n3 = 0;
            while (n3 < n2) {
                SimpleNode simpleNode7 = simpleNode3.getChild(n3);
                if (simpleNode7.id != 90) {
                    simpleNodeArray[n3] = simpleNode7;
                    if (n > 0) {
                        throw new ParseException("non-keyword argument following keyword", simpleNode);
                    }
                } else {
                    simpleNodeArray[n3] = simpleNode7.getChild(1);
                    stringArray[n++] = (String)simpleNode7.getChild(0).getInfo();
                }
                ++n3;
            }
        } else {
            simpleNodeArray = new SimpleNode[]{};
        }
        if (n == 0 && simpleNode4 == null && simpleNode5 == null && simpleNode2.id == 74) {
            return this.Invoke(simpleNode2.getChild(0), simpleNode2.getChild(1), simpleNodeArray);
        }
        simpleNode2.visit(this);
        if (simpleNode4 != null || simpleNode5 != null) {
            this.makeArray(simpleNodeArray);
            CodeCompiler.makeStrings(this.code, stringArray, n);
            if (simpleNode4 == null) {
                this.code.aconst_null();
            } else {
                simpleNode4.getChild(0).visit(this);
            }
            if (simpleNode5 == null) {
                this.code.aconst_null();
            } else {
                simpleNode5.getChild(0).visit(this);
            }
            if (this.mrefs.callextra == 0) {
                this.mrefs.callextra = this.code.pool.Methodref("org/python/core/PyObject", "_callextra", "([Lorg/python/core/PyObject;[Ljava/lang/String;Lorg/python/core/PyObject;Lorg/python/core/PyObject;)Lorg/python/core/PyObject;");
            }
            this.code.invokevirtual(this.mrefs.callextra);
        } else if (n > 0) {
            this.makeArray(simpleNodeArray);
            CodeCompiler.makeStrings(this.code, stringArray, n);
            if (this.mrefs.call1 == 0) {
                this.mrefs.call1 = this.code.pool.Methodref("org/python/core/PyObject", "__call__", "([Lorg/python/core/PyObject;[Ljava/lang/String;)Lorg/python/core/PyObject;");
            }
            this.code.invokevirtual(this.mrefs.call1);
        } else {
            switch (simpleNodeArray.length) {
                case 0: {
                    if (this.mrefs.calla0 == 0) {
                        this.mrefs.calla0 = this.code.pool.Methodref("org/python/core/PyObject", "__call__", "()Lorg/python/core/PyObject;");
                    }
                    this.code.invokevirtual(this.mrefs.calla0);
                    break;
                }
                case 1: {
                    if (this.mrefs.calla1 == 0) {
                        this.mrefs.calla1 = this.code.pool.Methodref("org/python/core/PyObject", "__call__", "(Lorg/python/core/PyObject;)Lorg/python/core/PyObject;");
                    }
                    simpleNodeArray[0].visit(this);
                    this.code.invokevirtual(this.mrefs.calla1);
                    break;
                }
                case 2: {
                    if (this.mrefs.calla2 == 0) {
                        this.mrefs.calla2 = this.code.pool.Methodref("org/python/core/PyObject", "__call__", "(Lorg/python/core/PyObject;Lorg/python/core/PyObject;)Lorg/python/core/PyObject;");
                    }
                    simpleNodeArray[0].visit(this);
                    simpleNodeArray[1].visit(this);
                    this.code.invokevirtual(this.mrefs.calla2);
                    break;
                }
                case 3: {
                    if (this.mrefs.calla3 == 0) {
                        this.mrefs.calla3 = this.code.pool.Methodref("org/python/core/PyObject", "__call__", "(Lorg/python/core/PyObject;Lorg/python/core/PyObject;Lorg/python/core/PyObject;)Lorg/python/core/PyObject;");
                    }
                    simpleNodeArray[0].visit(this);
                    simpleNodeArray[1].visit(this);
                    simpleNodeArray[2].visit(this);
                    this.code.invokevirtual(this.mrefs.calla3);
                    break;
                }
                case 4: {
                    if (this.mrefs.calla4 == 0) {
                        this.mrefs.calla4 = this.code.pool.Methodref("org/python/core/PyObject", "__call__", "(Lorg/python/core/PyObject;Lorg/python/core/PyObject;Lorg/python/core/PyObject;Lorg/python/core/PyObject;)Lorg/python/core/PyObject;");
                    }
                    simpleNodeArray[0].visit(this);
                    simpleNodeArray[1].visit(this);
                    simpleNodeArray[2].visit(this);
                    simpleNodeArray[3].visit(this);
                    this.code.invokevirtual(this.mrefs.calla4);
                    break;
                }
                default: {
                    this.makeArray(simpleNodeArray);
                    if (this.mrefs.call2 == 0) {
                        this.mrefs.call2 = this.code.pool.Methodref("org/python/core/PyObject", "__call__", "([Lorg/python/core/PyObject;)Lorg/python/core/PyObject;");
                    }
                    this.code.invokevirtual(this.mrefs.call2);
                    break;
                }
            }
        }
        return null;
    }

    public Object Slice_Op(SimpleNode simpleNode, SimpleNode simpleNode2) throws Exception {
        if (this.mode == 4) {
            this.restoreAugTmps(simpleNode2, 4);
            this.mode = 1;
        } else {
            int n = this.mode;
            this.mode = 0;
            simpleNode.visit(this);
            SimpleNode[] simpleNodeArray = new SimpleNode[3];
            int n2 = simpleNode2.getNumChildren();
            int n3 = 0;
            int n4 = 0;
            while (n4 < n2) {
                SimpleNode simpleNode3 = simpleNode2.getChild(n4);
                if (simpleNode3.id == 83) {
                    ++n3;
                } else {
                    simpleNodeArray[n3] = simpleNode3;
                }
                ++n4;
            }
            n3 = 0;
            while (n3 < 3) {
                if (simpleNodeArray[n3] == null) {
                    this.code.aconst_null();
                } else {
                    simpleNodeArray[n3].visit(this);
                }
                ++n3;
            }
            this.mode = n;
            if (this.mode == 3) {
                this.saveAugTmps(simpleNode2, 4);
                this.mode = 0;
            }
        }
        switch (this.mode) {
            case 2: {
                if (this.mrefs.delslice == 0) {
                    this.mrefs.delslice = this.code.pool.Methodref("org/python/core/PyObject", "__delslice__", "(Lorg/python/core/PyObject;Lorg/python/core/PyObject;Lorg/python/core/PyObject;)V");
                }
                this.code.invokevirtual(this.mrefs.delslice);
                return null;
            }
            case 0: {
                if (this.mrefs.getslice == 0) {
                    this.mrefs.getslice = this.code.pool.Methodref("org/python/core/PyObject", "__getslice__", "(Lorg/python/core/PyObject;Lorg/python/core/PyObject;Lorg/python/core/PyObject;)Lorg/python/core/PyObject;");
                }
                this.code.invokevirtual(this.mrefs.getslice);
                return null;
            }
            case 1: {
                this.code.aload(this.temporary);
                if (this.mrefs.setslice == 0) {
                    this.mrefs.setslice = this.code.pool.Methodref("org/python/core/PyObject", "__setslice__", "(Lorg/python/core/PyObject;Lorg/python/core/PyObject;Lorg/python/core/PyObject;Lorg/python/core/PyObject;)V");
                }
                this.code.invokevirtual(this.mrefs.setslice);
                return null;
            }
        }
        return null;
    }

    public Object Index_Op(SimpleNode simpleNode) throws Exception {
        SimpleNode simpleNode2 = simpleNode.getChild(0);
        SimpleNode simpleNode3 = simpleNode.getChild(1);
        if (simpleNode3.id == 82) {
            return this.Slice_Op(simpleNode2, simpleNode3);
        }
        if (this.mode == 4) {
            this.restoreAugTmps(simpleNode, 2);
            this.mode = 1;
        } else {
            int n = this.mode;
            this.mode = 0;
            simpleNode2.visit(this);
            simpleNode3.visit(this);
            this.mode = n;
            if (this.mode == 3) {
                this.saveAugTmps(simpleNode, 2);
                this.mode = 0;
            }
        }
        switch (this.mode) {
            case 2: {
                if (this.mrefs.delitem == 0) {
                    this.mrefs.delitem = this.code.pool.Methodref("org/python/core/PyObject", "__delitem__", "(Lorg/python/core/PyObject;)V");
                }
                this.code.invokevirtual(this.mrefs.delitem);
                return null;
            }
            case 0: {
                if (this.mrefs.getitem == 0) {
                    this.mrefs.getitem = this.code.pool.Methodref("org/python/core/PyObject", "__getitem__", "(Lorg/python/core/PyObject;)Lorg/python/core/PyObject;");
                }
                this.code.invokevirtual(this.mrefs.getitem);
                return null;
            }
            case 1: {
                this.code.aload(this.temporary);
                if (this.mrefs.setitem == 0) {
                    this.mrefs.setitem = this.code.pool.Methodref("org/python/core/PyObject", "__setitem__", "(Lorg/python/core/PyObject;Lorg/python/core/PyObject;)V");
                }
                this.code.invokevirtual(this.mrefs.setitem);
                return null;
            }
        }
        return null;
    }

    public Object Dot_Op(SimpleNode simpleNode) throws Exception {
        if (this.mode == 4) {
            this.restoreAugTmps(simpleNode, 2);
            this.mode = 1;
        } else {
            String string = this.getName(simpleNode.getChild(1));
            int n = this.mode;
            this.mode = 0;
            simpleNode.getChild(0).visit(this);
            this.mode = n;
            this.code.ldc(string);
            if (this.mode == 3) {
                this.saveAugTmps(simpleNode, 2);
                this.mode = 0;
            }
        }
        switch (this.mode) {
            case 2: {
                if (this.mrefs.delattr == 0) {
                    this.mrefs.delattr = this.code.pool.Methodref("org/python/core/PyObject", "__delattr__", "(Ljava/lang/String;)V");
                }
                this.code.invokevirtual(this.mrefs.delattr);
                return null;
            }
            case 0: {
                if (this.mrefs.getattr == 0) {
                    this.mrefs.getattr = this.code.pool.Methodref("org/python/core/PyObject", "__getattr__", "(Ljava/lang/String;)Lorg/python/core/PyObject;");
                }
                this.code.invokevirtual(this.mrefs.getattr);
                return null;
            }
            case 1: {
                this.code.aload(this.temporary);
                if (this.mrefs.setattr == 0) {
                    this.mrefs.setattr = this.code.pool.Methodref("org/python/core/PyObject", "__setattr__", "(Ljava/lang/String;Lorg/python/core/PyObject;)V");
                }
                this.code.invokevirtual(this.mrefs.setattr);
                return null;
            }
        }
        return null;
    }

    public Object seqSet(SimpleNode simpleNode) throws Exception {
        int n = simpleNode.getNumChildren();
        if (n > 0 && simpleNode.getChild((int)(n - 1)).id == 84) {
            --n;
        }
        if (this.mrefs.unpackSequence == 0) {
            this.mrefs.unpackSequence = this.code.pool.Methodref("org/python/core/Py", "unpackSequence", "(Lorg/python/core/PyObject;I)[Lorg/python/core/PyObject;");
        }
        this.code.aload(this.temporary);
        this.code.iconst(n);
        this.code.invokestatic(this.mrefs.unpackSequence);
        int n2 = this.code.getLocal();
        this.code.astore(n2);
        int n3 = 0;
        while (n3 < n) {
            this.code.aload(n2);
            this.code.iconst(n3);
            this.code.aaload();
            this.set(simpleNode.getChild(n3));
            ++n3;
        }
        this.code.freeLocal(n2);
        return null;
    }

    public Object seqDel(SimpleNode simpleNode) throws Exception {
        int n = simpleNode.getNumChildren();
        if (n > 0 && simpleNode.getChild((int)(n - 1)).id == 84) {
            --n;
        }
        int n2 = 0;
        while (n2 < n) {
            simpleNode.getChild(n2).visit(this);
            ++n2;
        }
        return null;
    }

    public Object tuple(SimpleNode simpleNode) throws Exception {
        if (this.mode == 1) {
            return this.seqSet(simpleNode);
        }
        if (this.mode == 2) {
            return this.seqDel(simpleNode);
        }
        this.code.new_(this.code.pool.Class("org/python/core/PyTuple"));
        this.code.dup();
        this.makeArray(simpleNode.children);
        if (this.mrefs.PyTuple_init == 0) {
            this.mrefs.PyTuple_init = this.code.pool.Methodref("org/python/core/PyTuple", "<init>", "([Lorg/python/core/PyObject;)V");
        }
        this.code.invokespecial(this.mrefs.PyTuple_init);
        return null;
    }

    public Object fplist(SimpleNode simpleNode) throws Exception {
        if (this.mode == 1) {
            return this.seqSet(simpleNode);
        }
        throw new ParseException("in fplist node", simpleNode);
    }

    public Object list(SimpleNode simpleNode) throws Exception {
        if (simpleNode.getNumChildren() > 1 && simpleNode.getChild((int)1).id == 40) {
            return this.list_comprehension(simpleNode);
        }
        if (this.mode == 1) {
            return this.seqSet(simpleNode);
        }
        if (this.mode == 2) {
            return this.seqDel(simpleNode);
        }
        this.code.new_(this.code.pool.Class("org/python/core/PyList"));
        this.code.dup();
        this.makeArray(simpleNode.children);
        if (this.mrefs.PyList_init == 0) {
            this.mrefs.PyList_init = this.code.pool.Methodref("org/python/core/PyList", "<init>", "([Lorg/python/core/PyObject;)V");
        }
        this.code.invokespecial(this.mrefs.PyList_init);
        return null;
    }

    public Object list_comprehension(SimpleNode simpleNode) throws Exception {
        this.code.new_(this.code.pool.Class("org/python/core/PyList"));
        this.code.dup();
        if (this.mrefs.PyList_init2 == 0) {
            this.mrefs.PyList_init2 = this.code.pool.Methodref("org/python/core/PyList", "<init>", "()V");
        }
        this.code.invokespecial(this.mrefs.PyList_init2);
        this.code.dup();
        int n = this.storeTop();
        this.code.aload(n);
        this.code.ldc("append");
        if (this.mrefs.getattr == 0) {
            this.mrefs.getattr = this.code.pool.Methodref("org/python/core/PyObject", "__getattr__", "(Ljava/lang/String;)Lorg/python/core/PyObject;");
        }
        this.code.invokevirtual(this.mrefs.getattr);
        int n2 = this.storeTop();
        this.listComprehensionExprs.push(simpleNode.getChild(0));
        this.listComprehensionAppends.push(new Integer(n2));
        simpleNode.getChild(1).visit(this);
        this.listComprehensionAppends.pop();
        this.listComprehensionExprs.pop();
        return null;
    }

    public Object list_iter(SimpleNode simpleNode) throws Exception {
        if (simpleNode.getNumChildren() == 0) {
            int n = (Integer)this.listComprehensionAppends.peek();
            SimpleNode simpleNode2 = (SimpleNode)this.listComprehensionExprs.peek();
            this.code.aload(n);
            simpleNode2.visit(this);
            if (this.mrefs.calla1 == 0) {
                this.mrefs.calla1 = this.code.pool.Methodref("org/python/core/PyObject", "__call__", "(Lorg/python/core/PyObject;)Lorg/python/core/PyObject;");
            }
            this.code.invokevirtual(this.mrefs.calla1);
            this.code.pop();
            return null;
        }
        return simpleNode.getChild(0).visit(this);
    }

    public Object dictionary(SimpleNode simpleNode) throws Exception {
        this.code.new_(this.code.pool.Class("org/python/core/PyDictionary"));
        this.code.dup();
        this.makeArray(simpleNode.children);
        if (this.mrefs.PyDictionary_init == 0) {
            this.mrefs.PyDictionary_init = this.code.pool.Methodref("org/python/core/PyDictionary", "<init>", "([Lorg/python/core/PyObject;)V");
        }
        this.code.invokespecial(this.mrefs.PyDictionary_init);
        return null;
    }

    public Object str_1op(SimpleNode simpleNode) throws Exception {
        simpleNode.getChild(0).visit(this);
        this.code.invokevirtual("org/python/core/PyObject", "__repr__", "()Lorg/python/core/PyString;");
        return null;
    }

    public Object lambdef(SimpleNode simpleNode) throws Exception {
        String string = "<lambda>";
        SimpleNode simpleNode2 = simpleNode.getNumChildren() == 2 ? simpleNode.getChild(1) : simpleNode.getChild(0);
        SimpleNode simpleNode3 = new SimpleNode(28);
        simpleNode3.jjtAddChild(simpleNode2, 0);
        this.setline(simpleNode);
        this.code.new_(this.code.pool.Class("org/python/core/PyFunction"));
        this.code.dup();
        this.loadFrame();
        if (this.mrefs.f_globals == 0) {
            this.mrefs.f_globals = this.code.pool.Fieldref("org/python/core/PyFrame", "f_globals", "Lorg/python/core/PyObject;");
        }
        this.code.getfield(this.mrefs.f_globals);
        this.makeArray(simpleNode.scope.ac.getDefaults());
        simpleNode.scope.setup_closure(this.my_scope);
        simpleNode.scope.dump();
        this.module.PyCode(simpleNode3, string, true, this.className, false, false, simpleNode.beginLine, simpleNode.scope).get(this.code);
        Vector vector = simpleNode.scope.freevars;
        simpleNode.scope = null;
        if (!this.makeClosure(vector)) {
            if (this.mrefs.PyFunction_init1 == 0) {
                this.mrefs.PyFunction_init1 = this.code.pool.Methodref("org/python/core/PyFunction", "<init>", "(Lorg/python/core/PyObject;[Lorg/python/core/PyObject;Lorg/python/core/PyCode;)V");
            }
            this.code.invokespecial(this.mrefs.PyFunction_init1);
        } else {
            if (this.mrefs.PyFunction_closure_init1 == 0) {
                this.mrefs.PyFunction_closure_init1 = this.code.pool.Methodref("org/python/core/PyFunction", "<init>", "(Lorg/python/core/PyObject;[Lorg/python/core/PyObject;Lorg/python/core/PyCode;[Lorg/python/core/PyObject;)V");
            }
            this.code.invokespecial(this.mrefs.PyFunction_closure_init1);
        }
        return null;
    }

    public Object Ellipses(SimpleNode simpleNode) throws Exception {
        if (this.mrefs.Ellipsis == 0) {
            this.mrefs.Ellipsis = this.code.pool.Fieldref("org/python/core/Py", "Ellipsis", "Lorg/python/core/PyObject;");
        }
        this.code.getstatic(this.mrefs.Ellipsis);
        return null;
    }

    public Object Slice(SimpleNode simpleNode) throws Exception {
        SimpleNode[] simpleNodeArray = new SimpleNode[3];
        int n = simpleNode.getNumChildren();
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            SimpleNode simpleNode2 = simpleNode.getChild(n3);
            if (simpleNode2.id == 83) {
                ++n2;
            } else {
                simpleNodeArray[n2] = simpleNode2;
            }
            ++n3;
        }
        this.code.new_(this.code.pool.Class("org/python/core/PySlice"));
        this.code.dup();
        n2 = 0;
        while (n2 < 3) {
            if (simpleNodeArray[n2] == null) {
                this.getNone();
            } else {
                simpleNodeArray[n2].visit(this);
            }
            ++n2;
        }
        if (this.mrefs.PySlice_init == 0) {
            this.mrefs.PySlice_init = this.code.pool.Methodref("org/python/core/PySlice", "<init>", "(Lorg/python/core/PyObject;Lorg/python/core/PyObject;Lorg/python/core/PyObject;)V");
        }
        this.code.invokespecial(this.mrefs.PySlice_init);
        return null;
    }

    public Object classdef(SimpleNode simpleNode) throws Exception {
        this.setline(simpleNode);
        String string = this.getName(simpleNode.getChild(0));
        this.code.ldc(string);
        int n = simpleNode.getNumChildren();
        SimpleNode[] simpleNodeArray = new SimpleNode[n - 2];
        int n2 = 0;
        while (n2 < n - 2) {
            simpleNodeArray[n2] = simpleNode.getChild(n2 + 1);
            ++n2;
        }
        this.makeArray(simpleNodeArray);
        simpleNode.scope.setup_closure(this.my_scope);
        simpleNode.scope.dump();
        this.module.PyCode(simpleNode.getChild(n - 1), string, false, string, true, false, simpleNode.beginLine, simpleNode.scope).get(this.code);
        Vector vector = simpleNode.scope.freevars;
        simpleNode.scope = null;
        this.getDocString(simpleNode.getChild(n - 1));
        if (!this.makeClosure(vector)) {
            if (this.mrefs.makeClass == 0) {
                this.mrefs.makeClass = this.code.pool.Methodref("org/python/core/Py", "makeClass", "(Ljava/lang/String;[Lorg/python/core/PyObject;Lorg/python/core/PyCode;Lorg/python/core/PyObject;)Lorg/python/core/PyObject;");
            }
            this.code.invokestatic(this.mrefs.makeClass);
        } else {
            if (this.mrefs.makeClass_closure == 0) {
                this.mrefs.makeClass_closure = this.code.pool.Methodref("org/python/core/Py", "makeClass", "(Ljava/lang/String;[Lorg/python/core/PyObject;Lorg/python/core/PyCode;Lorg/python/core/PyObject;[Lorg/python/core/PyObject;)Lorg/python/core/PyObject;");
            }
            this.code.invokestatic(this.mrefs.makeClass_closure);
        }
        this.set(simpleNode.getChild(0));
        return null;
    }

    public Object Int(SimpleNode simpleNode) throws Exception {
        Object object = simpleNode.getInfo();
        if (object instanceof Integer) {
            int n = (Integer)object;
            this.module.PyInteger(n).get(this.code);
        } else {
            this.module.PyLong((String)object).get(this.code);
        }
        return null;
    }

    public Object Float(SimpleNode simpleNode) throws Exception {
        this.module.PyFloat((Double)simpleNode.getInfo()).get(this.code);
        return null;
    }

    public Object Complex(SimpleNode simpleNode) throws Exception {
        this.module.PyComplex((Double)simpleNode.getInfo()).get(this.code);
        return null;
    }

    private String getName(SimpleNode simpleNode) {
        String string = (String)simpleNode.getInfo();
        if (this.className != null && string.startsWith("__") && !string.endsWith("__")) {
            return "_" + this.className + string;
        }
        return string;
    }

    void emitGetGlobal(String string) throws Exception {
        this.code.ldc(string);
        if (this.mrefs.getglobal == 0) {
            this.mrefs.getglobal = this.code.pool.Methodref("org/python/core/PyFrame", "getglobal", "(Ljava/lang/String;)Lorg/python/core/PyObject;");
        }
        this.code.invokevirtual(this.mrefs.getglobal);
    }

    public Object Name(SimpleNode simpleNode) throws Exception {
        String string = this.fast_locals ? (String)simpleNode.getInfo() : this.getName(simpleNode);
        if (this.mode == 3) {
            this.mode = 0;
        } else if (this.mode == 4) {
            this.mode = 1;
        }
        SymInfo symInfo = (SymInfo)this.tbl.get(string);
        switch (this.mode) {
            case 0: {
                this.loadFrame();
                if (symInfo != null) {
                    int n = symInfo.flags;
                    if (!this.my_scope.nested_scopes) {
                        n &= 0xFFFFFFDF;
                    }
                    if ((n & 0x42) != 0 || this.optimizeGlobals && (n & 0x31) == 0) {
                        this.emitGetGlobal(string);
                        return null;
                    }
                    if (this.fast_locals) {
                        if ((n & 0x10) != 0) {
                            this.code.iconst(symInfo.env_index);
                            if (this.mrefs.getderef == 0) {
                                this.mrefs.getderef = this.code.pool.Methodref("org/python/core/PyFrame", "getderef", "(I)Lorg/python/core/PyObject;");
                            }
                            this.code.invokevirtual(this.mrefs.getderef);
                            return null;
                        }
                        if ((n & 1) != 0) {
                            this.code.iconst(symInfo.locals_index);
                            if (this.mrefs.getlocal2 == 0) {
                                this.mrefs.getlocal2 = this.code.pool.Methodref("org/python/core/PyFrame", "getlocal", "(I)Lorg/python/core/PyObject;");
                            }
                            this.code.invokevirtual(this.mrefs.getlocal2);
                            return null;
                        }
                    }
                    if ((n & 0x20) != 0 && (n & 1) == 0) {
                        this.code.iconst(symInfo.env_index);
                        if (this.mrefs.getderef == 0) {
                            this.mrefs.getderef = this.code.pool.Methodref("org/python/core/PyFrame", "getderef", "(I)Lorg/python/core/PyObject;");
                        }
                        this.code.invokevirtual(this.mrefs.getderef);
                        return null;
                    }
                }
                this.code.ldc(string);
                if (this.mrefs.getlocal1 == 0) {
                    this.mrefs.getlocal1 = this.code.pool.Methodref("org/python/core/PyFrame", "getname", "(Ljava/lang/String;)Lorg/python/core/PyObject;");
                }
                this.code.invokevirtual(this.mrefs.getlocal1);
                return null;
            }
            case 1: {
                this.loadFrame();
                if (symInfo != null && (symInfo.flags & 0x42) != 0) {
                    this.code.ldc(string);
                    this.code.aload(this.temporary);
                    if (this.mrefs.setglobal == 0) {
                        this.mrefs.setglobal = this.code.pool.Methodref("org/python/core/PyFrame", "setglobal", "(Ljava/lang/String;Lorg/python/core/PyObject;)V");
                    }
                    this.code.invokevirtual(this.mrefs.setglobal);
                } else if (!this.fast_locals) {
                    this.code.ldc(string);
                    this.code.aload(this.temporary);
                    if (this.mrefs.setlocal1 == 0) {
                        this.mrefs.setlocal1 = this.code.pool.Methodref("org/python/core/PyFrame", "setlocal", "(Ljava/lang/String;Lorg/python/core/PyObject;)V");
                    }
                    this.code.invokevirtual(this.mrefs.setlocal1);
                } else {
                    if (symInfo == null) {
                        System.err.println("internal compiler error: " + simpleNode);
                    }
                    if ((symInfo.flags & 0x10) != 0) {
                        this.code.iconst(symInfo.env_index);
                        this.code.aload(this.temporary);
                        if (this.mrefs.setderef == 0) {
                            this.mrefs.setderef = this.code.pool.Methodref("org/python/core/PyFrame", "setderef", "(ILorg/python/core/PyObject;)V");
                        }
                        this.code.invokevirtual(this.mrefs.setderef);
                    } else {
                        this.code.iconst(symInfo.locals_index);
                        this.code.aload(this.temporary);
                        if (this.mrefs.setlocal2 == 0) {
                            this.mrefs.setlocal2 = this.code.pool.Methodref("org/python/core/PyFrame", "setlocal", "(ILorg/python/core/PyObject;)V");
                        }
                        this.code.invokevirtual(this.mrefs.setlocal2);
                    }
                }
                return null;
            }
            case 2: {
                this.loadFrame();
                if (symInfo != null && (symInfo.flags & 0x42) != 0) {
                    this.code.ldc(string);
                    if (this.mrefs.delglobal == 0) {
                        this.mrefs.delglobal = this.code.pool.Methodref("org/python/core/PyFrame", "delglobal", "(Ljava/lang/String;)V");
                    }
                    this.code.invokevirtual(this.mrefs.delglobal);
                } else if (!this.fast_locals) {
                    this.code.ldc(string);
                    if (this.mrefs.dellocal1 == 0) {
                        this.mrefs.dellocal1 = this.code.pool.Methodref("org/python/core/PyFrame", "dellocal", "(Ljava/lang/String;)V");
                    }
                    this.code.invokevirtual(this.mrefs.dellocal1);
                } else {
                    if (symInfo == null) {
                        System.err.println("internal compiler error: " + simpleNode);
                    }
                    if ((symInfo.flags & 0x10) != 0) {
                        this.error("can not delete variable '" + string + "' referenced in nested scope", true, simpleNode);
                    }
                    this.code.iconst(symInfo.locals_index);
                    if (this.mrefs.dellocal2 == 0) {
                        this.mrefs.dellocal2 = this.code.pool.Methodref("org/python/core/PyFrame", "dellocal", "(I)V");
                    }
                    this.code.invokevirtual(this.mrefs.dellocal2);
                }
                return null;
            }
        }
        return null;
    }

    public Object String(SimpleNode simpleNode) throws Exception {
        String string = (String)simpleNode.getInfo();
        if (string.length() > Short.MAX_VALUE) {
            throw new ParseException("string constant too large (more than 32767 characters)", simpleNode);
        }
        this.module.PyString(string).get(this.code);
        return null;
    }

    public CodeCompiler(Module module, boolean bl) {
        this.module = module;
        this.mrefs = this;
        this.pool = module.classfile.pool;
        this.continueLabels = new Stack();
        this.breakLabels = new Stack();
        this.finallyLabels = new Stack();
        this.listComprehensionExprs = new Stack();
        this.listComprehensionAppends = new Stack();
        this.print_results = bl;
    }

    static {
        DoFinally = new Integer(2);
    }
}

