/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs;

import java.io.File;
import java.io.IOException;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.ProjectHelper;
import org.apache.tools.ant.Task;

public class ImportTask
extends Task {
    private String file;
    private boolean optional;

    public void setOptional(boolean optional) {
        this.optional = true;
    }

    public void setFile(String file) {
        this.file = file;
    }

    public void execute() {
        if (this.file == null) {
            throw new BuildException("import requires file attribute");
        }
        if (this.getOwningTarget() == null || !"".equals(this.getOwningTarget().getName())) {
            throw new BuildException("import only allowed as a top-level task");
        }
        ProjectHelper helper = (ProjectHelper)this.getProject().getReference("ant.projectHelper");
        Vector importStack = helper.getImportStack();
        if (importStack.size() == 0) {
            throw new BuildException("import requires support in ProjectHelper");
        }
        if (this.getLocation() == null || this.getLocation().getFileName() == null) {
            throw new BuildException("Unable to get location of import task");
        }
        File buildFile = new File(this.getLocation().getFileName());
        buildFile = new File(buildFile.getAbsolutePath());
        File buildFileParent = new File(buildFile.getParent());
        this.getProject().log("Importing file " + this.file + " from " + buildFile.getAbsolutePath(), 3);
        File importedFile = new File(this.file);
        if (!importedFile.isAbsolute()) {
            importedFile = new File(buildFileParent, this.file);
        }
        if (!importedFile.exists()) {
            String message = "Cannot find " + this.file + " imported from " + buildFile.getAbsolutePath();
            if (this.optional) {
                this.getProject().log(message, 3);
                return;
            }
            throw new BuildException(message);
        }
        if (importStack.contains(importedFile = new File(ImportTask.getPath(importedFile)))) {
            this.getProject().log("Skipped already imported file:\n   " + importedFile + "\n", 1);
            return;
        }
        helper.parse(this.getProject(), importedFile);
    }

    private static String getPath(File file) {
        try {
            return file.getCanonicalPath();
        }
        catch (IOException e) {
            return file.getAbsolutePath();
        }
    }
}

