/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.IntrospectionHelper;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.ProjectHelper;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.TypeAdapter;
import org.apache.tools.ant.util.CollectionUtils;
import org.xml.sax.AttributeList;
import org.xml.sax.helpers.AttributeListImpl;

public class RuntimeConfigurable
implements Serializable {
    private static final String ANT_TYPE = "ant-type";
    private String elementTag = null;
    private List children = null;
    private transient Object wrappedObject = null;
    private transient IntrospectionHelper.Creator creator;
    private transient AttributeList attributes;
    private List attributeNames = null;
    private Map attributeMap = null;
    private StringBuffer characters = null;
    private boolean proxyConfigured = false;
    private String polyType = null;

    public RuntimeConfigurable(Object proxy, String elementTag) {
        this.wrappedObject = proxy;
        this.elementTag = elementTag;
        this.proxyConfigured = false;
        if (proxy instanceof Task) {
            ((Task)proxy).setRuntimeConfigurableWrapper(this);
        }
    }

    public void setProxy(Object proxy) {
        this.wrappedObject = proxy;
        this.proxyConfigured = false;
    }

    void setCreator(IntrospectionHelper.Creator creator) {
        this.creator = creator;
    }

    public Object getProxy() {
        return this.wrappedObject;
    }

    public String getPolyType() {
        return this.polyType;
    }

    public void setPolyType(String polyType) {
        this.polyType = polyType;
    }

    public void setAttributes(AttributeList attributes) {
        this.attributes = new AttributeListImpl(attributes);
        int i = 0;
        while (i < attributes.getLength()) {
            this.setAttribute(attributes.getName(i), attributes.getValue(i));
            ++i;
        }
    }

    public void setAttribute(String name, String value) {
        if (name.equalsIgnoreCase(ANT_TYPE)) {
            this.polyType = value;
        } else {
            if (this.attributeNames == null) {
                this.attributeNames = new ArrayList();
                this.attributeMap = new HashMap();
            }
            this.attributeNames.add(name);
            this.attributeMap.put(name, value);
        }
    }

    public Hashtable getAttributeMap() {
        if (this.attributeMap != null) {
            return new Hashtable(this.attributeMap);
        }
        return new Hashtable(1);
    }

    public AttributeList getAttributes() {
        return this.attributes;
    }

    public void addChild(RuntimeConfigurable child) {
        if (this.children == null) {
            this.children = new ArrayList();
        }
        this.children.add(child);
    }

    RuntimeConfigurable getChild(int index) {
        return (RuntimeConfigurable)this.children.get(index);
    }

    public Enumeration getChildren() {
        if (this.children != null) {
            return Collections.enumeration(this.children);
        }
        return new CollectionUtils.EmptyEnumeration();
    }

    public void addText(String data) {
        if (data.length() == 0) {
            return;
        }
        if (this.characters != null) {
            this.characters.append(data);
        } else {
            this.characters = new StringBuffer(data);
        }
    }

    public void addText(char[] buf, int start, int count) {
        if (count == 0) {
            return;
        }
        if (this.characters == null) {
            this.characters = new StringBuffer(count);
        }
        this.characters.append(buf, start, count);
    }

    public StringBuffer getText() {
        if (this.characters != null) {
            return this.characters;
        }
        return new StringBuffer(0);
    }

    public String getElementTag() {
        return this.elementTag;
    }

    public void maybeConfigure(Project p) throws BuildException {
        this.maybeConfigure(p, true);
    }

    public void maybeConfigure(Project p, boolean configureChildren) throws BuildException {
        String id = null;
        if (this.proxyConfigured) {
            return;
        }
        Object target = this.wrappedObject instanceof TypeAdapter ? ((TypeAdapter)this.wrappedObject).getProxy() : this.wrappedObject;
        IntrospectionHelper ih = IntrospectionHelper.getHelper(p, target.getClass());
        if (this.attributeNames != null) {
            int i = 0;
            while (i < this.attributeNames.size()) {
                block10: {
                    String name = (String)this.attributeNames.get(i);
                    String value = (String)this.attributeMap.get(name);
                    value = p.replaceProperties(value);
                    try {
                        ih.setAttribute(p, target, name.toLowerCase(Locale.US), value);
                    }
                    catch (BuildException be) {
                        if (name.equals("id")) break block10;
                        throw be;
                    }
                }
                ++i;
            }
            id = (String)this.attributeMap.get("id");
        }
        if (this.characters != null) {
            ProjectHelper.addText(p, this.wrappedObject, this.characters.substring(0));
        }
        Enumeration e = this.getChildren();
        while (e.hasMoreElements()) {
            RuntimeConfigurable child = (RuntimeConfigurable)e.nextElement();
            if (child.wrappedObject instanceof Task) {
                Task childTask = (Task)child.wrappedObject;
                childTask.setRuntimeConfigurableWrapper(child);
            }
            if (child.creator != null && configureChildren) {
                child.maybeConfigure(p);
                child.creator.store();
                continue;
            }
            String tag = child.getElementTag().toLowerCase(Locale.US);
            if (!configureChildren || !ih.supportsNestedElement(tag)) continue;
            child.maybeConfigure(p);
            ProjectHelper.storeChild(p, target, child.wrappedObject, tag);
        }
        if (id != null) {
            p.addReference(id, this.wrappedObject);
        }
        this.proxyConfigured = true;
    }

    public void reconfigure(Project p) {
        this.proxyConfigured = false;
        this.maybeConfigure(p);
    }
}

