/*
 * Decompiled with CFR 0.152.
 */
package SEdit;

import SEdit.ConnectorPlacement;
import SEdit.ElementDesc;
import SEdit.Formalism;
import SEdit.Graphics.GObject;
import SEdit.ReflectorUtil;
import SEdit.SArrow;
import SEdit.SComponent;
import SEdit.SConnect;
import SEdit.SElement;
import SEdit.SNode;
import SEdit.Structure;
import SEdit.StructureAgent;
import java.io.File;
import java.io.FileWriter;
import java.io.Writer;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.apache.xerces.dom.DocumentImpl;
import org.apache.xml.serialize.OutputFormat;
import org.apache.xml.serialize.XMLSerializer;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

class XMLStructureSaver {
    protected String name = "example";
    protected Structure structure;
    protected Formalism formalism;
    protected StructureAgent master;

    public void write(File file, Structure structure, Formalism formalism) {
        try {
            this.structure = structure;
            this.formalism = formalism;
            FileWriter fileWriter = new FileWriter(file);
            OutputFormat outputFormat = new OutputFormat();
            outputFormat.setIndenting(true);
            XMLSerializer xMLSerializer = new XMLSerializer((Writer)fileWriter, outputFormat);
            xMLSerializer.startDocument();
            DocumentImpl documentImpl = new DocumentImpl();
            this.writeStructure((Document)documentImpl);
            xMLSerializer.serialize((Document)documentImpl);
            xMLSerializer.endDocument();
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
        }
    }

    public Document generateDOM(Structure structure, Formalism formalism, Vector vector) {
        try {
            this.structure = structure;
            this.formalism = formalism;
            DocumentImpl documentImpl = new DocumentImpl();
            this.writeStructure((Document)documentImpl, vector);
            return documentImpl;
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
            return null;
        }
    }

    public void writeStructure(Document document, Vector vector) {
        DocumentFragment documentFragment = document.createDocumentFragment();
        Element element = document.createElement("structure");
        documentFragment.appendChild(element);
        element.setAttribute("type", this.formalism.getName());
        element.setAttribute("name", this.name);
        if (!this.structure.getDescription().equals("")) {
            element.setAttribute("description", this.structure.getDescription());
        }
        Vector<SElement> vector2 = new Vector<SElement>();
        Vector<SElement> vector3 = new Vector<SElement>();
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            SElement sElement = (SElement)enumeration.nextElement();
            if (sElement instanceof SNode) {
                vector2.addElement(sElement);
            }
            if (!(sElement instanceof SArrow)) continue;
            vector3.addElement(sElement);
        }
        if (vector2.size() > 0) {
            element.appendChild(this.writeNodes(document, vector2));
        }
        if (vector3.size() > 0) {
            element.appendChild(this.writeArrows(document, vector3));
        }
        document.appendChild(documentFragment);
    }

    public void writeStructure(Document document) {
        DocumentFragment documentFragment = document.createDocumentFragment();
        Element element = document.createElement("structure");
        documentFragment.appendChild(element);
        element.setAttribute("type", this.formalism.getName());
        element.setAttribute("name", this.name);
        if (!this.structure.getDescription().equals("")) {
            element.setAttribute("description", this.structure.getDescription());
        }
        if (this.structure.getNodes().size() > 0) {
            element.appendChild(this.writeNodes(document, this.structure.getNodes()));
        }
        if (this.structure.getArrows().size() > 0) {
            element.appendChild(this.writeArrows(document, this.structure.getArrows()));
        }
        element.appendChild(this.writeProperties(document, this.structure, null, 0));
        document.appendChild(documentFragment);
    }

    public DocumentFragment writeProperties(Document document, Object object, ElementDesc elementDesc, int n) {
        DocumentFragment documentFragment = document.createDocumentFragment();
        Hashtable hashtable = ReflectorUtil.getProperties(object);
        if (hashtable.size() > 0) {
            Enumeration enumeration = hashtable.keys();
            while (enumeration.hasMoreElements()) {
                Element element = document.createElement("property");
                String string = (String)enumeration.nextElement();
                String string2 = (String)hashtable.get(string);
                if (string2.equals("") || string.equals("id") || string.equals("label") || elementDesc != null && elementDesc.isDefaultValue(string, string2, n)) continue;
                element.setAttribute("name", string);
                Text text = document.createTextNode(string2);
                element.appendChild(text);
                documentFragment.appendChild(element);
            }
        }
        return documentFragment;
    }

    public DocumentFragment writeGraphic(Document document, SElement sElement) {
        DocumentFragment documentFragment = document.createDocumentFragment();
        GObject gObject = sElement.getGObject();
        Element element = document.createElement("graphic");
        element.setAttribute("x", Integer.toString(gObject.getLocation().x));
        element.setAttribute("y", Integer.toString(gObject.getLocation().y));
        documentFragment.appendChild(element);
        element.appendChild(this.writeProperties(document, gObject, sElement.getDescriptor(), 2));
        return documentFragment;
    }

    public DocumentFragment writeConnector(Document document, String string, SConnect sConnect) {
        DocumentFragment documentFragment = document.createDocumentFragment();
        ConnectorPlacement connectorPlacement = sConnect.getConnectorPlacement();
        Element element = document.createElement("connector");
        element.setAttribute("ref", sConnect.getID());
        element.setAttribute("name", string);
        if (connectorPlacement.getSide() != 0) {
            switch (connectorPlacement.getSide()) {
                case 1: {
                    element.setAttribute("side", "Right");
                    break;
                }
                case 2: {
                    element.setAttribute("side", "Left");
                    break;
                }
                case 3: {
                    element.setAttribute("side", "Top");
                    break;
                }
                case 4: {
                    element.setAttribute("side", "Bottom");
                }
            }
        }
        if (connectorPlacement.getRatio() != -1.0) {
            element.setAttribute("ratio", Double.toString(connectorPlacement.getRatio()));
        }
        documentFragment.appendChild(element);
        return documentFragment;
    }

    public DocumentFragment writeNode(Document document, SNode sNode) {
        DocumentFragment documentFragment = document.createDocumentFragment();
        Element element = document.createElement("node");
        element.setAttribute("type", sNode.getDescriptor().getName());
        element.setAttribute("id", sNode.getID());
        if (sNode.getLabel() != null) {
            element.setAttribute("label", sNode.getLabel());
        }
        if (sNode instanceof SComponent) {
            SConnect sConnect;
            String string;
            SComponent sComponent = (SComponent)sNode;
            Enumeration enumeration = sComponent.getInNames();
            while (enumeration.hasMoreElements()) {
                string = (String)enumeration.nextElement();
                sConnect = sComponent.getInConnect(string);
                element.appendChild(this.writeConnector(document, string, sConnect));
            }
            enumeration = sComponent.getOutNames();
            while (enumeration.hasMoreElements()) {
                string = (String)enumeration.nextElement();
                sConnect = sComponent.getOutConnect(string);
                element.appendChild(this.writeConnector(document, string, sConnect));
            }
        }
        element.appendChild(this.writeGraphic(document, sNode));
        element.appendChild(this.writeProperties(document, sNode, sNode.getDescriptor(), 1));
        documentFragment.appendChild(element);
        return documentFragment;
    }

    public DocumentFragment writeNodes(Document document, Vector vector) {
        SNode sNode;
        DocumentFragment documentFragment = document.createDocumentFragment();
        Vector<SNode> vector2 = new Vector<SNode>();
        Element element = document.createElement("nodes");
        documentFragment.appendChild(element);
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            sNode = (SNode)enumeration.nextElement();
            if (!sNode.persistent) continue;
            if (sNode instanceof SConnect) {
                element.appendChild(this.writeNode(document, sNode));
                continue;
            }
            vector2.addElement(sNode);
        }
        enumeration = vector2.elements();
        while (enumeration.hasMoreElements()) {
            sNode = (SNode)enumeration.nextElement();
            element.appendChild(this.writeNode(document, sNode));
        }
        return documentFragment;
    }

    public DocumentFragment writeArrow(Document document, SArrow sArrow) {
        DocumentFragment documentFragment = document.createDocumentFragment();
        Element element = document.createElement("arrow");
        element.setAttribute("type", sArrow.getDescriptor().getName());
        element.setAttribute("id", sArrow.getID());
        element.setAttribute("from", sArrow.getOrigin().getID());
        element.setAttribute("to", sArrow.getTarget().getID());
        if (sArrow.getLabel() != null) {
            element.setAttribute("label", sArrow.getLabel());
        }
        element.appendChild(this.writeGraphic(document, sArrow));
        element.appendChild(this.writeProperties(document, sArrow, sArrow.getDescriptor(), 1));
        documentFragment.appendChild(element);
        return documentFragment;
    }

    public DocumentFragment writeArrows(Document document, Vector vector) {
        DocumentFragment documentFragment = document.createDocumentFragment();
        Element element = document.createElement("arrows");
        documentFragment.appendChild(element);
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            SArrow sArrow = (SArrow)enumeration.nextElement();
            if (!sArrow.persistent) continue;
            element.appendChild(this.writeArrow(document, sArrow));
        }
        return documentFragment;
    }

    public XMLStructureSaver(StructureAgent structureAgent) {
        this.master = structureAgent;
    }

    public static void main(String[] stringArray) {
    }
}

