/*
 * Decompiled with CFR 0.152.
 */
package SEdit;

import SEdit.ArrowDesc;
import SEdit.ComponentDesc;
import SEdit.ConnectorPlacement;
import SEdit.ElementDesc;
import SEdit.Formalism;
import SEdit.Namespace;
import SEdit.NodeDesc;
import SEdit.ReflectorUtil;
import SEdit.SConnect;
import SEdit.Structure;
import SEdit.StructureAgent;
import SEdit.Utils;
import java.awt.Point;
import java.util.Hashtable;
import org.apache.xerces.jaxp.DocumentBuilderFactoryImpl;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XMLStructureLoader {
    protected Structure structure;
    protected Formalism formalism;
    protected StructureAgent master;
    protected Namespace nm;
    boolean insertMode = false;

    public boolean getInsertMode() {
        return this.insertMode;
    }

    public void setInsertMode(boolean bl) {
        this.insertMode = bl;
    }

    public Structure parse(String string, Structure structure) {
        try {
            this.structure = structure;
            this.nm = new Namespace(structure);
            Document document = DocumentBuilderFactoryImpl.newInstance().newDocumentBuilder().parse(string);
            this.parseStructure(document.getDocumentElement());
            return this.structure;
        }
        catch (Exception exception) {
            System.err.println("** Error : structure parsing error in " + string);
            exception.printStackTrace(System.err);
            return null;
        }
    }

    public Structure integrate(Structure structure, Document document) {
        try {
            this.insertMode = true;
            this.structure = structure;
            this.nm = new Namespace(structure);
            this.parseStructure(document.getDocumentElement());
            return this.structure;
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
            return null;
        }
    }

    public static String parseFormalismName(String string) {
        try {
            Document document = DocumentBuilderFactoryImpl.newInstance().newDocumentBuilder().parse(string);
            return document.getDocumentElement().getAttribute("type");
        }
        catch (Exception exception) {
            System.err.println("** Error : parsing error in " + string);
            return null;
        }
    }

    void parseStructure(Element element) {
        NodeList nodeList;
        NodeList nodeList2;
        Node node;
        String string = element.getAttribute("type");
        this.formalism = this.master.getFormalism(string);
        this.structure.setFormalism(this.formalism);
        String string2 = element.getAttribute("description");
        if (!string2.equals("")) {
            this.structure.setDescription(string);
        }
        if ((node = (nodeList2 = element.getElementsByTagName("nodes")).item(0)) != null) {
            nodeList2 = node.getChildNodes();
            this.parseNodes(nodeList2);
        }
        if ((node = (nodeList2 = element.getElementsByTagName("arrows")).item(0)) != null) {
            nodeList2 = node.getChildNodes();
            this.parseArrows(nodeList2);
        }
        if ((nodeList = element.getElementsByTagName("property")).getLength() > 0) {
            try {
                ReflectorUtil.setProperties(this.structure, this.getProperties(nodeList));
            }
            catch (Exception exception) {
                Utils.debug(this, exception);
            }
        }
    }

    void addProperty(Hashtable hashtable, Element element) {
        String string = element.getAttribute("name");
        String string2 = element.getFirstChild().getNodeValue();
        hashtable.put(string, string2);
    }

    Hashtable getProperties(NodeList nodeList) {
        Hashtable hashtable = new Hashtable();
        int n = nodeList.getLength();
        for (int i = 0; i < n; ++i) {
            Element element;
            if (nodeList.item(i).getNodeType() != 1 || !(element = (Element)nodeList.item(i)).getNodeName().equals("property")) continue;
            this.addProperty(hashtable, element);
        }
        return hashtable;
    }

    void parseNodes(NodeList nodeList) {
        int n = nodeList.getLength();
        for (int i = 0; i < n; ++i) {
            if (nodeList.item(i).getNodeType() != 1) continue;
            Element element = (Element)nodeList.item(i);
            Point point = null;
            String string = element.getAttribute("type");
            String string2 = element.getAttribute("id");
            String string3 = null;
            if (element.getAttributeNode("label") != null) {
                string3 = element.getAttribute("label");
            }
            Hashtable hashtable = new Hashtable();
            Hashtable hashtable2 = new Hashtable();
            Hashtable<String, SConnect> hashtable3 = new Hashtable<String, SConnect>();
            Hashtable<String, ConnectorPlacement> hashtable4 = new Hashtable<String, ConnectorPlacement>();
            NodeList nodeList2 = element.getChildNodes();
            for (int j = 0; j < nodeList2.getLength(); ++j) {
                Object object;
                Object object2;
                if (nodeList2.item(j).getNodeType() != 1) continue;
                Element element2 = (Element)nodeList2.item(j);
                if (element2.getNodeName().equals("graphic")) {
                    point = new Point(Integer.parseInt(element2.getAttribute("x")), Integer.parseInt(element2.getAttribute("y")));
                    object2 = element2.getChildNodes();
                    for (int k = 0; k < object2.getLength(); ++k) {
                        if (object2.item(k).getNodeType() != 1 || !(object = (Element)object2.item(k)).getNodeName().equals("property")) continue;
                        this.addProperty(hashtable2, (Element)object);
                    }
                }
                if (element2.getNodeName().equals("property")) {
                    this.addProperty(hashtable, element2);
                }
                if (!element2.getNodeName().equals("connector")) continue;
                object2 = element2.getAttribute("ref");
                String string4 = element2.getAttribute("name");
                object = element2.getAttribute("side");
                String string5 = element2.getAttribute("ratio");
                int n2 = 0;
                if (((String)object).toLowerCase().equals("left")) {
                    n2 = 2;
                }
                if (((String)object).toLowerCase().equals("right")) {
                    n2 = 1;
                }
                if (((String)object).toLowerCase().equals("top")) {
                    n2 = 3;
                }
                if (((String)object).toLowerCase().equals("bottom")) {
                    n2 = 4;
                }
                double d = -1.0;
                if (string5 != null && !string5.equals("")) {
                    d = new Double(string5);
                }
                ConnectorPlacement connectorPlacement = d < 0.0 || d > 1.0 ? new ConnectorPlacement(n2) : new ConnectorPlacement(n2, d);
                SConnect sConnect = (SConnect)this.structure.getNode(this.nm.lookupID((String)object2));
                hashtable3.put(string4, sConnect);
                hashtable4.put(string4, connectorPlacement);
            }
            ElementDesc elementDesc = this.formalism.getDesc(string);
            if (elementDesc instanceof ComponentDesc) {
                this.master.newComponent(this.insertMode, (ComponentDesc)elementDesc, this.nm.putID(string2), string3, hashtable, point, hashtable2, hashtable3, hashtable4);
                continue;
            }
            if (!(elementDesc instanceof NodeDesc)) continue;
            this.master.newNode(this.insertMode, (NodeDesc)elementDesc, this.nm.putID(string2), string3, hashtable, point, hashtable2);
        }
    }

    void parseArrows(NodeList nodeList) {
        int n = nodeList.getLength();
        for (int i = 0; i < n; ++i) {
            if (nodeList.item(i).getNodeType() != 1) continue;
            Element element = (Element)nodeList.item(i);
            Point point = null;
            String string = element.getAttribute("type");
            String string2 = element.getAttribute("id");
            String string3 = null;
            if (element.getAttributeNode("label") != null) {
                string3 = element.getAttribute("label");
            }
            String string4 = element.getAttribute("to");
            String string5 = element.getAttribute("from");
            Hashtable hashtable = new Hashtable();
            Hashtable hashtable2 = new Hashtable();
            NodeList nodeList2 = element.getChildNodes();
            for (int j = 0; j < nodeList2.getLength(); ++j) {
                if (nodeList2.item(j).getNodeType() != 1) continue;
                Element element2 = (Element)nodeList2.item(j);
                if (element2.getNodeName().equals("graphic")) {
                    point = new Point(Integer.parseInt(element2.getAttribute("x")), Integer.parseInt(element2.getAttribute("y")));
                    NodeList nodeList3 = element2.getChildNodes();
                    for (int k = 0; k < nodeList3.getLength(); ++k) {
                        Element element3;
                        if (nodeList3.item(k).getNodeType() != 1 || !(element3 = (Element)nodeList3.item(k)).getNodeName().equals("property")) continue;
                        this.addProperty(hashtable2, element3);
                    }
                }
                if (!element2.getNodeName().equals("property")) continue;
                this.addProperty(hashtable, element2);
            }
            ArrowDesc arrowDesc = this.formalism.getArrowDesc(string);
            this.master.newArrow(this.insertMode, arrowDesc, this.nm.putID(string2), this.nm.lookupID(string5), this.nm.lookupID(string4), string3, hashtable, point, hashtable2);
        }
    }

    public XMLStructureLoader(StructureAgent structureAgent) {
        this.master = structureAgent;
    }

    public static void main(String[] stringArray) {
        XMLStructureLoader xMLStructureLoader = new XMLStructureLoader(null);
        System.err.println(XMLStructureLoader.parseFormalismName(stringArray[0]));
    }
}

