/*
 * Decompiled with CFR 0.152.
 */
package SEdit;

import SEdit.ActionDesc;
import SEdit.ArrowDesc;
import SEdit.ComponentDesc;
import SEdit.ConnectorDesc;
import SEdit.ConnectorPlacement;
import SEdit.Formalism;
import SEdit.NodeDesc;
import SEdit.ReflectorUtil;
import SEdit.Utils;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Vector;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.xerces.jaxp.DocumentBuilderFactoryImpl;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class XMLFormalism {
    protected Formalism formalism;

    public Formalism parse(String string) {
        try {
            Document document = DocumentBuilderFactoryImpl.newInstance().newDocumentBuilder().parse(string);
            System.out.println("Document well formed :" + string);
            this.parseFormalism(document.getDocumentElement());
            System.out.println("Document validated :" + string);
            return this.formalism;
        }
        catch (IOException iOException) {
            System.err.println("** Error : file cannot be read " + string);
        }
        catch (SAXException sAXException) {
            System.err.println("** Error : SAX error in " + string);
            System.err.println(sAXException.getMessage());
        }
        catch (ParserConfigurationException parserConfigurationException) {
            System.err.println("** Error : ParserConfiguration error in " + string);
            System.err.println(parserConfigurationException.getMessage());
        }
        catch (ArithmeticException arithmeticException) {
            System.err.println("** Error : formalism parsing error in " + string);
        }
        return null;
    }

    void parseFormalism(Element element) {
        String string;
        Hashtable hashtable = new Hashtable();
        this.formalism = new Formalism(element.getAttribute("name"));
        String string2 = element.getAttribute("description");
        if (!string2.equals("")) {
            this.formalism.setDescription(string2);
        }
        if (!(string = element.getAttribute("class")).equals("")) {
            this.formalism.setStructureClass(string);
        }
        NodeList nodeList = element.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            if (nodeList.item(i).getNodeType() != 1) continue;
            Element element2 = (Element)nodeList.item(i);
            if (element2.getNodeName().equals("formalism-info")) {
                this.parseFormalismInfo(element2);
            }
            if (element2.getNodeName().equals("connector-types")) {
                this.parseConnectors(element2.getChildNodes());
            }
            if (element2.getNodeName().equals("node-types")) {
                this.parseNodes(element2.getChildNodes());
            }
            if (element2.getNodeName().equals("arrow-types")) {
                this.parseArrows(element2.getChildNodes());
            }
            if (element2.getNodeName().equals("action")) {
                this.formalism.addActionDesc(this.parseAction(element2));
            }
            if (element2.getNodeName().equals("graphic-element")) {
                String string3 = element2.getAttribute("class");
                Hashtable hashtable2 = new Hashtable();
                NodeList nodeList2 = element2.getChildNodes();
                for (int j = 0; j < nodeList2.getLength(); ++j) {
                    Element element3;
                    if (nodeList2.item(j).getNodeType() != 1 || !(element3 = (Element)nodeList2.item(j)).getNodeName().equals("property")) continue;
                    this.addProperty(hashtable2, element3);
                }
                this.formalism.setGraphicProperties(hashtable2);
            }
            if (!element2.getNodeName().equals("property")) continue;
            this.addProperty(hashtable, element2);
            this.formalism.setProperties(hashtable);
        }
    }

    ActionDesc parseAction(Element element) {
        int n = 0;
        String string = null;
        String string2 = null;
        String string3 = element.getAttribute("description");
        NodeList nodeList = element.getElementsByTagName("icon");
        if (nodeList.getLength() > 0) {
            string = ((Element)nodeList.item(0)).getAttribute("url");
        }
        if ((nodeList = element.getElementsByTagName("java-method")).getLength() > 0) {
            string2 = ((Element)nodeList.item(0)).getAttribute("name");
            n = 1;
        } else {
            nodeList = element.getElementsByTagName("scheme-function");
            if (nodeList.getLength() > 0) {
                string2 = ((Element)nodeList.item(0)).getAttribute("name");
                n = 2;
            }
        }
        return new ActionDesc(n, string2, string3, string);
    }

    Hashtable getProperties(NodeList nodeList) {
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        int n = nodeList.getLength();
        for (int i = 0; i < n; ++i) {
            if (nodeList.item(i).getNodeType() != 1) continue;
            Element element = (Element)nodeList.item(i);
            String string = element.getAttribute("name");
            String string2 = element.getFirstChild().getNodeValue();
            hashtable.put(string, string2);
        }
        return hashtable;
    }

    void addProperty(Hashtable hashtable, Element element) {
        String string = element.getAttribute("name");
        String string2 = element.getFirstChild().getNodeValue();
        hashtable.put(string, string2);
    }

    void parseNodes(NodeList nodeList) {
        int n = nodeList.getLength();
        for (int i = 0; i < n; ++i) {
            Element element;
            int n2;
            Hashtable hashtable = new Hashtable();
            NodeDesc nodeDesc = null;
            if (nodeList.item(i).getNodeType() != 1) continue;
            Element element2 = (Element)nodeList.item(i);
            String string = element2.getAttribute("name");
            String string2 = element2.getAttribute("category");
            String string3 = element2.getAttribute("description");
            String string4 = element2.getAttribute("class");
            String string5 = null;
            NodeList nodeList2 = element2.getChildNodes();
            boolean bl = false;
            for (n2 = 0; n2 < nodeList2.getLength(); ++n2) {
                if (nodeList2.item(n2).getNodeType() != 1 || !(element = (Element)nodeList2.item(n2)).getNodeName().equals("module")) continue;
                bl = true;
            }
            nodeDesc = bl ? new ComponentDesc(string, string3, string4) : new NodeDesc(string, string3, string4);
            nodeDesc.setFormalism(this.formalism);
            for (n2 = 0; n2 < nodeList2.getLength(); ++n2) {
                Object object;
                int n3;
                Object object2;
                String string6;
                if (nodeList2.item(n2).getNodeType() != 1) continue;
                element = (Element)nodeList2.item(n2);
                if (element.getNodeName().equals("icon")) {
                    string5 = element.getAttribute("url");
                    nodeDesc.setIcon(string5);
                }
                if (element.getNodeName().equals("module")) {
                    string6 = element.getAttribute("type");
                    int n4 = 0;
                    if (string6.toLowerCase().equals("free")) {
                        n4 = 1;
                    }
                    if (string6.toLowerCase().equals("template")) {
                        n4 = 3;
                    }
                    if (string6.toLowerCase().equals("fixed")) {
                        n4 = 2;
                    }
                    object2 = element.getAttribute("layout");
                    n3 = 0;
                    if (((String)object2).toLowerCase().equals("auto")) {
                        n3 = 1;
                    }
                    if (((String)object2).toLowerCase().equals("justified")) {
                        n3 = 2;
                    }
                    if (((String)object2).toLowerCase().equals("manual")) {
                        n3 = 3;
                    }
                    ((ComponentDesc)nodeDesc).setModule(n4);
                    ((ComponentDesc)nodeDesc).setLayout(n3);
                    object = element.getChildNodes();
                    for (int j = 0; j < object.getLength(); ++j) {
                        if (object.item(j).getNodeType() != 1) continue;
                        Element element3 = (Element)object.item(j);
                        if (object.item(j).getNodeType() != 1) continue;
                        String string7 = element3.getAttribute("type");
                        String string8 = element3.getAttribute("name");
                        String string9 = element3.getAttribute("side");
                        String string10 = element3.getAttribute("ratio");
                        int n5 = 0;
                        if (string9.toLowerCase().equals("left")) {
                            n5 = 2;
                        }
                        if (string9.toLowerCase().equals("right")) {
                            n5 = 1;
                        }
                        if (string9.toLowerCase().equals("top")) {
                            n5 = 3;
                        }
                        if (string9.toLowerCase().equals("bottom")) {
                            n5 = 4;
                        }
                        double d = -1.0;
                        if (string10 != null && !string10.equals("")) {
                            d = new Double(string10);
                        }
                        ConnectorPlacement connectorPlacement = d < 0.0 || d > 1.0 ? new ConnectorPlacement(n5) : new ConnectorPlacement(n5, d);
                        ConnectorDesc connectorDesc = this.formalism.getConnectorDesc(string7);
                        ((ComponentDesc)nodeDesc).addModuleConnector(string8, connectorDesc, connectorPlacement);
                    }
                }
                if (element.getNodeName().equals("graphic-element")) {
                    string6 = element.getAttribute("class");
                    if (!string6.equals("")) {
                        nodeDesc.setGraphicClass(string6);
                    }
                    Hashtable hashtable2 = new Hashtable();
                    object2 = element.getChildNodes();
                    for (n3 = 0; n3 < object2.getLength(); ++n3) {
                        if (object2.item(n3).getNodeType() != 1 || !(object = (Element)object2.item(n3)).getNodeName().equals("property")) continue;
                        this.addProperty(hashtable2, (Element)object);
                    }
                    nodeDesc.setGraphicProperties(hashtable2);
                }
                if (element.getNodeName().equals("property")) {
                    this.addProperty(hashtable, element);
                    nodeDesc.setProperties(hashtable);
                }
                if (!element.getNodeName().equals("action")) continue;
                nodeDesc.addActionDesc(this.parseAction(element));
            }
            if (nodeDesc == null) continue;
            nodeDesc.setCategory(string2);
            this.formalism.addNodeDesc(nodeDesc);
            try {
                ReflectorUtil.setProperties(nodeDesc, hashtable);
                continue;
            }
            catch (Exception exception) {
                Utils.log("setProperties failed:" + exception);
            }
        }
    }

    void parseConnectors(NodeList nodeList) {
        int n = nodeList.getLength();
        for (int i = 0; i < n; ++i) {
            Object object;
            if (nodeList.item(i).getNodeType() != 1) continue;
            Element element = (Element)nodeList.item(i);
            String string = element.getAttribute("name");
            String string2 = element.getAttribute("description");
            String string3 = element.getAttribute("class");
            String string4 = element.getAttribute("mode");
            String string5 = element.getAttribute("category");
            String string6 = null;
            NodeList nodeList2 = element.getElementsByTagName("icon");
            if (nodeList2.getLength() > 0) {
                string6 = ((Element)nodeList2.item(0)).getAttribute("url");
            }
            ConnectorDesc connectorDesc = new ConnectorDesc(string, string2, string3, string4);
            connectorDesc.setIcon(string6);
            connectorDesc.setCategory(string5);
            this.formalism.addConnectorDesc(connectorDesc);
            NodeList nodeList3 = element.getElementsByTagName("graphic-element");
            if (nodeList3.getLength() > 0) {
                NodeList nodeList4;
                object = ((Element)nodeList3.item(0)).getAttribute("class");
                if (!((String)object).equals("")) {
                    connectorDesc.setGraphicClass((String)object);
                }
                if ((nodeList4 = ((Element)nodeList3.item(0)).getElementsByTagName("property")).getLength() > 0) {
                    connectorDesc.setGraphicProperties(this.getProperties(nodeList4));
                }
                element.removeChild(nodeList3.item(0));
            }
            if ((object = element.getElementsByTagName("property")).getLength() <= 0) continue;
            try {
                ReflectorUtil.setProperties(connectorDesc, this.getProperties((NodeList)object));
                continue;
            }
            catch (Exception exception) {
                Utils.log("setProperties failed:" + exception);
            }
        }
    }

    void parseArrows(NodeList nodeList) {
        int n = nodeList.getLength();
        for (int i = 0; i < n; ++i) {
            NodeList nodeList2;
            Object object;
            NodeList nodeList3;
            NodeDesc nodeDesc;
            if (nodeList.item(i).getNodeType() != 1) continue;
            Element element = (Element)nodeList.item(i);
            String string = element.getAttribute("name");
            String string2 = element.getAttribute("description");
            String string3 = element.getAttribute("class");
            String string4 = element.getAttribute("category");
            String string5 = null;
            String string6 = null;
            String string7 = null;
            NodeDesc nodeDesc2 = this.formalism.getNodeDesc(element.getAttribute("from"));
            if (nodeDesc2 == null) {
                nodeDesc2 = this.formalism.getConnectorDesc(element.getAttribute("from"));
            }
            if (nodeDesc2 != null) {
                string5 = nodeDesc2.getElementClass();
            }
            if ((nodeDesc = this.formalism.getNodeDesc(element.getAttribute("to"))) == null) {
                nodeDesc = this.formalism.getConnectorDesc(element.getAttribute("to"));
            }
            if (nodeDesc != null) {
                string6 = nodeDesc.getElementClass();
            }
            if ((nodeList3 = element.getElementsByTagName("icon")).getLength() > 0) {
                string7 = ((Element)nodeList3.item(0)).getAttribute("url");
            }
            ArrowDesc arrowDesc = new ArrowDesc(string, string2, string3, string7, string5, string6, nodeDesc2, nodeDesc);
            arrowDesc.setCategory(string4);
            this.formalism.addArrowDesc(arrowDesc);
            arrowDesc.setFormalism(this.formalism);
            NodeList nodeList4 = element.getElementsByTagName("graphic-element");
            if (nodeList4.getLength() > 0) {
                object = ((Element)nodeList4.item(0)).getAttribute("class");
                if (!((String)object).equals("")) {
                    arrowDesc.setGraphicClass((String)object);
                }
                if ((nodeList2 = ((Element)nodeList4.item(0)).getElementsByTagName("property")).getLength() > 0) {
                    arrowDesc.setGraphicProperties(this.getProperties(nodeList2));
                }
                element.removeChild(nodeList4.item(0));
            }
            if ((object = element.getElementsByTagName("property")).getLength() > 0) {
                try {
                    ReflectorUtil.setProperties(arrowDesc, this.getProperties((NodeList)object));
                }
                catch (Exception exception) {
                    Utils.log("setProperties failed:" + exception);
                }
            }
            nodeList2 = element.getElementsByTagName("action");
            for (int j = 0; j < nodeList2.getLength(); ++j) {
                if (nodeList2.item(j).getNodeType() != 1) continue;
                arrowDesc.addActionDesc(this.parseAction((Element)nodeList2.item(j)));
            }
        }
    }

    void parseFormalismInfo(Element element) {
        NodeList nodeList;
        Object object;
        NodeList nodeList2 = element.getElementsByTagName("author");
        if (nodeList2.getLength() > 0) {
            object = new Vector();
            int n = nodeList2.getLength();
            for (int i = 0; i < n; ++i) {
                String string = nodeList2.item(i).getFirstChild().getNodeValue();
                ((Vector)object).addElement(string);
            }
            this.formalism.setAuthors((Vector)object);
        }
        if ((object = element.getElementsByTagName("doc")).getLength() > 0) {
            String string = ((Element)object.item(0)).getAttribute("url");
            this.formalism.setDocURL(string);
        }
        if ((nodeList = element.getElementsByTagName("icon")).getLength() > 0) {
            String string = ((Element)nodeList.item(0)).getAttribute("url");
            this.formalism.setIcon(string);
        }
    }

    public static void main(String[] stringArray) {
        XMLFormalism xMLFormalism = new XMLFormalism();
        System.err.println(xMLFormalism.parse(stringArray[0]));
    }
}

