/*
 * Decompiled with CFR 0.152.
 */
package SEdit;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.io.Serializable;

class VerticalFlowLayout
implements LayoutManager,
Serializable {
    public static final int TOP = 0;
    public static final int CENTER = 1;
    int align;
    int hgap;
    int vgap;
    private static final long serialVersionUID = -7262534875583282631L;

    public VerticalFlowLayout() {
        this(1, 5, 5);
    }

    public VerticalFlowLayout(int n) {
        this(n, 5, 5);
    }

    public VerticalFlowLayout(int n, int n2, int n3) {
        this.align = n;
        this.hgap = n2;
        this.vgap = n3;
    }

    public int getAlignment() {
        return this.align;
    }

    public void setAlignment(int n) {
        this.align = n;
    }

    public int getHgap() {
        return this.hgap;
    }

    public void setHgap(int n) {
        this.hgap = n;
    }

    public int getVgap() {
        return this.vgap;
    }

    public void setVgap(int n) {
        this.vgap = n;
    }

    public void addLayoutComponent(String string, Component component) {
    }

    public void removeLayoutComponent(Component component) {
    }

    public Dimension preferredLayoutSize(Container container) {
        Dimension dimension = new Dimension(0, 0);
        int n = container.getComponentCount();
        for (int i = 0; i < n; ++i) {
            Component component = container.getComponent(i);
            if (!component.isVisible()) continue;
            Dimension dimension2 = component.getPreferredSize();
            dimension.width = Math.max(dimension.width, dimension2.width);
            if (i > 0) {
                dimension.height += this.vgap;
            }
            dimension.height += dimension2.height;
        }
        Insets insets = container.getInsets();
        dimension.width += insets.left + insets.right + this.hgap * 2;
        dimension.height += insets.top + insets.bottom + this.vgap * 2;
        return dimension;
    }

    public Dimension minimumLayoutSize(Container container) {
        Dimension dimension = new Dimension(0, 0);
        int n = container.getComponentCount();
        for (int i = 0; i < n; ++i) {
            Component component = container.getComponent(i);
            if (!component.isVisible()) continue;
            Dimension dimension2 = component.getMinimumSize();
            dimension.width = Math.max(dimension.width, dimension2.width);
            if (i > 0) {
                dimension.height += this.vgap;
            }
            dimension.height += dimension2.height;
        }
        Insets insets = container.getInsets();
        dimension.width += insets.left + insets.right + this.hgap * 2;
        dimension.height += insets.top + insets.bottom + this.vgap * 2;
        return dimension;
    }

    private void moveComponents(Container container, int n, int n2, int n3, int n4, int n5, int n6) {
        switch (this.align) {
            case 0: {
                break;
            }
            case 1: {
                n += n4 / 2;
            }
        }
        for (int i = n5; i < n6; ++i) {
            Component component = container.getComponent(i);
            if (!component.isVisible()) continue;
            component.setLocation(n + (n3 - component.getSize().width) / 2, n2);
            n2 += this.vgap + component.getSize().height;
        }
    }

    public void layoutContainer(Container container) {
        Insets insets = container.getInsets();
        int n = container.getSize().height - (insets.top + insets.bottom + this.vgap * 2);
        int n2 = container.getComponentCount();
        int n3 = insets.left + this.hgap;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        for (int i = 0; i < n2; ++i) {
            Component component = container.getComponent(i);
            if (!component.isVisible()) continue;
            Dimension dimension = component.getPreferredSize();
            component.setSize(dimension.width, dimension.height);
            if (n4 == 0 || n4 + dimension.height <= n) {
                if (n4 > 0) {
                    n4 += this.vgap;
                }
                n4 += dimension.height;
                n5 = Math.max(dimension.width, n5);
                continue;
            }
            this.moveComponents(container, n3, insets.top + this.vgap, n5, n - n4, n6, i);
            n4 = dimension.height;
            n3 += this.hgap + n5;
            n5 = dimension.width;
            n6 = i;
        }
        this.moveComponents(container, n3, insets.top + this.vgap, n5, n - n4, n6, n2);
    }

    public String toString() {
        String string = "";
        switch (this.align) {
            case 0: {
                string = ",align=top";
                break;
            }
            case 1: {
                string = ",align=center";
            }
        }
        return this.getClass().getName() + "[hgap=" + this.hgap + ",vgap=" + this.vgap + string + "]";
    }
}

