/*
 * Decompiled with CFR 0.152.
 */
package SEdit;

import SEdit.ActionDesc;
import SEdit.ArrowDesc;
import SEdit.ElementDesc;
import SEdit.Formalism;
import SEdit.HelpBox;
import SEdit.NodeDesc;
import SEdit.PropertyFrame;
import SEdit.SElement;
import SEdit.SElementPropertyFrame;
import SEdit.Structure;
import SEdit.StructureAgent;
import SEdit.StructureDialog;
import SEdit.StructureEditor;
import SEdit.Utils;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JTabbedPane;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import madkit.utils.graphics.LoadDialog;

public abstract class StructureBean
extends JRootPane {
    StructureAgent myAgent;
    StructureEditor editor;
    PropertyFrame propertyEditor;
    StructureDialog propertyDialog;
    JToggleButton buttonSnapToGrid;
    JToggleButton buttonPropertyEditor;
    boolean ending = false;

    public StructureEditor getEditor() {
        return this.editor;
    }

    public void setEditor(StructureEditor structureEditor) {
        this.editor = structureEditor;
    }

    public void setTitle(String string) {
        Container container = Utils.getFrameParent(this);
        if (container != null) {
            if (container instanceof JFrame) {
                ((JFrame)container).setTitle(string);
            } else if (container instanceof Frame) {
                ((Frame)container).setTitle(string);
            } else if (container instanceof JInternalFrame) {
                ((JInternalFrame)container).setTitle(string);
            }
        }
    }

    public Structure getStructure() {
        return this.myAgent.getStructure();
    }

    public Formalism getFormalism() {
        return this.myAgent.getFormalism();
    }

    public StructureBean(StructureAgent structureAgent) {
        this.myAgent = structureAgent;
    }

    JComponent makeElements() {
        JPanel jPanel;
        String string;
        Object object;
        Hashtable<String, JPanel> hashtable = new Hashtable<String, JPanel>();
        Object object2 = this.getFormalism().nodeDescList.elements();
        while (object2.hasMoreElements()) {
            object = (NodeDesc)object2.nextElement();
            string = ((ElementDesc)object).getCategory();
            if (!hashtable.containsKey(string)) {
                jPanel = new JPanel();
                jPanel.setLayout(new BoxLayout(jPanel, 0));
                hashtable.put(string, jPanel);
            }
            this.addToolElement((JPanel)hashtable.get(string), (ElementDesc)object);
        }
        object2 = this.getFormalism().arrowDescList.elements();
        while (object2.hasMoreElements()) {
            object = (ArrowDesc)object2.nextElement();
            string = ((ElementDesc)object).getCategory();
            if (!hashtable.containsKey(string)) {
                jPanel = new JPanel();
                jPanel.setLayout(new BoxLayout(jPanel, 0));
                hashtable.put(string, jPanel);
            }
            this.addToolElement((JPanel)hashtable.get(string), (ElementDesc)object);
        }
        if (hashtable.size() == 1) {
            return (JPanel)hashtable.elements().nextElement();
        }
        object2 = new JTabbedPane(1);
        object = hashtable.keys();
        while (object.hasMoreElements()) {
            string = (String)object.nextElement();
            jPanel = (JPanel)hashtable.get(string);
            if (string.equals("")) {
                ((JTabbedPane)object2).add("<untitled>", jPanel);
                continue;
            }
            ((JTabbedPane)object2).add(string, jPanel);
        }
        ((JComponent)object2).setPreferredSize(new Dimension(400, 72));
        return object2;
    }

    void addTool(JToolBar jToolBar, final ActionDesc actionDesc) {
        JButton jButton;
        if (actionDesc.getIcon() == null || actionDesc.getIcon().equals("")) {
            jButton = (JButton)jToolBar.add(new JButton(actionDesc.getDescription()));
            jButton.setActionCommand(actionDesc.getDescription());
        } else {
            ImageIcon imageIcon = new ImageIcon(actionDesc.getIcon());
            jButton = imageIcon.getImage() != null ? (JButton)jToolBar.add(new JButton(new ImageIcon(this.getFormalism().getBase() + actionDesc.getIcon()))) : (JButton)jToolBar.add(new JButton(actionDesc.getDescription()));
            jButton.setActionCommand(actionDesc.getDescription());
        }
        jButton.setToolTipText(actionDesc.getDescription());
        jButton.setMargin(new Insets(0, 0, 0, 0));
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                actionDesc.execute(StructureBean.this.getStructure());
                StructureBean.this.editor.repaint();
            }
        });
    }

    void addTool(JToolBar jToolBar, String string, String string2) {
        JButton jButton;
        if (string2 == null || string2.equals("")) {
            jButton = (JButton)jToolBar.add(new JButton(string));
            jButton.setActionCommand(string);
        } else {
            URL uRL = this.getClass().getResource(string2);
            ImageIcon imageIcon = new ImageIcon(uRL);
            jButton = imageIcon.getImage() != null ? (JButton)jToolBar.add(new JButton(imageIcon)) : (JButton)jToolBar.add(new JButton(string));
            jButton.setActionCommand(string);
        }
        jButton.setToolTipText(string);
        jButton.setMargin(new Insets(0, 0, 0, 0));
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                StructureBean.this.command(actionEvent.getActionCommand());
            }
        });
    }

    void addToolElement(JPanel jPanel, ElementDesc elementDesc) {
        JButton jButton = elementDesc.hasIcon() ? (JButton)jPanel.add(new JButton(new ImageIcon(this.getFormalism().getBase() + elementDesc.getIcon()))) : (JButton)jPanel.add(new JButton(elementDesc.getName()));
        if (!elementDesc.getDescription().equals("")) {
            jButton.setToolTipText(elementDesc.getDescription());
        }
        jButton.setActionCommand(elementDesc.getName());
        jButton.setMargin(new Insets(0, 0, 0, 0));
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                NodeDesc nodeDesc = StructureBean.this.getFormalism().getNodeDesc(actionEvent.getActionCommand());
                if (nodeDesc == null) {
                    ArrowDesc arrowDesc = StructureBean.this.getFormalism().getArrowDesc(actionEvent.getActionCommand());
                    if (arrowDesc == null) {
                        System.err.println("Erreur : j'ai pas trouve le descripteur de: " + actionEvent.getActionCommand());
                    } else {
                        StructureBean.this.editor.setInsertMode(11, arrowDesc);
                    }
                } else {
                    StructureBean.this.editor.setInsertMode(10, nodeDesc);
                }
            }
        });
    }

    void addMenuItem(ActionListener actionListener, JMenu jMenu, String string, String string2, int n) {
        JMenuItem jMenuItem = n > 0 ? new JMenuItem(string, n) : new JMenuItem(string);
        jMenu.add(jMenuItem);
        jMenuItem.setActionCommand(string2);
        jMenuItem.addActionListener(actionListener);
    }

    public void setSnapToGrid(boolean bl) {
        this.buttonSnapToGrid.setSelected(bl);
    }

    void showPropertyEditor(boolean bl) {
        if (this.propertyEditor == null) {
            if (bl) {
                this.propertyEditor = new SElementPropertyFrame(this, null, 4, true);
            }
        } else if (bl) {
            this.propertyEditor.show();
        } else {
            this.propertyEditor.hide();
        }
    }

    void inspectElement(SElement sElement) {
        if (this.propertyEditor != null) {
            this.propertyEditor.editObject(sElement);
        } else {
            this.propertyEditor = new SElementPropertyFrame(this, sElement, 4, false);
        }
    }

    void command(String string) {
        if (string.equals("close")) {
            this.close();
        } else if (string.equals("Select")) {
            this.editor.setMode(0);
        } else if (string.equals("Clear")) {
            this.editor.clearAll();
        } else if (string.equals("Cut")) {
            this.editor.cut();
        } else if (string.equals("Copy")) {
            this.editor.copyToClipBoard();
        } else if (string.equals("Paste")) {
            this.editor.clearSelection();
            this.myAgent.insertClipBoard();
            this.editor.updateTranslateList();
        } else if (string.equals("Show grid")) {
            this.editor.toggleShowGrid();
        } else if (string.equals("delete")) {
            this.editor.deleteSelection();
        } else if (string.equals("switchConn")) {
            this.editor.switchConn();
        } else if (string.equals("switchNodes")) {
            this.editor.switchNodes();
        } else if (string.equals("switchArrows")) {
            this.editor.switchArrows();
        } else if (string.equals("insertXMLFile")) {
            LoadDialog loadDialog = new LoadDialog((Component)this, true, "load a structure", "sed");
            if (loadDialog.isFileChoosed()) {
                String string2 = loadDialog.getDirName();
                String string3 = loadDialog.getFileName();
                this.editor.clearSelection();
                this.myAgent.insertXMLFile(string2 + string3, true);
                this.editor.repaint();
            }
        } else if (string.equals("properties")) {
            this.propertyDialog = new StructureDialog(Utils.getRealFrameParent(this), this.getEditor());
        } else if (string.equals("saveXMLFile")) {
            this.save();
        } else if (string.equals("saveAsXMLFile")) {
            this.saveAs();
        } else if (string.equals("print")) {
            this.editor.printEditor();
        } else if (string.equals("Align horizontally")) {
            this.editor.alignHorizontal();
        } else if (string.equals("Align vertically")) {
            this.editor.alignVertical();
        } else if (string.equals("about")) {
            String string4 = "Formalism " + this.getFormalism().name + "\n";
            Enumeration enumeration = this.getFormalism().authors.elements();
            while (enumeration.hasMoreElements()) {
                string4 = string4 + "- " + (String)enumeration.nextElement();
            }
            string4 = string4 + " -";
            JOptionPane.showMessageDialog(null, string4);
        } else if (string.equals("doc")) {
            HelpBox helpBox = new HelpBox(this.getFormalism().docURL, this.getFormalism());
        } else if (string.equals("dumpFormalism")) {
            this.getStructure().getFormalism().dump();
        } else if (string.equals("dumpStructure")) {
            this.getStructure().dump();
        }
    }

    synchronized void close() {
        if (!this.ending) {
            this.ending = true;
            System.out.println("closing bean");
            this.myAgent.close();
            if (this.propertyDialog != null) {
                this.propertyDialog.dispose();
            }
            if (this.propertyEditor != null) {
                this.propertyEditor.dispose();
            }
        }
    }

    void saveAs() {
        LoadDialog loadDialog = new LoadDialog((Component)this, false, "save a structure", "sed");
        if (loadDialog.isFileChoosed()) {
            String string = loadDialog.getDirName();
            String string2 = loadDialog.getFileName();
            System.out.println(":: saving file: " + string + string2);
            this.myAgent.saveXMLFile(string + string2);
        }
    }

    void save() {
        String string = this.myAgent.getFileName();
        if (string == null) {
            this.saveAs();
        } else {
            this.myAgent.saveXMLFile(string);
        }
    }
}

