/*
 * Decompiled with CFR 0.152.
 */
package SEdit.Formalisms.World;

import SEdit.Formalisms.World.WorldControlDialog;
import SEdit.Formalisms.World.WorldEntity;
import SEdit.Structure;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.Enumeration;
import java.util.Vector;

public class WorldStructure
extends Structure
implements Runnable {
    String groupName;
    WorldControlDialog ed;
    static String groupTypeName = "DemoWorld";
    static int groupCounter = 1;
    int iteration = 0;
    int delay = 60;
    Thread process = null;
    protected boolean running;
    boolean step = false;
    public boolean execute = false;
    public boolean showIteration = false;
    protected Rectangle worldDimension = new Rectangle(5, 5, 600, 400);

    public Vector getEntities() {
        return this.getNodes();
    }

    public static void setGroupTypeName(String string) {
        groupTypeName = string;
    }

    String getGroupName() {
        if (this.groupName != null) {
            return this.groupName;
        }
        this.groupName = groupTypeName + "-" + groupCounter++;
        return this.groupName;
    }

    public void setDelay(int n) {
        this.delay = n;
    }

    public int getDelay() {
        return this.delay;
    }

    public void setExecute(boolean bl) {
        this.execute = bl;
    }

    public boolean getExecute() {
        return this.execute;
    }

    public void setShowIteration(boolean bl) {
        this.showIteration = bl;
    }

    public boolean getShowIteration() {
        return this.showIteration;
    }

    public Rectangle getWorldDimension() {
        return this.worldDimension;
    }

    public void setWorldDimension(Rectangle rectangle) {
        this.worldDimension = rectangle;
    }

    public void setWorldDimension(int n, int n2, int n3, int n4) {
        this.worldDimension.x = n;
        this.worldDimension.y = n2;
        this.worldDimension.width = n3;
        this.worldDimension.height = n4;
    }

    public void setWorldWidth(int n) {
        this.worldDimension.width = n;
        System.out.println(":: setWorldWidth: " + n);
    }

    public int getWorldWidth() {
        return this.worldDimension.width;
    }

    public void setWorldHeight(int n) {
        this.worldDimension.height = n;
    }

    public int getWorldHeight() {
        return this.worldDimension.height;
    }

    public void println(String string) {
        System.out.println(string);
    }

    public WorldStructure() {
        this.setWorldDimension(5, 5, 1000, 700);
        this.setGridSize(16);
        this.setSnapToGrid(true);
        this.setDisplayGrid(true);
    }

    public void drawBackground(Graphics graphics) {
        Rectangle rectangle = this.getWorldDimension();
        graphics.setColor(Color.blue);
        graphics.drawRect(4, 4, rectangle.x + rectangle.width + 2, rectangle.y + rectangle.height + 2);
        graphics.drawRect(3, 3, rectangle.x + rectangle.width + 4, rectangle.y + rectangle.height + 4);
        graphics.drawRect(2, 2, rectangle.x + rectangle.width + 6, rectangle.y + rectangle.height + 6);
    }

    public synchronized Vector detectEntities(WorldEntity worldEntity, Point point, int n) {
        Vector<WorldEntity> vector = new Vector<WorldEntity>();
        boolean bl = false;
        Vector vector2 = this.getEntities();
        for (WorldEntity worldEntity2 : vector2) {
            if (worldEntity2 == null || worldEntity2 == worldEntity) continue;
            Point point2 = worldEntity2.getGObject().getCenter();
            int n2 = (int)Math.sqrt((point.x - point2.x) * (point.x - point2.x) + (point.y - point2.y) * (point.y - point2.y));
            if (n2 > n) continue;
            bl = true;
            vector.addElement(worldEntity2);
        }
        if (bl) {
            return vector;
        }
        return null;
    }

    public void end() {
        Object[] objectArray = new WorldEntity[this.getEntities().size()];
        this.getEntities().copyInto(objectArray);
        for (int i = 0; i < objectArray.length; ++i) {
            Object object = objectArray[i];
            if (object == null) continue;
            ((WorldEntity)object).delete();
        }
    }

    public boolean isRunning() {
        return this.running;
    }

    public void run() {
        while (this.running) {
            if (this.showIteration) {
                System.out.println("iteration: " + this.iteration);
            }
            this.runEnvironment();
            this.runEntities();
            this.getEditor().repaint();
            ++this.iteration;
            this.step = false;
            try {
                Thread.sleep(this.delay);
            }
            catch (InterruptedException interruptedException) {
                this.running = false;
                break;
            }
        }
    }

    public synchronized void runEnvironment() {
    }

    public synchronized void runEntities() {
        Vector vector = this.getEntities();
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            WorldEntity worldEntity = (WorldEntity)enumeration.nextElement();
            if (worldEntity == null) continue;
            worldEntity.doIt();
        }
    }

    public void start() {
        if (!this.running) {
            this.running = true;
            this.process = new Thread(this);
            this.process.setPriority(10);
            this.process.start();
        }
    }

    public void stop() {
        this.running = false;
    }

    public void step() {
        if (!this.running) {
            this.runEnvironment();
            this.runEntities();
            this.getEditor().repaint();
        }
    }

    public void modifyDelay() {
        if (this.ed == null) {
            this.ed = new WorldControlDialog(this);
        } else {
            this.ed.show();
        }
    }
}

