/*
 * Decompiled with CFR 0.152.
 */
package turtlekit.simulations.gas;

import java.awt.Color;
import madkit.guis.SimplePlotPanel;
import madkit.kernel.Probe;
import turtlekit.kernel.Observer;
import turtlekit.kernel.Turtle;
import turtlekit.kernel.TurtleProbe;

public class GasObserver
extends Observer {
    SimplePlotPanel plot;
    TurtleProbe allTurtles;
    int wall;
    int nb;
    int holeSize;

    public GasObserver(int n, int n2, int n3) {
        this.nb = n2;
        this.wall = n;
        this.holeSize = n3;
    }

    public void initGUI() {
        this.plot = new SimplePlotPanel("gas on the right side of the wall", 300, this.nb);
        this.setGUIObject(this.plot);
    }

    public void setup() {
        int n;
        this.plot.initialisation();
        for (n = 0; n < this.patchGrid[0].length; ++n) {
            this.patchGrid[this.wall][n].setColor(Color.white);
        }
        for (n = 0; n < this.holeSize; ++n) {
            this.patchGrid[this.wall][this.envHeight / 2 - this.holeSize / 2 + n].setColor(Color.black);
        }
        this.allTurtles = new TurtleProbe(this.getSimulationGroup(), "turtle");
        this.addProbe((Probe)this.allTurtles);
    }

    public synchronized void watch() {
        int n = 0;
        Turtle[] turtleArray = this.allTurtles.getTurtles();
        for (int i = 0; i < turtleArray.length; ++i) {
            if (turtleArray[i].xcor() < this.wall) continue;
            ++n;
        }
        this.plot.addPoint(n);
    }
}

