/*
 * Decompiled with CFR 0.152.
 */
package madkit.simulation.probes;

import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.ListIterator;
import java.util.Map;
import madkit.kernel.AbstractAgent;
import madkit.kernel.Probe;

public class ReflexiveProbe
extends Probe {
    protected Map fields;
    private String property;

    public ReflexiveProbe(String string, String string2, String string3) {
        super(string, string2);
        this.property = string3;
        this.fields = new HashMap();
    }

    public ReflexiveProbe(String string, String string2, String string3, String string4) {
        super(string, string2, string3);
        this.property = string4;
        this.fields = new HashMap();
    }

    public String getProperty() {
        return this.property;
    }

    public void findFields() {
        ListIterator listIterator = this.getAgentsIterator();
        while (listIterator.hasNext()) {
            Object e = listIterator.next();
            try {
                this.fields.put(e, e.getClass().getField(this.property));
            }
            catch (Exception exception) {
                System.err.println("Can't find property: " + this.property + " on " + ((AbstractAgent)e).toString() + exception);
            }
        }
    }

    public void initialize() {
        this.findFields();
    }

    public void update(AbstractAgent abstractAgent, boolean bl) {
        if (bl) {
            this.updateFieldFor(abstractAgent);
        } else {
            this.fields.remove(abstractAgent);
        }
    }

    public void updateFieldFor(Object object) {
        try {
            this.fields.put(object, object.getClass().getField(this.property));
        }
        catch (Exception exception) {
            System.err.println("Can't find property: " + this.property + " on " + object.toString() + exception);
        }
    }

    public synchronized double getDouble(Object object) {
        try {
            return ((Field)this.fields.get(object)).getDouble(object);
        }
        catch (IllegalAccessException illegalAccessException) {
            System.err.println("Unable to getDouble on " + ((AbstractAgent)object).toString() + "  " + illegalAccessException);
            return Double.NaN;
        }
    }

    public synchronized long getLong(Object object) {
        try {
            return ((Field)this.fields.get(object)).getLong(object);
        }
        catch (IllegalAccessException illegalAccessException) {
            System.err.println("Unable to getLong on " + ((AbstractAgent)object).toString() + "  " + illegalAccessException);
            return 0L;
        }
    }

    public synchronized boolean getBoolean(Object object) {
        try {
            return ((Field)this.fields.get(object)).getBoolean(object);
        }
        catch (IllegalAccessException illegalAccessException) {
            System.err.println("Unable to getBoolean on " + ((AbstractAgent)object).toString() + "  " + illegalAccessException);
            return false;
        }
    }

    public synchronized char getChar(Object object) {
        try {
            return ((Field)this.fields.get(object)).getChar(object);
        }
        catch (IllegalAccessException illegalAccessException) {
            System.err.println("Unable to getBoolean on " + ((AbstractAgent)object).toString() + "  " + illegalAccessException);
            return '\uffff';
        }
    }

    public synchronized Object getObject(Object object) {
        try {
            return ((Field)this.fields.get(object)).get(object);
        }
        catch (IllegalAccessException illegalAccessException) {
            System.err.println("Unable to getObject on " + ((AbstractAgent)object).toString() + "  " + illegalAccessException);
            return null;
        }
    }

    public int getPropertyCount() {
        return this.fields.size();
    }
}

