/*
 * Decompiled with CFR 0.152.
 */
package madkit.FIPARequestProt;

import madkit.FIPARequestProt.InitiatorGUI;
import madkit.kernel.Agent;
import madkit.kernel.AgentAddress;
import madkit.kernel.Message;
import madkit.kernel.StringMessage;
import madkit.messages.ACLMessage;

public class Initiator
extends Agent {
    String myCommunity = "FIPARequestProt";
    String myGroup = "protocol1";
    String myRole = "initiator";
    boolean alive = true;
    InitiatorGUI gui;

    public void initGUI() {
        this.gui = new InitiatorGUI(this);
        this.setGUIObject(this.gui);
    }

    public void activate() {
        this.println("Hello I'm an agent !");
        int n = this.createGroup(true, this.myCommunity, this.myGroup, null, null);
        if (n == 1) {
            this.println("I create the group " + this.myGroup + " in community " + this.myCommunity);
        } else if (n == -1) {
            this.println("The group has already been created");
        } else {
            this.println("Cannot create the group");
        }
        int n2 = this.requestRole(this.myCommunity, this.myGroup, this.myRole, null);
        if (n2 == 1) {
            this.println("I play " + this.myRole + " in " + this.myGroup + " of " + this.myCommunity);
        } else if (n2 == -1) {
            this.println("I cannot enter the group: access denied");
        } else if (n2 == -2) {
            this.println("I already play the role " + this.myRole + " in " + this.myGroup + " of " + this.myCommunity);
        } else if (n2 == -3) {
            this.println("The group " + this.myGroup + " does not exist int the community " + this.myCommunity);
        } else if (n2 == -4) {
            this.println("The community " + this.myCommunity + " does not exist");
        }
    }

    public void live() {
        this.println("I am the initiator...");
        while (this.alive) {
            this.exitImmediatlyOnKill();
            Message message = this.waitNextMessage();
            if (message instanceof StringMessage) {
                this.handleMessage((StringMessage)message);
                continue;
            }
            if (!(message instanceof ACLMessage)) continue;
            this.handleMessage((ACLMessage)message);
        }
    }

    void die() {
        this.sendMessage(this.getAddress(), (Message)new StringMessage("die"));
    }

    void handleMessage(StringMessage stringMessage) {
        this.println("message: " + stringMessage.getString() + " : received from " + stringMessage.getSender());
    }

    void handleMessage(ACLMessage aCLMessage) {
        String string = aCLMessage.getPerformative();
        this.println("message: " + aCLMessage.getPerformative() + " : received from " + aCLMessage.getSender());
    }

    void sendRequest() {
        AgentAddress agentAddress = this.getAgentWithRole(this.myCommunity, this.myGroup, "participant");
        this.sendMessage(agentAddress, (Message)new ACLMessage(16, "food"));
    }

    public void end() {
        this.println("\t That's it !!! Bye ");
    }
}

