/*
 * Decompiled with CFR 0.152.
 */
package dynamicbees;

import dynamicbees.Bee;
import dynamicbees.BeeEnvironment;
import dynamicbees.BeeLauncherGUI;
import dynamicbees.BeeScheduler;
import dynamicbees.BeeWorldViewer;
import dynamicbees.QueenBee;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import madkit.kernel.AbstractAgent;
import madkit.kernel.Agent;
import madkit.kernel.Kernel;

public class BeeLauncher
extends Agent {
    int delay = 9;
    int beenumber = 2000;
    int height = 600;
    int width = 800;
    List agentsList = new ArrayList();
    List queensList = new ArrayList();
    List beesList = new ArrayList();
    boolean active = false;
    boolean withSwing = false;
    boolean randomMode = true;
    BeeScheduler beeScheduler;
    BeeEnvironment beeEnvironment;
    BeeWorldViewer beeViewer;

    public void setWidth(int n) {
        this.width = n;
        this.beeEnvironment.setWidth(n);
    }

    public int getWidth() {
        return this.width;
    }

    public void setHeight(int n) {
        this.height = n;
        this.beeEnvironment.setHeight(n);
    }

    public int getHeight() {
        return this.height;
    }

    public int getDelay() {
        return this.delay;
    }

    public void setDelay(int n) {
        this.delay = n;
        if (this.beeScheduler != null) {
            this.beeScheduler.delay = this.delay;
        }
    }

    public void setBeenumber(int n) {
        this.beenumber = n;
    }

    public int getBeenumber() {
        return this.beenumber;
    }

    public boolean getActive() {
        return this.active;
    }

    public void setActive(boolean bl) {
        this.active = bl;
    }

    public boolean getwithSwing() {
        return this.withSwing;
    }

    public void setwithSwing(boolean bl) {
        this.withSwing = bl;
    }

    public synchronized void launchBees(int n) {
        for (int i = 0; i < n; ++i) {
            Bee bee = new Bee();
            this.beesList.add(bee);
            if ((i + 1) % 5000 == 0) {
                System.err.println("" + (i + 1) + " bees launched");
            }
            this.launchAgent(bee, "Bee", false);
        }
    }

    public synchronized void launchQueens(int n) {
        for (int i = 0; i < n; ++i) {
            QueenBee queenBee = new QueenBee();
            this.queensList.add(queenBee);
            this.launchAgent(queenBee, "queen bee", false);
            if ((i + 1) % 1000 != 0) continue;
            System.err.println("" + (i + 1) + " bees launched");
        }
    }

    public synchronized void killBees(boolean bl, int n) {
        AbstractAgent abstractAgent;
        List list = bl ? this.queensList : this.beesList;
        Iterator iterator = list.iterator();
        for (int i = 0; iterator.hasNext() && i < n && (abstractAgent = (AbstractAgent)iterator.next()) != null; ++i) {
            iterator.remove();
            this.killAgent(abstractAgent);
        }
    }

    public void activate() {
        System.err.println("Launching simulation...");
        this.createGroup(true, "buzz", "bees", null, null);
        this.requestRole("buzz", "bees", "launcher", null);
        while (!this.active) {
            this.exitImmediatlyOnKill();
            this.pause(100);
        }
        QueenBee queenBee = new QueenBee();
        this.queensList.add(queenBee);
        this.launchAgent(queenBee, "queen bee", true);
        this.launchBees(this.beenumber);
        this.beeScheduler = new BeeScheduler(this.delay);
        this.agentsList.add(this.beeScheduler);
        this.beeEnvironment = new BeeEnvironment(this.width, this.height);
        this.agentsList.add(this.beeEnvironment);
        this.beeViewer = new BeeWorldViewer(this.withSwing, this.width, this.height);
        this.agentsList.add(this.beeViewer);
        this.launchAgent((AbstractAgent)this.beeEnvironment, "bee world", false);
        this.launchAgent((AbstractAgent)this.beeViewer, "viewer", true);
        this.launchAgent((AbstractAgent)this.beeScheduler, "bee scheduler", false);
        this.println("activated");
    }

    public void live() {
        boolean bl = false;
        while (true) {
            this.exitImmediatlyOnKill();
            this.pause(500 + (int)(Math.random() * 2000.0));
            if (!this.randomMode) continue;
            if (Math.random() < 0.8) {
                if (Math.random() < 0.5) {
                    if (this.queensList.size() <= 1) continue;
                    if (this.queensList.size() > 7) {
                        this.killBees(true, (int)(Math.random() * 7.0) + 1);
                        continue;
                    }
                    this.killBees(true, (int)(Math.random() * 2.0) + 1);
                    continue;
                }
                if (this.queensList.size() >= 10) continue;
                this.launchQueens((int)(Math.random() * 2.0) + 1);
                continue;
            }
            if (Math.random() < 0.5) {
                if (this.beesList.size() >= 5000) continue;
                this.launchBees((int)(Math.random() * 25.0) + 1);
                continue;
            }
            this.killBees(false, (int)(Math.random() * 25.0) + 1);
        }
    }

    public void end() {
        System.err.println("simulation ending");
        this.pause(200);
        boolean bl = false;
        for (AbstractAgent abstractAgent : this.agentsList) {
            this.killAgent(abstractAgent);
        }
        for (AbstractAgent abstractAgent : this.queensList) {
            this.killAgent(abstractAgent);
        }
        for (AbstractAgent abstractAgent : this.beesList) {
            this.killAgent(abstractAgent);
        }
        this.pause(1000);
        Kernel.debugString();
        System.gc();
    }

    public void initGUI() {
        this.setGUIObject(new BeeLauncherGUI(this));
    }
}

