/*
 * Decompiled with CFR 0.152.
 */
package madkit.designer;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import madkit.boot.Madkit;
import madkit.designer.PluginDesignerGUI;
import madkit.designer.PluginNode;
import madkit.kernel.AbstractAgent;
import madkit.kernel.Agent;
import madkit.kernel.Message;
import madkit.messages.ActMessage;
import madkit.system.PluginAgent;
import madkit.system.PluginInformation;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.BuildListener;
import org.apache.tools.ant.DefaultLogger;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.ProjectHelper;

public class PluginDesignerAgent
extends Agent {
    Map<String, PluginInformation> plugins = new HashMap<String, PluginInformation>();
    Map<String, PluginNode> pluginNodes = new HashMap<String, PluginNode>();
    PluginDesignerGUI gui = null;

    Map getPlugins() {
        return this.plugins;
    }

    public PluginDesignerAgent() {
        this.plugins = new HashMap<String, PluginInformation>();
    }

    public void initGUI() {
        this.gui = new PluginDesignerGUI(this);
        this.setGUIObject(this.gui);
    }

    public void activate() {
        this.createGroup(false, "system", null, null);
        this.requestRole("system", "designer", null);
        this.broadcastMessage("system", "plugin", (Message)new ActMessage("info"));
    }

    public void live() {
        while (true) {
            Message message;
            if (!((message = this.waitNextMessage()) instanceof ActMessage)) {
                continue;
            }
            this.handleMessage((ActMessage)message);
        }
    }

    void handleMessage(ActMessage actMessage) {
        PluginInformation pluginInformation;
        String string;
        String string2 = actMessage.getAction();
        if ("infos".equalsIgnoreCase(string2) && !this.plugins.containsKey(string = (pluginInformation = (PluginInformation)actMessage.getObject()).getName())) {
            this.plugins.put(pluginInformation.getName(), pluginInformation);
            if (this.hasGUI()) {
                this.gui.addPlugin(pluginInformation.getName(), false);
            }
        }
        if ("newPlugin".equalsIgnoreCase(string2) && !this.plugins.containsKey(string = (pluginInformation = (PluginInformation)actMessage.getObject()).getName())) {
            this.plugins.put(pluginInformation.getName(), pluginInformation);
            if (this.hasGUI()) {
                this.gui.addPlugin(pluginInformation.getName(), true);
            }
        }
    }

    boolean createJavaAgent(String string, String string2, String string3) {
        if (string3.equalsIgnoreCase("Standard Java agent")) {
            this.createEntity("newJavaAgent", string, string2, "standard_java", "java");
            System.out.println("Created the Java file: " + string2 + " with agent type : " + string3);
            return true;
        }
        if (string3.equalsIgnoreCase("Standard Java agent with GUI")) {
            this.createEntity("newJavaAgentWithGUI", string, string2, "standard_java2", "java");
            System.out.println("Created Java files: " + string2 + " with agent type : " + string3);
            return true;
        }
        System.out.println("Cannot create a Java agent of type : " + string3);
        return false;
    }

    void createPythonAgent(String string, String string2, String string3) {
        if (string3.equalsIgnoreCase("Standard Python Agent")) {
            this.createEntity("newScriptAgent", string, string2, "standard_python", "py");
            System.out.println("Created a Python agent of type : " + string3);
        } else {
            System.out.println("Cannot create a Python Agent of type : " + string3);
        }
    }

    void createJessAgent(String string, String string2, String string3) {
        if (string3.equalsIgnoreCase("Default Jess Agent")) {
            this.createEntity("newScriptAgent", string, string2, "standard_jess", "clp");
            System.out.println("Created a Jess agent of type : " + string3);
        } else {
            System.out.println("Cannot create a Jess agent of type : " + string3);
        }
    }

    void createBshAgent(String string, String string2, String string3) {
        if (string3.equalsIgnoreCase("Default BeanShell Agent")) {
            this.createEntity("newScriptAgent", string, string2, "standard_bsh", "bsh");
            System.out.println("Created a BeanShell agent of type : " + string3);
        } else {
            System.out.println("Cannot create a BeanShell agent of type : " + string3);
        }
    }

    void createSchemeAgent(String string, String string2, String string3) {
        if (string3.equalsIgnoreCase("Default Scheme Agent")) {
            this.createEntity("newScriptAgent", string, string2, "standard_scheme", "scm");
            System.out.println("Created a Scheme agent of type : " + string3);
        } else {
            System.out.println("Cannot create a Scheme agent of type : " + string3);
        }
    }

    void createEntity(String string, String string2, String string3, String string4, String string5) {
        System.out.println("Creating a script agent of type " + string4);
        File file = new File(Madkit.madkitDirectory, "plugins");
        File file2 = new File(file, "designer");
        File file3 = new File(file2, "scripts");
        DefaultLogger defaultLogger = new DefaultLogger();
        defaultLogger.setMessageOutputLevel(2);
        defaultLogger.setOutputPrintStream(System.out);
        defaultLogger.setErrorPrintStream(System.err);
        File file4 = new File(file3, "create.xml");
        File file5 = new File(file, string2);
        Project project = new Project();
        project.addBuildListener((BuildListener)defaultLogger);
        project.init();
        ProjectHelper.configureProject((Project)project, (File)file4);
        project.setUserProperty("agent.type", string4);
        project.setUserProperty("newProject", string2);
        project.setUserProperty("script.extens", string5);
        project.setUserProperty("agent.name", string3);
        try {
            project.executeTarget(string);
            System.out.println("Scripted agent : " + string3 + "." + string5 + " created");
        }
        catch (BuildException buildException) {
            System.err.println("SCRIPT AGENT CREATION FAILED");
            System.err.println(buildException.getMessage());
        }
    }

    boolean createPlugin(String string, String string2) {
        System.out.println("Creating a plugin of type " + string2);
        File file = new File(Madkit.madkitDirectory, "plugins");
        File file2 = new File(file, "designer");
        File file3 = new File(file2, "scripts");
        DefaultLogger defaultLogger = new DefaultLogger();
        defaultLogger.setMessageOutputLevel(2);
        defaultLogger.setOutputPrintStream(System.out);
        defaultLogger.setErrorPrintStream(System.err);
        File file4 = new File(file3, "create.xml");
        File file5 = new File(file, string);
        boolean bl = file5.mkdir();
        if (!bl) {
            System.err.println("Cannot create directory: " + file5);
            return false;
        }
        Project project = new Project();
        project.addBuildListener((BuildListener)defaultLogger);
        project.init();
        ProjectHelper.configureProject((Project)project, (File)file4);
        project.setUserProperty("plugin.type", string2);
        project.setUserProperty("newProject", string);
        try {
            project.executeTarget(project.getDefaultTarget());
            Project project2 = new Project();
            project2.addBuildListener((BuildListener)defaultLogger);
            project2.init();
            File file6 = new File(file5, "build.xml");
            ProjectHelper.configureProject((Project)project2, (File)file6);
            project2.executeTarget(project2.getDefaultTarget());
            PluginAgent pluginAgent = new PluginAgent();
            pluginAgent.init(file5);
            this.launchAgent((AbstractAgent)pluginAgent, "plugin-" + pluginAgent.getPluginName(), false);
            System.out.println("Plugin: " + string + " created");
            return true;
        }
        catch (BuildException buildException) {
            System.err.println("BUILD FAILED");
            System.err.println(buildException.getMessage());
            return false;
        }
    }
}

