/*
 * Decompiled with CFR 0.152.
 */
package marketorg;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JPanel;
import madkit.kernel.Agent;
import madkit.kernel.AgentAddress;
import madkit.kernel.Message;
import madkit.kernel.OPanel;
import madkit.messages.ACLMessage;
import marketorg.BidAnswer;

public class Broker
extends Agent
implements ActionListener {
    Vector bidders = new Vector();
    BidAnswer[] answers;
    int contract = 0;
    JButton b;
    int cpt = 0;
    AgentAddress client;
    boolean pause = false;

    public void enterPause() {
        this.pause = true;
        this.b.setBackground(Color.red);
        this.b.repaint();
        while (this.pause) {
            this.pause(200);
        }
    }

    public void initGUI() {
        JPanel jPanel = new JPanel(new BorderLayout());
        OPanel oPanel = new OPanel();
        jPanel.add("Center", (Component)oPanel);
        this.b = new JButton("Next step");
        this.b.addActionListener(this);
        jPanel.add("South", this.b);
        this.setGUIObject(jPanel);
        this.setOutputWriter(oPanel.getOut());
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this.pause = false;
        this.b.setBackground(Color.gray);
    }

    public void activate() {
        this.println("Broker ready");
        this.createGroup(true, "travel", "travel-providers", null, null);
        this.createGroup(true, "travel", "travel-clients", null, null);
        this.requestRole("travel", "travel-providers", "broker", null);
        this.requestRole("travel", "travel-clients", "broker", null);
    }

    public void handleMessage(ACLMessage aCLMessage) {
        String string = null;
        if (aCLMessage.getAct().equalsIgnoreCase("REQUEST")) {
            this.println("Receiving client request");
            this.enterPause();
            string = aCLMessage.getContent().toString();
            this.client = aCLMessage.getSender();
            AgentAddress[] agentAddressArray = this.getAgentsWithRole("travel", "travel-providers", string + "-provider");
            if (agentAddressArray.length == 0) {
                this.println("Not found providers of " + string);
                return;
            }
            this.println("Found providers of " + string);
            this.cpt = agentAddressArray.length;
            this.answers = new BidAnswer[this.cpt];
            this.println("Transmitting requests...");
            ACLMessage aCLMessage2 = new ACLMessage("REQUEST-FOR-BID", string);
            this.broadcastMessage("travel", "travel-providers", string + "-provider", (Message)aCLMessage2);
            this.println("Waiting for offers..");
        } else if (aCLMessage.getAct().equalsIgnoreCase("BID")) {
            this.receiveBid(aCLMessage);
        }
    }

    public void live() {
        while (true) {
            Message message;
            if ((message = this.waitNextMessage()) instanceof ACLMessage) {
                this.handleMessage((ACLMessage)message);
                continue;
            }
            System.err.println("ERROR: invalid message type: " + message);
        }
    }

    protected void receiveBid(ACLMessage aCLMessage) {
        this.println("Received an offer of " + aCLMessage.getContent() + " from " + aCLMessage.getSender());
        --this.cpt;
        this.answers[this.cpt] = new BidAnswer(aCLMessage.getSender(), new Integer(aCLMessage.getContent().toString()));
        if (this.cpt <= 0) {
            this.bestContract();
        }
    }

    void bestContract() {
        AgentAddress agentAddress = null;
        int n = 9999;
        this.println("Selecting best offer from " + this.answers.length + " proposals");
        this.enterPause();
        for (int i = 0; i < this.answers.length; ++i) {
            this.println(":: best: " + n + ", value: " + this.answers[i].getValue());
            if (this.answers[i].getValue() >= n) continue;
            agentAddress = this.answers[i].getBidder();
            n = this.answers[i].getValue();
        }
        if (agentAddress != null) {
            this.println("Chosen provider:" + agentAddress);
            this.println("  avec " + n + " F");
            ++this.contract;
            this.println("Sending provider confirmation");
            this.enterPause();
            this.sendMessage(agentAddress, (Message)new ACLMessage("MAKE-CONTRACT", "contract-" + this.contract));
            this.pause(100);
            this.println("Sending client confirmation");
            this.enterPause();
            this.sendMessage(this.client, (Message)new ACLMessage("MAKE-CONTRACT", "contract-" + this.contract));
        }
    }
}

