/*
 * Decompiled with CFR 0.152.
 */
package madkit.games.tictactoe;

import java.awt.Color;
import java.awt.Graphics;
import madkit.games.tictactoe.GameCases;
import madkit.games.tictactoe.GameCasesDisplay;

public class Piece {
    static final int RED = 0;
    static final int BLUE = 1;
    int column = 0;
    int row = 0;
    int couleur = 1;
    GameCases jeu;
    GameCasesDisplay display;

    public Piece(GameCases gameCases, GameCasesDisplay gameCasesDisplay, int n) {
        this.jeu = gameCases;
        this.couleur = n;
        this.display = gameCasesDisplay;
    }

    boolean install(int n, int n2) {
        boolean bl = this.place(n, n2);
        this.display.repaint();
        return bl;
    }

    boolean place(int n, int n2) {
        this.column = n;
        this.row = n2;
        return this.jeu.setPiece(this, n, n2);
    }

    void delete() {
        this.jeu.deletePiece(this, this.column, this.row);
    }

    void moveTo(int n, int n2) {
        this.delete();
        this.place(n, n2);
    }

    void draw(Graphics graphics, int n, int n2) {
        Color color = null;
        switch (this.couleur) {
            case 0: {
                color = Color.red;
                break;
            }
            case 1: {
                color = Color.blue;
            }
        }
        graphics.setColor(color);
        graphics.fillOval(this.column * n + 1, this.row * n2 + 1, n - 2, n2 - 2);
    }

    void dump() {
        switch (this.couleur) {
            case 0: {
                System.out.print("R");
                break;
            }
            case 1: {
                System.out.print("B");
            }
        }
    }

    boolean attempt(int n, int n2, int n3, int n4) {
        Piece piece;
        return this.jeu.isOccupied(n2, n3) && (piece = this.jeu.takePiece(n2, n3)) != null && piece.couleur == this.couleur && piece.tryLine(n - 1, n4);
    }

    boolean tryAllLines(int n) {
        if (this.attempt(n, this.column + 1, this.row, 1)) {
            return true;
        }
        if (this.attempt(n, this.column - 1, this.row, 2)) {
            return true;
        }
        if (this.attempt(n, this.column, this.row - 1, 3)) {
            return true;
        }
        if (this.attempt(n, this.column + 1, this.row - 1, 4)) {
            return true;
        }
        return this.attempt(n, this.column - 1, this.row - 1, 5);
    }

    boolean tryLine(int n, int n2) {
        if (n2 != 0 && n == 0) {
            return true;
        }
        switch (n2) {
            case 1: {
                return this.attempt(n, this.column + 1, this.row, 1);
            }
            case 2: {
                return this.attempt(n, this.column - 1, this.row, 2);
            }
            case 3: {
                return this.attempt(n, this.column, this.row - 1, 3);
            }
            case 4: {
                return this.attempt(n, this.column + 1, this.row - 1, 4);
            }
            case 5: {
                return this.attempt(n, this.column - 1, this.row - 1, 5);
            }
        }
        return false;
    }
}

