/*
 * Decompiled with CFR 0.152.
 */
package madkit.games.tictactoe;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JComponent;
import madkit.games.tictactoe.GameCases;

public class GameCasesDisplay
extends JComponent
implements MouseListener {
    GameCases jeu;

    public GameCasesDisplay(GameCases gameCases) {
        this.jeu = gameCases;
        this.addMouseListener(this);
        this.setPreferredSize(new Dimension(280, 280));
    }

    public void paint(Graphics graphics) {
        int n = (int)Math.floor((this.getWidth() - 2) / this.jeu.width);
        int n2 = (int)Math.floor((this.getHeight() - 2) / this.jeu.height);
        this.drawGrille(graphics, n, n2);
        this.drawCases(graphics, n, n2);
    }

    void drawGrille(Graphics graphics, int n, int n2) {
        int n3;
        graphics.setColor(Color.white);
        graphics.fillRect(0, 0, n * this.jeu.width, n2 * this.jeu.height);
        graphics.setColor(Color.darkGray);
        for (n3 = 0; n3 <= this.jeu.width; ++n3) {
            graphics.drawLine(n3 * n, 0, n3 * n, n2 * this.jeu.height);
        }
        for (n3 = 0; n3 <= this.jeu.height; ++n3) {
            graphics.drawLine(0, n3 * n2, n * this.jeu.width, n3 * n2);
        }
    }

    void drawCases(Graphics graphics, int n, int n2) {
        for (int i = 0; i < this.jeu.width; ++i) {
            for (int j = 0; j < this.jeu.height; ++j) {
                if (this.jeu.cases[i][j] == null) continue;
                this.jeu.cases[i][j].draw(graphics, n, n2);
            }
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
        int n = this.getWidth() / this.jeu.width;
        int n2 = this.getHeight() / this.jeu.height;
        this.jeu.doClick(mouseEvent.getX() / n, mouseEvent.getY() / n2);
        this.repaint();
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }
}

