/*
 * Decompiled with CFR 0.152.
 */
package dynamicbees;

import dynamicbees.AwtGridCanvas;
import dynamicbees.BeeColor;
import dynamicbees.BeeColorProbe;
import dynamicbees.BeePointProbe;
import dynamicbees.GridCanvas;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Point;
import madkit.kernel.Probe;
import madkit.kernel.ReferenceableAgent;
import madkit.kernel.Watcher;

public class BeeWorldViewer
extends Watcher
implements ReferenceableAgent {
    Component onScreen;
    BeeColorProbe p1;
    BeePointProbe p2;
    BeePointProbe p3;
    BeeColorProbe qp1;
    BeePointProbe qp2;
    BeePointProbe qp3;
    int width = 300;
    int height = 300;
    boolean show = true;
    boolean swing = true;

    public void setShow(boolean bl) {
        this.show = bl;
    }

    public boolean getShow() {
        return this.show;
    }

    public BeeWorldViewer() {
    }

    public BeeWorldViewer(boolean bl, int n, int n2) {
        this();
        this.swing = bl;
        this.width = n;
        this.height = n2;
    }

    public void initGUI() {
        if (this.swing) {
            this.onScreen = new GridCanvas(this.width, this.height, this);
            this.setGUIObject(this.onScreen);
        } else {
            this.onScreen = new AwtGridCanvas(this.width, this.height, this);
            this.setGUIObject(this.onScreen);
        }
    }

    public void paintBees(Graphics graphics) {
        BeeColor[] beeColorArray = this.p1.getColors();
        Point[] pointArray = this.p2.getPoints();
        Point[] pointArray2 = this.p3.getPoints();
        if (beeColorArray != null) {
            for (int i = 0; i < beeColorArray.length; ++i) {
                graphics.setColor(beeColorArray[i].currentColor);
                graphics.drawLine(pointArray2[i].x, pointArray2[i].y, pointArray[i].x, pointArray[i].y);
            }
        }
    }

    public void paintQueenBees(Graphics graphics) {
        BeeColor[] beeColorArray = this.qp1.getColors();
        Point[] pointArray = this.qp2.getPoints();
        Point[] pointArray2 = this.qp3.getPoints();
        if (beeColorArray != null) {
            for (int i = 0; i < beeColorArray.length; ++i) {
                graphics.setColor(beeColorArray[i].currentColor);
                graphics.drawLine(pointArray2[i].x, pointArray2[i].y, pointArray[i].x, pointArray[i].y);
                graphics.fillOval(pointArray[i].x, pointArray[i].y, 6, 6);
            }
        }
    }

    public synchronized void observe() {
        if (this.show) {
            if (this.swing) {
                this.onScreen.repaint();
            } else {
                ((AwtGridCanvas)this.onScreen).display();
            }
        }
    }

    public void activate() {
        if (!this.swing) {
            ((AwtGridCanvas)this.onScreen).initialisation();
        }
        this.p1 = new BeeColorProbe("bees", "bee", "beeColor");
        this.p2 = new BeePointProbe("bees", "bee", "p");
        this.p3 = new BeePointProbe("bees", "bee", "oldp");
        this.addProbe((Probe)this.p1);
        this.addProbe((Probe)this.p2);
        this.addProbe((Probe)this.p3);
        this.qp1 = new BeeColorProbe("bees", "queen bee", "beeColor");
        this.qp2 = new BeePointProbe("bees", "queen bee", "p");
        this.qp3 = new BeePointProbe("bees", "queen bee", "oldp");
        this.addProbe((Probe)this.qp1);
        this.addProbe((Probe)this.qp2);
        this.addProbe((Probe)this.qp3);
        this.createGroup(true, "buzz", "bees", null, null);
        this.requestRole("buzz", "bees", "bee observer", null);
        System.err.println("Activated");
    }

    public void end() {
        this.disposeMyGUI();
        super.end();
    }
}

