/*
 * Decompiled with CFR 0.152.
 */
package dynamicbees;

import dynamicbees.BeeLauncher;
import dynamicbees.BeeWorldViewer;
import dynamicbees.QueenBee;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import madkit.kernel.AbstractAgent;

class BeeLauncherGUI
extends JPanel
implements ActionListener {
    JButton launchSimu = this.addNewButton("Launch simulation");
    JButton launchQueen;
    JButton launchBee;
    JButton launchViewer;
    JButton randomMode = this.addNewButton("Random launch Off");
    BeeLauncher myLauncher;

    BeeLauncherGUI(BeeLauncher beeLauncher) {
        this.launchQueen = this.addNewButton("Launch a queen");
        this.launchBee = this.addNewButton("Launch a bee");
        this.launchViewer = this.addNewButton("Launch a viewer");
        this.myLauncher = beeLauncher;
        JSlider jSlider = new JSlider(0, 0, 19, 11);
        jSlider.addChangeListener(new SliderListener());
        jSlider.setMajorTickSpacing(5);
        jSlider.setPaintTicks(true);
        jSlider.setPaintLabels(false);
        jSlider.setBorder(BorderFactory.createEmptyBorder(0, 0, 15, 0));
        this.add(jSlider);
    }

    public JButton addNewButton(String string) {
        JButton jButton = new JButton(string);
        this.add(jButton);
        jButton.addActionListener(this);
        return jButton;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.launchSimu) {
            this.myLauncher.setActive(true);
        } else if (object == this.randomMode) {
            if (this.randomMode.getText().equals("Random launch Off")) {
                this.randomMode.setText("Random launch On");
                this.myLauncher.randomMode = false;
            } else {
                this.randomMode.setText("Random launch Off");
                this.myLauncher.randomMode = true;
            }
        } else if (object == this.launchQueen) {
            QueenBee queenBee = new QueenBee();
            this.myLauncher.queensList.add(queenBee);
            this.myLauncher.launchAgent(queenBee, "queen bee", true);
        } else if (object == this.launchBee) {
            this.myLauncher.launchBees(1);
        } else if (object == this.launchViewer) {
            BeeWorldViewer beeWorldViewer = new BeeWorldViewer(this.myLauncher.withSwing, this.myLauncher.width, this.myLauncher.height);
            this.myLauncher.agentsList.add(0, beeWorldViewer);
            this.myLauncher.launchAgent((AbstractAgent)beeWorldViewer, "viewer", true);
        }
    }

    class SliderListener
    implements ChangeListener {
        SliderListener() {
        }

        public void stateChanged(ChangeEvent changeEvent) {
            JSlider jSlider = (JSlider)changeEvent.getSource();
            if (!jSlider.getValueIsAdjusting()) {
                BeeLauncherGUI.this.myLauncher.setDelay(20 - jSlider.getValue());
            }
        }
    }
}

