/*
 * Decompiled with CFR 0.152.
 */
package dynamicbees;

import dynamicbees.Bee;
import dynamicbees.BeeEnumerator;
import dynamicbees.QueenBee;
import dynamicbees.QueenBeeEnumerator;
import madkit.kernel.ReferenceableAgent;
import madkit.kernel.Watcher;

public class BeeEnvironment
extends Watcher
implements ReferenceableAgent {
    int screenWidth = 300;
    int screenHeight = 300;
    int queenMaxAcc = 5;
    int queenMaxVel = 12;
    int beeMaxAcc = 3;
    int beeMaxVel = 9;
    BeeEnumerator beeEnumerator;
    QueenBeeEnumerator queenEnumerator;

    public void setWidth(int n) {
        this.screenWidth = n;
    }

    public int getWidth() {
        return this.screenWidth;
    }

    public void setHeight(int n) {
        this.screenHeight = n;
    }

    public int getHeight() {
        return this.screenHeight;
    }

    public void setQueenAcceleration(int n) {
        this.queenMaxAcc = n;
    }

    public int getQueenAcceleration() {
        return this.queenMaxAcc;
    }

    public void setQueenVelocity(int n) {
        this.queenMaxVel = n;
    }

    public int getQueenVelocity() {
        return this.queenMaxVel;
    }

    public void setBeeAcceleration(int n) {
        this.beeMaxAcc = n;
    }

    public int getBeeAcceleration() {
        return this.beeMaxAcc;
    }

    public void setBeeVelocity(int n) {
        this.beeMaxVel = n;
    }

    public int getBeeVelocity() {
        return this.beeMaxVel;
    }

    public BeeEnvironment() {
    }

    public BeeEnvironment(int n, int n2) {
        this();
        this.screenWidth = n;
        this.screenHeight = n2;
    }

    public void updateQueenBees(QueenBee[] queenBeeArray) {
        for (int i = 0; i < queenBeeArray.length; ++i) {
            if (queenBeeArray[i].beeWorld == this) continue;
            queenBeeArray[i].setEnvironment(this);
        }
        if (queenBeeArray.length > 0) {
            Bee[] beeArray = this.beeEnumerator.getBees();
            for (int i = 0; i < beeArray.length; ++i) {
                beeArray[i].setQueenBee(queenBeeArray[(int)(Math.random() * (double)queenBeeArray.length)]);
            }
        }
    }

    public void updateBees(Bee[] beeArray) {
        QueenBee[] queenBeeArray = this.queenEnumerator.getQueenBees();
        for (int i = 0; i < beeArray.length; ++i) {
            if (beeArray[i].beeWorld == this) continue;
            beeArray[i].setEnvironment(this);
            if (queenBeeArray.length <= 0) continue;
            beeArray[i].setQueenBee(queenBeeArray[(int)(Math.random() * (double)queenBeeArray.length)]);
        }
    }

    public void activate() {
        this.createGroup(false, "bees", null, null);
        this.requestRole("buzz", "bee environment", null);
        this.beeEnumerator = new BeeEnumerator("bees", "bee", this);
        this.queenEnumerator = new QueenBeeEnumerator("bees", "queen bee", this);
        this.addProbe(this.queenEnumerator);
        this.addProbe(this.beeEnumerator);
    }

    public void end() {
        this.disposeMyGUI();
        super.end();
    }
}

