/*
 * Decompiled with CFR 0.152.
 */
package gnu.xquery.lang;

import gnu.bytecode.ClassType;
import gnu.bytecode.Type;
import gnu.expr.ApplyExp;
import gnu.expr.Compilation;
import gnu.expr.Declaration;
import gnu.expr.ErrorExp;
import gnu.expr.Expression;
import gnu.expr.IfExp;
import gnu.expr.LambdaExp;
import gnu.expr.LetExp;
import gnu.expr.Parser;
import gnu.expr.PrimProcedure;
import gnu.expr.QuoteExp;
import gnu.expr.ReferenceExp;
import gnu.expr.ScopeExp;
import gnu.expr.SetExp;
import gnu.kawa.lispexpr.LispReader;
import gnu.kawa.lispexpr.ReadTable;
import gnu.kawa.reflect.InstanceOf;
import gnu.kawa.xml.AttributeConstructor;
import gnu.kawa.xml.ElementConstructor;
import gnu.kawa.xml.ElementType;
import gnu.mapping.InPort;
import gnu.mapping.Procedure;
import gnu.mapping.WrappedException;
import gnu.math.DFloNum;
import gnu.math.IntNum;
import gnu.text.SourceMessages;
import gnu.text.SyntaxException;
import gnu.xml.QName;
import gnu.xquery.lang.XQuery;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.Hashtable;
import java.util.Vector;
import kawa.standard.Scheme;

public class XQParser
extends LispReader {
    int curToken;
    Object curValue;
    public static final InstanceOf instanceOf = new InstanceOf(XQuery.getInstance(), "instance");
    int nesting = 1;
    static final int EOF_TOKEN = -1;
    static final int EOL_TOKEN = 10;
    static final char INTEGER_TOKEN = '0';
    static final char FLOAT_TOKEN = '1';
    static final int STRING_TOKEN = 34;
    static final int SLASHSLASH_TOKEN = 68;
    static final int DOTDOT_TOKEN = 50;
    static final int COLONCOLON_TOKEN = 88;
    static final int NCNAME_TOKEN = 65;
    static final int NCNAME_COLON_TOKEN = 67;
    static final int QNAME_TOKEN = 81;
    static final int ARROW_TOKEN = 82;
    static final int FNAME_TOKEN = 70;
    static final int DEFINE_TOKEN = 78;
    static final int OP_AXIS_FIRST = 100;
    static final int COUNT_OP_AXIS = 13;
    static final int AXIS_ANCESTOR = 0;
    static final int AXIS_ANCESTOR_OR_SELF = 1;
    static final int AXIS_ATTRIBUTE = 2;
    static final int AXIS_CHILD = 3;
    static final int AXIS_DESCENDANT = 4;
    static final int AXIS_DESCENDANT_OR_SELF = 5;
    static final int AXIS_FOLLOWING = 6;
    static final int AXIS_FOLLOWING_SIBLING = 7;
    static final int AXIS_NAMESPACE = 8;
    static final int AXIS_PARENT = 9;
    static final int AXIS_PRECEDING = 10;
    static final int AXIS_PRECEDING_SIBLING = 11;
    static final int AXIS_SELF = 12;
    static final int OP_WHERE = 196;
    static final int OP_OR = 200;
    static final int OP_AND = 204;
    static final int OP_EQU = 208;
    static final int OP_NEQ = 209;
    static final int OP_INSTANCEOF = 210;
    static final int OP_RANGE_TO = 211;
    static final int OP_LSS = 212;
    static final int OP_GRT = 213;
    static final int OP_LEQ = 214;
    static final int OP_GEQ = 215;
    static final int OP_ADD = 216;
    static final int OP_SUB = 217;
    static final int OP_MUL = 220;
    static final int OP_DIV = 221;
    static final int OP_MOD = 222;
    static final int OP_INTERSECT = 224;
    static final int OP_EXCEPT = 225;
    static final int OP_UNION = 226;
    public static ReadTable xqlReadTable = ReadTable.getInitial();
    int count = 0;
    Parser parser;
    String defaultNamespace = "";
    Hashtable namespaces = new Hashtable(50);
    public static final String[] axisNames = new String[13];
    static final Expression funcNamedChildren;
    static final Expression funcNamedDescendants;

    final int skipSpace() throws IOException {
        int n;
        while ((n = this.read()) >= 0 && Character.isWhitespace((char)n)) {
        }
        return n;
    }

    final void skipComment() throws IOException, SyntaxException {
        int n = 0;
        int n2 = this.getLineNumber() + 1;
        while (true) {
            int n3;
            if ((n3 = this.read()) == 45) {
                ++n;
                continue;
            }
            if (n3 == 125 && n >= 2) {
                return;
            }
            if (n3 < 0) {
                this.eofError("non-terminated comment starting at line " + n2);
                continue;
            }
            n = 0;
        }
    }

    final int skipHSpace() throws IOException {
        int n;
        while ((n = this.read()) == 32 || n == 9) {
        }
        return n;
    }

    final int peekNonSpace(String string) throws IOException, SyntaxException {
        int n = this.skipSpace();
        if (n < 0) {
            this.eofError(string);
        }
        this.unread(n);
        return n;
    }

    boolean checkNext(char c) throws IOException {
        if (this.peek() != c) {
            return false;
        }
        this.skip();
        return true;
    }

    public static boolean isNameStart(char c) {
        return Character.isLetter(c) || c == '_';
    }

    public static boolean isNamePart(char c) {
        return Character.isUnicodeIdentifierPart(c) || c == '-' || c == '.';
    }

    int getRawToken() throws IOException, SyntaxException {
        int n;
        while (true) {
            if ((n = this.read()) < 0) {
                this.curToken = -1;
                return -1;
            }
            if (n == 10 || n == 13) {
                if (this.nesting > 0) continue;
                this.curToken = 10;
                return 10;
            }
            if (n == 123) {
                n = this.read();
                if (n != 45) {
                    this.unread(n);
                    this.curToken = 123;
                    return 123;
                }
                n = this.read();
                if (n != 45) {
                    this.unread();
                    this.unread();
                    this.curToken = 123;
                    return 123;
                }
                this.skipComment();
                continue;
            }
            if (n != 32 && n != 9) break;
        }
        this.tokenBufferLength = 0;
        int n2 = n;
        switch (n2) {
            case 36: 
            case 40: 
            case 41: 
            case 44: 
            case 58: 
            case 64: 
            case 91: 
            case 93: 
            case 125: {
                break;
            }
            case 124: {
                n2 = 226;
                break;
            }
            case 42: {
                n2 = 220;
                break;
            }
            case 43: {
                n2 = 216;
                break;
            }
            case 45: {
                n2 = 217;
                break;
            }
            case 33: {
                if (!this.checkNext('=')) break;
                n2 = 209;
                break;
            }
            case 47: {
                if (!this.checkNext('/')) break;
                n2 = 68;
                break;
            }
            case 61: {
                if (this.checkNext('>')) {
                    n2 = 82;
                }
                n2 = 208;
                break;
            }
            case 62: {
                n2 = this.checkNext('=') ? 215 : 213;
                break;
            }
            case 60: {
                n2 = this.checkNext('=') ? 214 : 212;
                break;
            }
            case 46: {
                if (this.checkNext('.')) {
                    n2 = 50;
                    break;
                }
                n = this.peek();
                if (!Character.isDigit((char)n)) break;
                this.tokenBufferAppend(46);
                do {
                    this.tokenBufferAppend((char)n);
                    this.skip();
                } while (Character.isDigit((char)(n = this.peek())));
                n2 = 49;
                break;
            }
            case 34: 
            case 39: {
                while (true) {
                    if ((n = this.read()) < 0) {
                        this.eofError("unexpected end-of-file in string");
                    }
                    if (n2 == n) break;
                    this.tokenBufferAppend((char)n);
                }
                n2 = 34;
                break;
            }
            default: {
                if (Character.isDigit((char)n2)) {
                    boolean bl = false;
                    while (true) {
                        this.tokenBufferAppend(n2);
                        n = this.read();
                        if (n < 0) break;
                        n2 = (char)n;
                        if (n2 == 46) {
                            if (bl) break;
                            bl = true;
                            continue;
                        }
                        if (!Character.isDigit((char)n2)) break;
                    }
                    if (n == 101 || n == 69) {
                        n = this.read();
                        if (n == 43 || n == 45) {
                            this.tokenBufferAppend((char)n);
                            n = this.read();
                        }
                        int n3 = 0;
                        while (n >= 0) {
                            n2 = (char)n;
                            if (!Character.isDigit((char)n2)) {
                                this.unread();
                                break;
                            }
                            this.tokenBufferAppend(n2);
                            n = this.read();
                            ++n3;
                        }
                        if (n3 == 0) {
                            this.error("no digits following exponent");
                        }
                        n2 = 49;
                        break;
                    }
                    int n4 = n2 = bl ? 49 : 48;
                    if (n < 0) break;
                    this.unread(n);
                    break;
                }
                if (XQParser.isNameStart((char)n2)) {
                    do {
                        this.tokenBufferAppend(n2);
                    } while (XQParser.isNamePart((char)(n2 = (int)((char)(n = this.read())))));
                    if (n < 0) {
                        n2 = 65;
                        break;
                    }
                    if (n != 58) {
                        n2 = 65;
                    } else {
                        n = this.read();
                        if (n < 0) {
                            this.eofError("unexpected end-of-file after NAME ':'");
                        }
                        if (XQParser.isNameStart((char)(n2 = (int)((char)n)))) {
                            this.tokenBufferAppend(58);
                            do {
                                this.tokenBufferAppend(n2);
                            } while (XQParser.isNamePart((char)(n2 = (int)((char)(n = this.read())))));
                            n2 = 81;
                        } else {
                            n2 = 67;
                        }
                    }
                    this.unread(n);
                    break;
                }
                if (n2 >= 32 && n2 < 127) {
                    this.error("invalid character '" + (char)n2 + '\'');
                    break;
                }
                this.error("invalid character '\\u" + Integer.toHexString(n2) + '\'');
            }
        }
        this.curToken = n2;
        return n2;
    }

    public void appendNamedEntity(String string, StringBuffer stringBuffer) {
        string = string.intern();
        int n = 63;
        if (string == "lt") {
            n = 60;
        } else if (string == "gt") {
            n = 62;
        } else if (string == "amp") {
            n = 38;
        } else if (string == "quot") {
            n = 34;
        } else if (string == "apos") {
            n = 39;
        } else {
            this.error("unknown enity reference: '" + string + "'");
        }
        stringBuffer.append((char)n);
    }

    int peekOperator() throws IOException, SyntaxException {
        while (this.curToken == 10) {
            this.getRawToken();
        }
        if (this.curToken == 65) {
            int n = this.tokenBufferLength;
            if (n == 2 || n == 3) {
                char c = this.tokenBuffer[0];
                if (n == 2) {
                    if (c == 'o' && this.tokenBuffer[1] == 'r') {
                        this.curToken = 200;
                    } else if (c == 't' && this.tokenBuffer[1] == 'o') {
                        this.curToken = 211;
                    }
                } else {
                    char c2 = this.tokenBuffer[1];
                    char c3 = this.tokenBuffer[2];
                    if (c == 'a') {
                        if (c2 == 'n' && c3 == 'd') {
                            this.curToken = 204;
                        }
                    } else if (c == 'm') {
                        if (c2 == 'u' && c3 == 'l') {
                            this.curToken = 220;
                        }
                        if (c2 == 'o' && c3 == 'd') {
                            this.curToken = 222;
                        }
                    } else if (c == 'd' && c2 == 'i' && c3 == 'v') {
                        this.curToken = 221;
                    }
                }
            } else if (n == 5) {
                if (this.match("where")) {
                    this.curToken = 196;
                }
            } else if (n == 10) {
                int n2 = 0;
                while (true) {
                    if (n2 == 10) {
                        this.curToken = 210;
                        break;
                    }
                    if (this.tokenBuffer[n2] != "instanceof".charAt(n2)) break;
                    ++n2;
                }
            }
        }
        return this.curToken;
    }

    int peekOperand() throws IOException, SyntaxException {
        while (this.curToken == 10) {
            this.getRawToken();
        }
        if (this.curToken == 65 || this.curToken == 81) {
            int n;
            String string = new String(this.tokenBuffer, 0, this.tokenBufferLength);
            this.curValue = string;
            int n2 = n = this.nesting == 0 ? this.skipHSpace() : this.skipSpace();
            if (n == 40 && !string.equals("if")) {
                this.curToken = 70;
                return 70;
            }
            if ((n == 102 || n == 70) && "define".equals(string)) {
                this.unread();
                this.curToken = 78;
                return 78;
            }
            if (n >= 0) {
                this.unread();
            }
            return this.curToken;
        }
        if (this.curToken == 67) {
            int n = this.read();
            if (n == 58) {
                String string = new String(this.tokenBuffer, 0, this.tokenBufferLength).intern();
                int n3 = 13;
                while (--n3 >= 0) {
                    if (axisNames[n3] == string) break;
                }
                if (n3 >= 0) {
                    this.curToken = (char)(100 + n3);
                } else {
                    this.error("unknown axis name '" + string + '\'');
                }
                this.curValue = string;
            } else {
                this.unread(n);
            }
        }
        return this.curToken;
    }

    public XQParser(InPort inPort) {
        super(inPort);
    }

    public XQParser(InPort inPort, SourceMessages sourceMessages) {
        super(inPort, sourceMessages);
    }

    public void setInteractive(boolean bl) {
        if (this.interactive != bl) {
            this.nesting = bl ? --this.nesting : ++this.nesting;
        }
        this.interactive = bl;
    }

    protected ReadTable getReadTable() {
        return xqlReadTable;
    }

    public static Object readObject(InPort inPort) throws IOException, SyntaxException {
        return new XQParser(inPort).readObject();
    }

    private static final int priority(int n) {
        return n >> 2;
    }

    Expression parseExpr() throws IOException, SyntaxException {
        return this.parseSortExpr();
    }

    static Expression makeBinary(Expression expression, Expression expression2, Expression expression3) {
        Expression[] expressionArray = new Expression[]{expression2, expression3};
        return new ApplyExp(expression, expressionArray);
    }

    static Expression makeExprSequence(Expression expression, Expression expression2) {
        return XQParser.makeBinary(XQParser.makeFunctionExp("gnu.kawa.functions.AppendValues", "appendValues"), expression, expression2);
    }

    Expression makeBinary(int n, Expression expression, Expression expression2) {
        Expression expression3;
        switch (n) {
            case 216: {
                expression3 = XQParser.makeFunctionExp("gnu.kawa.functions.AddOp", "+");
                break;
            }
            case 217: {
                expression3 = XQParser.makeFunctionExp("gnu.kawa.functions.AddOp", "-");
                break;
            }
            case 220: {
                expression3 = XQParser.makeFunctionExp("gnu.kawa.functions.MultiplyOp", "$St", "mul");
                break;
            }
            case 221: {
                expression3 = XQParser.makeFunctionExp("gnu.kawa.functions.DivideOp", "$Sl", "div");
                break;
            }
            case 222: {
                expression3 = new QuoteExp(new PrimProcedure(ClassType.make("gnu.math.IntNum").getDeclaredMethod("remainder", 2)));
                break;
            }
            case 208: {
                expression3 = XQParser.makeFunctionExp("gnu.xquery.util.Compare", "=");
                break;
            }
            case 209: {
                expression3 = XQParser.makeFunctionExp("gnu.xquery.util.Compare", "!=");
                break;
            }
            case 212: {
                expression3 = XQParser.makeFunctionExp("gnu.xquery.util.Compare", "<");
                break;
            }
            case 214: {
                expression3 = XQParser.makeFunctionExp("gnu.xquery.util.Compare", "<=");
                break;
            }
            case 213: {
                expression3 = XQParser.makeFunctionExp("gnu.xquery.util.Compare", ">");
                break;
            }
            case 215: {
                expression3 = XQParser.makeFunctionExp("gnu.xquery.util.Compare", ">=");
                break;
            }
            case 211: {
                expression3 = XQParser.makeFunctionExp("gnu.xquery.util.IntegerRange", "integerRange");
                break;
            }
            default: {
                return new ErrorExp("unimplemented binary op: " + n);
            }
        }
        return XQParser.makeBinary(expression3, expression, expression2);
    }

    Expression parseSortExpr() throws IOException, SyntaxException {
        Expression expression = this.parseBinaryExpr(XQParser.priority(200));
        return expression;
    }

    public Expression parseElementType() throws IOException, SyntaxException {
        QName qName = this.parseNameTest(this.defaultNamespace);
        this.getRawToken();
        return new QuoteExp(new ElementType(qName));
    }

    public Expression parseDataType() throws IOException, SyntaxException {
        if (this.curToken == 65 || this.curToken == 81) {
            String string = new String(this.tokenBuffer, 0, this.tokenBufferLength);
            this.getRawToken();
            if ("element".equalsIgnoreCase(string)) {
                return this.parseElementType();
            }
            Type type = Scheme.getNamedType(string);
            return new QuoteExp(type);
        }
        this.getRawToken();
        return this.syntaxError("bad syntax - expected DataType");
    }

    Expression parseBinaryExpr(int n) throws IOException, SyntaxException {
        Expression expression = this.parseUnaryExpr();
        while (this.nesting != 0 || this.curToken != 10) {
            Expression[] expressionArray;
            int n2 = this.peekOperator();
            if (n2 == 212 && this.peek() == 47) {
                return expression;
            }
            int n3 = XQParser.priority(n2);
            if (n3 < n || n3 > 55) {
                return expression;
            }
            this.getRawToken();
            if (n2 == 210) {
                expressionArray = new Expression[]{expression, this.parseDataType()};
                expression = new ApplyExp(XQParser.makeFunctionExp("gnu.xquery.lang.XQParser", "instanceOf"), expressionArray);
                continue;
            }
            expressionArray = this.parseBinaryExpr(n3 + 1);
            if (n2 == 204) {
                expression = new IfExp(expression, (Expression)expressionArray, QuoteExp.falseExp);
                continue;
            }
            expression = this.makeBinary(n2, expression, (Expression)expressionArray);
        }
        return expression;
    }

    Expression parseUnaryExpr() throws IOException, SyntaxException {
        Expression expression;
        if (this.curToken == 217 || this.curToken == 216) {
            this.getRawToken();
            expression = this.parseUnionExpr();
            expression = this.syntaxError("non-trivial UnaryExpr not implemented");
        } else {
            expression = this.parseUnionExpr();
        }
        return expression;
    }

    Expression parseUnionExpr() throws IOException, SyntaxException {
        Expression expression = this.parseIntersectExceptExpr();
        while (this.curToken == 226) {
            int n = this.curToken;
            this.getRawToken();
            Expression expression2 = this.parseIntersectExceptExpr();
            expression = this.makeBinary(n, expression, expression2);
        }
        return expression;
    }

    Expression parseIntersectExceptExpr() throws IOException, SyntaxException {
        Expression expression = this.parsePathExpr();
        while (this.curToken == 224 || this.curToken == 225) {
            int n = this.curToken;
            this.getRawToken();
            Expression expression2 = this.parsePathExpr();
            expression = this.makeBinary(n, expression, expression2);
        }
        return expression;
    }

    Expression parsePathExpr() throws IOException, SyntaxException {
        if (this.curToken == 47 || this.curToken == 68) {
            return this.syntaxError("unimplemented non-relative PathExpr");
        }
        return this.parseRelativePathExpr();
    }

    Expression parseNodeTest(int n) throws IOException, SyntaxException {
        Declaration declaration = this.parser.lookup("dot", -1);
        return this.parseNodeTest(new ReferenceExp("dot", declaration), n);
    }

    QName parseNameTest(String string) throws IOException, SyntaxException {
        String string2 = null;
        String string3 = null;
        if (this.curToken == 81) {
            int n = this.tokenBufferLength;
            while (this.tokenBuffer[--n] != ':') {
            }
            String string4 = new String(this.tokenBuffer, 0, n);
            string2 = new String(this.tokenBuffer, ++n, this.tokenBufferLength - n);
            string3 = (String)this.namespaces.get(string4);
            if (string3 == null) {
                this.syntaxError("unknown namespace '" + string4 + "'");
            }
        } else if (this.curToken == 220) {
            int n = this.read();
            if (n != 58) {
                this.unread(n);
            } else {
                n = this.read();
                if (n < 0) {
                    this.eofError("unexpected end-of-file after '*:'");
                }
                if (XQParser.isNameStart((char)n)) {
                    this.unread();
                    this.getRawToken();
                    if (this.curToken != 65) {
                        this.syntaxError("invalid name test");
                    } else {
                        string2 = new String(this.tokenBuffer, 0, this.tokenBufferLength);
                    }
                } else if (n != 42) {
                    this.syntaxError("missing local-name after '*:'");
                }
            }
        } else if (this.curToken == 65) {
            string2 = new String(this.tokenBuffer, 0, this.tokenBufferLength);
            string3 = string;
        } else if (this.curToken == 67) {
            String string5 = new String(this.tokenBuffer, 0, this.tokenBufferLength);
            int n = this.read();
            if (n != 42) {
                this.syntaxError("invalid characters after 'NCName:'");
                return QName.make(string, string5);
            }
            string3 = (String)this.namespaces.get(string5);
            if (string3 == null) {
                this.syntaxError("unknown namespace '" + string5 + "'");
            }
            string2 = null;
        }
        return QName.make(string3, string2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    Expression parseNodeTest(Expression expression, int n) throws IOException, SyntaxException {
        ApplyExp applyExp;
        if (!(n >= 0 && n != 3 && n != 4 || this.curToken != 65 && this.curToken != 81 && this.curToken != 67 && this.curToken != 220)) {
            QName qName = this.parseNameTest(this.defaultNamespace);
            Expression[] expressionArray = new Expression[]{expression, new QuoteExp(qName.getNamespaceURI()), new QuoteExp(qName.getLocalName())};
            Expression expression2 = n == 4 ? funcNamedDescendants : funcNamedChildren;
            applyExp = new ApplyExp(expression2, expressionArray);
        } else if (this.curToken == 64 && n < 0 || n == 2) {
            if (n < 0) {
                this.getRawToken();
            }
            if (this.curToken != 65 && this.curToken != 81 && this.curToken != 67 && this.curToken != 220) return this.syntaxError("missing name or '*' after '@' or attribute::");
            QName qName = this.parseNameTest(null);
            Expression[] expressionArray = new Expression[]{expression, new QuoteExp(qName.getNamespaceURI()), new QuoteExp(qName.getLocalName())};
            applyExp = new ApplyExp(XQParser.makeFunctionExp("gnu.kawa.xml.NamedAttributes", "namedAttributes"), expressionArray);
        } else {
            if (n < 0) return null;
            return this.syntaxError("unsupported axis '" + axisNames[n] + "::'");
        }
        this.getRawToken();
        return applyExp;
    }

    Expression parseRelativePathExpr() throws IOException, SyntaxException {
        Expression expression = this.parseStepExpr();
        while (this.curToken == 47 || this.curToken == 68) {
            Expression[] expressionArray;
            int n = this.curToken;
            boolean bl = this.curToken == 68;
            this.getRawToken();
            LambdaExp lambdaExp = new LambdaExp(1);
            Declaration declaration = lambdaExp.addDeclaration("dot");
            declaration.setFlag(262144);
            declaration.noteValue(null);
            this.parser.push(lambdaExp);
            lambdaExp.body = this.parseStepExpr();
            this.parser.pop(lambdaExp);
            boolean bl2 = false;
            if (lambdaExp.body instanceof ApplyExp) {
                expressionArray = (Expression[])lambdaExp.body;
                Expression expression2 = expressionArray.getFunction();
                Expression[] expressionArray2 = expressionArray.getArgs();
                if (expression2 == funcNamedChildren && expressionArray2.length == 3 && expressionArray2[0] instanceof ReferenceExp && ((ReferenceExp)expressionArray2[0]).getBinding() == declaration) {
                    expressionArray2[0] = expression;
                    if (bl) {
                        expression2 = funcNamedDescendants;
                    }
                    expression = new ApplyExp(expression2, expressionArray2);
                    bl2 = true;
                }
            }
            if (bl2) continue;
            if (bl) {
                return this.syntaxError("// not implemented except as //NAME");
            }
            expressionArray = new Expression[]{lambdaExp, expression};
            expression = new ApplyExp(XQParser.makeFunctionExp("gnu.kawa.functions.ValuesMap", "valuesMap"), expressionArray);
        }
        return expression;
    }

    Expression parseStepExpr() throws IOException, SyntaxException {
        int n = this.peekOperand() - 100;
        if (n >= 0 && n < 13) {
            this.getRawToken();
            return this.parseStepQualifiers(this.parseNodeTest(n));
        }
        return this.parseOtherStepExpr();
    }

    Expression parseStepQualifiers(Expression expression) throws IOException, SyntaxException {
        while (this.curToken == 91) {
            int n = this.getLineNumber() + 1;
            int n2 = this.getColumnNumber() + 1;
            this.getRawToken();
            LambdaExp lambdaExp = new LambdaExp(1);
            lambdaExp.setFile(this.getName());
            lambdaExp.setLine(n, n2);
            this.parser.push(lambdaExp);
            Declaration declaration = lambdaExp.addDeclaration("dot");
            declaration.noteValue(null);
            Expression expression2 = this.parseExpr();
            expression2.setFile(this.getName());
            expression2.setLine(n, n2);
            this.parser.pop(lambdaExp);
            lambdaExp.body = expression2;
            if (this.curToken != 93) {
                return this.syntaxError("missing ']'");
            }
            this.getRawToken();
            Expression[] expressionArray = new Expression[]{expression, lambdaExp};
            expression = new ApplyExp(XQParser.makeFunctionExp("gnu.xquery.util.ValuesFilter", "valuesFilter"), expressionArray);
        }
        return expression;
    }

    Expression parseOtherStepExpr() throws IOException, SyntaxException {
        Expression expression = this.parsePrimaryExpr();
        expression = this.parseStepQualifiers(expression);
        return expression;
    }

    Expression parsePrimaryExpr() throws IOException, SyntaxException {
        Expression expression = this.parseMaybePrimaryExpr();
        if (expression == null) {
            return this.syntaxError("missing PrimaryExpr");
        }
        return expression;
    }

    void parseContent(int n, Vector vector) throws IOException, SyntaxException {
        StringBuffer stringBuffer = new StringBuffer();
        while (true) {
            Object object2;
            int n2;
            if (((n2 = this.read()) < 0 || n2 == 123 || n2 == n) && stringBuffer.length() > 0) {
                vector.addElement(new QuoteExp(stringBuffer.toString()));
                stringBuffer.setLength(0);
            }
            if (n2 < 0) {
                this.eofError("unexpected end-of-file");
            }
            if (n2 == 123) {
                n2 = this.read();
                if (n2 == 123) {
                    stringBuffer.append('{');
                    continue;
                }
                this.unread(n2);
                object2 = this.parseEnclosedExpr();
                if (n != 60) {
                    object2 = this.stringValue((Expression)object2);
                }
                vector.addElement(object2);
                continue;
            }
            if (n2 == 125) {
                n2 = this.read();
                if (n2 == 125) {
                    stringBuffer.append('}');
                    continue;
                }
                this.error("unexpected '}' in element content");
                this.unread(n2);
                continue;
            }
            if (n2 == 60 && n == 60) {
                n2 = this.read();
                if (n2 == 47) break;
                this.unread(n2);
                this.getRawToken();
                object2 = this.parseElementConstructor();
                if (n != 60) {
                    object2 = this.stringValue((Expression)object2);
                }
                vector.addElement(object2);
                continue;
            }
            if (n2 == n) break;
            if (n2 == 38) {
                object2 = new StringBuffer(30);
                int n3 = 0;
                n2 = this.read();
                if (n2 == 35) {
                    n2 = this.read();
                    if (n2 == 120) {
                        n3 = 16;
                        n2 = this.read();
                    }
                    n3 = 10;
                }
                while (n2 >= 0) {
                    char c = (char)n2;
                    if (!XQParser.isNamePart(c)) break;
                    ((StringBuffer)object2).append(c);
                    n2 = this.read();
                }
                if (n2 != 59) {
                    this.error("invalid entity/character reference");
                    continue;
                }
                String string = ((StringBuffer)object2).toString();
                if (n3 == 0) {
                    this.appendNamedEntity(string, stringBuffer);
                    continue;
                }
                try {
                    stringBuffer.append((char)Integer.parseInt(string, n3));
                }
                catch (NumberFormatException numberFormatException) {
                    this.error("invalid character references");
                }
                continue;
            }
            stringBuffer.append((char)n2);
        }
    }

    Expression parseEnclosedExpr() throws IOException, SyntaxException {
        this.peekNonSpace("unexpected end-of-file after '{'");
        int n = this.getLineNumber() + 1;
        int n2 = this.getColumnNumber() + 1;
        this.getRawToken();
        ++this.nesting;
        Expression expression = this.parseExpr();
        --this.nesting;
        while (this.curToken == 44) {
            this.getRawToken();
            expression = XQParser.makeExprSequence(expression, this.parseExpr());
        }
        expression.setFile(this.getName());
        expression.setLine(n, n2);
        if (this.curToken != 125) {
            return this.syntaxError("missing '}'");
        }
        return expression;
    }

    Expression stringValue(Expression expression) {
        Expression[] expressionArray = new Expression[]{expression};
        Expression expression2 = XQParser.makeFunctionExp("gnu.xquery.util.StringValue", "string");
        return new ApplyExp(expression2, expressionArray);
    }

    Expression parseNameSpec(String string, boolean bl) throws IOException, SyntaxException {
        if (this.curToken == 65 || this.curToken == 81) {
            String string2 = new String(this.tokenBuffer, 0, this.tokenBufferLength);
            QName qName = this.curToken == 65 ? QName.make(string, string2) : this.parseNameTest(string);
            return new QuoteExp(bl ? AttributeConstructor.make(string2, qName) : ElementConstructor.make(string2, qName));
        }
        if (this.curToken == 123) {
            return this.parseEnclosedExpr();
        }
        return null;
    }

    Expression parseElementConstructor() throws IOException, SyntaxException {
        Object[] objectArray;
        Object object2;
        int n;
        int n2;
        ++this.nesting;
        Vector<Expression> vector = new Vector<Expression>();
        Expression expression = this.parseNameSpec(this.defaultNamespace, false);
        vector.addElement(expression);
        if (expression == null) {
            return this.syntaxError("missing NameSpec");
        }
        while ((n2 = this.skipSpace()) >= 0 && n2 != 62 && n2 != 47) {
            this.unread(n2);
            this.getRawToken();
            n = vector.size();
            object2 = this.parseNameSpec(null, true);
            if (object2 == null) break;
            if (!(object2 instanceof QuoteExp) || !(((QuoteExp)object2).getValue() instanceof AttributeConstructor)) {
                vector.addElement((Expression)object2);
                object2 = XQParser.makeFunctionExp("gnu.xquery.util.MakeAttribute", "makeAttribute");
            }
            if ((n2 = this.skipSpace()) != 61) {
                return this.syntaxError("missing '=' after attribute");
            }
            n2 = this.skipSpace();
            if (n2 == 123) {
                vector.addElement(this.stringValue(this.parseEnclosedExpr()));
            } else {
                this.parseContent(n2, vector);
            }
            objectArray = new Expression[vector.size() - n];
            int n3 = objectArray.length;
            while (--n3 >= 0) {
                objectArray[n3] = (Expression)vector.elementAt(n + n3);
            }
            vector.setSize(n);
            vector.addElement(new ApplyExp((Expression)object2, (Expression[])objectArray));
        }
        n = 0;
        if (n2 == 47) {
            n2 = this.read();
            if (n2 == 62) {
                n = 1;
            } else {
                this.unread(n2);
            }
        }
        if (n == 0) {
            if (n2 != 62) {
                return this.syntaxError("missing '>' after start element");
            }
            this.parseContent(60, vector);
            n2 = this.skipSpace();
            if (n2 >= 0 && n2 != 62) {
                String string;
                this.unread(n2);
                this.getRawToken();
                if (this.curToken != 65 && this.curToken != 81) {
                    return this.syntaxError("invalid tag syntax after '</'");
                }
                if (!(expression instanceof QuoteExp)) {
                    return this.syntaxError("'<{'expression'}>' must be closed by '</>'");
                }
                object2 = new String(this.tokenBuffer, 0, this.tokenBufferLength);
                Object object3 = ((QuoteExp)expression).getValue();
                String string2 = string = object3 instanceof ElementConstructor ? ((ElementConstructor)object3).getXmlName() : object3.toString();
                if (!((String)object2).equals(string)) {
                    return this.syntaxError("'<" + string + ">' closed by '</" + (String)object2 + ">'");
                }
                n2 = this.skipSpace();
            }
            if (n2 != 62) {
                return this.syntaxError("missing '>' after end element");
            }
        }
        objectArray = new Expression[vector.size()];
        vector.copyInto(objectArray);
        --this.nesting;
        return new ApplyExp(XQParser.makeFunctionExp("gnu.xquery.util.MakeElement", "makeElement"), (Expression[])objectArray);
    }

    Expression parseExprSequence() throws IOException, SyntaxException {
        if (this.curToken == 41 || this.curToken == -1) {
            return QuoteExp.voidExp;
        }
        Expression expression = null;
        while (true) {
            Expression expression2 = this.parseExpr();
            Expression expression3 = expression = expression == null ? expression2 : XQParser.makeExprSequence(expression, expression2);
            if (this.curToken == 41 || this.curToken == -1) break;
            if (this.nesting == 0 && this.curToken == 10) {
                return expression;
            }
            if (this.curToken != 44) {
                return this.syntaxError("missing ')' - saw " + new String(this.tokenBuffer, 0, this.tokenBufferLength) + " @:" + this.getColumnNumber());
            }
            this.getRawToken();
        }
        return expression;
    }

    Expression parseTypeSwitch() throws IOException, SyntaxException {
        Object object2;
        Expression expression;
        this.getRawToken();
        Expression expression2 = this.parseExpr();
        if (this.curToken != 41) {
            return this.syntaxError("missing ')' after 'typeswitch' selector");
        }
        this.getRawToken();
        Object object3 = null;
        Vector<Object> vector = new Vector<Object>();
        vector.addElement(expression2);
        if (this.match("as")) {
            this.getRawToken();
            if (this.curToken == 36) {
                this.getRawToken();
                if (this.curToken == 81 || this.curToken == 65) {
                    object3 = new String(this.tokenBuffer, 0, this.tokenBufferLength).intern();
                }
            }
            if (object3 == null) {
                return this.syntaxError("missing Variable after 'as' clause");
            }
            this.getRawToken();
        }
        String string = object3 == null ? "$arg$" : object3.toString();
        while (this.match("case")) {
            Expression expression3;
            this.getRawToken();
            expression = this.parseDataType();
            object2 = new LambdaExp(1);
            Declaration declaration = object2.addDeclaration(string, (Type)((QuoteExp)expression).getValue());
            if (this.match("return")) {
                this.getRawToken();
            } else {
                this.error("missing 'return' after 'case'");
            }
            this.parser.push((ScopeExp)object2);
            object2.body = expression3 = this.parseExpr();
            this.parser.pop((ScopeExp)object2);
            vector.addElement(object2);
        }
        expression = new LambdaExp(0);
        if (this.match("default")) {
            this.getRawToken();
            if (this.match("return")) {
                this.getRawToken();
            } else {
                this.error("missing 'return' after 'default'");
            }
            this.parser.push((ScopeExp)expression);
            expression.body = object2 = this.parseExpr();
            this.parser.pop((ScopeExp)expression);
        } else {
            expression.body = QuoteExp.voidExp;
            this.error('w', "no 'default' clause in 'typeswitch'");
        }
        vector.addElement(expression);
        object2 = new Expression[vector.size()];
        vector.copyInto((Object[])object2);
        return new ApplyExp(XQParser.makeFunctionExp("gnu.kawa.reflect.TypeSwitch", "typeSwitch"), (Expression[])object2);
    }

    Expression parseMaybePrimaryExpr() throws IOException, SyntaxException {
        Expression expression;
        int n = this.getLineNumber() + 1;
        int n2 = this.getColumnNumber() + 1;
        int n3 = this.peekOperand();
        if (n3 == 40) {
            this.getRawToken();
            ++this.nesting;
            expression = this.parseExprSequence();
            --this.nesting;
            if (this.curToken == -1) {
                this.eofError("missing ')' - unexpected end-of-file");
            }
        } else if (n3 == 212) {
            --n2;
            this.getRawToken();
            if (this.curToken == 47) {
                this.getRawToken();
                String string = this.curToken == 65 || this.curToken == 81 || this.curToken == 67 ? "saw end tag '</" + new String(this.tokenBuffer, 0, this.tokenBufferLength) + ">' not in an element constructor" : "saw end tag '</' not in an element constructor";
                Expression expression2 = this.syntaxError(string);
                while (this.curToken != 213 && this.curToken != -1 && this.curToken != 10) {
                    this.getRawToken();
                }
                return expression2;
            }
            expression = this.parseElementConstructor();
            expression.setFile(this.getName());
            expression.setLine(n, n2);
        } else if (n3 == 34) {
            expression = new QuoteExp(new String(this.tokenBuffer, 0, this.tokenBufferLength));
        } else if (n3 == 48) {
            IntNum intNum = IntNum.valueOf(this.tokenBuffer, 0, this.tokenBufferLength, 10, false);
            expression = new QuoteExp(intNum);
        } else if (n3 == 49) {
            DFloNum dFloNum = new DFloNum(new String(this.tokenBuffer, 0, this.tokenBufferLength));
            expression = new QuoteExp(dFloNum);
        } else if (n3 == 36) {
            int n4 = this.peek();
            if (n4 < 0 || Character.isWhitespace((char)n4)) {
                return this.syntaxError("missing name after variable-name operator '$'");
            }
            this.getRawToken();
            String string = new String(this.tokenBuffer, 0, this.tokenBufferLength).intern();
            Declaration declaration = this.parser.lookup(string, -1);
            expression = null;
            if (declaration == null && Compilation.generateServletDefault) {
                if (string == "request") {
                    expression = XQParser.makeFunctionExp("gnu.kawa.servlet.GetRequest", "getRequest");
                }
                if (string == "response") {
                    expression = XQParser.makeFunctionExp("gnu.kawa.servlet.GetResponse", "getResponse");
                }
                if (expression != null) {
                    expression = new ApplyExp(expression, Expression.noExpressions);
                }
            }
            if (expression == null) {
                expression = new ReferenceExp(string, declaration);
            }
        } else if (n3 == 70) {
            Object[] objectArray;
            String string = new String(this.tokenBuffer, 0, this.tokenBufferLength);
            if (string.equals("typeswitch")) {
                return this.parseTypeSwitch();
            }
            n2 -= this.tokenBufferLength;
            string = string.intern();
            ++this.nesting;
            this.getRawToken();
            Vector<Object[]> vector = new Vector<Object[]>(10);
            if (this.curToken != 41) {
                while (true) {
                    objectArray = this.parseExpr();
                    vector.addElement(objectArray);
                    if (this.curToken == 41) break;
                    if (this.curToken != 44) {
                        return this.syntaxError("missing ')' after function call");
                    }
                    this.getRawToken();
                }
            }
            objectArray = new Expression[vector.size()];
            vector.copyInto(objectArray);
            Declaration declaration = this.parser.lookup(string, 2);
            expression = new ApplyExp(new ReferenceExp(string, declaration), (Expression[])objectArray);
            expression.setFile(this.getName());
            expression.setLine(n, n2);
            --this.nesting;
        } else {
            if (n3 == 65 || n3 == 81) {
                int n5;
                int n6 = n5 = this.nesting == 0 ? this.skipHSpace() : this.skipSpace();
                if (n5 == 36) {
                    int n7 = -1;
                    if (this.tokenBufferLength == 3) {
                        char c = this.tokenBuffer[0];
                        char c2 = this.tokenBuffer[1];
                        char c3 = this.tokenBuffer[2];
                        if (c == 'l' && c2 == 'e' && c3 == 't') {
                            n7 = 0;
                        } else if (c == 'f' && c2 == 'o' && c3 == 'r') {
                            n7 = 1;
                        }
                    }
                    if (n7 < 0) {
                        throw new Error("invalid syntax - variable following name");
                    }
                    Expression expression3 = this.parseFLWRExpression(n7 > 0);
                    expression3.setFile(this.getName());
                    expression3.setLine(n, n2 - 3);
                    return expression3;
                }
                if (n5 == 40 && this.tokenBufferLength == 2 && this.tokenBuffer[0] == 'i' && this.tokenBuffer[1] == 'f') {
                    return this.parseIfExpr();
                }
                if (n5 >= 0) {
                    this.unread();
                }
                return this.parseNodeTest(-1);
            }
            if (n3 == 220 || n3 == 67 || n3 == 64) {
                return this.parseNodeTest(-1);
            }
            return null;
        }
        this.getRawToken();
        return expression;
    }

    public Expression parseIfExpr() throws IOException, SyntaxException {
        this.getRawToken();
        ++this.nesting;
        Expression expression = this.parseExpr();
        if (this.curToken != 41) {
            return this.syntaxError("missing ')' after 'if (EXPR'");
        }
        this.getRawToken();
        if (this.curToken != 65 || this.tokenBufferLength != 4 || !new String(this.tokenBuffer, 0, 4).equalsIgnoreCase("then")) {
            return this.syntaxError("missing 'then'");
        }
        this.getRawToken();
        Expression expression2 = this.parseExpr();
        if (this.curToken != 65 || this.tokenBufferLength != 4 || !new String(this.tokenBuffer, 0, 4).equalsIgnoreCase("else")) {
            return this.syntaxError("missing 'else'");
        }
        this.getRawToken();
        --this.nesting;
        Expression expression3 = this.parseExpr();
        return new IfExp(expression, expression2, expression3);
    }

    public boolean match(String string) {
        if (this.curToken != 65) {
            return false;
        }
        int n = string.length();
        if (this.tokenBufferLength != n) {
            return false;
        }
        int n2 = n;
        while (--n2 >= 0) {
            char c;
            char c2 = string.charAt(n2);
            if (c2 == (c = this.tokenBuffer[n2])) continue;
            return false;
        }
        return true;
    }

    public Expression parseFLWRExpression(boolean bl, String string, Expression expression) throws IOException, SyntaxException {
        Expression expression2;
        ScopeExp scopeExp;
        Object object2;
        Expression[] expressionArray = new Expression[]{expression};
        if (bl) {
            object2 = new LambdaExp(1);
            scopeExp = object2;
        } else {
            object2 = new LetExp(expressionArray);
            scopeExp = object2;
        }
        object2 = scopeExp.addDeclaration(string);
        if (bl) {
            ((Declaration)object2).noteValue(null);
            ((Declaration)object2).setFlag(262144);
        }
        this.parser.push(scopeExp);
        if (this.curToken == 44) {
            int n = this.skipSpace();
            if (n != 36) {
                return this.syntaxError("missin $NAME after ','");
            }
            expression2 = this.parseFLWRExpression(bl);
        } else {
            Expression expression3;
            if (this.curToken == 196) {
                this.getRawToken();
                expression3 = this.parseBinaryExpr(XQParser.priority(200));
            } else {
                expression3 = this.match("where") ? this.parseBinaryExpr(XQParser.priority(200)) : null;
            }
            boolean bl2 = this.match("return");
            if (!(bl2 || this.match("let") || this.match("let"))) {
                return this.syntaxError("missing 'return' clause");
            }
            this.peekNonSpace("unexpected eof-of-file after 'return'");
            int n = this.getLineNumber() + 1;
            int n2 = this.getColumnNumber() + 1;
            if (bl2) {
                this.getRawToken();
            }
            expression2 = this.parseExpr();
            if (expression3 != null) {
                expression2 = new IfExp(expression3, expression2, QuoteExp.voidExp);
            }
            expression2.setFile(this.getName());
            expression2.setLine(n, n2);
        }
        if (bl) {
            ((LambdaExp)scopeExp).body = expression2;
            Expression[] expressionArray2 = new Expression[]{scopeExp, expressionArray[0]};
            return new ApplyExp(XQParser.makeFunctionExp("gnu.kawa.functions.ValuesMap", "valuesMap"), expressionArray2);
        }
        ((LetExp)scopeExp).setBody(expression2);
        return scopeExp;
    }

    public Expression parseFLWRExpression(boolean bl) throws IOException, SyntaxException {
        this.getRawToken();
        if (this.curToken != 81 && this.curToken != 65 && this.curToken != 67) {
            return this.syntaxError("missing Variable token:" + this.curToken);
        }
        String string = new String(this.tokenBuffer, 0, this.tokenBufferLength).intern();
        if (this.curToken == 67) {
            this.curToken = 58;
        } else {
            this.getRawToken();
        }
        if (bl) {
            if (!this.match("in")) {
                return this.syntaxError("missing 'in' in 'for' clause");
            }
        } else if (this.curToken != 58 || this.getRawToken() != 208) {
            return this.syntaxError("missing ':=' in 'let' clause - " + this.curToken);
        }
        this.getRawToken();
        Expression expression = this.parseBinaryExpr(XQParser.priority(200));
        return this.parseFLWRExpression(bl, string, expression);
    }

    public Expression parseFunctionDefinition(int n, int n2) throws IOException, SyntaxException {
        Object object2;
        if (this.curToken != 81 && this.curToken != 65) {
            return this.syntaxError("missing function name");
        }
        String string = new String(this.tokenBuffer, 0, this.tokenBufferLength).intern();
        this.getRawToken();
        if (this.curToken != 40) {
            return this.syntaxError("missing parameter list:" + this.curToken);
        }
        this.getRawToken();
        LambdaExp lambdaExp = new LambdaExp();
        lambdaExp.setFile(this.getName());
        lambdaExp.setLine(n, n2);
        lambdaExp.setName(string);
        Declaration declaration = this.parser.currentScope().addDeclaration(string);
        declaration.setCanRead(true);
        declaration.setProcedureDecl(true);
        declaration.setFile(this.getName());
        declaration.setLine(n, n2);
        this.parser.push(lambdaExp);
        if (this.curToken != 41) {
            while (true) {
                if (this.curToken != 36) {
                    this.error("missing '$' before parameter name");
                } else {
                    this.getRawToken();
                }
                if (this.curToken == 81 || this.curToken == 65) {
                    object2 = new String(this.tokenBuffer, 0, this.tokenBufferLength).intern();
                    Declaration declaration2 = lambdaExp.addDeclaration((String)object2);
                    this.getRawToken();
                }
                ++lambdaExp.min_args;
                ++lambdaExp.max_args;
                if (this.curToken == 41) break;
                if (this.curToken != 44) {
                    return this.syntaxError("missing ',' in parameter list");
                }
                this.getRawToken();
            }
        }
        this.getRawToken();
        lambdaExp.body = this.parseEnclosedExpr();
        this.parser.pop(lambdaExp);
        object2 = new SetExp(string, (Expression)lambdaExp);
        ((SetExp)object2).setDefining(true);
        ((SetExp)object2).binding = declaration;
        declaration.noteValue(lambdaExp);
        return object2;
    }

    public Object readObject() throws IOException, SyntaxException {
        return this.parse(null);
    }

    public Expression parse(Parser parser) throws IOException, SyntaxException {
        int n;
        this.parser = parser;
        int n2 = this.skipSpace();
        if (n2 < 0) {
            return null;
        }
        this.unread(n2);
        int n3 = this.getLineNumber() + 1;
        int n4 = this.getColumnNumber() + 1;
        if (n2 == 35 && n3 == 1 && n4 == 1) {
            this.read();
            n2 = this.read();
            if (n2 != 33 || (n2 = this.read()) != 47) {
                this.error("'#' is only allowed in initial '#!/PROGRAM'");
            }
            while (n2 != 13 && n2 != 10 && n2 >= 0) {
                n2 = this.read();
            }
        }
        if (this.getRawToken() == -1) {
            return null;
        }
        this.peekOperand();
        if (this.curToken == 78) {
            this.getRawToken();
            this.peekNonSpace("unexpected end-of-file after 'define'");
            int n5 = this.getLineNumber() + 1;
            int n6 = this.getColumnNumber() + 1;
            if (this.match("function")) {
                this.getRawToken();
            } else {
                this.error("'define' is not followed by 'function'");
            }
            Expression expression = this.parseFunctionDefinition(n5, n6);
            expression.setFile(this.getName());
            expression.setLine(n3, n4);
            return expression;
        }
        if (this.curToken == 65 && "namespace".equals((String)this.curValue)) {
            int n7 = n = this.nesting == 0 ? this.skipHSpace() : this.skipSpace();
            if (n >= 0) {
                this.unread();
                if (XQParser.isNameStart((char)n)) {
                    this.getRawToken();
                    if (this.curToken != 65) {
                        return this.syntaxError("confused after seeing 'namespace'");
                    }
                    String string = new String(this.tokenBuffer, 0, this.tokenBufferLength);
                    this.getRawToken();
                    if (this.curToken != 208) {
                        return this.syntaxError("missing '=' in namespace declaration");
                    }
                    this.getRawToken();
                    if (this.curToken != 34) {
                        return this.syntaxError("missing uri namespace declaration");
                    }
                    String string2 = new String(this.tokenBuffer, 0, this.tokenBufferLength);
                    this.namespaces.put(string, string2);
                    return QuoteExp.voidExp;
                }
            }
        }
        if (this.curToken == 65 && "default".equals((String)this.curValue)) {
            int n8 = n = this.nesting == 0 ? this.skipHSpace() : this.skipSpace();
            if (n >= 0) {
                this.unread();
                if (XQParser.isNameStart((char)n)) {
                    this.getRawToken();
                    this.curValue = new String(this.tokenBuffer, 0, this.tokenBufferLength);
                    if (this.curToken != 65 || !"namespace".equalsIgnoreCase((String)this.curValue)) {
                        return this.syntaxError("expected 'namespace' after 'default'");
                    }
                    this.getRawToken();
                    if (this.curToken != 208) {
                        return this.syntaxError("missing '=' in namespace declaration");
                    }
                    this.getRawToken();
                    if (this.curToken != 34) {
                        return this.syntaxError("missing uri namespace declaration");
                    }
                    String string = new String(this.tokenBuffer, 0, this.tokenBufferLength);
                    this.defaultNamespace = string.toString();
                    return QuoteExp.voidExp;
                }
            }
        }
        Expression expression = this.parseExprSequence();
        if (this.curToken == 10) {
            this.unread(10);
        }
        expression.setFile(this.getName());
        expression.setLine(n3, n4);
        return expression;
    }

    public static Expression makeFunctionExp(String string, String string2) {
        return XQParser.makeFunctionExp(string, Compilation.mangleNameIfNeeded(string2), string2);
    }

    public static Expression makeFunctionExp(String string, String string2, String string3) {
        try {
            Class<?> clazz = Class.forName(string);
            Field field = clazz.getDeclaredField(string2);
            Procedure procedure = (Procedure)field.get(null);
            ClassType classType = ClassType.make(string);
            gnu.bytecode.Field field2 = classType.getDeclaredField(string2);
            Declaration declaration = new Declaration(string3, field2);
            declaration.noteValue(new QuoteExp(procedure));
            declaration.setFlag(16384);
            return new ReferenceExp(string3, declaration);
        }
        catch (Exception exception) {
            throw new WrappedException(exception);
        }
    }

    public void error(String string) {
        super.error(string);
    }

    public Expression syntaxError(String string) throws IOException, SyntaxException {
        this.error(string);
        if (this.interactive) {
            int n;
            this.curToken = 0;
            this.curValue = null;
            this.nesting = 0;
            while ((n = this.read()) >= 0) {
                if (n != 13 && n != 10) continue;
                this.unread(n);
                break;
            }
            throw new SyntaxException(this.getMessages());
        }
        return new ErrorExp(string);
    }

    static {
        XQParser.axisNames[0] = "ancestor";
        XQParser.axisNames[1] = "ancestor-or-self";
        XQParser.axisNames[2] = "attribute";
        XQParser.axisNames[3] = "child";
        XQParser.axisNames[4] = "descendant";
        XQParser.axisNames[5] = "descendant-or-self";
        XQParser.axisNames[6] = "following";
        XQParser.axisNames[7] = "following-sibling";
        XQParser.axisNames[8] = "namespace";
        XQParser.axisNames[9] = "parent";
        XQParser.axisNames[10] = "preceding";
        XQParser.axisNames[11] = "preceding-sibling";
        XQParser.axisNames[12] = "self";
        funcNamedChildren = XQParser.makeFunctionExp("gnu.kawa.xml.NamedChildren", "namedChildren");
        funcNamedDescendants = XQParser.makeFunctionExp("gnu.kawa.xml.NamedDescendants", "namedDescendants");
    }
}

