/*
 * Decompiled with CFR 0.152.
 */
package gnu.lists;

import gnu.lists.CharSeq;
import gnu.lists.Consumable;
import gnu.lists.Consumer;
import gnu.lists.Convert;
import gnu.lists.Sequence;
import gnu.lists.SimpleVector;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Writer;

public class FString
extends SimpleVector
implements CharSeq,
Externalizable,
Consumable {
    public char[] data;
    protected static char[] empty = new char[0];

    public FString() {
        this.data = empty;
    }

    public FString(int n) {
        this.size = n;
        this.data = new char[n];
    }

    public FString(int n, char c) {
        char[] cArray = new char[n];
        this.data = cArray;
        this.size = n;
        while (--n >= 0) {
            cArray[n] = c;
        }
    }

    public FString(char[] cArray) {
        this.size = cArray.length;
        this.data = cArray;
    }

    public FString(String string) {
        this.data = string.toCharArray();
        this.size = this.data.length;
    }

    public FString(StringBuffer stringBuffer) {
        this(stringBuffer, 0, stringBuffer.length());
    }

    public FString(StringBuffer stringBuffer, int n, int n2) {
        this.size = n2;
        this.data = new char[n2];
        if (n2 > 0) {
            stringBuffer.getChars(n, n + n2, this.data, 0);
        }
    }

    public FString(char[] cArray, int n, int n2) {
        this.size = n2;
        this.data = new char[n2];
        System.arraycopy(cArray, n, this.data, 0, n2);
    }

    public FString(Sequence sequence) {
        this.data = new char[sequence.size()];
        this.addAll(sequence);
    }

    public FString(CharSeq charSeq) {
        int n = charSeq.size();
        char[] cArray = new char[n];
        charSeq.getChars(0, n, cArray, 0);
        this.data = cArray;
        this.size = n;
    }

    public FString(CharSeq charSeq, int n, int n2) {
        char[] cArray = new char[n2];
        charSeq.getChars(n, n + n2, cArray, 0);
        this.data = cArray;
        this.size = n2;
    }

    public int length() {
        return this.size;
    }

    public int getBufferLength() {
        return this.data.length;
    }

    public void setBufferLength(int n) {
        int n2 = this.data.length;
        if (n2 != n) {
            char[] cArray = new char[n];
            System.arraycopy(this.data, 0, cArray, 0, n2 < n ? n2 : n);
            this.data = cArray;
        }
    }

    protected Object getBuffer() {
        return this.data;
    }

    public final Object getBuffer(int n) {
        return Convert.toObject(this.data[n]);
    }

    public final Object setBuffer(int n, Object object2) {
        Object object3 = Convert.toObject(this.data[n]);
        this.data[n] = Convert.toChar(object2);
        return object3;
    }

    public final Object get(int n) {
        if (n >= this.size) {
            throw new ArrayIndexOutOfBoundsException();
        }
        return Convert.toObject(this.data[n]);
    }

    public final char charAt(int n) {
        if (n >= this.size) {
            throw new StringIndexOutOfBoundsException(n);
        }
        return this.data[n];
    }

    public final char charAtBuffer(int n) {
        return this.data[n];
    }

    public void getChars(int n, int n2, char[] cArray, int n3) {
        if (n < 0 || n > n2) {
            throw new StringIndexOutOfBoundsException(n);
        }
        if (n2 > this.size) {
            throw new StringIndexOutOfBoundsException(n2);
        }
        if (n3 + n2 - n > cArray.length) {
            throw new StringIndexOutOfBoundsException(n3);
        }
        if (n < n2) {
            System.arraycopy(this.data, n, cArray, n3, n2 - n);
        }
    }

    public void getChars(int n, int n2, StringBuffer stringBuffer) {
        if (n < 0 || n > n2) {
            throw new StringIndexOutOfBoundsException(n);
        }
        if (n2 > this.size) {
            throw new StringIndexOutOfBoundsException(n2);
        }
        if (n < n2) {
            stringBuffer.append(this.data, n, n2 - n);
        }
    }

    public void getChars(StringBuffer stringBuffer) {
        stringBuffer.append(this.data, 0, this.size);
    }

    public char[] toCharArray() {
        int n = this.size;
        int n2 = this.data.length;
        if (n == n2) {
            return this.data;
        }
        char[] cArray = new char[n];
        System.arraycopy(this.data, 0, cArray, 0, n);
        return cArray;
    }

    public void shift(int n, int n2, int n3) {
        System.arraycopy(this.data, n, this.data, n2, n3);
    }

    public FString copy(int n, int n2) {
        char[] cArray = new char[n2 - n];
        int n3 = n;
        while (n3 < n2) {
            cArray[n3 - n] = this.data[n3];
            ++n3;
        }
        return new FString(cArray);
    }

    public String toString() {
        return new String(this.data, 0, this.size);
    }

    public String substring(int n, int n2) {
        return new String(this.data, n, n2 - n);
    }

    public void setCharAt(int n, char c) {
        if (n < 0 || n >= this.size) {
            throw new StringIndexOutOfBoundsException(n);
        }
        this.data[n] = c;
    }

    public void setCharAtBuffer(int n, char c) {
        this.data[n] = c;
    }

    public final void fill(char c) {
        int n = this.size;
        while (--n >= 0) {
            this.data[n] = c;
        }
    }

    public void fill(int n, int n2, char c) {
        if (n < 0 || n2 > this.size) {
            throw new IndexOutOfBoundsException();
        }
        int n3 = n;
        while (n3 < n2) {
            this.data[n3] = c;
            ++n3;
        }
    }

    protected void clearBuffer(int n, int n2) {
        while (--n2 >= 0) {
            this.data[n++] = '\u0000';
        }
    }

    public void replace(int n, char[] cArray, int n2, int n3) {
        System.arraycopy(cArray, n2, this.data, n, n3);
    }

    public void replace(int n, String string) {
        string.getChars(0, string.length(), this.data, n);
    }

    public int hashCode() {
        char[] cArray = this.data;
        int n = this.size;
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            n2 = 31 * n2 + cArray[n3];
            ++n3;
        }
        return n2;
    }

    public boolean equals(Object object2) {
        if (object2 == null || !(object2 instanceof FString)) {
            return false;
        }
        char[] cArray = ((FString)object2).data;
        int n = this.size;
        if (cArray == null || cArray.length != n) {
            return false;
        }
        int n2 = n;
        while (--n2 >= 0) {
            if (this.data[n2] == cArray[n2]) continue;
            return false;
        }
        return true;
    }

    public int getElementKind() {
        return 29;
    }

    public void consume(Consumer consumer) {
        consumer.write(this.data, 0, this.data.length);
    }

    public boolean consumeNext(int n, Object object2, Consumer consumer) {
        int n2 = n >>> 1;
        if (n2 >= this.size) {
            return false;
        }
        consumer.writeChar(this.data[n2]);
        return true;
    }

    protected void consume(int n, Object object2, int n2, Object object3, Consumer consumer) {
        if (consumer.ignoring()) {
            return;
        }
        int n3 = n >>> 1;
        int n4 = n2 >>> 1;
        consumer.write(this.data, n3, n4 - n3);
    }

    public void writeTo(int n, int n2, Writer writer) throws IOException {
        writer.write(this.data, n, n2);
    }

    public void writeTo(Writer writer) throws IOException {
        writer.write(this.data, 0, this.size);
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        int n = this.size;
        objectOutput.writeInt(n);
        int n2 = 0;
        while (n2 < n) {
            objectOutput.writeChar(this.data[n2]);
            ++n2;
        }
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        int n = objectInput.readInt();
        char[] cArray = new char[n];
        int n2 = 0;
        while (n2 < n) {
            cArray[n2] = objectInput.readChar();
            ++n2;
        }
        this.data = cArray;
        this.size = n;
    }
}

