/*
 * Decompiled with CFR 0.152.
 */
package gnu.kawa.lispexpr;

import gnu.expr.BeginExp;
import gnu.expr.Compilation;
import gnu.expr.Expression;
import gnu.expr.Interpreter;
import gnu.expr.ModuleExp;
import gnu.kawa.lispexpr.LispReader;
import gnu.lists.LList;
import gnu.lists.PairWithPosition;
import gnu.lists.Sequence;
import gnu.mapping.Environment;
import gnu.mapping.InPort;
import gnu.text.Lexer;
import gnu.text.SourceMessages;
import gnu.text.SyntaxException;
import java.io.IOException;
import java.util.Vector;
import kawa.lang.Translator;
import kawa.standard.Scheme;

public abstract class LispInterpreter
extends Interpreter {
    public ModuleExp parse(Environment environment, Lexer lexer) throws IOException, SyntaxException {
        SourceMessages sourceMessages = lexer.getMessages();
        Translator translator = new Translator(environment, sourceMessages);
        translator.immediate = true;
        lexer.clearErrors();
        PairWithPosition pairWithPosition = PairWithPosition.make(null, LList.Empty, lexer.getName(), lexer.getLineNumber() + 1, lexer.getColumnNumber() + 1);
        Object object2 = ((LispReader)lexer).readObject();
        if (object2 == Sequence.eofValue) {
            return null;
        }
        pairWithPosition.car = object2;
        return Scheme.makeModuleExp(pairWithPosition, translator);
    }

    public ModuleExp parseFile(InPort inPort, SourceMessages sourceMessages) {
        Translator translator = new Translator(Environment.user(), sourceMessages);
        ModuleExp moduleExp = new ModuleExp();
        if (Compilation.generateAppletDefault) {
            moduleExp.setFlag(16384);
        }
        moduleExp.setFile(inPort.getName());
        Vector vector = new Vector(20);
        translator.push(moduleExp);
        try {
            Object object2;
            LispReader lispReader = (LispReader)this.getLexer(inPort, sourceMessages);
            while ((object2 = lispReader.readObject()) != Sequence.eofValue && translator.scan_form(object2, vector, moduleExp)) {
            }
            if (inPort.peek() == 41) {
                lispReader.fatal("An unexpected close paren was read.");
            }
        }
        catch (SyntaxException syntaxException) {
            if (syntaxException.getMessages() != sourceMessages) {
                throw new RuntimeException("confussing syntax error: " + syntaxException);
            }
        }
        catch (IOException iOException) {
            throw new RuntimeException("I/O exception reading file: " + iOException.toString());
        }
        translator.finishModule(moduleExp, vector);
        return moduleExp;
    }

    public Expression makeBody(Expression[] expressionArray) {
        return new BeginExp(expressionArray);
    }
}

