/*
 * Decompiled with CFR 0.152.
 */
package gnu.expr;

import gnu.bytecode.Type;
import gnu.expr.Keyword;
import gnu.mapping.CallContext;
import gnu.mapping.MethodProc;
import gnu.mapping.Procedure;
import gnu.mapping.WrongType;

public class GenericProc
extends MethodProc {
    MethodProc[] methods;
    int count;
    int minArgs;
    int maxArgs;

    public int numArgs() {
        return this.minArgs | this.maxArgs << 12;
    }

    public void add(MethodProc methodProc) {
        if (this.methods == null) {
            this.methods = new MethodProc[8];
        } else if (this.count >= this.methods.length) {
            MethodProc[] methodProcArray = new MethodProc[2 * this.methods.length];
            System.arraycopy(this.methods, 0, methodProcArray, 0, this.count);
            this.methods = methodProcArray;
        }
        int n = 0;
        while (n < this.count) {
            MethodProc methodProc2 = MethodProc.mostSpecific(methodProc, this.methods[n]);
            if (methodProc2 == methodProc) break;
            ++n;
        }
        if (n < this.count) {
            System.arraycopy(this.methods, n, this.methods, n + 1, this.count - n);
        }
        this.methods[n] = methodProc;
        ++this.count;
        int n2 = methodProc.minArgs();
        if (n2 < this.minArgs) {
            this.minArgs = n2;
        }
        if ((n2 = methodProc.maxArgs()) == -1 || n2 > this.maxArgs) {
            this.maxArgs = n2;
        }
    }

    public Object applyN(Object[] objectArray) throws Throwable {
        Procedure.checkArgCount(this, objectArray.length);
        CallContext callContext = CallContext.getInstance();
        int n = 0;
        while (n < this.count) {
            MethodProc methodProc = this.methods[n];
            if (methodProc.match(callContext, objectArray) == 0) {
                return methodProc.applyV(callContext);
            }
            ++n;
        }
        throw new WrongType(this, -1, null);
    }

    public int isApplicable(Type[] typeArray) {
        int n = -1;
        int n2 = this.count;
        while (--n2 >= 0) {
            MethodProc methodProc = this.methods[n2];
            int n3 = methodProc.isApplicable(typeArray);
            if (n3 == 1) {
                return 1;
            }
            if (n3 != 0) continue;
            n = 0;
        }
        return n;
    }

    public int match(CallContext callContext, Object[] objectArray) {
        if (this.count == 1) {
            return this.methods[0].match(callContext, objectArray);
        }
        int n = 0;
        while (n < this.count) {
            MethodProc methodProc = this.methods[n];
            int n2 = methodProc.match(callContext, objectArray);
            if (n2 == 0) {
                callContext.ivalue1 = n;
                return 0;
            }
            ++n;
        }
        return -1;
    }

    public Object applyV(CallContext callContext) throws Throwable {
        return this.methods[callContext.ivalue1].applyV(callContext);
    }

    public static GenericProc make(Object[] objectArray) {
        int n = objectArray.length;
        boolean bl = false;
        GenericProc genericProc = new GenericProc();
        int n2 = 0;
        while (n2 < n) {
            Object object2 = objectArray[n2];
            if (object2 instanceof Keyword) {
                String string = ((Keyword)object2).getName();
                Object object3 = objectArray[++n2];
                if (string == "name") {
                    genericProc.setName(object3.toString());
                } else if (string == "method") {
                    genericProc.add((MethodProc)object3);
                } else {
                    genericProc.setProperty(string, object3);
                }
            } else {
                genericProc.add((MethodProc)object2);
            }
            ++n2;
        }
        return genericProc;
    }
}

