/*
 * Decompiled with CFR 0.152.
 */
package com.l2fprod.gui.plaf.skin.impl.gtk;

import com.l2fprod.gui.plaf.skin.DefaultButton;
import com.l2fprod.gui.plaf.skin.SkinSplitPane;
import com.l2fprod.gui.plaf.skin.impl.AbstractSkinSplitPane;
import com.l2fprod.gui.plaf.skin.impl.gtk.GtkUtils;
import com.l2fprod.gui.plaf.skin.impl.gtk.parser.GtkParser;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.JSplitPane;
import javax.swing.SwingConstants;

class GtkSplitPane
extends AbstractSkinSplitPane
implements SkinSplitPane,
SwingConstants {
    DefaultButton h_gutter;
    DefaultButton v_gutter;
    DefaultButton h_thumb;
    DefaultButton v_thumb;
    DefaultButton up;
    DefaultButton down;
    DefaultButton left;
    DefaultButton right;

    public Dimension getPreferredSize(JSplitPane splitpane) {
        Insets insets = splitpane.getInsets();
        int width = 0;
        int height = 0;
        if (splitpane.getOrientation() == 1) {
            width = Math.max(Math.max(this.up.getWidth(), this.down.getWidth()), 10);
            height = splitpane.getHeight() + insets.top + insets.bottom;
        } else {
            height = Math.max(Math.max(this.left.getHeight(), this.right.getHeight()), 10);
            width = splitpane.getWidth() + insets.left + insets.right;
        }
        Dimension d = new Dimension(width, height);
        return d;
    }

    public Dimension getArrowPreferredSize(int direction) {
        switch (direction) {
            case 1: {
                return new Dimension(this.up.getWidth(), this.up.getHeight());
            }
            case 5: {
                return new Dimension(this.down.getWidth(), this.down.getHeight());
            }
            case 7: {
                return new Dimension(this.left.getWidth(), this.left.getHeight());
            }
            case 3: {
                return new Dimension(this.right.getWidth(), this.right.getHeight());
            }
        }
        throw new Error("Invalid direction " + direction);
    }

    public boolean status() {
        return true;
    }

    public boolean installSkin(JComponent c) {
        return true;
    }

    public boolean paintArrow(Graphics g, AbstractButton b, int direction) {
        Dimension size = b.getSize();
        switch (direction) {
            case 1: {
                this.down.paint(g, 0, 0, size.width, size.height, b);
                break;
            }
            case 5: {
                this.up.paint(g, 0, 0, size.width, size.height, b);
                break;
            }
            case 7: {
                this.left.paint(g, 0, 0, size.width, size.height, b);
                break;
            }
            case 3: {
                this.right.paint(g, 0, 0, size.width, size.height, b);
            }
        }
        return true;
    }

    public boolean paintGutter(Graphics g, JSplitPane splitpane, Dimension d) {
        if (splitpane.getOrientation() == 1) {
            this.h_gutter.paint(g, 0, 0, d.width, d.height, splitpane);
            return true;
        }
        this.v_gutter.paint(g, 0, 0, d.width, d.height, splitpane);
        return true;
    }

    public boolean paintThumb(Graphics g, JSplitPane splitpane, Dimension d) {
        if (splitpane.getOrientation() == 1 && this.h_thumb != null) {
            this.h_thumb.paint(g, Math.max(0, (d.width - this.h_thumb.getWidth()) / 2), (d.height - this.h_thumb.getHeight()) / 2, Math.min(d.width, this.h_thumb.getWidth()), this.h_thumb.getHeight(), splitpane);
        } else if (splitpane.getOrientation() == 0 && this.v_thumb != null) {
            this.v_thumb.paint(g, (d.width - this.v_thumb.getWidth()) / 2, Math.max(0, (d.height - this.v_thumb.getHeight()) / 2), this.v_thumb.getWidth(), Math.min(d.height, this.v_thumb.getHeight()), splitpane);
        } else {
            return false;
        }
        return true;
    }

    public GtkSplitPane(GtkParser parser) throws Exception {
        this.h_gutter = GtkUtils.newButton(parser, "GtkPaned", new String[]{"function", "orientation"}, new String[]{"BOX", "HORIZONTAL"});
        this.v_gutter = GtkUtils.newButton(parser, "GtkPaned", new String[]{"function", "orientation"}, new String[]{"BOX", "VERTICAL"});
        this.h_thumb = GtkUtils.newButton(parser, "GtkPaned", new String[]{"function", "orientation"}, new String[]{"HANDLE", "HORIZONTAL"});
        if (this.h_thumb == null) {
            this.h_thumb = this.h_gutter;
        }
        this.v_thumb = GtkUtils.newButton(parser, "GtkPaned", new String[]{"function", "orientation"}, new String[]{"HANDLE", "VERTICAL"});
        if (this.v_thumb == null) {
            this.v_thumb = this.v_gutter;
        }
        this.up = GtkUtils.newButton(parser, "GtkPaned", new String[]{"function", "arrow_direction"}, new String[]{"ARROW", "UP"});
        this.down = GtkUtils.newButton(parser, "GtkPaned", new String[]{"function", "arrow_direction"}, new String[]{"ARROW", "DOWN"});
        this.left = GtkUtils.newButton(parser, "GtkPaned", new String[]{"function", "arrow_direction"}, new String[]{"ARROW", "LEFT"});
        this.right = GtkUtils.newButton(parser, "GtkPaned", new String[]{"function", "arrow_direction"}, new String[]{"ARROW", "RIGHT"});
    }
}

