/*
 * Decompiled with CFR 0.152.
 */
package com.l2fprod.gui.plaf.skin;

import com.l2fprod.gui.plaf.skin.Skin;
import com.l2fprod.gui.plaf.skin.SkinLookAndFeel;
import java.awt.AlphaComposite;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Graphics2D;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.UIManager;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicPopupMenuUI;

public class SkinPopupMenuUI
extends BasicPopupMenuUI {
    PopupMenuListener m_PopupListener;
    AncestorListener m_AncestorListener;
    private Skin skin = SkinLookAndFeel.getSkin();

    public void installDefaults() {
        super.installDefaults();
        this.skin.getPersonality().installSkin(this.popupMenu);
        if (Boolean.TRUE.equals(UIManager.get("PopupMenu.animation"))) {
            this.popupMenu.setOpaque(false);
        }
    }

    public void installListeners() {
        super.installListeners();
        if (Boolean.TRUE.equals(UIManager.get("PopupMenu.animation"))) {
            this.m_AncestorListener = new SkinPopupAncestorListener();
            this.popupMenu.addAncestorListener(this.m_AncestorListener);
            this.m_PopupListener = new SkinPopupMenuListener();
            this.popupMenu.addPopupMenuListener(this.m_PopupListener);
        }
    }

    public void paint(Graphics g, JComponent c) {
        Graphics2D g2d = (Graphics2D)g;
        AlphaComposite alpha = (AlphaComposite)c.getClientProperty("alpha");
        if (alpha != null) {
            g2d.setComposite(alpha);
        }
        this.skin.getPersonality().paintDialog(g, c);
        super.paint(g, c);
    }

    protected void uninstallDefaults() {
        super.uninstallDefaults();
        this.popupMenu.setOpaque(true);
    }

    protected void uninstallListeners() {
        super.uninstallListeners();
        if (this.m_AncestorListener != null) {
            this.popupMenu.removeAncestorListener(this.m_AncestorListener);
        }
        if (this.m_PopupListener != null) {
            this.popupMenu.removePopupMenuListener(this.m_PopupListener);
        }
        this.popupMenu.putClientProperty("alpha", null);
    }

    public static ComponentUI createUI(JComponent c) {
        return new SkinPopupMenuUI();
    }

    public JPopupMenu popupMenu() {
        return this.popupMenu;
    }

    class SkinPopupAncestorListener
    implements AncestorListener {
        public void ancestorAdded(AncestorEvent event) {
            Container parent = event.getComponent().getParent();
            if (parent instanceof JComponent) {
                ((JComponent)parent).setDoubleBuffered(false);
                ((JComponent)parent).setOpaque(false);
            }
        }

        public void ancestorMoved(AncestorEvent event) {
        }

        public void ancestorRemoved(AncestorEvent event) {
        }

        SkinPopupAncestorListener() {
        }
    }

    class SkinPopupMenuListener
    implements PopupMenuListener {
        Thread popupAnimator = null;

        public void popupMenuCanceled(PopupMenuEvent e) {
            if (this.popupAnimator != null) {
                this.popupAnimator.interrupt();
            }
            SkinPopupMenuUI.this.popupMenu().putClientProperty("alpha", null);
        }

        public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
            if (this.popupAnimator != null) {
                this.popupAnimator.interrupt();
            }
            SkinPopupMenuUI.this.popupMenu().putClientProperty("alpha", null);
        }

        public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
            SkinPopupMenuUI.this.popupMenu().putClientProperty("alpha", AlphaComposite.getInstance(3, 0.0f));
            if (this.popupAnimator != null) {
                this.popupAnimator.interrupt();
            }
            this.popupAnimator = new Thread(this, "PopupAnimator"){
                private final /* synthetic */ SkinPopupMenuListener this$0;
                private final /* synthetic */ SkinPopupMenuUI this$1;

                public final void run() {
                    try {
                        AlphaComposite current = (AlphaComposite)this.this$1.popupMenu().getClientProperty("alpha");
                        while (current != null && (double)current.getAlpha() < 0.75) {
                            Thread.sleep(25L);
                            current = AlphaComposite.getInstance(current.getRule(), current.getAlpha() + 0.05f);
                            this.this$1.popupMenu().putClientProperty("alpha", current);
                            this.this$1.popupMenu().repaint();
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    this.this$0.popupAnimator = null;
                }
                {
                    this.this$0 = this$0;
                    this.this$1 = SkinPopupMenuListener.access$0(this.this$0);
                    this.constructor$0(this$0, $1);
                }

                private final void constructor$0(SkinPopupMenuListener skinPopupMenuListener, String $1) {
                }
            };
            this.popupAnimator.start();
        }

        static /* synthetic */ SkinPopupMenuUI access$0(SkinPopupMenuListener skinPopupMenuListener) {
            return skinPopupMenuListener.SkinPopupMenuUI.this;
        }

        SkinPopupMenuListener() {
        }
    }
}

