/*
 * Decompiled with CFR 0.152.
 */
package madkit.imageviewer;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import javax.swing.ImageIcon;
import madkit.resbrowser.RessourceInfo;

class Miniature {
    protected int size;
    protected int imageX;
    protected int imageY;
    protected int imageWidth;
    protected int imageHeight;
    protected ImageIcon image;
    protected Color rectColor;
    protected Color rectSelectedColor;
    protected RessourceInfo ressourceInfo;
    protected boolean selected;
    protected boolean loaded;

    public Miniature(RessourceInfo ressourceInfo, int n) {
        this.ressourceInfo = ressourceInfo;
        this.size = n;
        this.rectColor = Color.black;
        this.rectSelectedColor = Color.red;
        this.selected = false;
        this.loaded = false;
    }

    public void paint(Graphics graphics, int n, int n2) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        if (!this.loaded) {
            try {
                String string = this.ressourceInfo.getResourceName();
                if (!string.startsWith("/")) {
                    string = "/" + string;
                }
                this.image = new ImageIcon(this.getClass().getResource(string));
            }
            catch (Exception exception) {
                this.image = null;
            }
            this.setIconSize(this.size);
            this.loaded = true;
        }
        if (this.image != null) {
            graphics2D.drawImage(this.image.getImage(), n + this.imageX, n2 + this.imageY, this.imageWidth, this.imageHeight, null);
        }
        if (this.selected) {
            graphics2D.setColor(this.rectSelectedColor);
            graphics2D.draw(new Rectangle(n - 1, n2 - 1, this.size + 1, this.size + 1));
        }
        graphics2D.setColor(this.rectColor);
        graphics2D.draw(new Rectangle(n, n2, this.size - 1, this.size - 1));
    }

    public void setIconSize(int n) {
        if (this.image != null) {
            if (n < this.image.getIconWidth() - 2 || n < this.image.getIconHeight() - 2) {
                if (this.image.getIconHeight() > this.image.getIconWidth()) {
                    this.imageWidth = (n - 2) * this.image.getIconWidth() / this.image.getIconHeight();
                    this.imageHeight = n - 2;
                    this.imageX = 1 + (n - this.imageWidth) / 2;
                    this.imageY = 1;
                } else {
                    this.imageHeight = (n - 2) * this.image.getIconHeight() / this.image.getIconWidth();
                    this.imageWidth = n - 2;
                    this.imageX = 1;
                    this.imageY = 1 + (n - this.imageHeight) / 2;
                }
            } else {
                this.imageHeight = this.image.getIconHeight();
                this.imageWidth = this.image.getIconWidth();
                this.imageX = 1 + (n - this.imageWidth) / 2;
                this.imageY = 1 + (n - this.imageHeight) / 2;
            }
        }
        this.size = n;
    }

    public Dimension getIconDimension() {
        if (this.image != null) {
            return new Dimension(this.image.getIconWidth(), this.image.getIconHeight());
        }
        return null;
    }

    public int getIconSize() {
        return this.size;
    }

    public RessourceInfo getRessource() {
        return this.ressourceInfo;
    }

    public void setSelected(boolean bl) {
        if (!this.loaded) {
            try {
                String string = this.ressourceInfo.getResourceName();
                if (!string.startsWith("/")) {
                    string = "/" + string;
                }
                this.image = new ImageIcon(this.getClass().getResource(string));
            }
            catch (Exception exception) {
                this.image = null;
            }
            this.setIconSize(this.size);
            this.loaded = true;
        }
        this.selected = bl;
    }
}

