/*
 * Decompiled with CFR 0.152.
 */
package turtlekit.simulations.termites;

import turtlekit.kernel.Launcher;
import turtlekit.simulations.termites.PatchInitializer;
import turtlekit.simulations.termites.Termite;

public class TermiteLauncher
extends Launcher {
    int nbOfTermites = 400;
    float densityRate = 0.5f;

    public TermiteLauncher() {
        this.setSimulationName("TERMITES");
        this.setWidth(150);
        this.setHeight(110);
    }

    public void setNbOfTermites(int n) {
        this.nbOfTermites = n;
    }

    public int getNbOfTermites() {
        return this.nbOfTermites;
    }

    public void setDensityRate(float f) {
        this.densityRate = f;
    }

    public float getDensityRate() {
        return this.densityRate;
    }

    public void addSimulationAgents() {
        this.addViewer(3);
        for (int i = 0; i < this.nbOfTermites; ++i) {
            Termite termite = new Termite();
            this.addTurtle(termite);
        }
        this.addObserver(new PatchInitializer(this.densityRate), false);
    }
}

