/*
 * Decompiled with CFR 0.152.
 */
package madkit.boot;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Enumeration;
import java.util.Vector;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;

public class MadkitClassLoader
extends URLClassLoader {
    private Vector classes = new Vector();

    public MadkitClassLoader(URL[] uRLArray, ClassLoader classLoader) {
        super(uRLArray, classLoader);
    }

    public MadkitClassLoader(URL[] uRLArray) {
        super(uRLArray);
    }

    public static MadkitClassLoader newMadkitClassLoader(File[] fileArray, ClassLoader classLoader) {
        MadkitClassLoader madkitClassLoader = new MadkitClassLoader(new URL[0], classLoader);
        for (int i = 0; i < fileArray.length; ++i) {
            File file = fileArray[i];
            if (!file.getPath().endsWith(".jar")) continue;
            try {
                madkitClassLoader.addURL(file.toURL());
                JarFile jarFile = new JarFile(file);
                Enumeration<JarEntry> enumeration = jarFile.entries();
                while (enumeration.hasMoreElements()) {
                    String string;
                    ZipEntry zipEntry = enumeration.nextElement();
                    if (zipEntry.isDirectory() || !(string = zipEntry.getName()).endsWith(".class")) continue;
                    string = string.replace('/', '.');
                    string = string.substring(0, string.length() - 6);
                    madkitClassLoader.addClassToReload(string);
                }
                continue;
            }
            catch (MalformedURLException malformedURLException) {
                System.err.println("Error: bad jar file " + file.getPath());
                continue;
            }
            catch (IOException iOException) {
                System.err.println("Error: not a jar file " + file.getPath());
            }
        }
        return madkitClassLoader;
    }

    public void addURL(URL uRL) {
        URL[] uRLArray = this.getURLs();
        for (int i = 0; i < uRLArray.length; ++i) {
            if (!uRLArray[i].equals(uRL)) continue;
            return;
        }
        super.addURL(uRL);
        System.out.println("adding " + uRL.getFile() + " to classpath");
    }

    public void addDir(File file) {
        Vector vector = this.addDir0(new Vector(), file);
        for (URL uRL : vector) {
            super.addURL(uRL);
        }
    }

    private Vector addDir0(Vector vector, File file) {
        if (file.isDirectory()) {
            String[] stringArray = file.list();
            for (int i = 0; i < stringArray.length; ++i) {
                File file2 = new File(file.getPath() + File.separator + stringArray[i]);
                if (file2.isDirectory()) {
                    this.addDir0(vector, file2);
                    continue;
                }
                if (!file2.getPath().endsWith(".jar")) continue;
                try {
                    vector.add(file2.toURL());
                    continue;
                }
                catch (MalformedURLException malformedURLException) {
                    System.err.println("Error: bad jar file " + file2.getPath());
                }
            }
        }
        return vector;
    }

    void reinitizalize() {
        URL[] uRLArray = this.getURLs();
        for (int i = 0; i < uRLArray.length; ++i) {
        }
    }

    protected Class findClass(String string) throws ClassNotFoundException {
        return super.findClass(string);
    }

    public void addClassToReload(String string) {
        this.classes.add(string);
    }

    protected synchronized Class loadClass(String string, boolean bl) throws ClassNotFoundException {
        if (this.classes.contains(string)) {
            Class clazz = this.findClass(string);
            if (clazz == null) {
                return super.loadClass(string, bl);
            }
            if (bl) {
                this.resolveClass(clazz);
            }
            this.classes.remove(string);
            return clazz;
        }
        return super.loadClass(string, bl);
    }
}

